/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.cpanels.XpPresetEditorPanel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class XpPresetSaveConfirmPanel
extends XPcaAutoControlPanel {
    JTextArea txtArea;
    JButton yes;
    JButton cancel;
    JPanel buttonPanel;
    XpPresetEditorPanel parent;
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");

    public XpPresetSaveConfirmPanel(XpPresetEditorPanel parent) {
        TransactionLogName tln = new TransactionLogName("TID=CreatePresetSavePanel");
        this.logger.log(Level.FINE, "{0} begin,Creating PresetSavePanel", tln);
        this.parent = parent;
        this.initUI();
        this.setBackground(null);
        this.logger.log(Level.FINE, "{0} end,Creating PresetSavePanel", tln);
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.setTitle(CvUtils.getResourceBundle().getString("XP_WINDOWING_CF_PA_TITLE"));
        this.txtArea = new JTextArea();
        this.txtArea.setEditable(false);
        this.txtArea.setLineWrap(true);
        this.txtArea.setWrapStyleWord(true);
        this.txtArea.setName(XpPresetSaveConfirmPanel.class.getName() + "txtArea");
        this.yes = new JButton();
        this.yes.setText(CvUtils.getResourceBundle().getString("XP_PRESET_CF_SAVE"));
        this.yes.setFocusable(false);
        this.yes.setName("confirmPanelYesBtn");
        this.yes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpPresetSaveConfirmPanel.this.yesButton_actionPerformed();
            }
        });
        this.cancel = new JButton();
        this.cancel.setText(CvUtils.getResourceBundle().getString("XP_PRESET_CANCEL"));
        this.cancel.setFocusable(false);
        this.cancel.setName("confirmPanelCancelBtn");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpPresetSaveConfirmPanel.this.parent.parent.showEditorPanel();
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.yes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 20), 0, 0));
        this.buttonPanel.add((Component)this.cancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.setName(XpPresetSaveConfirmPanel.class.getName() + "buttonPanel");
        this.add((Component)this.buttonPanel, "Center");
        this.add((Component)this.txtArea, "North");
    }

    public void setCurrentPreset(final String preset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XpPresetSaveConfirmPanel.this.txtArea.setText(CvUtils.getResourceBundle().getString("XP_WINDOWING_CF_MESSAGE") + " " + preset + " ?");
            }
        });
    }

    private void yesButton_actionPerformed() {
        double[] newWWWL;
        double[] wwwl;
        int index;
        String selected;
        block11: {
            String[] labels = this.parent.parent.wwwlmodel.getPresets();
            selected = this.parent.presetCombox.getSelectedItem().toString().split("\\(")[0].trim();
            String itemName = this.parent.txtfield.getText();
            index = this.parent.presetCombox.getSelectedIndex();
            for (int i = 0; i < labels.length; ++i) {
                if (i != index) continue;
                selected = labels[i];
            }
            this.parent.parent.wwwlmodel.setTitle(selected, itemName);
            wwwl = this.parent.parent.wwwlmodel.getWWWL(selected);
            newWWWL = new double[2];
            try {
                newWWWL[0] = Double.parseDouble(String.valueOf(this.parent.txtwidth.getValue()));
                newWWWL[1] = Double.parseDouble(String.valueOf(this.parent.txtlevel.getValue()));
            }
            catch (NumberFormatException e) {
                if (wwwl == null || wwwl.length < 2) break block11;
                newWWWL[0] = wwwl[0];
                newWWWL[1] = wwwl[1];
            }
        }
        if (wwwl != null && wwwl.length >= 2 && (newWWWL[0] != wwwl[0] || newWWWL[1] != wwwl[1])) {
            FrameOwner frameOwner;
            XpMedicalImage img = null;
            if (null != this.getScreen() && (frameOwner = (FrameOwner)((Object)this.getScreen().getCapable(FrameOwner.class.getName()))) != null && frameOwner.getFrame() instanceof XpMedicalImage) {
                img = (XpMedicalImage)frameOwner.getFrame();
            }
            if (newWWWL[0] > CvUtils.getMaxWW(img)) {
                newWWWL[0] = CvUtils.getMaxWW(img);
            } else if (newWWWL[0] < CvUtils.getMinWW(img)) {
                newWWWL[0] = CvUtils.getMinWW(img);
            }
            if (newWWWL[1] > CvUtils.getMaxWL(img)) {
                newWWWL[1] = CvUtils.getMaxWL(img);
            } else if (newWWWL[1] < CvUtils.getMinWL(img)) {
                newWWWL[1] = CvUtils.getMinWL(img);
            }
            this.parent.parent.wwwlmodel.setWWWL(selected, newWWWL);
        }
        this.parent.parent.updateSelectedPreset();
        this.parent.parent.updatePresets();
        this.parent.parent.showMainPanel(index);
    }
}

