/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.cpanels;

import com.ge.med.cse.cvf.cpanels.ListDataModel;
import com.ge.med.cse.cvf.cpanels.XPwWinLevelField;
import com.ge.med.cse.cvf.cpanels.XPwWinWidthField;
import com.ge.med.cse.cvf.cpanels.XpPresetEditorPanel;
import com.ge.med.cse.cvf.cpanels.XpPresetSaveConfirmPanel;
import com.ge.med.cse.cvf.model.WWWLModel;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.cse.cvf.util.ValueBasedDecimalFormatter;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwInvertControl;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XpWindowingPanel
extends XPcaAutoControlPanel {
    JPanel windowPanel;
    JPanel editorPanel;
    JPanel confirmPanel;
    JPanel mainPanel;
    JPanel mainPanel1;
    ValueBasedDecimalFormatter dfe = new ValueBasedDecimalFormatter();
    XPwWinWidthField winWidthField = new XPwWinWidthField(this.dfe);
    XPwWinLevelField winlevelField = new XPwWinLevelField(this.dfe);
    XPwInvertControl btInv = new XPwInvertControl();
    WWWLModel wwwlmodel;
    private static double EPSILON = 1.0E-9;
    XpPresetEditorPanel editPanel = new XpPresetEditorPanel(this);
    XpPresetSaveConfirmPanel presetconfirmPanel = new XpPresetSaveConfirmPanel(this.editPanel);
    JList presetList;
    JButton editBut = null;
    DefaultListModel model = new DefaultListModel();
    String modality_;
    ArrayList presetModel = null;
    String[] presetLabels = null;
    ListDataModel model1 = null;
    String editPanelName = "EditorPanel";
    String listPanelName = "ListPanel";
    String confirmName = "ConfirmPanel";
    CardLayout cardLayout = new CardLayout();
    Logger logger = Logger.getLogger("com.ge.med.cse.cvf.cpanels");
    boolean uiInitiated = false;
    PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ComponentSelection")) {
                if (XpWindowingPanel.this.uiInitiated) {
                    XpWindowingPanel.this.updatePresets();
                    XpWindowingPanel.this.updateWindowSetting();
                    XpWindowingPanel.this.updateButtonState();
                }
            } else if (evt.getPropertyName().equals("FrameIndex")) {
                if (XpWindowingPanel.this.uiInitiated) {
                    XpWindowingPanel.this.updateWindowSetting();
                }
            } else if (evt.getPropertyName().equals("reference_vp_selection")) {
                if (XpWindowingPanel.this.uiInitiated) {
                    XpWindowingPanel.this.updatePresets();
                    XpWindowingPanel.this.updateWindowSetting();
                    XpWindowingPanel.this.updateButtonState();
                }
            } else if (evt.getPropertyName().equals("winMax")) {
                if (XpWindowingPanel.this.uiInitiated) {
                    XpWindowingPanel.this.updateWindowSetting();
                }
            } else if (evt.getPropertyName().equals("winMin")) {
                XpWindowingPanel.this.updateWindowSetting();
            } else if (evt.getPropertyName().equals("data_changed")) {
                if (XpWindowingPanel.this.uiInitiated) {
                    XpWindowingPanel.this.updatePresets();
                }
            } else if (evt.getPropertyName().equalsIgnoreCase("videoInverted") && XpWindowingPanel.this.uiInitiated) {
                XpWindowingPanel.this.updateButtonState();
            }
        }
    };

    public XpWindowingPanel() {
        this.setIcon(CvUtils.getIcon("XP_BRIGHT_CONTRAST_ICON"));
        this.setBackground(null);
        TransactionLogName tln = new TransactionLogName("TID=CreateWindowingPanel");
        this.logger.log(Level.FINE, "{0} begin,Creating WindowingPanel", tln);
        if (!CvPropertiesManager.getBoolean("isLazyLoading", false)) {
            this.initUI();
            this.cardLayout.show(this, this.listPanelName);
            this.uiInitiated = true;
        }
        this.logger.log(Level.FINE, "{0} end,Creating WindowingPanel", tln);
    }

    @Override
    public void panelStart() {
        super.panelStart();
        if (CvPropertiesManager.getBoolean("isLazyLoading", false) && !this.uiInitiated) {
            this.initUI();
            CvUtils.updateBackground(this, UIManager.getColor("P9"));
            this.cardLayout.show(this, this.listPanelName);
            this.updatePresets();
            this.updateWindowSetting();
            this.updateButtonState();
            this.uiInitiated = true;
        }
    }

    private void initUI() {
        this.setLayout(this.cardLayout);
        this.setOpaque(false);
        this.windowPanel = new JPanel();
        this.editorPanel = new JPanel();
        this.confirmPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.mainPanel1 = new JPanel();
        this.editorPanel.setName(XpWindowingPanel.class.getName() + "editorPanel");
        this.confirmPanel.setName(XpWindowingPanel.class.getName() + "confirmPanel");
        this.mainPanel.setName(XpWindowingPanel.class.getName() + "mainPanel");
        this.mainPanel1.setName(XpWindowingPanel.class.getName() + "mainPanel1");
        this.mainPanel1.setLayout(new BorderLayout());
        this.mainPanel1.setBackground(null);
        JLabel windowLabel = new JLabel();
        this.windowPanel.setName(XpWindowingPanel.class.getName() + "windowPanel");
        JLabel levelLabel = new JLabel();
        windowLabel.setIcon(CvUtils.getIcon("XP_BRIGHT_ICON"));
        windowLabel.setIconTextGap(10);
        windowLabel.setText(CvUtils.getResourceBundle().getString("XP_WIDTH_LABEL"));
        this.windowPanel.setLayout(new GridBagLayout());
        this.windowPanel.setOpaque(false);
        this.windowPanel.setBackground(null);
        this.winWidthField.setPreferredSize(new Dimension(100, 30));
        this.winWidthField.setName("listPanelWWTxtField");
        this.winlevelField.setPreferredSize(new Dimension(100, 30));
        this.winlevelField.setName("listPanelWLTxtField");
        this.windowPanel.add((Component)windowLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 5), 0, 0));
        this.windowPanel.add((Component)this.winWidthField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.windowPanel.add((Component)levelLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.windowPanel.add((Component)this.winlevelField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        levelLabel.setIcon(CvUtils.getIcon("XP_CONTRAST_ICON"));
        levelLabel.setIconTextGap(15);
        levelLabel.setText(CvUtils.getResourceBundle().getString("XP_LEVEL_LABEL"));
        this.btInv.setToolTipText(CvUtils.getResourceBundle().getString("XP_INVERT_VIDEO_NAME"));
        this.btInv.setFocusable(false);
        this.btInv.setPreferredSize(new Dimension(50, 45));
        this.btInv.setName("invertBtn");
        JPanel combPanel = new JPanel(new GridBagLayout());
        combPanel.add((Component)this.windowPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(20, 0, 0, 40), 0, 0));
        combPanel.add((Component)this.btInv, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(30, 0, 0, 0), 0, 0));
        this.mainPanel.setBackground(null);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)combPanel, "North");
        this.mainPanel1.add((Component)this.mainPanel, "North");
        JPanel presPanel = new JPanel(new GridBagLayout());
        JLabel preset_lb = new JLabel(CvUtils.getResourceBundle().getString("XP_PRESET_LABEL"));
        this.presetList = new JList(this.model);
        this.presetList.setName("presetList");
        JPanel scrollPanel = new JPanel();
        Border scrollBorder = BorderFactory.createEmptyBorder(5, 0, 0, 0);
        scrollPanel.setBorder(scrollBorder);
        JScrollPane presetPane = new JScrollPane(this.presetList, 20, 31);
        presetPane.setPreferredSize(new Dimension(225, 150));
        this.presetList.setSelectionMode(0);
        this.presetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                XpWindowingPanel.this.updateSelectedPreset();
            }
        });
        scrollPanel.add((Component)presetPane, "Center");
        this.editBut = new JButton(CvUtils.getResourceBundle().getString("XP_EDIT_NAME"));
        this.editBut.setFocusable(false);
        this.editBut.setEnabled(false);
        this.editBut.setPreferredSize(new Dimension(225, 30));
        this.editBut.setName("editBtn");
        this.editBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XpWindowingPanel.this.editButtonActionPerformed(e);
            }
        });
        JPanel listPanel = new JPanel(new FlowLayout());
        listPanel.add(presetPane);
        presPanel.add((Component)preset_lb, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        presPanel.add((Component)listPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 10, 0, 0), 0, 0));
        presPanel.add((Component)this.editBut, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 10, 0, 0), 0, 0));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)presPanel, "North");
        this.mainPanel1.add((Component)panel2, "Center");
        this.add((Component)this.mainPanel1, this.listPanelName);
        this.add((Component)this.editPanel, this.editPanelName);
        this.add((Component)this.presetconfirmPanel, this.confirmName);
    }

    @Override
    public void setScreen(XPscreen screen) {
        super.setScreen(screen);
        this.getScreen().removePropertyChangeListener(this.viewPortListener);
        this.getScreen().addPropertyChangeListener(this.viewPortListener);
        this.presetconfirmPanel.setScreen(screen);
    }

    public void updateSelectedPreset() {
        int selPreset = this.presetList.getSelectedIndex();
        if (selPreset < 0) {
            return;
        }
        double[] wwwl = null;
        try {
            if (this.wwwlmodel != null && this.presetLabels != null) {
                wwwl = this.wwwlmodel.getWWWL(this.presetLabels[selPreset].trim());
            }
        }
        catch (Exception ex) {
            return;
        }
        if (wwwl != null && wwwl.length >= 2) {
            this.winWidthField.setValue(new Double(wwwl[0]));
            this.winlevelField.setValue(new Double(wwwl[1]));
            this.setWindowing();
            this.editBut.setEnabled(true);
        }
    }

    private void setWindowing() {
        TransactionLogName tln = new TransactionLogName("TID=Cv_windowing");
        this.logger.log(Level.FINEST, "{0} begin", tln);
        WindowLevelCapable wlc = (WindowLevelCapable)this.getScreen().getCapable(WindowLevelCapable.class.getName());
        if (wlc == null) {
            this.logger.log(Level.INFO, "SEV5 not windowlevel capable", tln);
            return;
        }
        double ww = (Double)this.winWidthField.getValue();
        XpMedicalImage img = null;
        if (wlc instanceof FrameOwner && ((FrameOwner)((Object)wlc)).getFrame() instanceof XpMedicalImage) {
            img = (XpMedicalImage)((FrameOwner)((Object)wlc)).getFrame();
        }
        if (ww > CvUtils.getMaxWW(img)) {
            ww = CvUtils.getMaxWW(img);
            this.winWidthField.setValue(new Double(ww));
        } else if (ww < CvUtils.getMinWW(img)) {
            ww = CvUtils.getMinWW(img);
            this.winWidthField.setValue(new Double(ww));
        }
        double wl = (Double)this.winlevelField.getValue();
        if (wl > CvUtils.getMaxWL(img)) {
            wl = CvUtils.getMaxWL(img);
            this.winlevelField.setValue(new Double(wl));
        } else if (wl < CvUtils.getMinWL(img)) {
            wl = CvUtils.getMinWL(img);
            this.winlevelField.setValue(new Double(wl));
        }
        wlc.setWinMinMax(wl - ww * 0.5, wl + ww * 0.5);
        this.logger.log(Level.FINEST, "{0} begin", tln);
    }

    public void updatePresets() {
        FrameOwner fo = (FrameOwner)((Object)this.getScreen().getCapable(FrameOwner.class.getName()));
        XpMedicalImage img = null;
        if (fo != null && (img = (XpMedicalImage)fo.getFrame()) != null) {
            this.modality_ = DicomUtils.getModality(img);
        }
        if (this.modality_ != null) {
            this.wwwlmodel = WWWLModel.getModel(this.modality_);
            this.presetLabels = this.wwwlmodel.getPresets();
        }
        this.presetModel = new ArrayList();
        if (this.wwwlmodel != null && this.presetLabels != null) {
            for (int i = 0; i < this.presetLabels.length; ++i) {
                String shortcutkey = this.wwwlmodel.getShortCutKey(this.presetLabels[i]);
                this.presetModel.add(this.wwwlmodel.getTitle(this.presetLabels[i]) + " (" + shortcutkey + ")");
            }
        } else {
            this.presetModel.add("Predef1(F6)");
            this.presetModel.add("Predef2(F7)");
            this.presetModel.add("Predef3(F8)");
            this.presetModel.add("Predef4(F9)");
            this.presetModel.add("Predef5(F10)");
            this.presetModel.add("Predef6(F11)");
        }
        this.model1 = new ListDataModel(this.presetModel);
        this.presetList.setModel(this.model1);
        this.presetList.setSelectionMode(0);
    }

    private void updateWindowSetting() {
        WindowLevelCapable wl = (WindowLevelCapable)this.getScreen().getCapable(WindowLevelCapable.class.getName());
        if (wl == null) {
            this.logger.log(Level.INFO, "not windowlevel capable");
            return;
        }
        double min = wl.getWinMin();
        double max = wl.getWinMax();
        this.winWidthField.setValue(new Double(max - min));
        this.winlevelField.setValue(new Double((max + min) / 2.0));
        boolean presetListSelected = false;
        if (this.wwwlmodel != null && this.presetLabels != null) {
            for (int i = 0; i < this.presetLabels.length; ++i) {
                double[] wwwl = this.wwwlmodel.getWWWL(this.presetLabels[i]);
                if (wwwl == null || wwwl.length < 2 || !(Math.abs(max - min - wwwl[0]) < EPSILON) || !(Math.abs((max + min) / 2.0 - wwwl[1]) < EPSILON)) continue;
                this.presetList.setSelectedIndex(i);
                presetListSelected = true;
                break;
            }
        }
        if (!presetListSelected) {
            this.presetList.clearSelection();
            this.editBut.setEnabled(false);
        }
    }

    private void updateButtonState() {
        WindowLevelCapable wlc = this.getWLPort();
        if (wlc != null) {
            boolean isInverted = wlc.isVideoInverted();
            if (this.btInv.isSelected() && !isInverted) {
                this.btInv.setSelected(false);
            }
            if (!this.btInv.isSelected() && isInverted) {
                this.btInv.setSelected(true);
            }
        }
    }

    private void editButtonActionPerformed(ActionEvent e) {
        if (this.presetList.isSelectionEmpty()) {
            return;
        }
        this.editPanel.setPresets();
        this.editPanel.setSelectedPreset(this.presetList.getSelectedIndex());
        this.showEditorPanel();
    }

    public void showEditorPanel() {
        this.cardLayout.show(this, this.editPanelName);
        this.repaint();
    }

    public void showMainPanel(int index) {
        this.presetList.setSelectedIndex(index);
        this.cardLayout.show(this, this.listPanelName);
        this.repaint();
    }

    public void showConfirmPanel() {
        this.cardLayout.show(this, this.confirmName);
        this.repaint();
    }

    @Override
    public String getToolTipText() {
        return CvUtils.getResourceBundle().getString("WINDOW_TOOLTIP");
    }

    @Override
    public String getTitle() {
        return CvUtils.getResourceBundle().getString("WINDOW_TOOLTIP");
    }

    @Override
    public String getName() {
        return CvUtils.getResourceBundle().getString("WINDOW_TOOLTIP");
    }
}

