/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.cse.cvf.comparators.DefaultImComparator;
import com.ge.med.cse.cvf.crossref.CvCrossRefUtils;
import com.ge.med.cse.cvf.crossref.XpSliceCollectionRoi;
import com.ge.med.cse.cvf.log.UserMessageLevel;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.XpAnnotationVc;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationModel;
import com.ge.med.terra.jami.capable.FrameOwner;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class XPCrossRefLinesManager {
    private static final Logger logger = Logger.getLogger(XPCrossRefLinesManager.class.getName());
    private static XPscreen screen_ = null;
    private static TransactionLogName addCRTln = new TransactionLogName("TID=CV_addCrossReferenceCmd");
    private static TransactionLogName removeCRTln = new TransactionLogName("TID=CV_removeCrossReferenceCmd");

    public static void setScreen(XPscreen screen) {
        screen_ = screen;
    }

    public static boolean putCrossReferenceLines(int seriesNo, int from, int to, int interval, boolean append) {
        logger.log(Level.INFO, "{0} begin", addCRTln);
        ROICapable roic = (ROICapable)screen_.getCapable(ROICapable.class.getName());
        if (roic == null) {
            logger.log(Level.WARNING, "{0} SEV5 Not ROICapable.", addCRTln);
            return false;
        }
        int status = -1;
        CvCrossRefUtils.CrossRefResult result = XPCrossRefLinesManager.getReferenceSeries(seriesNo);
        if (result == null) {
            logger.log(Level.WARNING, "{0} Not a valid series for cross reference.", addCRTln);
            status = 0;
        } else {
            status = result.status;
        }
        if (status != -1) {
            XPCrossRefLinesManager.logUserMessage(status);
            return false;
        }
        RoiActor ra = XPCrossRefLinesManager.putCrossRefROI(roic, result.refSeries, from, to, interval, append);
        if (ra == null) {
            logger.log(Level.WARNING, "{0} SEV5 Failed to post cross reference ROI.", addCRTln);
            return false;
        }
        logger.log(Level.INFO, "{0} end", addCRTln);
        return true;
    }

    private static CvCrossRefUtils.CrossRefResult getReferenceSeries(int seriesno) {
        CvCrossRefUtils.CrossRefResult result = new CvCrossRefUtils.CrossRefResult();
        result.status = 7;
        if (screen_ instanceof XPscreen) {
            DMSession sess;
            DMSystem dmsys = null;
            try {
                dmsys = CvUtils.getDMSystem();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "{0} SEV5 Unable to get DMSession.", addCRTln);
            }
            DMSession dMSession = sess = dmsys != null ? dmsys.getLocalDB() : null;
            if (sess == null) {
                logger.log(Level.INFO, "{0} SEV5 DMSession is NULL.", addCRTln);
                return result;
            }
            JComponent comp = XPCrossRefLinesManager.getSelectedPort();
            if (comp == null) {
                logger.log(Level.INFO, "{0} SEV5 No selected port found.", addCRTln);
                return result;
            }
            XpViewport comPort = null;
            if (comp instanceof XpViewport) {
                comPort = (XpViewport)comp;
            }
            if (comPort instanceof FrameOwner) {
                int sel;
                JComponent port;
                if (comPort.getImages() == null && comPort.getImages().length == 0) {
                    logger.log(Level.INFO, "{0} SEV5 Images not available.", addCRTln);
                    return result;
                }
                DMImage img = null;
                if (comPort instanceof SelectionCapable && (port = ((SelectionCapable)((Object)comPort)).getViewportComponent(sel = ((SelectionCapable)((Object)comPort)).getComponentSelection())) instanceof FrameOwner) {
                    img = ((XpMedicalDmImage)((FrameOwner)((Object)port)).getFrame()).getDMImage();
                }
                if (img == null) {
                    img = ((XpMedicalDmImage)((FrameOwner)((Object)comPort)).getFrame()).getDMImage();
                }
                if (img == null) {
                    img = ((XpMedicalDmImage)comPort.getImages()[0]).getDMImage();
                }
                if (img == null) {
                    logger.log(Level.INFO, "{0} SEV5 Images not available.", addCRTln);
                    return result;
                }
                if (seriesno != -1) {
                    DMObject[] series;
                    String examid = (String)img.getValue(new DMTag(32, 16));
                    String examuid = (String)img.getValue(new DMTag(32, 13));
                    String query = "(0x0020, 0x000D) = " + examuid;
                    if (examid != null && examid.trim().length() > 0) {
                        query = query + " AND (0x0020, 0x0010) = " + examid;
                    }
                    if ((series = sess.getRelated("series", new DMQuery(query = query + " AND (0x0020, 0x0011) = " + seriesno))) != null && series.length > 0) {
                        for (int i = 0; i < series.length; ++i) {
                            result = CvCrossRefUtils.isSeriesValidForCrossReference(series[i], img);
                            if (result == null || result.status != -1) continue;
                            result.refSeries = series[i];
                            break;
                        }
                    }
                } else {
                    result = CvCrossRefUtils.fetchValidReferenceSeries(sess, img);
                }
                return result;
            }
            logger.log(Level.INFO, "{0} SEV5 Cross ref not supported by the selected port.", addCRTln);
            return result;
        }
        return result;
    }

    private static JComponent getSelectedPort() {
        if (screen_ == null || !(screen_ instanceof XPscreen)) {
            return null;
        }
        JComponent c = screen_.getSelectedPort();
        while (c != null && c instanceof XPscreen) {
            c = ((XPscreen)c).getSelectedPort();
        }
        return c;
    }

    private static RoiActor putCrossRefROI(ROICapable roic, DMObject series, int startimg, int endimg, int interval, boolean append) {
        int numImgs;
        int startIndex = 0;
        int endIndex = 0;
        if (roic == null) {
            logger.log(Level.INFO, "{0} Sev5 ROICapable is null.", addCRTln);
            return null;
        }
        if (series == null) {
            logger.log(Level.INFO, "{0} Sev5 Cross reference series object is null.", addCRTln);
            return null;
        }
        if (roic instanceof FrameOwner) {
            XpMedicalImage img = (XpMedicalImage)((FrameOwner)((Object)roic)).getFrame();
            if (img == null) {
                logger.log(Level.INFO, "{0} Sev5 Viewport has no image.", addCRTln);
                return null;
            }
            if ("SSAVE".equals(DicomUtils.getImageType(img, false))) {
                logger.log(Level.INFO, "{0} Sev5 Cannot apply graphics on a screen save image.", addCRTln);
                return null;
            }
        }
        if ((numImgs = series.getNumberOfRelated("image")) == 0) {
            logger.log(Level.INFO, "{0} Sev5 Cross reference series has no images.", addCRTln);
            XPCrossRefLinesManager.logUserMessage(7);
            return null;
        }
        if (numImgs > CvUtils.getLargeSeriesSize()) {
            logger.log(Level.INFO, "{0} Sev5 Cross reference not supported for series size > " + CvUtils.getLargeSeriesSize(), addCRTln);
            XPCrossRefLinesManager.logUserMessage(9);
            return null;
        }
        XpMedicalImage[] imgs = CvUtils.getXpImages(new DMObject[]{series});
        if (imgs == null || imgs.length == 0) {
            logger.log(Level.INFO, "{0} Sev5 Cross reference series has no images.", addCRTln);
            return null;
        }
        Arrays.sort(imgs, new DefaultImComparator());
        if (endimg < startimg && endimg != -1) {
            logger.log(Level.INFO, "{0} Sev5 Invalid image range for cross reference : [" + startimg + "," + endimg + "]", addCRTln);
            return null;
        }
        if (startimg < 0) {
            startIndex = 0;
        } else {
            startIndex = Arrays.binarySearch(imgs, new Integer(startimg), new DefaultImComparator());
            if (startimg == endimg && startIndex < 0) {
                logger.log(Level.INFO, "{0} Sev5 Not a valid image range.", addCRTln);
                return null;
            }
            if (startIndex < 0 && Math.abs(startIndex + 1) < imgs.length) {
                startIndex = Math.abs(startIndex + 1);
            }
        }
        if (endimg < 0) {
            endIndex = imgs.length - 1;
        } else {
            endIndex = Arrays.binarySearch(imgs, new Integer(endimg), new DefaultImComparator());
            if (startimg == endimg && endIndex < 0) {
                logger.log(Level.INFO, "{0} Sev5 Not a valid image range.", addCRTln);
                return null;
            }
            if (endIndex < 0 && Math.abs(endIndex + 2) < imgs.length) {
                endIndex = Math.abs(endIndex + 2);
            }
        }
        XpSliceCollectionRoi cr = null;
        boolean exists = false;
        List roilist = roic.getRois();
        for (int i = 0; i < roilist.size(); ++i) {
            if (!(roilist.get(i) instanceof XpSliceCollectionRoi)) continue;
            cr = (XpSliceCollectionRoi)roilist.get(i);
            exists = true;
            break;
        }
        if (cr == null) {
            JComponent comp = XPCrossRefLinesManager.getSelectedPort();
            XpAnnotationVc vc = null;
            XpAnnotationModel annotModel = null;
            if (comp instanceof XpCompositePort) {
                vc = ((XpCompositePort)comp).getSelectedPort().getMedicalImageVc().getAnnotationVc();
                annotModel = vc.getAnnotationModel();
            } else if (comp instanceof XpSingularPort) {
                vc = ((XpSingularPort)comp).getMedicalImageVc().getAnnotationVc();
                annotModel = vc.getAnnotationModel();
            }
            if (vc != null) {
                cr = new XpSliceCollectionRoi(annotModel);
            } else {
                logger.log(Level.WARNING, "{0} Visual component of selected port is null.");
            }
        }
        if (!append) {
            cr.removeAllSlices();
        }
        if (interval <= 0) {
            cr.addSlice(imgs[0]);
            cr.addSlice(imgs[imgs.length - 1]);
        } else {
            int last = -1;
            for (int i = startIndex; i <= endIndex; i += interval) {
                cr.addSlice(imgs[i]);
                last = i;
            }
            if (last != endIndex) {
                cr.addSlice(imgs[endIndex]);
            }
        }
        if (!exists) {
            roic.add(cr);
        }
        cr.setVisible(cr.isVisible());
        return cr;
    }

    public static boolean removeCrossReferenceLines() {
        logger.log(Level.INFO, "{0} begin", removeCRTln);
        ROICapable roic = (ROICapable)screen_.getCapable(ROICapable.class.getName());
        if (roic == null) {
            logger.log(Level.WARNING, "{0} Sev5 ROICapable is null.", removeCRTln);
            return false;
        }
        List roilist = roic.getRois();
        if (roilist == null) {
            return false;
        }
        for (int i = 0; i < roilist.size(); ++i) {
            if (!(roilist.get(i) instanceof XpSliceCollectionRoi)) continue;
            RoiActor ra = (RoiActor)roilist.get(i);
            if (ra != null) {
                roic.remove(ra);
            }
            return true;
        }
        logger.log(Level.INFO, "{0} Sev5 No Cross Reference ROI on selected port.", removeCRTln);
        logger.log(Level.INFO, "{0} end", removeCRTln);
        return true;
    }

    public static void logUserMessage(int status) {
        if (status != -1) {
            if (status == 0) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_SERIES_TYPE"));
            } else if (status == 1) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_EXAM"));
            } else if (status == 2) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_SERIES"));
            } else if (status == 3) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_PAT_POS"));
            } else if (status == 4) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_PAT_ORIENTATION"));
            } else if (status == 5) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_LANDMARK"));
            } else if (status == 6 || status == 10) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_SCAN_PLANE"));
            } else if (status == 7) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XR_INVALID_SERIES_TYPE"));
            } else if (status == 9) {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("XP_SERIES_TOO_LAREG_FOR_CMD"));
            } else {
                logger.log(UserMessageLevel.USER_MSG, CvUtils.getResourceBundle().getString("DEFAULT_FAIL_MSG"));
            }
        }
    }
}

