/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class XpCvOnPortLayoutManager
implements LayoutManager {
    public static final String SOUTH = "South";
    public static final String NORTH = "North";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String NORTHEAST = "NorthEast";
    public static final String NORTHWEST = "NorthWest";
    public static final String SOUTHEAST = "SouthEast";
    public static final String SOUTHWEST = "SouthWest";
    private String[] dir = new String[]{"North", "South", "NorthEast", "SouthEast", "NorthWest", "SouthWest", "East", "West"};
    Component[][] ctl = new Component[8][0];
    int HedgePad = 5;
    int edgePad = 5;
    int pad = 10;

    @Override
    public void addLayoutComponent(String name, Component comp) {
        for (int i = 0; i < this.ctl.length; ++i) {
            if (!this.dir[i].equals(name)) continue;
            int len = this.ctl[i].length;
            Component[] tmp = new Component[len + 1];
            System.arraycopy(this.ctl[i], 0, tmp, 0, len);
            this.ctl[i] = tmp;
            this.ctl[i][len] = comp;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        block0: for (int i = 0; i < this.ctl.length; ++i) {
            for (int j = 0; j < this.ctl[i].length; ++j) {
                if (comp != this.ctl[i][j]) continue;
                for (int k = 0; k < this.ctl[i].length - 1; ++k) {
                    if (k < j) continue;
                    this.ctl[i][j] = this.ctl[i][k + 1];
                }
                int len = this.ctl[i].length;
                Component[] tmp = new Component[len - 1];
                System.arraycopy(this.ctl[i], 0, tmp, 0, len - 1);
                this.ctl[i] = tmp;
                continue block0;
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return parent.getMinimumSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return parent.getMinimumSize();
    }

    @Override
    public void layoutContainer(Container parent) {
        for (int dir = 7; dir >= 0; --dir) {
            int i;
            int testSize;
            Dimension ad = null;
            Dimension psize = parent.getSize();
            boolean done = false;
            int num = this.ctl[dir].length;
            if (psize.getWidth() <= 0.0 || psize.getHeight() <= 0.0) {
                return;
            }
            if (dir < 6) {
                while (!done) {
                    ad = this.getAvgPerferedSize(this.ctl[dir]);
                    if (psize.width < this.HedgePad * 2 + (this.pad + ad.width) * num - this.pad) {
                        testSize = num != 0 ? (psize.width - this.HedgePad * 2 + this.pad) / num - this.pad : 0;
                        Dimension minD = this.getMaxMinSize(this.ctl[dir]);
                        if (minD.width < testSize) {
                            ad.height = testSize * ad.height / ad.width;
                            ad.width = testSize;
                            done = true;
                        }
                    } else {
                        done = true;
                    }
                    if (done) continue;
                    --num;
                }
            } else {
                ad = this.getAvgPerferedSize(this.ctl[dir]);
                if (psize.height < this.edgePad * 2 + (this.pad + ad.height) * num - this.pad) {
                    testSize = (psize.height - this.edgePad * 2 + this.pad) / num - this.pad;
                    Dimension minD = this.getMaxMinSize(this.ctl[dir]);
                    if (minD.height < testSize) {
                        ad.width = testSize * ad.width / ad.height;
                        ad.height = testSize;
                        this.HedgePad = ad.width + this.edgePad;
                        done = true;
                    }
                } else {
                    done = true;
                }
                if (!done) {
                    --num;
                }
            }
            int x = this.edgePad;
            int y = this.edgePad;
            if (dir < 2) {
                x = (parent.getWidth() - (num * (this.pad + ad.width) - this.pad)) / 2;
            } else if (dir < 4) {
                x = parent.getWidth() - (num * (this.pad + ad.width) - this.pad);
            } else if (dir < 6) {
                x = 0;
            } else {
                y = (parent.getHeight() - (num * (this.pad + ad.height) - this.pad)) / 2;
            }
            if (dir == 1 || dir == 3 || dir == 5) {
                y = parent.getHeight() - ad.height - this.edgePad;
            }
            if (dir == 2 || dir == 3 || dir == 6) {
                x = parent.getWidth() - ad.width - this.edgePad;
            }
            if (dir == 1 || dir == 3 || dir == 5) {
                y -= this.pad;
            }
            if (dir == 0 || dir == 2 || dir == 4) {
                y += this.pad / 2;
            }
            if (dir == 4 || dir == 5 || dir == 7) {
                x += this.pad / 2;
            }
            if (dir < 6) {
                for (i = 0; i < num; ++i) {
                    this.ctl[dir][i].setLocation(x, y);
                    this.ctl[dir][i].setSize(ad);
                    this.ctl[dir][i].setVisible(true);
                    x += ad.width + this.pad;
                }
            } else {
                for (i = 0; i < num; ++i) {
                    this.ctl[dir][i].setLocation(x, y);
                    this.ctl[dir][i].setSize(ad);
                    this.ctl[dir][i].setVisible(true);
                    y += ad.height + this.pad;
                }
            }
            for (i = num; i < this.ctl[dir].length; ++i) {
                this.ctl[dir][i].setLocation(0, 0);
                this.ctl[dir][i].setSize(0, 0);
                this.ctl[dir][i].setVisible(false);
            }
        }
    }

    private Dimension getMaxMinSize(Component[] list) {
        int minHeight = 0;
        int minWidth = 0;
        if (list != null && list.length > 0) {
            for (int j = 0; j < list.length; ++j) {
                Dimension d = list[j].getMinimumSize();
                if (minHeight > d.height) {
                    minHeight = d.height;
                }
                if (minWidth <= d.width) continue;
                minWidth = d.width;
            }
        }
        return new Dimension(minWidth, minHeight);
    }

    private Dimension getAvgPerferedSize(Component[] list) {
        int minHeight = 0;
        int minWidth = 0;
        if (list.length == 0) {
            return new Dimension(0, 0);
        }
        for (int j = 0; j < list.length; ++j) {
            Dimension d = list[j].getPreferredSize();
            minHeight += d.height;
            minWidth += d.width;
        }
        return new Dimension(minWidth / list.length, minHeight / list.length);
    }
}

