/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.crossref;

import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.capable.GrayScaleCapable;
import com.ge.med.terra.jami.capable.SliceControlledCapable;
import com.ge.med.terra.jami.marker.XpSliceMarker;
import java.awt.Color;
import java.awt.geom.Point2D;

public class XpCvSliceMarker
extends XpSliceMarker
implements GrayScaleCapable {
    private boolean grayscaleMode = false;

    public XpCvSliceMarker(double x, double y) {
        super(x, y);
    }

    @Override
    protected Point2D[] getImageIntersectionPoints(SliceControlledCapable scc, int slIdx) {
        XpImage mi = this.getImage();
        if (mi != null) {
            Point2D[] point2DArray;
            Point2D[][] cintPts = (Point2D[][])this.intPtsMap.get(scc);
            if (cintPts == null) {
                int len = scc.getNumSlices();
                cintPts = new Point2D[len][];
                XpSlice mySlice = mi.getSlice();
                for (int i = 0; i < len; ++i) {
                    XpSlice currSlice = scc.getSlice(i);
                    cintPts[i] = new Point2D[2];
                    cintPts[i][0] = new Point2D.Double();
                    cintPts[i][1] = new Point2D.Double();
                    if (currSlice == null) continue;
                    mySlice.getIntersection(currSlice, cintPts[i]);
                    if (cintPts[i][0].getX() != cintPts[i][1].getX() || cintPts[i][0].getY() != cintPts[i][1].getY()) continue;
                    cintPts[i] = mySlice.getIntersectionWithInfinite(currSlice);
                }
                this.intPtsMap.put(scc, cintPts);
            }
            if (slIdx < 0 || slIdx >= cintPts.length) {
                Point2D[] point2DArray2 = new Point2D[2];
                point2DArray2[0] = new Point2D.Double(0.0, 0.0);
                point2DArray = point2DArray2;
                point2DArray2[1] = new Point2D.Double(0.0, 0.0);
            } else {
                point2DArray = cintPts[slIdx];
            }
            return point2DArray;
        }
        return new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
    }

    @Override
    public Color getForeground() {
        if (this.isGrayScaleMode()) {
            return Color.WHITE;
        }
        return super.getForeground();
    }

    @Override
    public boolean isGrayScaleMode() {
        return this.grayscaleMode;
    }

    @Override
    public void setGrayScaleMode(boolean g) {
        this.grayscaleMode = g;
    }
}

