/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader;

import com.ge.med.cse.cvf.dataloader.adv.CvDMObject;
import com.ge.med.cse.cvf.util.CvImageFusionUtils;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DatasetLoaderUtils {
    private static HashMap<String, Boolean> fusionValidCache = new HashMap();
    private static HashMap<String, DMObject[][]> fusionFilterCache = new HashMap();
    public static final String APP_ID = System.getProperty("APP_IDENTIFIER");
    public static final String DATASET_3D_LAYERED = "DATASET_3D_FUSION";
    public static final String DATASET_3D_SINGLE = "DATASET_3D_SINGLE";
    public static final String DATASET_2D_FUSION = "DATASET_2D_FUSION";
    public static final String DATASET_2D_1 = "DATASET_2D_1";
    public static final String DATASET_2D_2 = "DATASET_2D_2";
    public static final String DATASET_2D_COMPARE = "DATASET_2D_COMPARE";
    public static final String VALID_MODALITY = "VALID_MODALITY";
    public static final String NOT_VALID_FUSION = "NOT_VALID_FUSION";
    public static final String DATA_LOADING_TASK_2D_SINGLE_IMAGE = "DATA_LOADING_TASK_2D_SINGLE_IMAGE";
    public static final String DATA_LOADING_TASK_2D_COMPARE_IMAGE = "DATA_LOADING_TASK_2D_CIOMPARE_IMAGE";
    public static final String DATA_LOADING_TASK_2D_FUSION_IMAGE = "DATA_LOADING_TASK_2D_FUSION_IMAGE";
    public static final String DATA_LOADING_TASK_VOLUME_SINGLE = "DATA_LOADING_TASK_VOLUME_SINGLE";
    public static final String DATA_LOADING_TASK_VOLUME_FUSION = "DATA_LOADING_TASK_VOLUME_FUSION";
    public static final String DATA_LOADING_EXCEPTION = "DATA_LOADING_EXCEPTION";
    public static final String EXCEEEDS_SIZE = "EXCEEEDS_SIZE";
    public static final String INVALID_MODALITY = "INVALID_MODALITY";
    public static final String INVALID_IMAGETYPE = "INVALID_IMAGETYPE";
    public static final String INVALID_PHOTOMETRIC_INTERPRETATION = "INVALID_PHOTOMETRIC_INTERPRETATION";
    public static final String INVALID_FUSION_VOLUME = "INVALID_FUSION_VOLUME";
    public static final String INVALID_FUSION_IMAGE = "INVALID_FUSION_IMAGE";
    public static final String INVALID_FOR_VOLUME = "INVALID_FOR_VOLUME";
    public static final String SUPPORTED_MODALITY = "SUPPORTED_MODALITY";
    public static final String VOLUME_CAN_NOT_BUILT = "VOLUME_NOT_SUPPORTED";
    public static final String NO_IMAGE_PRESENT = "NO_IMAGE_PRESENT";
    public static final String PORT_MULTIFRAME = "PORT_MULTIFRAME";
    private static DMTag seriesInstanceUIDTag = new DMTag(32, 14);

    public static boolean isPRSeries(DMObject dmo) {
        return dmo != null && "PR".equalsIgnoreCase((String)dmo.getValue(new DMTag(8, 96)));
    }

    public static DMTag[] getNeededTags(DMTagValueInterface series) {
        String modatliy = series.getValue(new DMTag(8, 96)).toString();
        return CvUtils.getNeededTags("" + modatliy, "");
    }

    public static ArrayList<CvDMObject> sortImagesWithImageNumber(DMObject[] dmoImgTemp) {
        int totalBlank = dmoImgTemp.length;
        ArrayList<CvDMObject> tempMVDMObject = new ArrayList<CvDMObject>();
        for (int j = 0; j < totalBlank; ++j) {
            Integer imgNumber = Integer.MAX_VALUE;
            Object obj = dmoImgTemp[j].getValue(32, 19);
            if (obj != null) {
                try {
                    imgNumber = Integer.parseInt(obj.toString().trim());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            CvDMObject mvDMObject = new CvDMObject(dmoImgTemp[j], imgNumber);
            tempMVDMObject.add(mvDMObject);
        }
        long d1 = System.currentTimeMillis();
        Collections.sort(tempMVDMObject);
        return tempMVDMObject;
    }

    public static String checkModalityForVolumeBuild(DMObject serObj) {
        String type;
        int volumesizelimit;
        String selectedModality = DicomUtils.getModality(serObj);
        int numberofreleated = serObj.getNumberOfRelated("image");
        if (numberofreleated > (volumesizelimit = Integer.parseInt(CvPropertiesManager.getProperty("MV.volume.size", "600")))) {
            return EXCEEEDS_SIZE;
        }
        String supportedVol = CvPropertiesManager.getProperty("cvf.j3d.modalities", "ct,pt,mr");
        String[] allModality = supportedVol.split(",");
        List<String> modalitylist = Arrays.asList(allModality);
        if (selectedModality.equalsIgnoreCase("ct") && (type = DicomUtils.getCTImageType(serObj, true)).equalsIgnoreCase("SCOUT")) {
            return INVALID_FOR_VOLUME;
        }
        if (modalitylist.contains(selectedModality.toLowerCase())) {
            return VALID_MODALITY;
        }
        return INVALID_MODALITY;
    }

    public static boolean isFusionValid(DMObject dmoct, DMObject dmopt) {
        String ctUID = (String)dmoct.getValue(seriesInstanceUIDTag);
        String ptUID = (String)dmopt.getValue(seriesInstanceUIDTag);
        String uidString = ctUID + ptUID;
        if (fusionValidCache.containsKey(uidString)) {
            return fusionValidCache.get(uidString);
        }
        boolean status = CvImageFusionUtils.isValidFusionCombination(dmoct, dmopt);
        fusionValidCache.put(uidString, status);
        return status;
    }

    public static DMObject[][] filterMatchingSlieces(DMObject dmoCT, DMObject dmoPT) {
        String ctUID = (String)dmoCT.getValue(seriesInstanceUIDTag);
        String ptUID = (String)dmoPT.getValue(seriesInstanceUIDTag);
        String uidString = ctUID + ptUID;
        if (fusionFilterCache.containsKey(uidString)) {
            return fusionFilterCache.get(uidString);
        }
        DMObject[][] ctpet = CvImageFusionUtils.filterOutMatchingSlices(dmoCT.getRelated("image"), dmoPT.getRelated("image"));
        fusionFilterCache.put(uidString, ctpet);
        return ctpet;
    }
}

