/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.MultiDatasetLoader;
import com.ge.med.cse.cvf.dataloader.adv.CvDMObject;
import com.ge.med.cse.cvf.dataloader.adv.XpBlankImageLoader;
import com.ge.med.cse.cvf.dataloader.adv.XpSingleSeriesLoadRunner;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XpCompareModeLoader
implements Runnable,
MultiDatasetLoader,
Observer,
PropertyChangeListener {
    private boolean isInterrupted = false;
    private volatile int frameIndex = 0;
    private int numberOfImages = 0;
    JComponent[] ports = null;
    DatasetModel[] models = null;
    TaskMonitor monitor = null;

    @Override
    public void update(Observable o, Object arg) {
        this.isInterrupted = true;
    }

    @Override
    public void load(JComponent viewport, DatasetModel model, Properties prop, TaskMonitor monitor) {
        throw new RuntimeException("Not implemetned");
    }

    @Override
    public void run() {
        block18: {
            try {
                if (this.ports != null && this.ports.length > 1 && this.ports[0] instanceof XpCompositePort && this.ports[1] instanceof XpCompositePort) {
                    final XpCompositePort port1 = (XpCompositePort)this.ports[0];
                    final XpCompositePort port2 = (XpCompositePort)this.ports[1];
                    DMObject dmo1 = (DMObject)this.models[0].getDataset().getData();
                    DMObject dmo2 = (DMObject)this.models[1].getDataset().getData();
                    if (DatasetLoaderUtils.isPRSeries(dmo1) && !DatasetLoaderUtils.isPRSeries(dmo2)) {
                        CvImageLoader.getInstance().loadData(port1, new DMObject[]{dmo1}, true);
                        XpSingleSeriesLoadRunner singleLoader = new XpSingleSeriesLoadRunner(new DMObject[]{dmo2}, port2, this.monitor);
                        singleLoader.run();
                        return;
                    }
                    if (!DatasetLoaderUtils.isPRSeries(dmo1) && DatasetLoaderUtils.isPRSeries(dmo2)) {
                        CvImageLoader.getInstance().loadData(port2, new DMObject[]{dmo2}, true);
                        XpSingleSeriesLoadRunner singleLoader = new XpSingleSeriesLoadRunner(new DMObject[]{dmo1}, port1, this.monitor);
                        singleLoader.run();
                        return;
                    }
                    if (DatasetLoaderUtils.isPRSeries(dmo1) && DatasetLoaderUtils.isPRSeries(dmo2)) {
                        CvImageLoader.getInstance().loadData(port1, new DMObject[]{dmo1}, true);
                        CvImageLoader.getInstance().loadData(port2, new DMObject[]{dmo2}, true);
                        return;
                    }
                    DMTagValueInterface[] allImg1 = dmo1.getRelated("image");
                    DMTagValueInterface[] allImg2 = dmo2.getRelated("image");
                    String result = this.models[0].getDataset().getDataSetValidator().validateImages(allImg1);
                    String str = this.models[1].getDataset().getDataSetValidator().validateImages(allImg2);
                    if (str.equalsIgnoreCase("SUPPORTED_MODALITY") && result.equalsIgnoreCase("SUPPORTED_MODALITY")) {
                        int size2;
                        if (this.isInterrupted) {
                            return;
                        }
                        DMTag[] tags1 = DatasetLoaderUtils.getNeededTags(dmo1);
                        DMTag[] tags2 = DatasetLoaderUtils.getNeededTags(dmo2);
                        ArrayList<CvDMObject> mvDMObjectList1 = DatasetLoaderUtils.sortImagesWithImageNumber((DMObject[])allImg1);
                        ArrayList<CvDMObject> mvDMObjectList2 = DatasetLoaderUtils.sortImagesWithImageNumber((DMObject[])allImg2);
                        int size1 = mvDMObjectList1.size();
                        int maxsize = size1 > (size2 = mvDMObjectList2.size()) ? size1 : size2;
                        XpBlankImageLoader blankLoader = new XpBlankImageLoader();
                        blankLoader.load(port1, this.models[0], CvPropertiesManager.getProperties(), this.monitor);
                        if (this.isInterrupted) {
                            return;
                        }
                        blankLoader.load(port2, this.models[1], CvPropertiesManager.getProperties(), this.monitor);
                        if (this.isInterrupted) {
                            return;
                        }
                        this.monitor.taskBegin("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE", maxsize);
                        int totalnumberOfImagesShow = 0;
                        this.monitor.taskProgress("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE", totalnumberOfImagesShow);
                        while (totalnumberOfImagesShow != maxsize) {
                            int temp;
                            boolean isParsed = false;
                            if (this.isInterrupted) {
                                return;
                            }
                            if (this.frameIndex + 1 > maxsize) {
                                this.frameIndex = 0;
                            }
                            if (size1 > (temp = this.frameIndex) && !mvDMObjectList1.get(temp).isLoadDone()) {
                                final XpMedicalImage[] imgs1 = XpMedicalDmImage.wrapDMImages(mvDMObjectList1.get(temp).getDmObject().getImages(tags1));
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (XpCompareModeLoader.this.isInterrupted) {
                                            return;
                                        }
                                        port1.replaceImage(imgs1[0], temp);
                                    }
                                });
                                mvDMObjectList1.get(temp).setLoadDone(true);
                                isParsed = true;
                            }
                            if (size2 > temp && !mvDMObjectList2.get(temp).isLoadDone()) {
                                final XpMedicalImage[] imgs2 = XpMedicalDmImage.wrapDMImages(mvDMObjectList2.get(temp).getDmObject().getImages(tags2));
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (XpCompareModeLoader.this.isInterrupted) {
                                            return;
                                        }
                                        port2.replaceImage(imgs2[0], temp);
                                    }
                                });
                                mvDMObjectList2.get(temp).setLoadDone(true);
                                isParsed = true;
                            }
                            if (isParsed) {
                                ++totalnumberOfImagesShow;
                                if (this.monitor != null) {
                                    this.monitor.taskProgress("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE", totalnumberOfImagesShow);
                                }
                            }
                            ++this.frameIndex;
                        }
                        this.monitor.taskDone("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE");
                    } else {
                        this.monitor.taskFailed("DATA_LOADING_TASK_2D_CIOMPARE_IMAGE", "INVALID_MODALITY", null);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (ex instanceof InterruptedException) break block18;
                this.monitor.taskFailed("DATA_LOADING_TASK_2D_SINGLE_IMAGE", "DATA_LOADING_EXCEPTION", ex);
            }
        }
    }

    @Override
    public void load(JComponent[] ports, DatasetModel[] models, Properties prop, TaskMonitor monitor) {
        this.ports = ports;
        this.models = models;
        this.monitor = monitor;
        ports[1].addPropertyChangeListener("FrameIndex", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newIndex = ((CvSeriesDisplayer)evt.getSource()).getFrameIndex();
        this.frameIndex = newIndex - 1;
    }
}

