/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.dataloader.adv;

import com.ge.med.cse.cvf.appframework.ContextProvider;
import com.ge.med.cse.cvf.appframework.DataContext;
import com.ge.med.cse.cvf.base.CvImageLoader;
import com.ge.med.cse.cvf.dataloader.DatasetLoaderUtils;
import com.ge.med.cse.cvf.dataloader.DatasetModel;
import com.ge.med.cse.cvf.dataloader.adv.XpBlankImageLoader;
import com.ge.med.cse.cvf.dataloader.adv.XpReplaceImageLoader;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.tap.dm.DMObject;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class XpSingleSeriesLoadRunner
implements Runnable,
Observer {
    private DMObject[] series = null;
    private TaskMonitor taskMonitor = null;
    private XpReplaceImageLoader reploader = null;
    private XpViewport vp = null;

    public XpSingleSeriesLoadRunner(DMObject[] series, XpViewport vp, TaskMonitor taskmonitor) {
        this.series = series;
        this.taskMonitor = taskmonitor;
        this.vp = vp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (DatasetLoaderUtils.isPRSeries(this.series[0])) {
                if (this.vp instanceof XpCompositePort) {
                    this.taskMonitor.taskBegin("DATA_LOADING_TASK_2D_SINGLE_IMAGE", 1);
                    XpCompositePort compPort = (XpCompositePort)this.vp;
                    CvImageLoader.getInstance().loadData(compPort, this.series, true);
                    this.taskMonitor.taskDone("DATA_LOADING_TASK_2D_FUSION_IMAGE");
                }
                return;
            }
            DataContext dataContext = ContextProvider.getDataContext(DatasetLoaderUtils.APP_ID);
            this.reploader = new XpReplaceImageLoader();
            DatasetModel model = dataContext.getDatasetModel("DATASET_2D_1");
            String str = model.getDataset().getDataSetValidator().validateImages(this.series[0].getRelated("image"));
            if ("SUPPORTED_MODALITY".equals(str)) {
                XpBlankImageLoader blankloader = new XpBlankImageLoader();
                model.getDataset().setData(this.series[0]);
                blankloader.load(this.vp, model, CvPropertiesManager.getProperties(), this.taskMonitor);
                this.reploader.load(this.vp, model, CvPropertiesManager.getProperties(), this.taskMonitor);
                if (SwingUtilities.isEventDispatchThread()) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            XpSingleSeriesLoadRunner.this.reploader.run();
                        }
                    });
                    thread.start();
                } else {
                    this.reploader.run();
                }
            }
        }
        finally {
            this.vp = null;
            this.series = null;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.reploader != null) {
            this.reploader.update(o, arg);
        }
    }
}

