/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.j3d.ViewCalculator;
import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.XjVolumeGeometry;
import com.ge.med.jnu.JnVector3d;

public class J3DZPagingViewCalculator
extends ViewCalculator {
    public J3DZPagingViewCalculator() {
    }

    public J3DZPagingViewCalculator(T3DCapable capable) {
        super(capable);
    }

    public J3DZPagingViewCalculator(T3DCapable capable, XjVolumeGeometry vol) {
        super(capable, vol);
    }

    @Override
    protected void updateContent() {
        if (!this.volumeLoaded) {
            return;
        }
        double[] eyept = this.t3dCapable.getEyePoint(null);
        double[] lookpt = this.t3dCapable.getLookPoint(null);
        double[] up = this.t3dCapable.getUp(null);
        if (JnVector3d.distance(this.currentLookPt, lookpt) < 0.01) {
            return;
        }
        this.numViews = this.vdims[2];
        this.firstLookPt.set(this.ulc);
        this.firstLookPt.scaleAdd(0.5, this.xside);
        this.firstLookPt.scaleAdd(0.5, this.yside);
        this.curpos = this.getViewIndex(eyept, lookpt, up);
        System.arraycopy(lookpt, 0, this.currentLookPt, 0, 3);
        System.arraycopy(eyept, 0, this.currentEyePt, 0, 3);
        System.arraycopy(up, 0, this.currentUp, 0, 3);
        this.pcs.firePropertyChange("FrameIndex", -1, this.curpos);
    }

    @Override
    public void getView(int i, double[] eyept, double[] lookpt, double[] up) {
        if (this.curpos == i) {
            this.t3dCapable.getEyePoint(eyept);
            this.t3dCapable.getLookPoint(lookpt);
            this.t3dCapable.getUp(up);
            return;
        }
        lookpt[0] = this.firstLookPt.x;
        lookpt[1] = this.firstLookPt.y;
        lookpt[2] = this.firstLookPt.z;
        JnVector3d.scaleAdd(lookpt, this.zdir, i, lookpt);
        eyept[0] = lookpt[0];
        eyept[1] = lookpt[1];
        eyept[2] = lookpt[2];
        JnVector3d.sub(eyept, JnVector3d.cross(this.xdir, this.ydir).normalize().toArray(), eyept);
        this.t3dCapable.getUp(up);
    }

    @Override
    public int getViewIndex(double[] eyept, double[] lookpt, double[] up) {
        int viewIndex = 0;
        double[] tmpv = new double[3];
        JnVector3d.sub(lookpt, this.firstLookPt.toArray(), tmpv);
        JnVector3d.normalize(tmpv);
        double[] zvec = new double[3];
        JnVector3d.add(this.firstLookPt.toArray(), this.zdir, zvec);
        JnVector3d.normalize(zvec);
        double dotP = JnVector3d.dot(zvec, tmpv);
        if (Math.abs(dotP - 1.0) > 1.0E-5) {
            return -1;
        }
        JnVector3d normal = JnVector3d.cross(this.xdir, this.ydir).normalize();
        JnVector3d.sub(eyept, lookpt, tmpv);
        JnVector3d.normalize(tmpv);
        dotP = JnVector3d.dot(normal.toArray(), tmpv);
        if (Math.abs(dotP - 1.0) > 1.0E-5) {
            return -1;
        }
        viewIndex = (int)Math.floor(JnVector3d.distance(this.firstLookPt.toArray(), lookpt) / JnVector3d.length(this.zdir));
        return viewIndex;
    }
}

