/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d;

import com.ge.med.cse.cvf.idc.MultiSelectionCapable;
import com.ge.med.cse.cvf.j3d.J3DViewport;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.idc.T3DCapable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.XpViewportDirector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class J3DZoomLinkedDirector
implements XpViewportDirector {
    private ArrayList<J3DViewport> portList = new ArrayList();
    private ZoomPropertyChangeListener listener = new ZoomPropertyChangeListener(this);
    private Map<String, String> psValidation = new HashMap<String, String>();

    public J3DZoomLinkedDirector() {
        this.init();
    }

    private void init() {
        String validation = CvPropertiesManager.getProperty("PRIMARY.SECONDARY.J3DZoomLinkedDirector", "AXIAL:AXIAL;CORONAL:CORONAL;SAGITTAL:SAGITTAL;OBLIQUE:OBLIQUE;3D:3D");
        if (validation != null) {
            String[] primarySecondary_pair;
            for (String ps : primarySecondary_pair = validation.split(";")) {
                String[] psKeypair = ps.split(":");
                this.psValidation.put(psKeypair[0], psKeypair[1]);
            }
        }
    }

    @Override
    public void connectViewport(XpViewport viewport) {
        if (!this.portList.contains(viewport) && viewport instanceof T3DCapable) {
            this.portList.add((J3DViewport)viewport);
            ((J3DViewport)viewport).addPropertyChangeListener("viewHeight", this.listener);
        }
    }

    @Override
    public void disconnectAllViewports() {
        for (int i = 0; i < this.portList.size(); ++i) {
            J3DViewport port = this.portList.get(i);
            port.removePropertyChangeListener("viewHeight", this.listener);
        }
        this.portList.clear();
    }

    @Override
    public void disconnectViewport(XpViewport viewport) {
        if (this.portList.contains(viewport)) {
            this.portList.remove(viewport);
            viewport.removePropertyChangeListener("viewHeight", this.listener);
        }
    }

    private void notifyZoom(Object src) {
        if (this.portList.isEmpty()) {
            return;
        }
        if (!this.isPrimaryViewPort((J3DViewport)src)) {
            return;
        }
        J3DViewport source = (J3DViewport)src;
        double height = source.getViewHeight();
        String primary_ViewType = source.getViewType();
        String suppportedViewTypes = this.psValidation.get(primary_ViewType);
        if (suppportedViewTypes != null) {
            suppportedViewTypes = suppportedViewTypes.trim().toLowerCase();
        }
        for (int i = 0; i < this.portList.size(); ++i) {
            J3DViewport port;
            if (this.portList.get(i).equals(source) || !this.portList.get(i).isSelected() || (port = this.portList.get(i)).equals(source) || suppportedViewTypes == null || !suppportedViewTypes.contains(port.getViewType().toLowerCase()) || port.getViewHeight() == height) continue;
            port.setViewHeight(height);
        }
    }

    private boolean isPrimaryViewPort(J3DViewport source) {
        MultiSelectionCapable basescreen = (MultiSelectionCapable)((Object)SwingUtilities.getAncestorOfClass(MultiSelectionCapable.class, source));
        if (basescreen == null) {
            return false;
        }
        for (int i = 0; i < basescreen.getNumComponents(); ++i) {
            if (source != basescreen.getViewportComponent(i) || basescreen.getComponentSelectionState(i) != 0) continue;
            return true;
        }
        return false;
    }

    private static class ZoomPropertyChangeListener
    implements PropertyChangeListener {
        J3DZoomLinkedDirector adaptee;

        public ZoomPropertyChangeListener(J3DZoomLinkedDirector adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.adaptee.notifyZoom(evt.getSource());
        }
    }
}

