/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.action;

import com.ge.med.cse.cvf.base.BaseAction;
import com.ge.med.idc.Capable;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.j3d.Cursor3DVc;
import com.ge.med.terra.jami.j3d.T3DViewport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.logging.Level;

public class J3DShowHideCursorAction
extends BaseAction {
    protected static final String showActionName = "J3D_SHOW_CURSOR";
    protected static final String hideActionName = "J3D_HIDE_CURSOR";
    protected static String actionName = null;
    protected boolean show3dCursor;
    ContainerListener containerlistener = new ContainerAdapter(){

        @Override
        public void componentAdded(ContainerEvent evt) {
            Component c = evt.getChild();
            if (c instanceof Cursor3DVc) {
                J3DShowHideCursorAction.this.show3dCursor = c.isVisible();
                J3DShowHideCursorAction.this.reConfigure(c.isVisible());
            }
        }

        @Override
        public void componentRemoved(ContainerEvent evt) {
            Component c = evt.getChild();
            if (c instanceof Cursor3DVc) {
                J3DShowHideCursorAction.this.show3dCursor = !c.isVisible();
                J3DShowHideCursorAction.this.reConfigure(!c.isVisible());
            }
        }
    };

    @Override
    protected String getName() {
        return actionName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            boolean j3dCursorVisibilityChanged = false;
            XpViewport[] port = this.findViewportsByClass(T3DViewport.class);
            for (int i = 0; i < port.length; ++i) {
                if (!(port[i] instanceof T3DViewport)) continue;
                Component[] comps = ((T3DViewport)port[i]).getT3DComponent().getComponents();
                if (comps == null || comps.length == 0) {
                    return;
                }
                for (int j = 0; j < comps.length; ++j) {
                    if (!(comps[j] instanceof Cursor3DVc)) continue;
                    ((Cursor3DVc)comps[j]).setVisible(!this.show3dCursor);
                    ((Cursor3DVc)comps[j]).repaint();
                    j3dCursorVisibilityChanged = true;
                }
            }
            if (j3dCursorVisibilityChanged) {
                this.reConfigure(!this.show3dCursor);
                this.show3dCursor = !this.show3dCursor;
            }
        }
        catch (Exception exp) {
            this.getLogger().log(Level.WARNING, "Exception during show/hide 3d cursor, stack trace {0}", new Object[]{exp});
        }
    }

    @Override
    public void setCapable(Capable cap) {
        super.setCapable(cap);
        XpViewport[] port = this.findViewportsByClass(T3DViewport.class);
        if (port != null) {
            for (int i = 0; i < port.length; ++i) {
                if (!(port[i] instanceof T3DViewport)) continue;
                ((T3DViewport)port[i]).getT3DComponent().addContainerListener(this.containerlistener);
            }
        }
    }

    protected void reConfigure(boolean bol) {
        actionName = bol ? hideActionName : showActionName;
        super.configure();
    }
}

