/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.util.CvPropertiesManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;

public class VVBatchProtocol {
    public static final String VVBatchProtcolDir = System.getProperty("VVBatchProtcolDir", ".");
    public static final String VOLUME_VIEWER_PROTOCOL_PATH_PROPERTY = "vav.vvProtocolPath";
    protected static String protocolPath = CvPropertiesManager.getProperty("vav.vvProtocolPath", VVBatchProtcolDir);
    public static final String BATCH_PROTOCOL_EXTENTION_PROPERTY = "vav.vvBatchProtocolExtention";
    protected static String batchProtocolExtention = CvPropertiesManager.getProperty("vav.vvBatchProtocolExtention", ".flm");
    public static final String MODALITY_CT = "ct";
    public static final String VIEW_NAME_AXIAL = "Axial";
    public static final String VIEW_NAME_SAGITTAL = "Sagittal";
    public static final String VIEW_NAME_CORONAL = "Coronal";
    public static final String MODEL_OBLIQUE = "Oblique";
    public static final String MODEL_FAN = "fan";
    public static final String MODEL_3D_ROTATION = "Rotation";
    public static final String RENDER_STYLE_AVERAGE = "average";
    public static final String RENDER_STYLE_MIP = "max_voxel";
    public static final String RENDER_STYLE_MINIP = "min_voxel";
    public static final String ROTATE_DIRECTION_LEFT = "left";
    public static final String ROTATE_DIRECTION_RIGHT = "right";
    public static final String ROTATE_DIRECTION_UP = "up";
    public static final String ROTATE_DIRECTION_DOWN = "down";
    public static final String AUTO_FILMING_ON = "On";
    public static final String AUTO_FILMING_OFF = "Off";
    public String name = "Default";
    public String version = "2.0";
    public String viewName = null;
    public String model = "Oblique";
    public String modality = "all";
    public int numberOfViews = 0;
    public double fieldOfView = 0.0;
    public double spacing = 1.0;
    public double thickness = 0.0;
    public double centerX = 0.5;
    public double centerY = 0.5;
    public double vectorX = 0.0;
    public double vectorY = 1.0;
    public double rotation = 18.0;
    public String rotateDirection = "right";
    public double voxelSize = -1.0;
    public String renderMode = "average";
    public String autoFilming = null;
    public String archive = null;
    public int nbCopies = -1;
    public String filmFormat = null;
    public String fileType = null;
    public String buildProtocols = null;
    public String referenceOnFilm = null;
    public String pageOrientation = null;
    public String slotOrientation = null;
    public String protection = null;

    public static final int defaultRenderingQuality() {
        return Integer.parseInt(CvPropertiesManager.getProperty("vav.defaultRenderingQuality", "1"));
    }

    public static List<String> getVolumeViewerProtocolPath() {
        ArrayList<String> protocolDirectories = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(protocolPath, File.pathSeparator);
        while (tokenizer.hasMoreElements()) {
            protocolDirectories.add((String)tokenizer.nextElement());
        }
        return protocolDirectories;
    }

    public static String getBatchProtocolExtention() {
        return batchProtocolExtention;
    }

    public static String[] getBatchProtocolFileList() {
        List<File> files = VVBatchProtocol.getBatchProtocolFiles();
        String[] fileNames = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            fileNames[i] = files.get(i).getName();
        }
        return fileNames;
    }

    public static List<File> getBatchProtocolFiles() {
        ArrayList<File> fileList = new ArrayList<File>();
        FileFilter batchFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return name.endsWith(VVBatchProtocol.getBatchProtocolExtention());
            }
        };
        List<String> directoryList = VVBatchProtocol.getVolumeViewerProtocolPath();
        for (int i = 0; i < directoryList.size(); ++i) {
            File directory = new File(directoryList.get(i));
            VVBatchProtocol.findFilesUnderDirectory(directory, batchFilter, fileList);
        }
        Collections.sort(fileList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                long modTime2;
                long modTime1 = ((File)obj1).lastModified();
                return modTime1 < (modTime2 = ((File)obj2).lastModified()) ? 1 : (modTime2 < modTime1 ? -1 : 0);
            }
        });
        return fileList;
    }

    public static List<File> findBatchProtocolFile(final String fileName) {
        ArrayList<File> fileList = new ArrayList<File>();
        FileFilter batchFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return name.equals(fileName);
            }
        };
        List<String> directoryList = VVBatchProtocol.getVolumeViewerProtocolPath();
        for (int i = 0; i < directoryList.size(); ++i) {
            File directory = new File(directoryList.get(i));
            VVBatchProtocol.findFilesUnderDirectory(directory, batchFilter, fileList);
        }
        Collections.sort(fileList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                long modTime2;
                long modTime1 = ((File)obj1).lastModified();
                return modTime1 < (modTime2 = ((File)obj2).lastModified()) ? 1 : (modTime2 > modTime1 ? -1 : 0);
            }
        });
        return fileList;
    }

    protected static int findFilesUnderDirectory(File directory, FileFilter filter, List<File> filesInDirectory) {
        int i;
        if (!directory.isDirectory()) {
            return 0;
        }
        if (filesInDirectory == null) {
            filesInDirectory = new ArrayList<File>();
        }
        int numFilesAdded = 0;
        File[] files = directory.listFiles(filter);
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                filesInDirectory.add(files[i]);
            }
        }
        if (files != null) {
            numFilesAdded = files.length;
        }
        files = directory.listFiles();
        for (i = 0; i < files.length; ++i) {
            numFilesAdded += VVBatchProtocol.findFilesUnderDirectory(files[i], filter, filesInDirectory);
        }
        return files.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<VVBatchProtocol> getBatchProtocols() throws FileNotFoundException, IOException {
        ArrayList<VVBatchProtocol> protocolList = new ArrayList<VVBatchProtocol>();
        List<File> protocolFiles = VVBatchProtocol.getBatchProtocolFiles();
        for (int i = 0; i < protocolFiles.size(); ++i) {
            try (FileInputStream protocolIS = new FileInputStream(protocolFiles.get(i));){
                VVBatchProtocol protocol = new VVBatchProtocol(protocolIS);
                protocolList.add(protocol);
                continue;
            }
        }
        return protocolList;
    }

    public static VVBatchProtocol getBatchProtocol(String protocolFile) throws FileNotFoundException, IOException {
        VVBatchProtocol protocol = null;
        List<File> files = VVBatchProtocol.findBatchProtocolFile(protocolFile);
        if (files != null && files.size() > 0) {
            FileInputStream fis = new FileInputStream(files.get(0));
            try {
                protocol = new VVBatchProtocol(fis);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException();
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return protocol;
    }

    public static VVBatchProtocol createDefaultProtocol() {
        VVBatchProtocol defaultProtocol = new VVBatchProtocol();
        defaultProtocol.name = "Default";
        defaultProtocol.version = "2.0";
        defaultProtocol.viewName = VIEW_NAME_CORONAL;
        defaultProtocol.model = MODEL_OBLIQUE;
        defaultProtocol.modality = "all";
        defaultProtocol.fieldOfView = 0.0;
        defaultProtocol.spacing = 5.0;
        defaultProtocol.thickness = 5.0;
        defaultProtocol.centerX = 0.5;
        defaultProtocol.centerY = 0.5;
        defaultProtocol.vectorX = 0.0;
        defaultProtocol.vectorY = 1.0;
        defaultProtocol.renderMode = RENDER_STYLE_AVERAGE;
        return defaultProtocol;
    }

    public VVBatchProtocol() {
    }

    public VVBatchProtocol(InputStream protocolStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(protocolStream));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("Name ")) {
                this.name = line.substring(line.indexOf(" ") + 1).replace('_', ' ');
                continue;
            }
            if (line.startsWith("Version ")) {
                this.version = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("ViewName ")) {
                this.viewName = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("Model ")) {
                this.model = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("Modality ")) {
                this.modality = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("NumberOfViews ")) {
                this.numberOfViews = Integer.parseInt(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("FieldOfView ")) {
                this.fieldOfView = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("Spacing ")) {
                this.spacing = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("Thickness ")) {
                this.thickness = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("CenterX ")) {
                this.centerX = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("CenterY ")) {
                this.centerY = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("VectorX ")) {
                this.vectorX = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("VectorY ")) {
                this.vectorY = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("Rotation ")) {
                this.rotation = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("Orientation")) {
                this.rotateDirection = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("Voxel_Size")) {
                this.voxelSize = Double.parseDouble(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("Render_Mode ")) {
                this.renderMode = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("AutoFilming ")) {
                this.autoFilming = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("Archive ")) {
                this.archive = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("NbCopies ")) {
                this.nbCopies = Integer.parseInt(line.substring(line.indexOf(" ") + 1));
                continue;
            }
            if (line.startsWith("FilmFormat ")) {
                this.filmFormat = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("FileType ")) {
                this.fileType = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("BuildProtocols ")) {
                this.buildProtocols = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("ReferenceOnFilm ")) {
                this.referenceOnFilm = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("PageOrientation ")) {
                this.pageOrientation = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (line.startsWith("SlotOrientation ")) {
                this.slotOrientation = line.substring(line.indexOf(" ") + 1);
                continue;
            }
            if (!line.startsWith("Protection ")) continue;
            this.protection = line.substring(line.indexOf(" ") + 1);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getT3DRenderStyle() {
        String style = "AVERAGE";
        switch (VVBatchProtocol.defaultRenderingQuality()) {
            case 2: {
                style = "MAJOR_AXIS_AVERAGE";
                if (this.renderMode.equalsIgnoreCase(RENDER_STYLE_MIP)) {
                    style = "MAJOR_AXIS_MIP";
                    break;
                }
                if (!this.renderMode.equalsIgnoreCase(RENDER_STYLE_MINIP)) break;
                style = "MAJOR_AXIS_MINIP";
                break;
            }
            case 1: {
                style = "AVERAGE";
                if (this.renderMode.equalsIgnoreCase(RENDER_STYLE_MIP)) {
                    style = "MIP";
                    break;
                }
                if (!this.renderMode.equalsIgnoreCase(RENDER_STYLE_MINIP)) break;
                style = "MINIP";
            }
        }
        return style;
    }

    public String toString() {
        return this.name;
    }
}

