/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.j3d.vav;

import com.ge.med.cse.cvf.j3d.vav.BatchParallelTaskManager;
import com.ge.med.cse.cvf.j3d.vav.VVBatchProtocol;
import com.ge.med.cse.cvf.j3d.vav.VavBatchJobContainer;
import com.ge.med.cse.cvf.j3d.vav.VavBatchModel;
import com.ge.med.cse.cvf.j3d.vav.VavBatchSession;
import com.ge.med.cse.cvf.j3d.vav.VavException;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VavBatchManager {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private BatchParallelTaskManager taskManager = new BatchParallelTaskManager();
    private boolean processing_ = false;
    private boolean processingPaused_ = false;
    private String appIdentifier_ = null;
    private List<VavBatchSession> batchSessions = Collections.synchronizedList(new ArrayList());
    private List<VavBatchSession> activebatchSessions = Collections.synchronizedList(new ArrayList());
    private PropertyChangeListener sessionLsnr = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VavBatchSession session = (VavBatchSession)evt.getSource();
            if ("session_aborted_property".equals(evt.getPropertyName()) || "session_completed_property".equals(evt.getPropertyName())) {
                VavBatchManager.this.logger.log(Level.INFO, "Batch Session [" + session.getID() + "] complete or aborted");
                session.removePropertyChangeListener(this);
                VavBatchManager.this.activebatchSessions.remove(session);
            } else {
                if ("session_started_property".equals(evt.getPropertyName())) {
                    VavBatchManager.this.logger.log(Level.INFO, "Batch Session [" + session.getID() + "] started");
                    Object object = VavBatchManager.this.lock;
                    synchronized (object) {
                        VavBatchManager.this.lock.notify();
                    }
                }
                if ("session_error_property".equals(evt.getPropertyName())) {
                    VavBatchManager.this.logger.log(Level.INFO, "Batch Session [" + session.getID() + "] start error : " + evt.getNewValue());
                    Object object = VavBatchManager.this.lock;
                    synchronized (object) {
                        VavBatchManager.this.lock.notify();
                    }
                }
            }
        }
    };
    private Object lock = new Object();

    public VavBatchManager(String appIdentifier) {
        this.appIdentifier_ = appIdentifier;
    }

    public String getName() {
        return this.appIdentifier_;
    }

    public synchronized void startProcessing() {
        if (this.taskManager == null) {
            return;
        }
        if (!this.processing_) {
            this.processing_ = true;
            this.startNextSessionThread();
        }
    }

    public synchronized void shutdown() {
        if (this.processing_) {
            for (int i = 0; i < this.activebatchSessions.size(); ++i) {
                VavBatchSession session = this.activebatchSessions.get(i);
                session.abort();
                session.removePropertyChangeListener(this.sessionLsnr);
            }
            this.activebatchSessions.clear();
            for (VavBatchSession session : this.batchSessions) {
                session.abort();
            }
            this.batchSessions.clear();
            this.processing_ = false;
            this.processingPaused_ = false;
            this.taskManager.shutdown();
            this.taskManager = null;
        }
    }

    public synchronized void pauseProcessing() {
        if (this.processing_ && !this.processingPaused_) {
            this.taskManager.pause();
            this.processingPaused_ = true;
            for (int i = 0; i < this.activebatchSessions.size(); ++i) {
                VavBatchSession session = this.activebatchSessions.get(i);
                session.pause();
            }
        }
    }

    public synchronized void resumeProcessing() {
        if (this.processing_ && this.processingPaused_) {
            this.taskManager.resume();
            this.processingPaused_ = false;
            for (int i = 0; i < this.activebatchSessions.size(); ++i) {
                VavBatchSession session = this.activebatchSessions.get(i);
                session.resume();
            }
        }
    }

    private void startNextSessionThread() {
        Thread th = new Thread(){

            @Override
            public void run() {
                System.err.println("============ startNextSessionThread");
                VavBatchManager.this.nextSession();
            }
        };
        th.setName("VavBatchManager[" + this.appIdentifier_ + "]_nextSessionThread");
        th.start();
    }

    private synchronized boolean isProcessingPaused() {
        return this.processingPaused_;
    }

    private synchronized boolean isProcessingStarted() {
        return this.processing_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextSession() {
        System.err.println("============ nextSession begin");
        while (this.isProcessingStarted()) {
            Object object = this.lock;
            synchronized (object) {
                while (this.isProcessingPaused() || this.batchSessions.isEmpty()) {
                    try {
                        this.lock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.processing_) break;
            System.err.println("============ nextSession processing batch session - begin");
            VavBatchSession session = this.batchSessions.remove(0);
            if (session.isSessioIdle()) {
                session.addPropertyChangeListener(this.sessionLsnr);
                this.activebatchSessions.add(session);
                session.start(this.taskManager);
                System.err.println("============ nextSession processing batch session - session start triggered");
                Object object2 = this.lock;
                synchronized (object2) {
                    if (!session.isSessioStarted() && !session.isSessionError()) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                System.err.println("============ nextSession processing batch session - session started");
            }
            System.err.println("============ nextSession processing batch session - next session loop");
        }
        System.err.println("============ nextSession end");
    }

    public synchronized VavBatchJobContainer addBatchJobs(String[] batchFiles, String[] outputSeriesUIDs, boolean autoBatch, String inputSeriesUID, int startImgNum, int endImgNum) throws VavException {
        if (batchFiles == null || batchFiles.length == 0) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputSeriesUID == null) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input series UID found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        this.logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputSeriesUID, startImgNum, endImgNum);
        session.addBatchJobs(batchFiles, outputSeriesUIDs, autoBatch);
        this.logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(String[] batchFiles, String[] outputSeriesUIDs, boolean autoBatch, XjVolumeInfo inputVolInfo) throws VavException {
        if (batchFiles == null || batchFiles.length == 0) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputVolInfo == null) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input Volume Info found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        this.logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputVolInfo);
        session.addBatchJobs(batchFiles, outputSeriesUIDs, autoBatch);
        this.logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(String[] batchFiles, String[] outputSeriesUIDs, boolean autoBatch, XjVolumeModel inputVolModel) throws VavException {
        if (batchFiles == null || batchFiles.length == 0) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid protocol file found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputVolModel == null) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input Volume Model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        this.logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputVolModel);
        session.addBatchJobs(batchFiles, outputSeriesUIDs, autoBatch);
        this.logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(VavBatchModel[] batchModels, String[] outputSeriesUIDs, String inputSeriesUID, int startImgNum, int endImgNum) throws VavException {
        if (batchModels == null || batchModels.length == 0) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid batch model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputSeriesUID == null) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input series UID found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        this.logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputSeriesUID, startImgNum, endImgNum);
        session.addBatchJobs(batchModels, outputSeriesUIDs);
        this.logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(VavBatchModel[] batchModels, String[] outputSeriesUIDs, XjVolumeInfo inputVolInfo) throws VavException {
        if (batchModels == null || batchModels.length == 0) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid batch model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputVolInfo == null) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input Volume Info found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        this.logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputVolInfo);
        session.addBatchJobs(batchModels, outputSeriesUIDs);
        this.logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public synchronized VavBatchJobContainer addBatchJobs(VavBatchModel[] batchModels, String[] outputSeriesUIDs, XjVolumeModel inputVolModel) {
        if (batchModels == null || batchModels.length == 0) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no valid batch model found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_BATCH_PROTOCOL);
        }
        if (inputVolModel == null) {
            this.logger.log(Level.INFO, "VavBatchManager.addBatchJobs() ..... no input Volume Modwl found");
            throw new VavException(VavException.VavErrorCodes.VAV_INVALID_VOLUME);
        }
        this.logger.log(Level.INFO, "create batch session begin");
        VavBatchSession session = new VavBatchSession();
        session.setVolume(inputVolModel);
        session.addBatchJobs(batchModels, outputSeriesUIDs);
        this.logger.log(Level.INFO, "create jobs end");
        this.batchSessions.add(session);
        return session;
    }

    public static String[] getDefaultBatchProtocols() {
        return VVBatchProtocol.getBatchProtocolFileList();
    }
}

