/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.log;

import com.ge.med.cse.cvf.log.UserMsgUI;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class SimpleUsrMsgUI
extends UserMsgUI
implements ActionListener,
ComponentListener {
    protected Timer timer;
    private JTextArea comp = new JTextArea(2, 1);
    private static final int defaultTimeout = Integer.parseInt(CvPropertiesManager.getProperty("cvf.SimpleUsrMsgUI.defaulttimeout", "10000"));

    public SimpleUsrMsgUI() {
        this.comp.setEditable(false);
        this.comp.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.comp.setFocusable(false);
        this.comp.setLineWrap(true);
        this.comp.setWrapStyleWord(true);
        this.comp.setName("userMessageTextBox");
        this.comp.setBackground(UIManager.getColor("P8"));
        this.comp.setOpaque(true);
        this.timer = new Timer(defaultTimeout, this);
    }

    @Override
    public Container getComponent() {
        return this.comp;
    }

    @Override
    public void publish(final LogRecord record) {
        Object[] params = record.getParameters();
        this.timer.stop();
        int timeout = defaultTimeout;
        if (params != null && params.length > 0 && params[0] instanceof String && ((String)params[0]).startsWith("MSGUITIMEOUT=")) {
            try {
                timeout = Integer.parseInt(((String)params[0]).split("=")[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (timeout > 0) {
            this.timer.setDelay(timeout);
            this.timer.restart();
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleUsrMsgUI.this.comp.setText("");
                    SimpleUsrMsgUI.this.comp.setText(record.getMessage());
                }
            });
        } else {
            this.comp.setText("");
            this.comp.setText(record.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.comp.setText("");
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setActive();
    }

    @Override
    public void dispose() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this);
            this.timer = null;
        }
        super.dispose();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }
}

