/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.plugins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarFile;

public class CvPlugInsBuilder {
    public static final String CV_PLUGIN_COUNT = "CvPlugin_count";
    public static final String CV_PLUGIN_RPEFIX = "CvPlugin";
    public static final String CLASSNAME = "_classname";
    public static final String EXTENSIONS = "_extensions";
    public static final String ICONPATH = "_iconpath";
    public static final String DESCRIPTION = "_description";
    public static final String NAME = "_name";
    public static final String DEPENDENCY = "_dependency";
    private static HashMap<String, ResourceBundle> PLUGIN_I18N_BUNDLE = new HashMap();

    public static boolean validateCvPluginSignature(File jarFileToValidate) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarFileToValidate);
            String plunginCount = jarFile.getManifest().getMainAttributes().getValue(CV_PLUGIN_COUNT);
            if (plunginCount == null) {
                String classname = jarFile.getManifest().getMainAttributes().getValue("CvPlugin_classname");
                String name = jarFile.getManifest().getMainAttributes().getValue("CvPlugin_name");
                if (classname == null || name == null) {
                    return false;
                }
            } else {
                int count = Integer.parseInt(plunginCount);
                for (int i = 0; i < count; ++i) {
                    String countStr = "_" + i;
                    String classname = jarFile.getManifest().getMainAttributes().getValue(CV_PLUGIN_RPEFIX + countStr + CLASSNAME);
                    String name = jarFile.getManifest().getMainAttributes().getValue(CV_PLUGIN_RPEFIX + countStr + NAME);
                    if (classname != null && name != null) continue;
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean loadJarToClassPath(File jarToLoad) {
        JarClassLoader jarLoader = new JarClassLoader();
        try {
            jarLoader.addJarToClassPath(jarToLoad.getAbsolutePath());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getPluginFileAttribute(File f, String attribute, boolean isi18N) {
        String suffix = "";
        String val = null;
        ResourceBundle rb = null;
        if (isi18N) {
            rb = PLUGIN_I18N_BUNDLE.get(f.getName());
            if (rb == null) {
                rb = CvPlugInsBuilder.getResourceBundle(f);
                PLUGIN_I18N_BUNDLE.put(f.getName(), rb);
            }
            if (rb != null) {
                Locale locale = Locale.getDefault();
                suffix = "_" + locale.getLanguage().toLowerCase() + "_" + locale.getCountry().toUpperCase();
                String attributleLocale = attribute + suffix;
                try {
                    if (rb.containsKey(attributleLocale)) {
                        val = rb.getString(attributleLocale);
                    }
                    val = rb.getString(attribute);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        } else {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(f);
                val = jarFile.getManifest().getMainAttributes().getValue(attribute);
                jarFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return val;
            }
        }
        return val;
    }

    private static ResourceBundle getResourceBundle(File f) {
        PropertyResourceBundle prb = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            jarFile.getManifest().write(bao);
            ByteArrayInputStream bai = new ByteArrayInputStream(bao.toByteArray());
            prb = new PropertyResourceBundle(bai);
            bao.close();
            bai.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return prb;
    }

    private static class JarClassLoader {
        private JarClassLoader() {
        }

        public void addJarToClassPath(String jarFilepath) throws Exception {
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, new File(jarFilepath).toURL());
        }
    }
}

