/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.print;

import com.ge.med.cse.cvf.print.XpFilmErrorLookup;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.cse.cvf.util.DicomPageablePort;
import com.ge.med.cse.cvf.util.DicomPrintablePort;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.Doc;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

public class XpPrintJobListener
implements PrintJobListener {
    private Doc printDoc = null;
    private Logger logger = Logger.getLogger(XpPrintJobListener.class.getName());

    public XpPrintJobListener(Doc doc) {
        this.printDoc = doc;
    }

    @Override
    public void printDataTransferCompleted(PrintJobEvent pje) {
        this.logger.log(Level.FINE, "{0} Print Data Transfer Completed");
    }

    @Override
    public void printJobCanceled(PrintJobEvent pje) {
        this.logger.log(Level.FINE, "Printjob canceled");
        if (this.printDoc != null) {
            Object data = null;
            try {
                data = this.printDoc.getPrintData();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (data instanceof DicomPrintablePort) {
                ((DicomPrintablePort)data).dispose();
            } else if (data instanceof DicomPageablePort) {
                ((DicomPageablePort)data).dispose();
            } else if (data instanceof Pageable) {
                int count = ((Pageable)data).getNumberOfPages();
                for (int i = 0; i < count; ++i) {
                    Printable p = ((Pageable)data).getPrintable(i);
                    if (!(p instanceof DicomPrintablePort)) continue;
                    ((DicomPrintablePort)p).dispose();
                }
            }
        }
        pje.getPrintJob().removePrintJobListener(this);
        this.printDoc = null;
    }

    @Override
    public void printJobCompleted(PrintJobEvent pje) {
        this.logger.log(Level.FINE, "job is completed");
        if (this.printDoc != null) {
            Object data = null;
            try {
                data = this.printDoc.getPrintData();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (data instanceof DicomPrintablePort) {
                ((DicomPrintablePort)data).dispose();
            } else if (data instanceof DicomPageablePort) {
                ((DicomPageablePort)data).dispose();
            } else if (data instanceof Pageable) {
                int count = ((Pageable)data).getNumberOfPages();
                for (int i = 0; i < count; ++i) {
                    Printable p = ((Pageable)data).getPrintable(i);
                    if (!(p instanceof DicomPrintablePort)) continue;
                    ((DicomPrintablePort)p).dispose();
                }
            }
        }
        pje.getPrintJob().removePrintJobListener(this);
        this.printDoc = null;
    }

    @Override
    public void printJobFailed(PrintJobEvent pje) {
        String error = null;
        error = pje.getPrintEventType() == 103 ? CvUtils.getResourceBundle().getString("FILM_JOB_FAILED") : XpFilmErrorLookup.getErrorString(pje.getPrintEventType());
        if (error.equals("UNKNOWN_FILM_ERROR")) {
            error = CvUtils.getResourceBundle().getString("FILM_ERROR");
        }
        this.logger.log(Level.INFO, "Printjob failed with code : " + pje.getPrintEventType() + ", " + error);
        if (this.printDoc != null) {
            Object data = null;
            try {
                data = this.printDoc.getPrintData();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (data instanceof DicomPrintablePort) {
                ((DicomPrintablePort)data).dispose();
            } else if (data instanceof DicomPageablePort) {
                ((DicomPageablePort)data).dispose();
            } else if (data instanceof Pageable) {
                int count = ((Pageable)data).getNumberOfPages();
                for (int i = 0; i < count; ++i) {
                    Printable p = ((Pageable)data).getPrintable(i);
                    if (!(p instanceof DicomPrintablePort)) continue;
                    ((DicomPrintablePort)p).dispose();
                }
            }
        }
        pje.getPrintJob().removePrintJobListener(this);
        this.printDoc = null;
    }

    @Override
    public void printJobNoMoreEvents(PrintJobEvent pje) {
        this.logger.log(Level.FINE, "{0} Print Job No More Events");
    }

    @Override
    public void printJobRequiresAttention(PrintJobEvent pje) {
        this.logger.log(Level.FINE, "{0} Print Job Requires Attention");
    }
}

