/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.roi;

import com.ge.med.cse.cvf.util.CvDSAImageUtils;
import com.ge.med.cse.cvf.util.CvUtils;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.marker.XpMarker;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMImage;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class CvCalibrateVc
extends XpMarker {
    private static final Logger logger = Logger.getLogger(CvCalibrateVc.class.getName());
    private Point2D startPt = new Point2D.Double();
    private Point2D endPt = new Point2D.Double();
    private Point2D imageStartPt = new Point2D.Double();
    private Point2D imageEndPt = new Point2D.Double();
    private long distance = 0L;
    public double calibratedFactor = 1.0;
    private Cursor cursor = null;
    private XpDicomElement examid = new XpDicomElement(32, 16);
    private XpDicomElement seriesid = new XpDicomElement(32, 17);
    private XpDicomElement imageid = new XpDicomElement(32, 19);
    private XpDicomElement imageuid = new XpDicomElement(8, 24);
    private XpDicomElement seruid = new XpDicomElement(32, 14);
    public static final String CALIBRATION_DONE = "calibration_done_property";

    public CvCalibrateVc() {
        this.setOpaque(true);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (me.getX() >= 0 && me.getY() >= 0 && me.getX() < this.getWidth() && me.getY() < this.getHeight()) {
            this.endPt.setLocation(me.getPoint());
        } else {
            this.endPt.setLocation(this.getWidth(), this.getHeight());
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.startPt.setLocation(me.getPoint().getX(), me.getPoint().getY());
        this.endPt.setLocation(me.getPoint().getX(), me.getPoint().getY());
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.cursor = Cursor.getPredefinedCursor(1);
        this.setCursor(this.cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent me) {
        this.endPt.setLocation(me.getPoint().getX(), me.getPoint().getY());
        this.repaint();
        XpVisualComponent imgVc = this.getXpVisualComponentParent();
        String _return = (String)JOptionPane.showInputDialog(this, CvUtils.getResourceBundle().getString("XP_CALIBRATE_MESSAGE"), CvUtils.getResourceBundle().getString("XP_CALIBRATE_HEADING"), -1, null, null, "" + this.distance);
        try {
            if (_return != null) {
                if (imgVc != null) {
                    imgVc.remove(this);
                    imgVc.revalidate();
                    imgVc.repaint();
                    this.startPt.setLocation(-1.0, -1.0);
                    this.endPt.setLocation(-1.0, -1.0);
                }
                double calibVal = Double.parseDouble(_return);
                this.calibratedFactor = calibVal / (double)this.distance;
                XpImage img = this.getImage();
                XpSlice slice = img.getSlice();
                slice.pixelSizeX = this.calibratedFactor;
                slice.pixelSizeY = this.calibratedFactor;
                if (img instanceof XpDicomObject) {
                    XpDicomObject dmo = (XpDicomObject)((Object)img);
                    dmo.getValue(this.imageuid);
                    dmo.getValue(this.seruid);
                    CvUtils.putCalibrationFactor(this.seruid.getStringValue(), this.imageuid.getStringValue(), this.calibratedFactor);
                    dmo.getValue(this.examid);
                    dmo.getValue(this.seriesid);
                    dmo.getValue(this.imageid);
                    logger.log(Level.INFO, "CvCalibrateVc.mouseReleased(), calibrated image E" + this.examid.getStringValue() + "/S" + this.seriesid.getStringValue() + "/I" + this.imageid.getStringValue() + "  1 pix = " + this.calibratedFactor + " mm");
                } else {
                    logger.log(Level.INFO, "CvCalibrateVc.mouseReleased()...calibrated image, 1 pix = " + this.calibratedFactor + " mm");
                }
                if (img instanceof XpMedicalDmImage) {
                    int numFrms = 0;
                    DMImage dmImg = ((XpMedicalDmImage)img).getDMImage();
                    DMComposite dmComp = dmImg.getComposite();
                    if (dmComp != null) {
                        numFrms = CvDSAImageUtils.getNumFrames(dmComp);
                        logger.log(Level.INFO, "CvCalibrateVc.mouseReleased()...number of frames for multi-frame IOD = " + numFrms);
                    }
                    if (numFrms > 1) {
                        this.firePropertyChange(CALIBRATION_DONE, -1.0, this.calibratedFactor);
                    }
                }
            } else if (imgVc != null) {
                imgVc.remove(this);
                imgVc.revalidate();
                imgVc.repaint();
                this.startPt.setLocation(-1.0, -1.0);
                this.endPt.setLocation(-1.0, -1.0);
            }
        }
        catch (Exception e) {
            logger.info("CvCalibrateVc.mouseReleased(), exception occured " + e.getMessage());
        }
        finally {
            if (imgVc != null) {
                imgVc.remove(this);
                imgVc.revalidate();
                imgVc.repaint();
                this.startPt.setLocation(-1.0, -1.0);
                this.endPt.setLocation(-1.0, -1.0);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.BLUE);
        g2.drawLine((int)this.startPt.getX(), (int)this.startPt.getY(), (int)this.endPt.getX(), (int)this.endPt.getY());
        this.transformDisplayToImage(this.startPt, this.imageStartPt);
        this.transformDisplayToImage(this.endPt, this.imageEndPt);
        this.distance = Math.abs(Math.round(this.imageEndPt.distance(this.imageStartPt)));
        String calcDist = "(" + this.distance + " pix)";
        g2.drawString(calcDist, (int)this.endPt.getX() + 1, (int)this.endPt.getY() - 1);
    }

    @Override
    public boolean contains(int x, int y) {
        return true;
    }
}

