/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.saveimage;

import com.ge.med.cse.cvf.j3d.utils.J3DGeomUtils;
import com.ge.med.cse.cvf.saveimage.DicomDecorator;
import com.ge.med.cse.cvf.saveimage.XpDicomComposite;
import com.ge.med.cse.cvf.saveimage.XpSaveParameters;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.tap.util.dicom.DicomComposite;

public class MRDicomCompositeFiller
implements DicomDecorator {
    DicomComposite referenceComposite = null;
    XpSaveParameters saveParams = null;

    @Override
    public void setReferenceComposite(DicomComposite referenceComposite) {
        this.referenceComposite = referenceComposite;
    }

    @Override
    public void setReferenceParameters(XpSaveParameters parsms) {
        this.saveParams = parsms;
    }

    @Override
    public void Decorate(XpDicomComposite xp) {
        XpSlice slice = this.saveParams.image.getSlice();
        xp.removeTag(8, 100);
        String imageType = "DERIVED\\SECONDARY\\REFORMATTED";
        if (this.saveParams.renderStyle.equals("MAJOR_AXIS_AVERAGE") || this.saveParams.renderStyle.equals("AVERAGE")) {
            imageType = imageType + "\\AVERAGE";
        } else if (this.saveParams.renderStyle.equals("MAJOR_AXIS_MIP") || this.saveParams.renderStyle.equals("MIP")) {
            imageType = imageType + "\\MIP";
        } else if (this.saveParams.renderStyle.equals("MAJOR_AXIS_MINIP") || this.saveParams.renderStyle.equals("MINIP")) {
            imageType = imageType + "\\MINIP";
        } else if (this.saveParams.renderStyle.equals("FULLBODY_MIP")) {
            imageType = "DERIVED\\SECONDARY\\PJN\\MIP";
        } else if (this.saveParams.renderStyle.equals("FULLBODY_MINIP")) {
            imageType = "DERIVED\\SECONDARY\\PJN\\MINIP";
        } else if (this.saveParams.renderStyle.equals("FULLBODY_AVERAGE")) {
            imageType = "DERIVED\\SECONDARY\\PJN\\AVERAGE";
        } else if (this.saveParams.renderStyle.equals("VOLUME")) {
            imageType = "DERIVED\\SECONDARY\\3D";
        }
        xp.setValue(8, 8, imageType);
        xp.removeTag(8, 4416);
        xp.removeTag(8, 8466);
        if (this.saveParams.sliceSpacing < 0.0) {
            xp.removeTag(24, 136);
        } else {
            xp.setValue(24, 136, XpDicomComposite.formatDouble(this.saveParams.sliceSpacing));
        }
        xp.removeTag(24, 4112);
        xp.removeTag(24, 4118);
        xp.removeTag(24, 4120);
        xp.removeTag(24, 4121);
        xp.removeTag(24, 4882);
        xp.removeTag(25, 4120);
        xp.removeTag(25, 4121);
        xp.removeTag(25, 4122);
        xp.removeTag(25, 4123);
        xp.setValue(25, 4126, XpDicomComposite.formatDouble((double)slice.height * slice.pixelSizeY));
        xp.removeTag(25, 4286);
        short planeType = J3DGeomUtils.getPlaneType(slice);
        String sliceLocation = xp.getSliceLocation(slice, planeType);
        xp.setValue(32, 4161, sliceLocation);
        xp.removeTag(32, 16384);
        xp.removeTag(32, 36950);
        xp.removeTag(32, 36951);
        xp.removeTag(33, 4149);
        xp.removeTag(33, 4150);
        xp.removeTag(33, 4151);
        if (this.saveParams.renderStyle.equals("FULLBODY_MIP") || this.saveParams.renderStyle.equals("FULLBODY_MINIP") || this.saveParams.renderStyle.equals("FULLBODY_AVERAGE")) {
            double[] rotationAngles = new double[3];
            J3DGeomUtils.rotationAnglesBetweenSlices(this.saveParams.inputSliceI, this.saveParams.inputSliceJ, this.saveParams.inputSliceN, slice.I, slice.J, slice.N, rotationAngles);
            xp.setValue(33, 4177, XpDicomComposite.formatDouble(rotationAngles[0]));
            xp.setValue(33, 4178, XpDicomComposite.formatDouble(rotationAngles[1]));
            xp.setValue(33, 4179, XpDicomComposite.formatDouble(rotationAngles[2]));
        }
        xp.removeTag(37, 4103);
        xp.removeTag(37, 4121);
        xp.setValue(39, 4149, new Short(planeType));
        xp.removeTag(39, 4150);
        xp.removeTag(39, 4160);
        xp.removeTag(39, 4161);
        xp.removeTag(39, 4162);
        xp.removeTag(39, 4163);
        xp.removeTag(39, 4164);
        xp.removeTag(39, 4165);
        xp.removeTag(39, 4166);
        xp.removeTag(39, 4167);
        xp.removeTag(39, 4168);
        xp.removeTag(39, 4169);
        xp.removeTag(39, 4170);
        xp.removeTag(39, 4171);
        xp.removeTag(39, 4172);
        xp.removeTag(39, 4173);
        xp.removeTag(39, 4176);
        xp.removeTag(39, 4177);
        xp.removeTag(39, 4192);
        xp.removeTag(39, 4193);
        xp.removeTag(41, 4117);
        xp.removeTag(41, 4118);
        xp.removeTag(41, 4119);
        xp.removeTag(41, 4120);
        xp.removeTag(64, 580);
        xp.removeTag(64, 581);
        xp.setValue(64, 597, "");
        if (this.saveParams.renderStyle.equals("FULLBODY_MIP") || this.saveParams.renderStyle.equals("FULLBODY_MINIP") || this.saveParams.renderStyle.equals("FULLBODY_AVERAGE")) {
            xp.setValue(67, 4144, new Short(6));
        } else {
            xp.removeTag(67, 4144);
        }
        xp.removeTag(67, 4250);
    }
}

