/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.textpage;

import com.ge.hc.cse.commons.interfaces.Formatter;
import com.ge.med.cse.cvf.textpage.UiElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class ContentTableModel
extends AbstractTableModel {
    private UiElement[] localRef;
    private DMObject[] localDMObjRef;
    Logger logger = Logger.getLogger(this.getClass().getName());

    public ContentTableModel(UiElement[] elemsTodisplay, DMObject[] toQuery) {
        this.localRef = elemsTodisplay;
        this.localDMObjRef = toQuery;
    }

    @Override
    public int getColumnCount() {
        return this.localRef.length;
    }

    @Override
    public int getRowCount() {
        return this.localDMObjRef.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object returnValue = null;
        String formatter = this.localRef[columnIndex].strFormatter;
        if (!formatter.equals("null")) {
            Class<?> c = null;
            try {
                c = Class.forName(formatter);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            Formatter f = null;
            try {
                f = (Formatter)c.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (f != null) {
                try {
                    returnValue = f.format(this.localDMObjRef[rowIndex]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.logger.log(Level.WARNING, "Exception in formattor of Text Page table model  message= " + ex.getMessage());
                }
            }
        } else {
            DMTag tagToQuery = this.localRef[columnIndex].getTag();
            if (tagToQuery != null) {
                returnValue = this.localDMObjRef[rowIndex].getValue(tagToQuery);
            }
        }
        return returnValue != null ? returnValue : "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        String name = this.localRef[columnIndex].getName();
        return name;
    }
}

