/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.cse.cvf.util;

import com.ge.med.cse.cvf.base.CvSeriesDisplayer;
import com.ge.med.cse.cvf.util.CvPropertiesManager;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ScreenLayoutHelper
extends MouseAdapter
implements PropertyChangeListener {
    XPscreen screen_;
    protected Map<Integer, CvSeriesDisplayer> sdMap = new HashMap<Integer, CvSeriesDisplayer>();
    private static final Logger logger = Logger.getLogger(ScreenLayoutHelper.class.getName());
    private static ScreenLayoutHelper instance;
    protected static final String PLACE_HOLDER_KEY = "PLACE_HOLDER_KEY";
    private HashMap<String, XPscreenLayout> configuredLayouts = null;
    private HashMap<XPscreenLayout, Dimension[]> configuredVPFormats = null;
    private List<CvSeriesDisplayer> sdList = new Vector<CvSeriesDisplayer>();

    public static ScreenLayoutHelper getInstance() {
        return instance == null ? (instance = new ScreenLayoutHelper()) : instance;
    }

    private ScreenLayoutHelper() {
    }

    public HashMap<String, XPscreenLayout> getConfiguredLayouts() {
        if (this.configuredLayouts == null) {
            this.configuredLayouts = new LinkedHashMap<String, XPscreenLayout>();
            String[] layouts = CvPropertiesManager.getProperties().getProperty("layouts").trim().split(",");
            for (int i = 0; i < layouts.length; ++i) {
                this.configuredLayouts.put(layouts[i], new XPscreenLayout(CvPropertiesManager.getProperties().getProperty(layouts[i])));
            }
        }
        return this.configuredLayouts;
    }

    public Dimension[] getViewportFormats(XPscreenLayout layout) {
        if (this.configuredVPFormats == null) {
            this.configuredVPFormats = new LinkedHashMap<XPscreenLayout, Dimension[]>();
            HashMap<String, XPscreenLayout> layouts = this.getConfiguredLayouts();
            for (String l : layouts.keySet()) {
                String val = CvPropertiesManager.getProperty(l + ".vpformat");
                if (val == null) continue;
                StringTokenizer st = new StringTokenizer(val, ",][");
                Dimension[] formats = new Dimension[st.countTokens() / 2];
                int n = 0;
                while (st.hasMoreElements()) {
                    int row = Integer.parseInt(st.nextToken());
                    int col = Integer.parseInt(st.nextToken());
                    formats[n] = new Dimension(col, row);
                    ++n;
                }
                this.configuredVPFormats.put(layouts.get(l), formats);
            }
        }
        return this.configuredVPFormats.get(layout);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != null && evt.getPropertyName().equalsIgnoreCase("layout_changed")) {
            XPscreenLayout oldLayout = (XPscreenLayout)evt.getOldValue();
            XPscreenLayout newLayout = (XPscreenLayout)evt.getNewValue();
            if (oldLayout != null) {
                this.doLayout(oldLayout, newLayout);
            }
        }
    }

    public void setScreen(XPscreen scrn) {
        if (this.screen_ == scrn) {
            return;
        }
        logger.log(Level.INFO, "Screen refrence set");
        this.screen_ = scrn;
        this.init();
        this.screen_.removePropertyChangeListener(this);
        this.screen_.addPropertyChangeListener("layout_changed", this);
        logger.log(Level.INFO, "Screen refrence set");
    }

    public XPscreen getScreen() {
        return this.screen_;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getComponent() instanceof CvSeriesDisplayer && ((CvSeriesDisplayer)e.getComponent()).getNumFrames() == 0) {
            Integer clientCode = (Integer)((JComponent)e.getSource()).getClientProperty(PLACE_HOLDER_KEY);
            ((JComponent)e.getSource()).firePropertyChange("ComponentSelection", -1, clientCode);
        }
    }

    protected void init() {
        CvSeriesDisplayer serDisp = new CvSeriesDisplayer();
        serDisp.putClientProperty(PLACE_HOLDER_KEY, new Integer(0));
        this.getScreen().setLayout(XPscreenLayout.layout1x1());
        this.getScreen().addPort(serDisp, 0);
        this.sdMap.put(1, serDisp);
    }

    protected void doLayout(XPscreenLayout oldlayout, XPscreenLayout newlayout) {
        int i;
        int newPorts;
        boolean needNewPorts;
        int oldPorts = oldlayout.getNoOfPorts();
        boolean bl = needNewPorts = oldPorts < (newPorts = newlayout.getNoOfPorts());
        if (needNewPorts) {
            for (i = oldPorts; i < newPorts; ++i) {
                CvSeriesDisplayer serDisp = new CvSeriesDisplayer();
                serDisp.addMouseListener(this);
                serDisp.putClientProperty(PLACE_HOLDER_KEY, new Integer(i));
                this.sdMap.put(i + 1, serDisp);
            }
        } else {
            for (i = oldPorts; i > newPorts; --i) {
                CvSeriesDisplayer sd = this.sdMap.remove(i);
                sd.dispose();
                sd.removeMouseListener(this);
            }
        }
        this.getScreen().clearScreen();
        this.getScreen().setLayout(newlayout);
        CvSeriesDisplayer sd1 = this.sdMap.get(1);
        if (oldPorts == 1) {
            sd1.putClientProperty("PREVIOUS_VP_FORMAT", new Dimension(sd1.getCols(), sd1.getRows()));
        }
        Dimension[] dims = this.getViewportFormats(newlayout);
        if (newPorts == 1) {
            Dimension dim = (Dimension)sd1.getClientProperty("PREVIOUS_VP_FORMAT");
            if (dim != null) {
                sd1.setRowCol(dim.height, dim.width);
            } else if (dims != null && dims.length > 0) {
                sd1.setRowCol(dims[0].height, dims[0].width);
            }
            this.getScreen().addPort(sd1, 0);
        } else {
            for (int i2 = 0; i2 < newPorts; ++i2) {
                CvSeriesDisplayer sd = this.sdMap.get(i2 + 1);
                if (dims != null && i2 < dims.length) {
                    sd.setRowCol(dims[i2].height, dims[i2].width);
                }
                this.getScreen().addPort(sd, i2);
            }
        }
        this.getScreen().revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenLayoutHelper.this.sdMap.get(1).setComponentSelection(0);
            }
        });
    }

    protected void selectNeedePort(boolean newPortAdded) {
        Component[] childs;
        this.sdList.clear();
        for (Component child : childs = this.getScreen().getComponents()) {
            if (!(child instanceof CvSeriesDisplayer)) continue;
            this.sdList.add((CvSeriesDisplayer)child);
        }
        Collections.sort(this.sdList, new NumberComparator());
        if (newPortAdded) {
            for (int i = 0; i < this.sdList.size(); ++i) {
                CvSeriesDisplayer sdToCheck = this.sdList.get(i);
                if (sdToCheck.getNumberMedicalImages() > 0) continue;
                Integer clientCode = (Integer)sdToCheck.getClientProperty(PLACE_HOLDER_KEY);
                sdToCheck.firePropertyChange("ComponentSelection", -1, clientCode);
                break;
            }
        } else {
            for (int i = this.sdList.size(); i > 0; --i) {
                CvSeriesDisplayer sdToCheck = this.sdList.get(i - 1);
                if (sdToCheck.getNumberMedicalImages() <= 0) continue;
                Integer clientCode = (Integer)sdToCheck.getClientProperty(PLACE_HOLDER_KEY);
                sdToCheck.firePropertyChange("ComponentSelection", -1, clientCode);
                break;
            }
        }
        this.getScreen().repaint();
    }

    public void removeAll() {
        int size = this.sdMap.size();
        for (int i = 1; i <= size; ++i) {
            CvSeriesDisplayer sd = this.sdMap.remove(i);
            sd.setImages(new DMImage[0]);
            sd.removeMouseListener(this);
            sd.dispose();
        }
        this.sdMap.clear();
        instance = null;
    }

    class NumberComparator
    implements Comparator<CvSeriesDisplayer> {
        NumberComparator() {
        }

        @Override
        public int compare(CvSeriesDisplayer sd1, CvSeriesDisplayer sd2) {
            Integer sd1Val = (Integer)sd1.getClientProperty(ScreenLayoutHelper.PLACE_HOLDER_KEY);
            Integer sd1Va2 = (Integer)sd2.getClientProperty(ScreenLayoutHelper.PLACE_HOLDER_KEY);
            return sd1Val.compareTo(sd1Va2);
        }
    }
}

