/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu;

import com.ge.med.jnu.JnTuple3d;
import com.ge.med.jnu.JnUtils;
import com.ge.med.jnu.JnVector4d;

public class JnVector3d
extends JnTuple3d {
    public JnVector3d() {
    }

    public JnVector3d(double x, double y, double z) {
        this.set(x, y, z);
    }

    public JnVector3d(double[] v) {
        this.set(v);
    }

    public final double[] toArray() {
        return new double[]{this.x, this.y, this.z};
    }

    public final void get(double[] v) {
        v[0] = this.x;
        v[1] = this.y;
        v[2] = this.z;
    }

    public final JnVector3d set(JnVector3d v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public final JnVector3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public final JnVector3d set(double[] v) {
        this.x = v[0];
        this.y = v[1];
        this.z = v[2];
        return this;
    }

    public final JnVector3d add(double[] v1, double[] v2) {
        this.x = v1[0] + v2[0];
        this.y = v1[1] + v2[1];
        this.z = v1[2] + v2[2];
        return this;
    }

    public final JnVector3d sub(double[] v) {
        this.x -= v[0];
        this.y -= v[1];
        this.z -= v[2];
        return this;
    }

    public final JnVector3d sub(double[] v1, double[] v2) {
        this.x = v1[0] - v2[0];
        this.y = v1[1] - v2[1];
        this.z = v1[2] - v2[2];
        return this;
    }

    public final JnVector3d add(double[] v) {
        this.x += v[0];
        this.y += v[1];
        this.z += v[2];
        return this;
    }

    public final JnVector3d add(JnVector3d v1, JnVector3d v2) {
        this.x = v1.x + v2.x;
        this.y = v1.y + v2.y;
        this.z = v1.z + v2.z;
        return this;
    }

    public final JnVector3d add(JnVector3d v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public final JnVector3d sub(JnVector3d v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public final JnVector3d sub(JnVector3d v1, JnVector3d v2) {
        this.x = v1.x - v2.x;
        this.y = v1.y - v2.y;
        this.z = v1.z - v2.z;
        return this;
    }

    public final JnVector3d scale(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    public final JnVector3d scaleAdd(double s, JnVector3d v) {
        this.x += s * v.x;
        this.y += s * v.y;
        this.z += s * v.z;
        return this;
    }

    public final JnVector3d scaleAdd(double s, JnVector3d v1, JnVector3d v2) {
        this.x = s * v1.x + v2.x;
        this.y = s * v1.y + v2.y;
        this.z = s * v1.z + v2.z;
        return this;
    }

    public final JnVector3d scaleAdd(double s, double[] v) {
        this.x += s * v[0];
        this.y += s * v[1];
        this.z += s * v[2];
        return this;
    }

    public final JnVector3d scaleAdd(double s, double[] v1, double[] v2) {
        this.x = s * v1[0] + v2[0];
        this.y = s * v1[1] + v2[1];
        this.z = s * v1[2] + v2[2];
        return this;
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final double dot(JnVector3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final double dot(double[] v) {
        return this.x * v[0] + this.y * v[1] + this.z * v[2];
    }

    public static JnVector3d cross(JnVector3d v1, JnVector3d v2) {
        JnVector3d result = new JnVector3d();
        JnVector3d.cross(v1, v2, result);
        return result;
    }

    public static void cross(JnVector3d v1, JnVector3d v2, JnVector3d result) {
        result.x = v1.y * v2.z - v1.z * v2.y;
        result.y = v1.z * v2.x - v1.x * v2.z;
        result.z = v1.x * v2.y - v1.y * v2.x;
    }

    public static JnVector3d cross(double[] v1, double[] v2) {
        JnVector3d result = new JnVector3d();
        result.x = v1[1] * v2[2] - v1[2] * v2[1];
        result.y = v1[2] * v2[0] - v1[0] * v2[2];
        result.z = v1[0] * v2[1] - v1[1] * v2[0];
        return result;
    }

    public static void cross(double[] v1, double[] v2, double[] result) {
        result[0] = v1[1] * v2[2] - v1[2] * v2[1];
        result[1] = v1[2] * v2[0] - v1[0] * v2[2];
        result[2] = v1[0] * v2[1] - v1[1] * v2[0];
    }

    public static double length(double[] v) {
        return Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
    }

    public static double distance(double[] v0, double[] v1) {
        double dx = v0[0] - v1[0];
        double dy = v0[1] - v1[1];
        double dz = v0[2] - v1[2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static void scale(double[] v, double s) {
        v[0] = v[0] * s;
        v[1] = v[1] * s;
        v[2] = v[2] * s;
    }

    public static void scaleAdd(double[] v0, double[] v1, double s, double[] res) {
        res[0] = v0[0] + s * v1[0];
        res[1] = v0[1] + s * v1[1];
        res[2] = v0[2] + s * v1[2];
    }

    public static void scaleAdd(double[] p0, double[] v0, double s0, double[] v1, double s1, double[] res) {
        res[0] = p0[0] + s0 * v0[0] + s1 * v1[0];
        res[1] = p0[1] + s0 * v0[1] + s1 * v1[1];
        res[2] = p0[2] + s0 * v0[2] + s1 * v1[2];
    }

    public static void scaleAdd(double[] p0, double[] v0, double s0, double[] v1, double s1, double[] v2, double s2, double[] res) {
        res[0] = p0[0] + s0 * v0[0] + s1 * v1[0] + s2 * v2[0];
        res[1] = p0[1] + s0 * v0[1] + s1 * v1[1] + s2 * v2[1];
        res[2] = p0[2] + s0 * v0[2] + s1 * v1[2] + s2 * v2[2];
    }

    public static double[] center(double[][] pts) {
        double[] result = new double[]{0.0, 0.0, 0.0};
        for (int i = 0; i < pts.length; ++i) {
            result[0] = result[0] + pts[i][0];
            result[1] = result[1] + pts[i][1];
            result[2] = result[2] + pts[i][2];
        }
        result[0] = result[0] / (double)pts.length;
        result[1] = result[1] / (double)pts.length;
        result[2] = result[2] / (double)pts.length;
        return result;
    }

    public static void normalize(double[] v) {
        double len = JnVector3d.length(v);
        v[0] = v[0] / len;
        v[1] = v[1] / len;
        v[2] = v[2] / len;
    }

    public static void sub(double[] v1, double[] v2, double[] res) {
        res[0] = v1[0] - v2[0];
        res[1] = v1[1] - v2[1];
        res[2] = v1[2] - v2[2];
    }

    public static double dot(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public static void add(double[] v1, double[] v2, double[] res) {
        res[0] = v1[0] + v2[0];
        res[1] = v1[1] + v2[1];
        res[2] = v1[2] + v2[2];
    }

    public static void vprint(double[] v) {
        System.err.println("[" + v[0] + "," + v[1] + "," + v[2] + "]");
    }

    public static void vprint(String title, double[] v) {
        System.err.println("" + title + " : [" + v[0] + "," + v[1] + "," + v[2] + "]");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        JnVector3d v3d = (JnVector3d)other;
        return this.x == v3d.x && this.y == v3d.y && this.z == v3d.z;
    }

    public final double angle(JnVector3d v) {
        double dotVal = this.dot(v);
        double l1 = this.length();
        double l2 = v.length();
        double angle = Math.acos(dotVal / (l1 * l2));
        return angle;
    }

    public final JnVector3d normalize() {
        double lenInv = 1.0 / this.length();
        this.x *= lenInv;
        this.y *= lenInv;
        this.z *= lenInv;
        return this;
    }

    public final double[] generateArray() {
        double[] a = new double[]{this.x, this.y, this.z};
        return a;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public final JnVector3d setLocation(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public final void setLocation(JnVector3d v) {
        this.setLocation(v.x, v.y, v.z);
    }

    public final void setLocation(double[] v) {
        this.setLocation(v[0], v[1], v[2]);
    }

    public final void setLocation(JnVector4d v) {
        this.setLocation(v.x, v.y, v.z);
    }

    public final double magnitudeSq() {
        return this.lengthSquared();
    }

    public final double magnitude() {
        return this.length();
    }

    public final JnVector3d subtract(JnVector3d p) {
        return this.sub(p);
    }

    public final JnVector3d multiplyBy(double d) {
        return this.scale(d);
    }

    public final double distance(JnVector3d p) {
        return Math.sqrt(this.sqDistance(p));
    }

    public final double sqDistance(JnVector3d p) {
        double dx = p.x - this.x;
        double dy = p.y - this.y;
        double dz = p.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final double distanceToPlane(JnVector3d planeNormal, JnVector3d planePoint) {
        double d = planeNormal.x * (this.x - planePoint.x) + planeNormal.y * (this.y - planePoint.y) + planeNormal.z * (this.z - planePoint.z);
        return Math.abs(d);
    }

    public final void fillArray(double[] array) {
        array[0] = this.x;
        array[1] = this.y;
        array[2] = this.z;
    }

    public final void fillArray(double[] array, int offset, int stride) {
        array[offset] = this.x;
        array[offset + stride] = this.y;
        array[offset + 2 * stride] = this.z;
    }

    public final void fillArray(double[] array, int offset) {
        this.fillArray(array, offset, 1);
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    public int hashCode() {
        int result = 1;
        long bits = JnUtils.doubleToLongBits(this.x);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.y);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = JnUtils.doubleToLongBits(this.z);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

