/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.jnu.geom;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.Rectangle3D;
import com.ge.med.jnu.geom.Shape3D;

public class VoxelIterator {
    private Rectangle3D bounds = new Rectangle3D();
    private Shape3D shape3d = null;
    private double dx = 1.0;
    private double dy = 1.0;
    private double dz = 1.0;
    private JnVector3d cpos = new JnVector3d();
    private boolean eop = false;
    private int w = 0;
    private int h = 0;
    private int d = 0;
    private int zidx = -1;
    private int xyidx = -1;
    private int[][] contains = null;
    private int[][] end = null;

    public VoxelIterator(Shape3D shape3d, double dx, double dy, double dz) {
        this.shape3d = shape3d;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.reset();
    }

    public boolean reset() {
        this.shape3d.getBounds3D(this.bounds);
        double bw = this.bounds.getWidth();
        double bh = this.bounds.getHeight();
        double bd = this.bounds.getDepth();
        this.w = (int)(bw / this.dx + 0.5);
        this.h = (int)(bh / this.dy + 0.5);
        this.d = (int)(bd / this.dz + 0.5);
        this.contains = new int[2][this.w * this.h];
        double y = this.bounds.y;
        int i = 0;
        while (i < this.h) {
            int offset = i * this.w;
            double x = this.bounds.x;
            int j = 0;
            while (j < this.w) {
                this.contains[0][offset + j] = -1;
                this.contains[1][offset + j] = -1;
                double z = this.bounds.z;
                int k = 0;
                while (k < this.d) {
                    if (this.shape3d.contains(x, y, z)) {
                        this.contains[0][offset + j] = k;
                        break;
                    }
                    ++k;
                    z += this.dz;
                }
                z = this.bounds.z + (double)(this.d - 1) * this.dz;
                k = this.d - 1;
                while (k >= 0) {
                    if (this.shape3d.contains(x, y, z)) {
                        this.contains[1][offset + j] = k;
                        break;
                    }
                    --k;
                    z -= this.dz;
                }
                ++j;
                x += this.dx;
            }
            ++i;
            y += this.dy;
        }
        this.zidx = -1;
        this.xyidx = 0;
        for (i = 0; i < this.contains[0].length; ++i) {
            if (this.contains[0][i] == -1) continue;
            this.zidx = this.contains[0][i];
            this.xyidx = i;
            break;
        }
        if (this.zidx == -1) {
            System.err.println("[JNU] VoxelIterator.reset: Shape3D contains no interior points??");
            this.eop = true;
            return false;
        }
        this.calcPoint(this.zidx, this.xyidx);
        this.eop = false;
        return true;
    }

    private void calcPoint(int zidx, int xyidx) {
        int xidx = xyidx % this.w;
        int yidx = xyidx / this.w;
        this.cpos.x = this.bounds.x + (double)xidx * this.dx;
        this.cpos.y = this.bounds.y + (double)yidx * this.dy;
        this.cpos.z = this.bounds.z + (double)zidx * this.dz;
    }

    public final boolean isDone() {
        return this.eop;
    }

    public final void next() {
        if (this.zidx != -1) {
            ++this.zidx;
            if (this.zidx <= this.contains[1][this.xyidx]) {
                this.calcPoint(this.zidx, this.xyidx);
                return;
            }
            this.zidx = -1;
            ++this.xyidx;
            while (this.xyidx < this.contains[0].length) {
                if (this.contains[0][this.xyidx] != -1) {
                    this.zidx = this.contains[0][this.xyidx];
                    this.calcPoint(this.zidx, this.xyidx);
                    return;
                }
                ++this.xyidx;
                if (this.xyidx < this.contains[0].length) continue;
                this.zidx = -1;
                this.eop = true;
                return;
            }
        }
    }

    public void currentVoxelPosition(JnVector3d pos) {
        pos.set(this.cpos);
    }

    public final double getDeltaX() {
        return this.dx;
    }

    public final double getDeltaY() {
        return this.dy;
    }

    public final double getDeltaZ() {
        return this.dz;
    }
}

