/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.border;

import com.ge.med.ptk.shape.RoundCornerRectangle;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.border.MatteBorder;

public class RoundedMatteBorder
extends MatteBorder {
    protected Color cornerColor_;
    protected double[] cornerWidths_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public RoundedMatteBorder(Insets borderInsets, Color matteColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, Color matteColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(Insets borderInsets, double cornerRadius, Color matteColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(new double[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, double cornerRadius, Color matteColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(Insets borderInsets, double[] cornerRadii, Color matteColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(cornerRadii);
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, double radiusNW, double radiusSW, double radiusSE, double radiusNE, Color matteColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{radiusNW, radiusSW, radiusSE, radiusNE});
        this.cornerColor_ = new Color(0, true);
    }

    public RoundedMatteBorder(Insets borderInsets, Color matteColor, Color cornerColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, Color matteColor, Color cornerColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY});
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(Insets borderInsets, double cornerRadius, Color matteColor, Color cornerColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(new double[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius});
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, double cornerRadius, Color matteColor, Color cornerColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{cornerRadius, cornerRadius, cornerRadius, cornerRadius});
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(Insets borderInsets, double[] cornerRadii, Color matteColor, Color cornerColor) {
        super(borderInsets, matteColor);
        this.setCornerRadii(cornerRadii);
        this.cornerColor_ = cornerColor;
    }

    public RoundedMatteBorder(int top, int left, int bottom, int right, double radiusNW, double radiusSW, double radiusSE, double radiusNE, Color matteColor, Color cornerColor) {
        super(top, left, bottom, right, matteColor);
        this.setCornerRadii(new double[]{radiusNW, radiusSW, radiusSE, radiusNE});
        this.cornerColor_ = cornerColor;
    }

    private final void setCornerRadii(double[] radii) {
        Insets insets = this.getBorderInsets();
        this.cornerWidths_ = new double[]{2.0 * Math.min(radii[0], (double)Math.max(insets.top, insets.left)), 2.0 * Math.min(radii[1], (double)Math.max(insets.left, insets.bottom)), 2.0 * Math.min(radii[2], (double)Math.max(insets.bottom, insets.right)), 2.0 * Math.min(radii[3], (double)Math.max(insets.right, insets.top))};
    }

    @Override
    public boolean isBorderOpaque() {
        return this.cornerColor_.getAlpha() < 255 ? false : super.isBorderOpaque();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.cornerColor_.getAlpha() > 0) {
            g.setColor(this.cornerColor_);
            g.fillRect(0, 0, (int)Math.ceil(this.cornerWidths_[0] / 2.0), (int)Math.ceil(this.cornerWidths_[0] / 2.0));
            g.fillRect(0, y + height - (int)Math.ceil(this.cornerWidths_[1] / 2.0), (int)Math.ceil(this.cornerWidths_[1] / 2.0), (int)Math.ceil(this.cornerWidths_[1] / 2.0));
            g.fillRect(x + width - (int)Math.ceil(this.cornerWidths_[1] / 2.0), y + height - (int)Math.ceil(this.cornerWidths_[1] / 2.0), (int)Math.ceil(this.cornerWidths_[2] / 2.0), (int)Math.ceil(this.cornerWidths_[2] / 2.0));
            g.fillRect(x + width - (int)Math.ceil(this.cornerWidths_[1] / 2.0), 0, (int)Math.ceil(this.cornerWidths_[3] / 2.0), (int)Math.ceil(this.cornerWidths_[3] / 2.0));
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundCornerRectangle shape = new RoundCornerRectangle((double)x, (double)y, (double)width, (double)height, this.cornerWidths_, this.cornerWidths_);
        Shape saveClip = g.getClip();
        Area clip = new Area(new Rectangle2D.Double(x, y, width, height));
        clip.subtract(new Area(new Rectangle2D.Double(x + this.getBorderInsets((Component)c).left, y + this.getBorderInsets((Component)c).top, width - this.getBorderInsets((Component)c).left - this.getBorderInsets((Component)c).right, height - this.getBorderInsets((Component)c).top - this.getBorderInsets((Component)c).bottom)));
        ((Graphics2D)g).clip(clip);
        g.setColor(this.getMatteColor());
        ((Graphics2D)g).fill(shape);
        g.setClip(saveClip);
    }
}

