/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.Utilities;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.Border;

public class CuiListCellRenderer
extends DefaultListCellRenderer {
    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
        this.setComponentOrientation(list.getComponentOrientation());
        this.setOpaque(true);
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        Border border = null;
        if (focus) {
            border = Utilities.getUIPropertyBorder(list, "List.focusCellHighlightBorder");
        }
        if (!focus || border == null) {
            border = Utilities.getUIPropertyBorder(list, "List.cellBorder");
        }
        if (border != null) {
            this.setBorder(border);
        }
        if (selected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            Color foreground = list.getForeground();
            Color background = list.getBackground();
            List rowColors = (List)list.getClientProperty("rowColors");
            if (rowColors != null) {
                this.setBackground((Color)rowColors.get(index));
                this.setForeground(foreground);
            } else if (index % 2 == 0) {
                this.setForeground(foreground);
                this.setBackground(background);
            } else {
                Color alternateForeground = foreground instanceof javax.swing.plaf.UIResource ? Utilities.getUIPropertyColor(list, "List.alternateForeground") : null;
                Color alternateBackground = background instanceof javax.swing.plaf.UIResource ? Utilities.getUIPropertyColor(list, "List.alternateBackground") : null;
                this.setForeground(alternateForeground != null ? alternateForeground : foreground);
                this.setBackground(alternateBackground != null ? alternateBackground : background);
            }
        }
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            if (value instanceof Object[] && ((Object[])value).length >= 1 && ((Object[])value)[0] instanceof Icon) {
                this.setIcon((Icon)((Object[])value)[0]);
            } else {
                this.setIcon(null);
            }
            if (value instanceof Object[] && ((Object[])value).length >= 2 && ((Object[])value)[1] instanceof String) {
                this.setText((String)((Object[])value)[1]);
            } else {
                this.setText(value == null ? "" : value.toString());
            }
        }
        return this;
    }

    public static class UIResource
    extends CuiListCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

