/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.utilities.VersionStamp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class CuiTreeControlIcon
implements Icon,
UIResource,
Serializable {
    protected int size_;
    protected boolean open_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public CuiTreeControlIcon() {
        this(11, false);
    }

    public CuiTreeControlIcon(int size, boolean open) {
        this.size_ = (int)Math.round((double)size * CuiLookAndFeel.getScale());
        this.open_ = open;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color background;
        int weight = Math.max(1, this.size_ / 10);
        if (this.size_ > 25 && weight % 2 != this.size_ % 2) {
            ++weight;
        }
        if ((background = UIManager.getColor("P7")) == null) {
            background = c.getBackground();
        }
        g.setColor(background);
        g.fillRect(x, y, this.size_, this.size_);
        Color foreground = UIManager.getColor("P11");
        if (foreground == null) {
            foreground = c.getForeground();
        }
        g.setColor(foreground);
        for (int i = 0; i < weight; ++i) {
            g.drawRect(x + i, y + i, this.size_ - 2 * i - 1, this.size_ - 2 * i - 1);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).fill(new Rectangle2D.Double(x + 2 * weight, (double)y + (double)(this.size_ - weight) / 2.0, this.size_ - 4 * weight, weight));
        if (!this.open_) {
            ((Graphics2D)g).fill(new Rectangle2D.Double((double)x + (double)(this.size_ - weight) / 2.0, y + 2 * weight, weight, this.size_ - 4 * weight));
        }
    }

    @Override
    public int getIconWidth() {
        return this.size_;
    }

    @Override
    public int getIconHeight() {
        return this.size_;
    }
}

