/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.laf;

import com.ge.med.ptk.laf.BaseTextUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.View;

public class DefaultTextUtilities
extends BaseTextUtilities
implements SwingConstants {
    static boolean oldJRE_;
    static Pattern noRotate_;

    @Override
    public void paintView(View v, Graphics g, Rectangle rect, int rotate) {
        if (rotate == 0) {
            v.paint(g, rect);
        } else {
            g.translate(rect.x, rect.y + rect.height);
            ((Graphics2D)g).rotate(-1.5707963267948966);
            v.paint(g, new Rectangle(0, 0, rect.height, rect.width));
            ((Graphics2D)g).rotate(1.5707963267948966);
            g.translate(-rect.x, -(rect.y + rect.height));
        }
    }

    static boolean containsNoRotate(String text) {
        if (oldJRE_) {
            return false;
        }
        try {
            if (noRotate_ == null) {
                String noRotate = (String)UIManager.get("DefaultTextUtilities.noRotate");
                noRotate_ = Pattern.compile(noRotate != null ? noRotate : "");
            }
            return noRotate_.matcher(text).find();
        }
        catch (NoSuchMethodError nsm) {
            oldJRE_ = true;
            return false;
        }
    }

    @Override
    public void drawStringUnderlineCharAt(Graphics g, String text, int index, int x, int y, int rotate, JComponent c) {
        if (rotate != 0 && text != null && !text.equals("") && DefaultTextUtilities.containsNoRotate(text)) {
            String hiragana = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e";
            String katakana = "\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
            String commaStop = "\u3001\u3002";
            FontMetrics fm = g.getFontMetrics();
            int fCharHeight = fm.getAscent() + fm.getDescent();
            int fDescent = fm.getDescent();
            int len = text.length();
            char[] data = new char[len];
            text.getChars(0, len, data, 0);
            int fWidth = 0;
            String[] fCharStrings = new String[len];
            int[] fCharWidths = new int[len];
            int[] fPosition = new int[len];
            for (int i = 0; i < len; ++i) {
                char ch = data[i];
                fCharWidths[i] = fm.charWidth(ch);
                if (fCharWidths[i] > fWidth) {
                    fWidth = fCharWidths[i];
                }
                fCharStrings[i] = new String(data, i, 1);
                fPosition[i] = commaStop.indexOf(ch) >= 0 ? 2 : (hiragana.indexOf(ch) >= 0 || katakana.indexOf(ch) >= 0 ? 1 : 0);
            }
            int fHeight = fCharHeight * len + fDescent;
            int yPos = y - fm.getAscent() + fCharHeight;
            for (int i = 0; i < fCharStrings.length; ++i) {
                switch (fPosition[i]) {
                    case 0: {
                        g.drawString(fCharStrings[i], x + (fWidth - fCharWidths[i]) / 2, yPos);
                        break;
                    }
                    case 1: {
                        int tweak = fCharHeight / 3;
                        g.drawString(fCharStrings[i], x + tweak / 2, yPos - tweak);
                        break;
                    }
                    case 2: {
                        int tweak = fCharHeight - fCharHeight / 3;
                        g.drawString(fCharStrings[i], x + tweak / 2, yPos - tweak);
                    }
                }
                yPos += fCharHeight;
            }
        } else if (rotate != 0) {
            FontMetrics fm = g.getFontMetrics();
            g.translate(x, y - fm.getAscent() + fm.stringWidth(text));
            ((Graphics2D)g).rotate(-Math.toRadians(90.0));
            this.BasicGraphicsUtils_drawStringUnderlineCharAt(g, text, index, 0, fm.getAscent());
            ((Graphics2D)g).rotate(Math.toRadians(90.0));
            g.translate(-x, -(y - fm.getAscent() + fm.stringWidth(text)));
        } else {
            this.BasicGraphicsUtils_drawStringUnderlineCharAt(g, text, index, x, y);
        }
    }

    @Override
    public String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int vAlign, int hAlign, int vTextPos, int hTextPos, Rectangle viewR, Rectangle iconR, Rectangle textR, int gap, int rotate) {
        String s;
        Icon ic;
        int hA;
        int vP;
        int vA;
        boolean lToR;
        Rectangle viewRR = rotate == 0 ? viewR : new Rectangle(viewR.y, viewR.x, viewR.height, viewR.width);
        boolean bl = lToR = rotate != 0 && c != null && c.getComponentOrientation().isLeftToRight();
        int n = rotate == 0 ? vAlign : (hAlign == 0 ? 0 : (vA = hAlign == 2 || hAlign == 10 && lToR ? 1 : 3));
        int n2 = rotate == 0 ? vTextPos : (hTextPos == 0 ? 0 : (vP = hTextPos == 2 || hTextPos == 10 && lToR ? 1 : 3));
        int n3 = rotate == 0 ? hAlign : (vAlign == 0 ? 0 : (hA = vAlign == 1 ? 2 : 4));
        int hP = rotate == 0 ? hTextPos : (vTextPos == 0 ? 0 : (vTextPos == 1 ? 2 : 4));
        Icon icon2 = ic = rotate == 0 || icon == null ? icon : new DummyRotatedIcon(icon);
        if (rotate != 0 && text != null && !text.equals("") && c != null && c.getClientProperty("html") == null && DefaultTextUtilities.containsNoRotate(text)) {
            String hiragana = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e";
            String katakana = "\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
            String commaStop = "\u3001\u3002";
            int fCharHeight = fm.getAscent() + fm.getDescent();
            int fDescent = fm.getDescent();
            int len = text.length();
            char[] data = new char[len];
            text.getChars(0, len, data, 0);
            int fWidth = 0;
            String[] fCharStrings = new String[len];
            int[] fCharWidths = new int[len];
            int[] fPosition = new int[len];
            for (int i = 0; i < len; ++i) {
                char ch = data[i];
                fCharWidths[i] = fm.charWidth(ch);
                if (fCharWidths[i] > fWidth) {
                    fWidth = fCharWidths[i];
                }
                fCharStrings[i] = new String(data, i, 1);
                fPosition[i] = commaStop.indexOf(ch) >= 0 ? 2 : (hiragana.indexOf(ch) >= 0 || katakana.indexOf(ch) >= 0 ? 1 : 0);
            }
            int fHeight = fCharHeight * len + fDescent;
            s = SwingUtilities.layoutCompoundLabel(new JLabel("<html><pre width=" + fHeight + " height=" + fWidth + "></pre></html>"){

                @Override
                public Font getFont() {
                    return new Font("Dialog", 1, 0);
                }
            }, fm, text, ic, vA, hA, vP, hP, viewRR, iconR, textR, gap);
        } else {
            String string = s = c == null ? SwingUtilities.layoutCompoundLabel(fm, text, ic, vA, hA, vP, hP, viewRR, iconR, textR, gap) : SwingUtilities.layoutCompoundLabel(c, fm, text, ic, vA, hA, vP, hP, viewRR, iconR, textR, gap);
        }
        if (rotate != 0) {
            iconR.setBounds(iconR.y, iconR.x, iconR.height, iconR.width);
            textR.setBounds(textR.y, textR.x, textR.height, textR.width);
        }
        return s;
    }

    protected static class DummyRotatedIcon
    implements Icon {
        protected Dimension size_;

        public DummyRotatedIcon(Icon realIcon) {
            this.size_ = new Dimension(realIcon.getIconHeight(), realIcon.getIconWidth());
        }

        @Override
        public int getIconWidth() {
            return this.size_.width;
        }

        @Override
        public int getIconHeight() {
            return this.size_.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

