/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.shape;

import com.ge.med.ptk.laf.CuiLookAndFeel;
import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.utilities.VersionStamp;

public class EdgeProfileBeveled
implements EdgeProfile {
    protected int interiorWidth_;
    protected int exteriorWidth_;
    protected double slope_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public EdgeProfileBeveled() {
        this((int)Math.ceil(CuiLookAndFeel.getInteriorEdge()), (int)Math.ceil(CuiLookAndFeel.getExteriorEdge()), CuiLookAndFeel.getBevelSlope());
    }

    public EdgeProfileBeveled(int interiorWidth, int exteriorWidth) {
        this(interiorWidth, exteriorWidth, 0.2);
    }

    public EdgeProfileBeveled(int interiorWidth, int exteriorWidth, double slope) {
        this.interiorWidth_ = interiorWidth;
        this.exteriorWidth_ = exteriorWidth;
        this.slope_ = slope;
    }

    @Override
    public double getInteriorWidth() {
        return this.interiorWidth_;
    }

    @Override
    public double getExteriorWidth() {
        return this.exteriorWidth_;
    }

    @Override
    public double getSlope(double distanceFromShape) {
        if (distanceFromShape <= (double)(-this.exteriorWidth_) || distanceFromShape >= (double)this.interiorWidth_) {
            return 0.0;
        }
        return distanceFromShape < 0.0 ? -this.slope_ : this.slope_;
    }

    public String toString() {
        return "EdgeProfileBeveled[" + this.getInteriorWidth() + "," + this.getExteriorWidth() + "," + this.slope_ + "]";
    }
}

