/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.ptk.shape;

import com.ge.med.ptk.shape.EdgeProfile;
import com.ge.med.ptk.utilities.VersionStamp;

public class EdgeProfileOgee
implements EdgeProfile {
    protected double interiorWidth_;
    protected double exteriorWidth_;
    protected double slope_;

    public static void main(String[] argv) {
        VersionStamp.handleVersionQuery(argv, "@(#)ptk2 2.8.1 202304241428 (Amazon.com Inc.|1.8.0_275|52.0|Linux|3.10.0-514.6.1.el7.x86_64|amd64|batbuild)");
    }

    public EdgeProfileOgee(double interiorWidth, double exteriorWidth, double slope) {
        this.interiorWidth_ = interiorWidth;
        this.exteriorWidth_ = exteriorWidth;
        this.slope_ = slope;
    }

    @Override
    public double getInteriorWidth() {
        return this.interiorWidth_;
    }

    @Override
    public double getExteriorWidth() {
        return this.exteriorWidth_;
    }

    @Override
    public double getSlope(double distanceFromShape) {
        if (distanceFromShape <= -this.exteriorWidth_ || distanceFromShape >= this.interiorWidth_) {
            return 0.0;
        }
        if (distanceFromShape < 0.0) {
            return this.slope_ * (this.exteriorWidth_ + distanceFromShape) * (this.exteriorWidth_ + distanceFromShape) / (this.exteriorWidth_ * this.exteriorWidth_);
        }
        return this.slope_ * (this.interiorWidth_ - distanceFromShape) * (this.interiorWidth_ - distanceFromShape) / (this.interiorWidth_ * this.interiorWidth_);
    }

    public String toString() {
        return "EdgeProfileOgee[" + this.getInteriorWidth() + "," + this.getExteriorWidth() + "," + this.slope_ + "]";
    }
}

