/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.JnPoint2D;
import java.io.Serializable;

public abstract class CPointBase
extends JnVector3d
implements Cloneable,
Serializable {
    public static final byte IMAGE = 0;
    public static final byte DISPLAY = 1;
    public static final byte RAS = 2;
    public static final byte NORMALIZED = 3;
    public static final byte LPS = 4;
    public static final byte VOXEL = 5;
    private static String[] csysname = new String[]{"IMAGE", "DISPLAY", "RAS", "NORMALIZED", "LPS", "VOXEL"};
    public byte csystem = (byte)2;

    public CPointBase() {
    }

    public CPointBase(byte csystem) {
        this.csystem = csystem;
    }

    public CPointBase(double[] p, byte csystem) {
        this.setPoint(p[0], p[1], p[2], csystem);
    }

    public CPointBase(double x, double y, double z, byte csystem) {
        this.setPoint(x, y, z, csystem);
    }

    public CPointBase(int x, int y, int z, byte csystem) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.csystem = csystem;
    }

    public static String getCSystem(byte csystem_val) {
        return csysname[csystem_val];
    }

    @Override
    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")_" + csysname[this.csystem];
    }

    public final void setPoint(CPointBase cp) {
        this.setPoint(cp.x, cp.y, cp.z, cp.csystem);
    }

    public final void setPoint(double x, double y, double z, byte csystem) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.csystem = csystem;
    }

    public final void setPoint(CPointBase p0, CPointBase p) {
        this.x = p.x - p0.x;
        this.y = p.y - p0.y;
        this.z = p.z - p0.z;
        this.csystem = p.csystem;
    }

    public final void setPoint(JnPoint2D p0, JnPoint2D p) {
        this.x = p.getX() - p0.getX();
        this.y = p.getY() - p0.getY();
        this.z = 0.0;
        this.csystem = 1;
    }
}

