/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CodecUtils {
    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static char getChar(byte[] b, int off) {
        return (char)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static short getShort(byte[] b, int off) {
        return (short)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static int getInt(byte[] b, int off) {
        return ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static String getString(byte[] b, int off) {
        int len = CodecUtils.getShort(b, off);
        off += 2;
        char[] charArray = new char[len];
        for (int i = 0; i < len; ++i) {
            charArray[i] = CodecUtils.getChar(b, off);
            off += 2;
        }
        return new String(charArray);
    }

    public static void putString(byte[] b, int off, String s) {
        CodecUtils.putShort(b, off, (short)s.length());
        off += 2;
        for (int i = 0; i < s.length(); ++i) {
            CodecUtils.putChar(b, off, s.charAt(i));
            off += 2;
        }
    }

    public static final int getStringLengthInBytes(String s) {
        return s.length() * 2 + 2;
    }

    public static float getFloat(byte[] b, int off) {
        int i = ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(i);
    }

    public static long getLong(byte[] b, int off) {
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    public static double getDouble(byte[] b, int off) {
        try {
            long j = (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
            return Double.longBitsToDouble(j);
        }
        catch (Exception e) {
            System.err.println("*********** " + b.length + "   " + off);
            e.printStackTrace();
            return 0.0;
        }
    }

    public static void putBoolean(byte[] b, int off, boolean val) {
        b[off] = (byte)(val ? 1 : 0);
    }

    public static void putChar(byte[] b, int off, char val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
    }

    public static void putShort(byte[] b, int off, short val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
    }

    public static void putInt(byte[] b, int off, int val) {
        b[off + 3] = (byte)(val >>> 0);
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off + 0] = (byte)(val >>> 24);
    }

    public static void putFloat(byte[] b, int off, float val) {
        int i = Float.floatToIntBits(val);
        b[off + 3] = (byte)(i >>> 0);
        b[off + 2] = (byte)(i >>> 8);
        b[off + 1] = (byte)(i >>> 16);
        b[off + 0] = (byte)(i >>> 24);
    }

    public static void putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)(val >>> 0);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
    }

    public static void putDouble(byte[] b, int off, double val) {
        long j = Double.doubleToLongBits(val);
        b[off + 7] = (byte)(j >>> 0);
        b[off + 6] = (byte)(j >>> 8);
        b[off + 5] = (byte)(j >>> 16);
        b[off + 4] = (byte)(j >>> 24);
        b[off + 3] = (byte)(j >>> 32);
        b[off + 2] = (byte)(j >>> 40);
        b[off + 1] = (byte)(j >>> 48);
        b[off + 0] = (byte)(j >>> 56);
    }

    public static void readFully(InputStream is, byte[] buff, int off, int len) throws IOException {
        int n;
        int rlen = 0;
        do {
            if ((n = is.read(buff, off + rlen, len - rlen)) >= 0) continue;
            throw new IOException("end of stream");
        } while ((rlen += n) < len);
    }

    public static void readFully(InputStream is, byte[] buff) throws IOException {
        CodecUtils.readFully(is, buff, 0, buff.length);
    }

    public static int readInt(InputStream is, byte[] buff) throws IOException {
        CodecUtils.readFully(is, buff, 0, 4);
        return CodecUtils.getInt(buff, 0);
    }

    public static short readShort(InputStream is, byte[] buff) throws IOException {
        CodecUtils.readFully(is, buff, 0, 2);
        return CodecUtils.getShort(buff, 0);
    }

    public static float readFloat(InputStream is, byte[] buff) throws IOException {
        CodecUtils.readFully(is, buff, 0, 4);
        return CodecUtils.getFloat(buff, 0);
    }

    public static double readDouble(InputStream is, byte[] buff) throws IOException {
        CodecUtils.readFully(is, buff, 0, 8);
        return CodecUtils.getDouble(buff, 0);
    }

    public static long readLong(InputStream is, byte[] buff) throws IOException {
        CodecUtils.readFully(is, buff, 0, 8);
        return CodecUtils.getLong(buff, 0);
    }

    public static byte[] objectToBytes(Object o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(baos);
            os.writeObject(o);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("object must be serializable");
        }
    }

    public static Object bytesToObject(byte[] buff) {
        try {
            try {
                ByteArrayInputStream baos = new ByteArrayInputStream(buff);
                return new ObjectInputStream(baos).readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("object must be serializable");
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("object must be serializable");
        }
    }

    public static Object bytesToObject(byte[] buff, int off, int len) {
        try {
            try {
                ByteArrayInputStream baos = new ByteArrayInputStream(buff, off, len);
                return new ObjectInputStream(baos).readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("object must be serializable");
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("object must be serializable");
        }
    }
}

