/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.Draw2DUtilsBase;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Draw2DUtils
extends Draw2DUtilsBase {
    private Draw2DUtils() {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("LineFast");
        String[] params = null;
        if (args.length > 0) {
            params = new String[]{"file", args[0]};
        }
        ImgPanel jp = new ImgPanel(500, 500);
        frame.setBounds(100, 100, 512, 512);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(jp);
        frame.setVisible(true);
    }

    private static class ImgPanel
    extends JPanel
    implements Draw2DUtilsBase.Raster1D,
    Draw2DUtilsBase.Raster2D {
        private BufferedImage bi = null;
        private byte[] pixels = null;

        public ImgPanel(int w, int h) {
            this.bi = new BufferedImage(w, h, 10);
            this.pixels = ((DataBufferByte)this.bi.getRaster().getDataBuffer()).getData();
            this.drawLines(w, h, this);
        }

        public void drawLines(int w, int h, Draw2DUtilsBase.Raster2D r) {
            Draw2DUtilsBase.lineBresenham(0, 0, w - 1, h - 1, r);
            Draw2DUtilsBase.lineBresenham(w - 1, 0, 0, h - 1, r);
            Draw2DUtilsBase.lineBresenham(w / 2, 0, w / 2, h - 1, r);
            Draw2DUtilsBase.lineBresenham(0, h / 2, w - 1, h / 2, r);
        }

        @Override
        public int getWidth() {
            return this.bi.getWidth();
        }

        @Override
        public int getHeight() {
            return this.bi.getHeight();
        }

        @Override
        public void clear() {
            Arrays.fill(this.pixels, (byte)0);
        }

        @Override
        public void setPixel(int idx) {
            this.pixels[idx] = 125;
        }

        @Override
        public void setPixel(int x, int y) {
            this.pixels[y * this.bi.getWidth() + x] = 125;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.drawRenderedImage(this.bi, null);
        }
    }

    public static class ImageBuffer
    implements Draw2DUtilsBase.Raster2D {
        private BufferedImage bi = null;
        private int w = 0;
        private int h = 0;
        private byte[] pixels = null;

        public ImageBuffer(int w, int h) {
            this.bi = new BufferedImage(w, h, 10);
            this.pixels = ((DataBufferByte)this.bi.getRaster().getDataBuffer()).getData();
            this.w = w;
            this.h = h;
        }

        public final BufferedImage getImage() {
            return this.bi;
        }

        @Override
        public int getWidth() {
            return this.bi.getWidth();
        }

        @Override
        public int getHeight() {
            return this.bi.getHeight();
        }

        @Override
        public void clear() {
            Arrays.fill(this.pixels, (byte)0);
        }

        @Override
        public void setPixel(int x, int y) {
            if (x < 0 || x >= this.w || y < 0 || y >= this.h) {
                return;
            }
            this.pixels[y * this.w + x] = 125;
        }
    }
}

