/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class XpComponentSave {
    private final JFrame jf = new JFrame("Offscreen");
    private final JPanel jp = new JPanel();
    private Robot robot = null;
    private Rectangle tmpRect = new Rectangle();
    public static final int RGB = 0;
    public static final int LUMINANCE_16 = 1;
    public static final int LUMINANCE_8 = 2;
    public static final int LUMINANCE_1 = 3;
    public static final int BYTE_BGR = 4;
    public static final int ARGB = 5;

    public XpComponentSave() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    private static int getBufferedType(int type) {
        if (type == 2) {
            return 10;
        }
        if (type == 1) {
            return 11;
        }
        if (type == 0) {
            return 1;
        }
        if (type == 5) {
            return 2;
        }
        if (type == 4) {
            return 5;
        }
        return 12;
    }

    public static BufferedImage getBufferedImage(JComponent jc, int type) {
        Dimension d = jc.getSize();
        int w = (int)d.getWidth();
        int h = (int)d.getHeight();
        return XpComponentSave.getBufferedImage(jc, w, h, type);
    }

    public static BufferedImage getBufferedImage(JComponent jc, int w, int h, int type) {
        BufferedImage bi = new BufferedImage(w, h, XpComponentSave.getBufferedType(type));
        Graphics g = bi.getGraphics();
        jc.paint(g);
        return bi;
    }

    public BufferedImage renderOffscreen(JComponent jc, int w, int h, int type) {
        jc.setPreferredSize(new Dimension(w, h));
        this.jf.setContentPane(jc);
        this.jf.pack();
        BufferedImage bi = XpComponentSave.getBufferedImage(jc, type);
        return bi;
    }

    public void renderOffscreen(JComponent jc, BufferedImage destination) {
        int w = destination.getWidth();
        int h = destination.getHeight();
        jc.setPreferredSize(new Dimension(w, h));
        this.jf.setContentPane(jc);
        this.jf.pack();
        Graphics g = destination.getGraphics();
        jc.paint(g);
        this.jf.setContentPane(this.jp);
    }

    public final void saveJPEG(JComponent offscreenJC, int w, int h, String fname) {
        BufferedImage bi = this.renderOffscreen(offscreenJC, w, h, 0);
        XpComponentSave.imageSave(bi, "jpeg", fname);
    }

    public static void offscreenSave(JComponent jc, String imgFormat, String fileName, int type) {
        BufferedImage bi = XpComponentSave.getBufferedImage(jc, type);
        XpComponentSave.imageSave(bi, imgFormat, fileName);
    }

    public final void screenSave(JComponent jc, String imgFormat, String fileName) {
        BufferedImage bi = this.getScreenRendering(jc);
        XpComponentSave.imageSave(bi, imgFormat, fileName);
    }

    public static void imageSave(RenderedImage rimg, String imgFormat, String fileName) {
        try {
            File f = new File(fileName);
            ImageIO.write(rimg, imgFormat, f);
        }
        catch (IOException ex) {
            System.err.println("ERROR: Writing to " + fileName);
        }
    }

    public final BufferedImage getScreenRendering(JComponent jc) {
        Point p = jc.getLocationOnScreen();
        Rectangle r = jc.getVisibleRect();
        int x = (int)p.getX();
        int y = (int)p.getY();
        int w = (int)r.getWidth();
        int h = (int)r.getHeight();
        this.tmpRect.setBounds(x, y, w, h);
        BufferedImage bi = this.robot.createScreenCapture(this.tmpRect);
        return bi;
    }
}

