/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.XpAnchorable;
import com.ge.med.terra.jami.XpGeomUtils;
import com.ge.med.terra.jami.XpHandleVc;
import com.ge.med.terra.jami.XpImage2DVc;
import com.ge.med.terra.jami.XpImageOrientation;
import com.ge.med.terra.jami.XpSingularPort;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.capable.Replicable;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class XpImageGridVc
extends XpVisualComponent
implements XpAnchorable,
Replicable {
    private XpHandleVc moveHandle = new XpHandleVc(this, 0);
    private double _gridSpacing = 50.0;
    private double _tickSpacing = 10.0;
    private double _tickLength = 5.0;
    private boolean _gridLinesON = true;
    private String _lineStyle = "DOTTED";
    private int _numberOfTickLines = 0;
    private int _numberOfPolyLines = 0;
    private int _numberOfAxis = 0;
    private int _numberOfTexts = 0;
    private int _centerX = 0;
    private int _centerY = 0;
    private int _rectWidth = 0;
    private int _rectHeight = 0;
    private double _zoom = 0.0;
    private double _pixelSizeX = 0.0;
    private double _pixelSizeY = 0.0;
    private int _xTextOffset = 0;
    private int _yTextOffset = 0;
    private CTransform imgDispTrans = null;
    private CTransform dispImgTras = null;
    private XpSingularPort vp = null;
    private CPoint[] _polyLine = null;
    private CPoint[] _axis = null;
    private CPoint[] _text = null;
    private CPoint[] _tickLine = null;
    private String[] _textValue = null;
    private CPoint centerImagePoint = new CPoint(0);
    private CPoint oneImageTick = new CPoint(0);
    private CPoint oneImageGrid = new CPoint(0);
    private CPoint imageTickDelta = new CPoint(0);
    private CPoint centerPoint = new CPoint(1);
    private CPoint oneTick = new CPoint(1);
    private CPoint oneGrid = new CPoint(1);
    private CPoint tickDelta = new CPoint(1);
    private CPoint p1 = new CPoint(1);
    private CPoint p2 = new CPoint(1);
    private CPoint p3 = new CPoint(1);
    private CPoint p4 = new CPoint(1);
    private int nhorizontal = 0;
    private Color col = Color.WHITE;
    private static final DecimalFormat df = new DecimalFormat("0.0");
    private boolean mousedrag = false;
    private static final String DOTTEDLINE = "DOTTED";
    float[] dashPattern = new float[]{2.0f, 1.0f, 2.0f, 1.0f};
    BasicStroke dottedStrk = new BasicStroke(1.0f, 0, 0, 10.0f, this.dashPattern, 0.0f);
    private XpGeomUtils gu = new XpGeomUtils();
    private CTransform transform = new CTransform();
    private CTransform _tempTrans = new CTransform();
    private Rectangle viewport = new Rectangle();
    private AffineTransform tx = new AffineTransform();

    public XpImageGridVc(XpSingularPort obj) {
        this.vp = obj;
        this.moveHandle.setFilled(false);
        this.add(this.moveHandle);
    }

    public XpImageGridVc() {
        this.moveHandle.setFilled(false);
        this.add(this.moveHandle);
    }

    @Override
    public Object clone() {
        int i;
        XpImageGridVc ng = new XpImageGridVc();
        ng.moveHandle.setFilled(this.moveHandle.isFilled());
        ng._gridLinesON = this._gridLinesON;
        ng._gridSpacing = this._gridSpacing;
        ng._tickSpacing = this._tickSpacing;
        ng._tickLength = this._tickLength;
        ng._lineStyle = this._lineStyle;
        ng._numberOfTickLines = this._numberOfTickLines;
        ng._numberOfPolyLines = this._numberOfPolyLines;
        ng._numberOfAxis = this._numberOfAxis;
        ng._numberOfTexts = this._numberOfTexts;
        ng._centerX = this._centerX;
        ng._centerY = this._centerY;
        ng._rectWidth = this._rectWidth;
        ng._rectHeight = this._rectHeight;
        ng._zoom = this._zoom;
        ng._pixelSizeX = this._pixelSizeX;
        ng._pixelSizeY = this._pixelSizeY;
        ng._xTextOffset = this._xTextOffset;
        ng._yTextOffset = this._yTextOffset;
        ng.centerImagePoint.setPoint(this.centerImagePoint);
        ng.oneImageTick.setPoint(this.oneImageTick);
        ng.oneImageGrid.setPoint(this.oneImageGrid);
        ng.imageTickDelta.setPoint(this.imageTickDelta);
        ng.centerPoint.setPoint(this.centerPoint);
        ng.oneTick.setPoint(this.oneTick);
        ng.oneGrid.setPoint(this.oneGrid);
        ng.tickDelta.setPoint(this.tickDelta);
        ng.p1.setPoint(this.p1);
        ng.p2.setPoint(this.p2);
        ng.p3.setPoint(this.p3);
        ng.p4.setPoint(this.p4);
        ng.mousedrag = this.mousedrag;
        if (this._polyLine != null) {
            ng._polyLine = new CPoint[this._polyLine.length];
            for (i = 0; i < this._polyLine.length; ++i) {
                ng._polyLine[i] = new CPoint(this._polyLine[i]);
            }
        }
        if (this._axis != null) {
            ng._axis = new CPoint[this._axis.length];
            for (i = 0; i < this._axis.length; ++i) {
                ng._axis[i] = new CPoint(this._axis[i]);
            }
        }
        if (this._text != null) {
            ng._text = new CPoint[this._text.length];
            for (i = 0; i < this._text.length; ++i) {
                ng._text[i] = new CPoint(this._text[i]);
            }
        }
        if (this._tickLine != null) {
            ng._tickLine = new CPoint[this._tickLine.length];
            for (i = 0; i < this._tickLine.length; ++i) {
                ng._tickLine[i] = new CPoint(this._tickLine[i]);
            }
        }
        if (this._textValue != null) {
            ng._textValue = new String[this._textValue.length];
            for (i = 0; i < this._textValue.length; ++i) {
                ng._textValue[i] = this._textValue[i];
            }
        }
        ng.dispImgTras = (CTransform)this.dispImgTras.clone();
        ng.imgDispTrans = (CTransform)this.imgDispTrans.clone();
        return ng;
    }

    public void initPaint() {
        int i;
        int vp_w = this.getWidth();
        int vp_h = this.getHeight();
        this._rectWidth = vp_w;
        this._rectHeight = vp_h;
        XpImageRenderAttributes orgattr = this.vp.getImageRenderAttributes();
        XpImageRenderAttributes defAttr = new XpImageRenderAttributes(orgattr);
        XpImageOrientation defOrnt = new XpImageOrientation();
        defAttr.setImageOrientation(defOrnt);
        this.vp.getBounds(this.viewport);
        int w = this.vp.getMedicalImageVc().getImageVc().getImage().getWidth();
        int h = this.vp.getMedicalImageVc().getImageVc().getImage().getHeight();
        this.gu.calcAffineTransform(this.viewport, defAttr, w, h, 0.0, true, this._pixelSizeX, this._pixelSizeY, this.tx);
        this.transform.load(this.tx);
        if (!this.mousedrag) {
            this._centerX = this._rectWidth / 2;
            this._centerY = this._rectHeight / 2;
        }
        this._xTextOffset = 0;
        this._yTextOffset = 0;
        this.imgDispTrans = this.transform;
        this.transform.inverse(this._tempTrans);
        this.dispImgTras = this._tempTrans;
        Container c = this.getParent();
        if (c instanceof XpImage2DVc) {
            XpImage2DVc ivc = (XpImage2DVc)c;
            this._pixelSizeX = ivc.getFrame().getPixelDimensionX();
            this._pixelSizeY = ivc.getFrame().getPixelDimensionY();
        } else {
            this._pixelSizeY = 1.0;
            this._pixelSizeX = 1.0;
        }
        this.centerImagePoint.setLocation(0.0, 0.0, 0.0);
        this.imgDispTrans.transform(this.centerImagePoint, this.centerPoint);
        this.oneImageTick.setLocation(this._tickSpacing / this._pixelSizeX, this._tickSpacing / this._pixelSizeY, 0.0);
        this.imgDispTrans.transform(this.oneImageTick, this.oneTick);
        this.oneImageGrid.setLocation(this._gridSpacing / this._pixelSizeX, this._gridSpacing / this._pixelSizeY, 0.0);
        this.imgDispTrans.transform(this.oneImageGrid, this.oneGrid);
        this.imageTickDelta.setLocation(this._tickLength / 2.0 / this._pixelSizeX, this._tickLength / 2.0 / this._pixelSizeY, 0.0);
        this.imgDispTrans.transform(this.imageTickDelta, this.tickDelta);
        double cmWidth_o = Math.abs(this.oneGrid.x - this.centerPoint.x);
        double cmHeight_o = Math.abs(this.oneGrid.y - this.centerPoint.y);
        double cmTHeight = Math.abs(this.oneTick.y - this.centerPoint.y);
        double cmTWidth = Math.abs(this.oneTick.x - this.centerPoint.x);
        double tickDeltaX = Math.abs(this.tickDelta.x - this.centerPoint.x);
        double tickDeltaY = Math.abs(this.tickDelta.y - this.centerPoint.y);
        this._zoom = cmWidth_o / this.oneImageGrid.x;
        double zoom = this._zoom + 0.01 < 1.0 ? 1.0 / (Math.floor(2.0 / this._zoom) + 1.0) : Math.floor(this._zoom / 4.0) + 1.0;
        double cmWidth = cmWidth_o / zoom;
        int nbOfCmW = (int)Math.floor((double)this._rectWidth / cmWidth);
        double cmHeight = cmHeight_o / zoom;
        int nbOfCmH = (int)Math.floor((double)this._rectHeight / cmHeight);
        int nbOfCmTH = (int)Math.floor((double)this._rectHeight / cmTHeight);
        int nbOfCmTW = (int)Math.floor((double)this._rectWidth / cmTWidth);
        this.initLines(nbOfCmW, nbOfCmH, nbOfCmTW, nbOfCmTH);
        double height_2 = (double)this._rectHeight / 2.0;
        double width_2 = (double)this._rectWidth / 2.0;
        double x = this._centerX;
        double y1 = (double)this._centerY - height_2;
        double y2 = (double)this._centerY + height_2;
        this.p1.setLocation(x, y1, 0.0);
        this.p2.setLocation(x, y2, 0.0);
        this._axis[0] = this.p1;
        this._axis[1] = this.p2;
        ++this._numberOfAxis;
        double y = this._centerY;
        double x1 = (double)this._centerX - width_2;
        double x2 = (double)this._centerX + width_2;
        this.p3.setLocation(x1, y, 0.0);
        this.p4.setLocation(x2, y, 0.0);
        this._axis[2] = this.p3;
        this._axis[3] = this.p4;
        ++this._numberOfAxis;
        this.nhorizontal = 0;
        for (i = 1; i <= (int)Math.floor((double)nbOfCmW / 2.0); ++i) {
            x1 = (double)this._centerX + (double)i * cmWidth;
            x2 = (double)this._centerX - (double)i * cmWidth;
            y1 = (double)this._centerY - height_2;
            y2 = (double)this._centerY + height_2;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x1, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value = this._gridSpacing * (double)i / (10.0 * zoom);
            this._textValue[this._numberOfTexts] = df.format(value);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(x1) + this._xTextOffset, this.doubleToint(this._centerY) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
            this._polyLine[this._numberOfPolyLines].setLocation(x2, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value1 = this._gridSpacing * (double)i / (-10.0 * zoom);
            this._textValue[this._numberOfTexts] = df.format(value1);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(x2) + this._xTextOffset, this.doubleToint(this._centerY) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
            this.nhorizontal += 2;
        }
        for (i = 1; i <= (int)Math.floor((double)nbOfCmH / 2.0); ++i) {
            x1 = (double)this._centerX - width_2;
            x2 = (double)this._centerX + width_2;
            y1 = (double)this._centerY + (double)i * cmHeight;
            y2 = (double)this._centerY - (double)i * cmHeight;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y1, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y1, 0.0);
            this._numberOfPolyLines += 2;
            double value2 = this._gridSpacing * (double)i / (-10.0 * zoom);
            this._textValue[this._numberOfTexts] = df.format(value2);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(this._centerX) + this._xTextOffset, this.doubleToint(y1) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
            this._polyLine[this._numberOfPolyLines].setLocation(x1, y2, 0.0);
            this._polyLine[this._numberOfPolyLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfPolyLines += 2;
            double value3 = this._gridSpacing * (double)i / (10.0 * zoom);
            this._textValue[this._numberOfTexts] = df.format(value3);
            this._text[this._numberOfTexts].setLocation(this.doubleToint(this._centerX) + this._xTextOffset, this.doubleToint(y2) - this._yTextOffset, 0.0);
            ++this._numberOfTexts;
        }
        for (i = 1; i <= (int)Math.floor((double)nbOfCmTH / 2.0); ++i) {
            x1 = (double)this._centerX - tickDeltaX;
            x2 = (double)this._centerX + tickDeltaX;
            y1 = (double)this._centerY + (double)i * cmTHeight;
            y2 = (double)this._centerY - (double)i * cmTHeight;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y1, 0.0);
            this._numberOfTickLines += 2;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y2, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfTickLines += 2;
        }
        for (i = 1; i <= (int)Math.floor((double)nbOfCmTW / 2.0); ++i) {
            y1 = (double)this._centerY - tickDeltaY;
            y2 = (double)this._centerY + tickDeltaY;
            x1 = (double)this._centerX + (double)i * cmTWidth;
            x2 = (double)this._centerX - (double)i * cmTWidth;
            this._tickLine[this._numberOfTickLines].setLocation(x1, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x1, y2, 0.0);
            this._numberOfTickLines += 2;
            this._tickLine[this._numberOfTickLines].setLocation(x2, y1, 0.0);
            this._tickLine[this._numberOfTickLines + 1].setLocation(x2, y2, 0.0);
            this._numberOfTickLines += 2;
        }
    }

    public void initLines(int nbOfCmW, int nbOfCmH, int nbOfCmTW, int nbOfCmTH) {
        int i;
        this._polyLine = null;
        this._text = null;
        this._axis = null;
        this._tickLine = null;
        this._numberOfPolyLines = 0;
        this._numberOfTickLines = 0;
        this._numberOfTexts = 0;
        this._numberOfAxis = 0;
        this._polyLine = new CPoint[((int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2) * 2];
        for (i = 0; i < this._polyLine.length; ++i) {
            this._polyLine[i] = new CPoint(0);
        }
        this._axis = new CPoint[4];
        for (i = 0; i < this._axis.length; ++i) {
            this._axis[i] = new CPoint(0);
        }
        this._text = new CPoint[(int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2];
        this._textValue = new String[(int)(Math.floor((double)nbOfCmW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmH / 2.0) * 2.0) + 2];
        for (i = 0; i < this._text.length; ++i) {
            this._text[i] = new CPoint(0);
            this._textValue[i] = new String();
        }
        this._tickLine = new CPoint[((int)(Math.floor((double)nbOfCmTW / 2.0) * 2.0) + (int)(Math.floor((double)nbOfCmTH / 2.0) * 2.0) + 2) * 2];
        for (i = 0; i < this._tickLine.length; ++i) {
            this._tickLine[i] = new CPoint(0);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.col);
        this.initPaint();
        if (this._gridLinesON) {
            for (i = 0; i < this._polyLine.length; i += 2) {
                this.drawLine(g2, this._polyLine[i], this._polyLine[i + 1], 0);
            }
        }
        for (i = 0; i <= this._axis.length - 2; i += 2) {
            this.drawLine(g2, this._axis[i], this._axis[i + 1], 0);
        }
        for (i = 0; i < this._tickLine.length - 2; i += 2) {
            this.drawLine(g2, this._tickLine[i], this._tickLine[i + 1], 0);
        }
        for (i = 0; i < this._text.length; ++i) {
            String content = this._textValue[i];
            FontRenderContext frc = g2.getFontRenderContext();
            Rectangle2D b = g2.getFont().getStringBounds(content, frc);
            int hw = 0;
            int hh = 0;
            if (i < this.nhorizontal) {
                hw = (int)(b.getWidth() * 0.5);
                hh = (int)b.getHeight();
            } else {
                hw = (int)(-(b.getWidth() * 0.6));
                hh = (int)(-b.getHeight() * 0.3);
            }
            g.drawString(content, (int)this._text[i].x - hw, (int)this._text[i].y - hh);
        }
        this.setAnchorPoint();
    }

    private int doubleToint(double x) {
        int val = (int)Math.floor(x + 0.5);
        return val;
    }

    public void setLineStyle(String style) {
        this._lineStyle = style;
    }

    public void setGridLinesON(boolean gridON) {
        this._gridLinesON = gridON;
    }

    public void setGridSpacing(double grSpacing) {
        this._gridSpacing = grSpacing;
    }

    public void setTickSpacing(double tkSpacing) {
        this._tickSpacing = tkSpacing;
    }

    public void setTickLength(double tkLength) {
        this._tickLength = tkLength;
    }

    public void drawLine(Graphics2D g, CPoint p0, CPoint p1, int offset) {
        if (this._lineStyle == DOTTEDLINE) {
            g.setStroke(this.dottedStrk);
        }
        g.drawLine(offset + (int)p0.x, offset + (int)p0.y, offset + (int)p1.x, offset + (int)p1.y);
    }

    @Override
    public void anchorDragged(MouseEvent e, CPoint drag, Object source) {
        this.mousedrag = true;
        double x = drag.x;
        double y = drag.y;
        this._centerX = (int)((double)this._centerX + x);
        this._centerY = (int)((double)this._centerY + y);
        this.repaint();
    }

    @Override
    public void anchorPressed(MouseEvent e, Object source) {
        this.setColor(Color.cyan);
        this.repaint();
    }

    @Override
    public void anchorReleased(MouseEvent e, Object source) {
        this.setColor(Color.white);
        this.repaint();
    }

    public void setColor(Color c) {
        this.col = c;
    }

    public void setAnchorPoint() {
        this.dispImgTras = this.getTransform((byte)1, (byte)0);
        CPoint disp = new CPoint(1);
        CPoint imp = new CPoint(0);
        disp.setLocation(this._centerX, this._centerY, 0.0);
        this.dispImgTras.transform(disp, imp);
        this.moveHandle.setLocation(imp.x, imp.y);
    }
}

