/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

import com.ge.med.terra.jami.XpCompositePort;
import com.ge.med.terra.jami.XpDicomObject;
import com.ge.med.terra.jami.XpFrameVisualizer;
import com.ge.med.terra.jami.XpImageScene;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpViewport;
import com.ge.med.terra.jami.remote.RmRenderSession;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

public class XpMultiImageViewport
extends XpCompositePort {
    private int anchorIndex = -1;
    private int[] sceneIndexMap = null;
    private XpViewport.IntValueDispatcher framedispatcher = new XpViewport.IntValueDispatcher("FrameIndex");

    public XpMultiImageViewport() {
        super(1, 2);
        this.init();
    }

    public XpMultiImageViewport(int selectionPolicy, int selectionMode) {
        super(selectionPolicy, selectionMode);
        this.init();
    }

    public XpMultiImageViewport(String rendererType) {
        super(rendererType);
        this.init();
    }

    public XpMultiImageViewport(String rendererType, int selectionPolicy, int selectionMode) {
        super(rendererType, selectionPolicy, selectionMode);
        this.init();
    }

    public XpMultiImageViewport(RmRenderSession rs, String remote2DRenderer) {
        super(rs, remote2DRenderer);
        this.init();
    }

    private void init() {
        this.initPorts();
    }

    @Override
    public Object clone() {
        XpMultiImageViewport mv = new XpMultiImageViewport(this.getRendererType(), this.getSelectionPolicy(), this.getSelectionMode());
        this.copyObject(mv);
        if (this.sceneIndexMap != null) {
            int len = this.sceneIndexMap.length;
            mv.sceneIndexMap = new int[this.sceneIndexMap.length];
            System.arraycopy(this.sceneIndexMap, 0, mv.sceneIndexMap, 0, len);
        }
        return mv;
    }

    @Override
    public void setImages(XpMedicalImage[] imageList) {
        if (this.getCine()) {
            return;
        }
        super.setImages(imageList);
        this.anchorIndex = 0;
        this.defaultSharedIRA();
        this.sync();
        this.initPorts();
        this.setEndOffset(this.getNumFrames() - 1);
    }

    @Override
    public int addImage(XpMedicalImage image, int index) {
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        if (index <= this.anchorIndex && index >= 0) {
            ++this.anchorIndex;
        }
        return super.addImage(image, index);
    }

    @Override
    public int addImages(XpMedicalImage[] images, int index) {
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        if (index <= this.anchorIndex && index >= 0) {
            this.anchorIndex += images.length;
        }
        return super.addImages(images, index);
    }

    @Override
    public int removeImage(int index) {
        if (this.getCine() || this.getMultiImageOp() != null) {
            return -1;
        }
        if (index < this.anchorIndex && index >= 0) {
            --this.anchorIndex;
        } else if (index == this.anchorIndex && this.anchorIndex == this.getNumFrames() - 1) {
            this.anchorIndex = 0;
        }
        return super.removeImage(index);
    }

    protected void clearPorts() {
        int len = this.getNumPorts();
        for (int j = 0; j < len; ++j) {
            XpFrameVisualizer fv = this.getPort(j);
            fv.setFrameScene(null, null);
        }
    }

    @Override
    protected void doLayoutPorts() {
        if (this.getNumScenes() > 0) {
            XpFrameVisualizer fv;
            int j;
            int rows = this.getRows();
            int cols = this.getCols();
            int configLen = rows * cols;
            int nports = this.getNumPorts();
            int size = this.getNumScenes();
            int startPos = this.getFrameIndex();
            boolean focus = false;
            for (j = 0; j < configLen; ++j) {
                int sceneIndex;
                fv = this.getPort(j);
                this.sceneIndexMap[j] = sceneIndex = startPos + j;
                XpImageScene fs = null;
                if (sceneIndex >= 0 && sceneIndex < size) {
                    fs = this.getScene(sceneIndex);
                }
                XpDicomObject dobj = null;
                if (fs != null) {
                    dobj = this.getDicomSource(sceneIndex);
                }
                fv.setFrameScene(fs, dobj);
                if (fs != null) {
                    fv.setVisible(true);
                    continue;
                }
                focus |= fv.getMedicalImageVc().getImageVc().hasFocus();
                fv.setVisible(false);
            }
            for (j = configLen; j < nports; ++j) {
                fv = this.getPort(j);
                if (fv == null) continue;
                fv.setFrameScene(null, null);
            }
            if (focus) {
                XpFrameVisualizer fv2 = this.getPort(0);
                fv2.getMedicalImageVc().getImageVc().requestFocus();
            }
        } else {
            this.clearPorts();
        }
    }

    @Override
    protected final void sync() {
        this.syncPorts();
    }

    @Override
    protected void syncPortsCB() {
        int portListLen = this.getNumPorts();
        if (this.sceneIndexMap == null || this.sceneIndexMap.length != portListLen) {
            this.sceneIndexMap = new int[portListLen];
        }
    }

    private void initPorts() {
        int nports = this.getNumPorts();
        for (int i = 0; i < nports; ++i) {
            XpFrameVisualizer fv = this.getPort(i);
            fv.getMedicalImageVc().getAnnotationGenerator().reset();
        }
        this.setComponentSelection(0);
    }

    @Override
    public void setFrameIndex(int index) {
        this.setFrame(index);
    }

    public void setFrame(int index) {
        int sLen = this.getNumScenes();
        if (index >= 0 && index < sLen) {
            this.anchorIndex = index;
            this.layoutImages();
            this.framedispatcher.setValues(this, index);
            SwingUtilities.invokeLater(this.framedispatcher);
        }
    }

    @Override
    public int getFrameIndex() {
        return this.anchorIndex;
    }

    @Override
    public int getSceneIndexAtPort(int portIdx) {
        if (portIdx < 0 || portIdx >= this.sceneIndexMap.length) {
            return -1;
        }
        return this.sceneIndexMap[portIdx];
    }

    @Override
    protected MouseListener getSelectionHandler(int portIdx) {
        return new SelectionMouseAdapter(this, portIdx);
    }

    private class SelectionMouseAdapter
    extends MouseAdapter {
        private XpMultiImageViewport miv = null;
        private int _portno = -1;

        public SelectionMouseAdapter(XpMultiImageViewport miv, int portno) {
            this.miv = miv;
            this._portno = portno;
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            int clickCount = me.getClickCount();
            if (clickCount == 2) {
                boolean ctrl;
                int modifier = me.getModifiers();
                boolean bl = ctrl = (modifier & 2) != 0;
                if (!ctrl) {
                    this.miv.setPortSelection(this._portno, 1, true);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            XpMultiImageViewport.this.setComponentSelection(this._portno);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            XpMultiImageViewport.this.updatePropRenderAttributes();
            XpMultiImageViewport.this.repaint();
        }
    }
}

