/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami;

public class XpStatistics {
    private double total = 0.0;
    private long numPts = 0L;
    private int winSize = 0;
    private int winIndex = 0;
    private int currWinSize = 0;
    private double[] winDistribution = null;

    public XpStatistics() {
        this(20);
    }

    public XpStatistics(int winSize) {
        this.syncWindowSize(winSize);
    }

    private void syncWindowSize(int winSize) {
        this.winSize = winSize;
        this.winDistribution = new double[winSize];
        this.resetWindowStatistics();
    }

    public final double getMean() {
        if (this.numPts > 0L) {
            return this.total / (double)this.numPts;
        }
        return -1.0;
    }

    public final void resetStatistics() {
        this.numPts = 0L;
        this.total = 0.0;
        this.resetWindowStatistics();
    }

    private void resetWindowStatistics() {
        this.winIndex = 0;
        this.currWinSize = 0;
    }

    public final void setWindowSize(int winSize) {
        this.syncWindowSize(winSize);
    }

    public final void addDataPoint(double dataValue) {
        this.total += dataValue;
        ++this.numPts;
        if (this.currWinSize < this.winSize) {
            ++this.currWinSize;
        }
        this.winDistribution[this.winIndex] = dataValue;
        this.winIndex = (this.winIndex + 1) % this.winSize;
    }

    public final long getNumDataPoints() {
        return this.numPts;
    }

    public final double getTotal() {
        return this.total;
    }

    public final double getWindowMean() {
        if (this.currWinSize == 0) {
            return 0.0;
        }
        double winTotal = 0.0;
        for (int i = 0; i < this.currWinSize; ++i) {
            winTotal += this.winDistribution[i];
        }
        return winTotal / (double)this.currWinSize;
    }

    public final double getWindowStdDev() {
        if (this.currWinSize <= 1) {
            return 0.0;
        }
        double mean = this.getWindowMean();
        double winSqTotal = 0.0;
        for (int i = 0; i < this.currWinSize; ++i) {
            double diff = mean - this.winDistribution[i];
            double term = diff * diff;
            winSqTotal += term;
        }
        double stddev = Math.sqrt(winSqTotal / (double)(this.currWinSize - 1));
        return stddev;
    }
}

