/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.image;

import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JVolumeImage
implements XpMedicalImage {
    protected int sliceIdx = 0;
    protected JVolume jv = null;
    protected XjVolumeInfo xj_vol = null;
    protected XpSlice slice = null;
    protected double deflevel = 0.0;
    protected double defwidth = 0.0;
    protected double rescaleIntercept = 0.0;
    protected double rescaleSlope = 1.0;
    protected double azimuth = 0.0;
    protected boolean loadedDefWL = false;
    protected boolean loadedDefWW = false;
    protected double[] minmax = new double[2];
    protected BufferedImage bimg = null;

    public JVolumeImage(JVolume jv, int idx) {
        this.jv = jv;
        this.sliceIdx = idx;
        this.xj_vol = jv.vol;
        this.slice = new XpSlice(this);
        this.initImage();
    }

    public static XpMedicalImage[] getImages(JVolume jv) {
        XjVolumeInfo vol = jv.vol;
        int nimgs = jv.dz;
        XpMedicalImage[] imgs = new XpMedicalImage[nimgs];
        for (int i = 0; i < nimgs; ++i) {
            imgs[i] = new JVolumeImage(jv, i);
        }
        return imgs;
    }

    @Override
    public final int getValues(XpDicomElement[] values) {
        boolean allLoaded = true;
        for (int i = 0; i < values.length; ++i) {
            int result = this.getValue(values[i]);
            if (result != 1) continue;
            allLoaded = false;
        }
        if (allLoaded) {
            return 0;
        }
        return 1;
    }

    @Override
    public final int getValue(XpDicomElement value) {
        value.value = this.xj_vol.getVSliceValue(this.sliceIdx, value.group, value.element);
        return value.value != null ? 0 : 1;
    }

    @Override
    public RenderedImage getPixelData() {
        if (this.bimg == null) {
            int dx = this.jv.dx;
            int dy = this.jv.dy;
            if (this.jv instanceof JVolume.LinearShort) {
                JVolume.LinearShort jls = (JVolume.LinearShort)this.jv;
                int offset = jls.PAD + this.sliceIdx * (dx * dy);
                this.bimg = JVolumeImage.build16bitImage(dx, dy, jls.volume, offset, new Hashtable());
            } else if (this.jv instanceof JVolume.Short) {
                JVolume.Short js = (JVolume.Short)this.jv;
                short[][] vol = js.volume;
                this.bimg = JVolumeImage.build16bitImage(dx, dy, vol[this.sliceIdx], 0, new Hashtable());
            } else if (this.jv instanceof JVolume.LinearByte) {
                JVolume.LinearByte jlb = (JVolume.LinearByte)this.jv;
                int offset = jlb.PAD + this.sliceIdx * (dx * dy);
                this.bimg = JVolumeImage.build8bitImage(dx, dy, jlb.volume, offset, new Hashtable());
            }
        }
        return this.bimg;
    }

    @Override
    public final double getPixelDimensionX() {
        return this.slice.pixelSizeX;
    }

    @Override
    public final double getPixelDimensionY() {
        return this.slice.pixelSizeY;
    }

    @Override
    public final XpSlice getSlice() {
        return this.slice;
    }

    @Override
    public final double getDefaultWindowWidth() {
        if (!this.loadedDefWW) {
            int subsample = 17;
            if (this.slice.width <= 128 && this.slice.height <= 128) {
                subsample = 5;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.defwidth;
    }

    @Override
    public final double getDefaultWindowLevel() {
        if (!this.loadedDefWL) {
            int subsample = 16;
            if (this.slice.width <= 128 && this.slice.height <= 128) {
                subsample = 4;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.deflevel;
    }

    @Override
    public final double getRescaleIntercept() {
        return this.rescaleIntercept;
    }

    @Override
    public final double getRescaleSlope() {
        return this.rescaleSlope;
    }

    @Override
    public final double getAzimuth() {
        return this.azimuth;
    }

    protected void initImage() {
        if (this.jv.normalize) {
            this.deflevel = this.jv.initWL;
            this.loadedDefWL = true;
            this.defwidth = this.jv.initWW;
            this.loadedDefWW = true;
            this.rescaleSlope = this.jv.rescaleSlope;
            this.rescaleIntercept = this.jv.rescaleIntercept;
        } else {
            StringTokenizer st;
            String snum;
            StringTokenizer st2;
            Object obj = this.xj_vol.getVSliceValue(this.sliceIdx, 40, 4176);
            if (obj instanceof String) {
                st2 = new StringTokenizer((String)obj, "\\");
                this.deflevel = (int)Float.parseFloat(st2.nextToken());
                this.loadedDefWL = true;
            } else if (obj instanceof Number) {
                this.deflevel = ((Number)obj).intValue();
                this.loadedDefWL = true;
            } else {
                this.deflevel = this.jv.initWL;
                this.loadedDefWL = true;
            }
            obj = this.xj_vol.getVSliceValue(this.sliceIdx, 40, 4177);
            if (obj instanceof String) {
                st2 = new StringTokenizer((String)obj, "\\");
                this.defwidth = (int)Float.parseFloat(st2.nextToken());
                this.loadedDefWW = true;
            } else if (obj instanceof Number) {
                this.defwidth = ((Number)obj).intValue();
                this.loadedDefWW = true;
            } else {
                this.defwidth = this.jv.initWW;
                this.loadedDefWW = true;
            }
            obj = this.xj_vol.getVSliceValue(this.sliceIdx, 40, 4178);
            if (obj instanceof String) {
                snum = (String)obj;
                if (snum.length() <= 0) {
                    snum = "0";
                }
                st = new StringTokenizer(snum, "\\");
                this.rescaleIntercept = Double.parseDouble(st.nextToken());
            } else {
                this.rescaleIntercept = obj instanceof Number ? ((Number)obj).doubleValue() : this.jv.rescaleIntercept;
            }
            obj = this.xj_vol.getVSliceValue(this.sliceIdx, 40, 4179);
            if (obj instanceof String) {
                snum = (String)obj;
                if (snum.length() <= 0) {
                    snum = "1";
                }
                st = new StringTokenizer(snum, "\\");
                this.rescaleSlope = Double.parseDouble(st.nextToken());
            } else {
                this.rescaleSlope = obj instanceof Number ? ((Number)obj).doubleValue() : this.jv.rescaleSlope;
            }
            if (this.rescaleSlope == 0.0) {
                this.rescaleSlope = 1.0;
            }
        }
        this.azimuth = XpImageUtils.gehcAzimuth(this);
        if (this.slice.width == 0 || this.slice.height == 0) {
            this.slice.width = this.jv.dx;
            this.slice.height = this.jv.dy;
        }
    }

    public static BufferedImage buildRGBImage(int dimx, int dimy, byte[] data, int offset, Hashtable properties) {
        DataBufferByte dbs = new DataBufferByte(data, dimx * dimy * 3, offset);
        int[] bandOffsets = new int[]{0, 1, 2};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx * 3, 3, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 0);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build16bitImage(int dimx, int dimy, short[] data, int offset, Hashtable properties) {
        DataBufferUShort dbs = new DataBufferUShort(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{16};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 1);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build8bitImage(int dimx, int dimy, byte[] data, int offset, Hashtable properties) {
        DataBufferByte dbs = new DataBufferByte(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{8};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 0);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }

    public static BufferedImage build32bitImage(int dimx, int dimy, int[] data, int offset, Hashtable properties) {
        DataBufferInt dbs = new DataBufferInt(data, dimx * dimy, offset);
        int[] bandOffsets = new int[]{0};
        WritableRaster wr = Raster.createInterleavedRaster(dbs, dimx, dimy, dimx, 1, bandOffsets, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{32};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 3);
        try {
            properties.put("PROPERTY_HASH", properties.keys());
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedImage img = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), properties);
        return img;
    }
}

