/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.jnu.JnVector3d;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Commons3D {
    public static final double ZERO = 1.0E-7;
    public static final short NO_CONTENT_STEP = 8192;
    public static final double THICK_STEP_THRESH = 1.5;

    public static short noContentPixel(String modality) {
        String modcode = modality.toUpperCase();
        if (modcode.equals("CT")) {
            return -2000;
        }
        if (modcode.equals("PT")) {
            return -8192;
        }
        return 0;
    }

    private static boolean isMajorVector(double[] v) {
        double v_x = Math.abs(v[0]);
        double v_y = Math.abs(v[1]);
        double v_z = Math.abs(v[2]);
        int nzeroes = 0;
        boolean majorVector = false;
        if (v_x < 1.0E-7) {
            ++nzeroes;
        }
        if (v_y < 1.0E-7) {
            ++nzeroes;
        }
        if (v_z < 1.0E-7) {
            ++nzeroes;
        }
        if (nzeroes >= 2) {
            majorVector = true;
        }
        return majorVector;
    }

    public static boolean isMajorAxis(double[] vox_xstep, double[] vox_ystep, double[] vox_view) {
        boolean majorAxis = Commons3D.isMajorVector(vox_view);
        if (majorAxis) {
            double dotXY = Math.abs(JnVector3d.dot(vox_xstep, vox_ystep));
            double dotXZ = Math.abs(JnVector3d.dot(vox_xstep, vox_view));
            double dotYZ = Math.abs(JnVector3d.dot(vox_ystep, vox_view));
            double DOT_ZERO = 1.0E-4;
            if (dotXY > 1.0E-4 || dotXZ > 1.0E-4 || dotYZ > 1.0E-4) {
                majorAxis = false;
            }
            if (majorAxis) {
                if (!Commons3D.isMajorVector(vox_xstep)) {
                    majorAxis = false;
                }
                if (!Commons3D.isMajorVector(vox_ystep)) {
                    majorAxis = false;
                }
            }
        }
        return majorAxis;
    }

    public static T3DRenderEngine createRenderEngine(String renderEngineClass) {
        T3DRenderEngine re = null;
        try {
            Class<?> reclass = Class.forName(renderEngineClass);
            Constructor<?> c = reclass.getConstructor(null);
            re = (T3DRenderEngine)c.newInstance(null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return re;
    }

    public static int getRenderStyleCode(String style) {
        int rstyle = -1;
        if (style.equals("REFORMAT")) {
            rstyle = 0;
        } else if (style.equals("FUSED_REFORMAT")) {
            rstyle = 10;
        } else if (style.equals("REFORMAT.NN")) {
            rstyle = 1;
        } else if (style.equals("MIP")) {
            rstyle = 2;
        } else if (style.equals("MAJOR_AXIS_MIP")) {
            rstyle = 11;
        } else if (style.equals("MAJOR_AXIS_MINIP")) {
            rstyle = 12;
        } else if (style.equals("MAJOR_AXIS_AVERAGE")) {
            rstyle = 13;
        } else if (style.equals("MINIP")) {
            rstyle = 3;
        } else if (style.equals("AVERAGE")) {
            rstyle = 4;
        } else if (style.equals("VOLUME")) {
            rstyle = 8;
        } else if (style.equals("FULLBODY_MIP")) {
            rstyle = 5;
        } else if (style.equals("FULLBODY_MINIP")) {
            rstyle = 6;
        } else if (style.equals("FULLBODY_AVERAGE")) {
            rstyle = 7;
        } else if (style.equals("REFORMAT.TC")) {
            rstyle = 9;
        } else if (style.equals("CURVED_REFORMAT")) {
            rstyle = 14;
        } else if (style.equals("LUMEN_REFORMAT")) {
            rstyle = 15;
        } else if (style.equals("MULTIVOLUME_REFORMAT")) {
            rstyle = 16;
        } else if (style.equals("MULTIVOLUME_MINIP")) {
            rstyle = 18;
        } else if (style.equals("MULTIVOLUME_MIP")) {
            rstyle = 17;
        } else if (style.equals("MULTIVOLUME_AVG")) {
            rstyle = 19;
        } else if (style.equals("IMAGE_2D_RENDER")) {
            rstyle = 60001;
        } else if (style.equals("LARGE_IMAGE_2D_RENDER")) {
            rstyle = 60002;
        } else if (style.equals("NO_RENDER")) {
            rstyle = 25;
        } else if (style.equals("SURFACE")) {
            rstyle = 26;
        }
        return rstyle;
    }
}

