/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DDepthCapable;
import com.ge.med.idc.XjChangeListener;
import com.ge.med.jnu.JnMatrix3d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.Cursor3DModel;
import com.ge.med.terra.jami.j3d.CustomCursor;
import com.ge.med.terra.jami.j3d.DefaultCursor3DModel;
import com.ge.med.terra.jami.j3d.ObliqueController;
import com.ge.med.terra.jami.j3d.OrientationCubeVc;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class DefaultObliqueController
extends XpVisualComponent
implements MouseInputListener,
ObliqueController {
    private static final Color AXIS_COLOR = Color.YELLOW;
    private static final int HANDLE_SENSITIVITY = 8;
    private static final int LINE_SENSITIVITY = 3;
    private static final Shape CENTER_HANDLE_SHAPE = new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f);
    private static final Shape ROTATION_HANDLE_SHAPE = new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f);
    private static final Stroke CENTER_OUTLINE_STROKE = new BasicStroke(2.5f);
    private static final double ROTATION_HANDLE_POSITION = 0.8;
    private static final Stroke AXIS_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private static final Stroke DIRECTION_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private static final Stroke THICKNESS_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{8.0f, 2.0f}, 0.0f);
    private static final Stroke POSITIVE_STROKE = new BasicStroke(1.0f);
    private int centerx_;
    private int centery_;
    private double angle_;
    private T3DCapable controller_;
    private XpVisualComponent geomVc_;
    private Cursor3DModel cursor_;
    protected PropertyChangeListener controllerChangeListener_;
    private JnVector3d deltaTmp = new JnVector3d();
    JnMatrix3d rtTmp = new JnMatrix3d();
    Point prev;
    private double sign_;
    private static final int UNKNOWN_MODE = -1;
    private static final int ANGLE_MODE = 0;
    private static final int THICKNESS_MODE = 1;
    private static final int PAN_MODE = 2;
    private int mouseMode_ = -1;
    private boolean interactive_;
    private static final Point2D N_S_V = new Point2D.Double(0.0, 1.0);
    private static final Point2D E_W_V = new Point2D.Double(1.0, 0.0);
    private static final Point2D NE_SW_V = new Point2D.Double(Math.cos(0.7853981633974483), -Math.sin(0.7853981633974483));
    private static final Point2D NW_SE_V = new Point2D.Double(Math.cos(0.7853981633974483), Math.sin(0.7853981633974483));
    private int thicknessDirectionCursor = 8;
    private List obliqueViewerList_ = new ArrayList();
    private JnMatrix3d obliqueRotation_ = new JnMatrix3d();
    private JnMatrix3d tmpRotation1 = new JnMatrix3d();
    private JnMatrix3d tmpRotation2 = new JnMatrix3d();
    private static final JnMatrix3d AXIAL_TRANSFORM = new JnMatrix3d(new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0});
    private static final JnMatrix3d CORONAL_TRANSFORM = new JnMatrix3d(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -1.0, 0.0});
    private static final JnMatrix3d SAGITTAL_TRANSFORM = new JnMatrix3d(new double[]{0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0});
    private Color rxColor_ = Color.CYAN;

    public void setRxByViewer(T3DCapable viewer) {
        if (viewer == null || this.controller_ == null) {
            return;
        }
        this.centery_ = 0;
        this.centerx_ = 0;
        this.angle_ = 0.0;
        JnMatrix3d rotation = DefaultObliqueController.getLPSxform(viewer);
        JnMatrix3d rx = this.findRotationRx(rotation, this.obliqueRotation_);
        JnVector3d eye = new JnVector3d();
        eye.set(this.controller_.getLookPoint(null));
        eye.scaleAdd(-1.0, new JnVector3d(-this.obliqueRotation_.m02, -this.obliqueRotation_.m12, this.obliqueRotation_.m22));
        this.controller_.setCamera(new double[0], this.controller_.getLookPoint(null), new double[]{this.obliqueRotation_.m01, this.obliqueRotation_.m11, -this.obliqueRotation_.m21});
        JnMatrix3d controllerXform = DefaultObliqueController.getLPSxform(this.controller_);
        JnVector3d xv = new JnVector3d(controllerXform.m00, controllerXform.m10, controllerXform.m20);
        JnVector3d jnVector3d = new JnVector3d(rotation.m00, rotation.m10, rotation.m20);
        if (Math.abs(xv.dot(jnVector3d)) < 0.01) {
            this.angle_ = 1.5707963267948966;
        }
    }

    private static final JnMatrix3d getLPSxform(T3DCapable capable) {
        JnVector3d eye = new JnVector3d(capable.getEyePoint(null));
        JnVector3d look = new JnVector3d(capable.getLookPoint(null));
        JnVector3d up = new JnVector3d(capable.getUp(null));
        JnVector3d zv = new JnVector3d();
        zv.sub(look, eye);
        zv.normalize();
        zv.x = -zv.x;
        zv.y = -zv.y;
        JnVector3d yv = new JnVector3d();
        yv.set(up);
        yv.normalize();
        yv.z = -yv.z;
        JnVector3d xv = JnVector3d.cross(yv, zv);
        return new JnMatrix3d(new double[]{xv.x, yv.x, zv.x, xv.y, yv.y, zv.y, xv.z, yv.z, zv.z});
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.interactive_) {
            this.computeCenter();
        }
        int cx = this.centerx_;
        int cy = this.centery_;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.interactive_) {
            g2d.setStroke(AXIS_STROKE);
            g2d.setColor(AXIS_COLOR);
            g2d.drawLine(cx, 0, cx, this.getHeight() - 1);
            g2d.drawLine(0, cy, this.getWidth() - 1, cy);
        }
        double halfT = 0.0;
        if (this.controller_ != null && !this.obliqueViewerList_.isEmpty()) {
            T3DCapable viewer = (T3DCapable)this.obliqueViewerList_.get(0);
            halfT = Math.abs(viewer.getViewClip(null)[0]);
            JnVector3d up = new JnVector3d(this.controller_.getUp(null));
            CPoint t = this.cursor_.getPoint(null);
            t.scaleAdd(halfT, up);
            this.geomVc_.getTransform((byte)2, (byte)1).transform(t);
            halfT = (double)this.centery_ - t.y;
        }
        g.setColor(Math.round(halfT) > 0L ? AXIS_COLOR : this.rxColor_);
        g2d.setStroke(POSITIVE_STROKE);
        Point p1 = new Point();
        Point p2 = new Point();
        DefaultObliqueController.lineAcrossPort(cx, cy, this.getWidth(), this.getHeight(), this.angle_, p1, p2);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        if (Math.round(halfT) > 0L) {
            g2d.setStroke(THICKNESS_STROKE);
            g2d.setColor(this.rxColor_);
            double vx = -Math.sin(this.angle_) * halfT;
            double vy = Math.cos(this.angle_) * halfT;
            DefaultObliqueController.lineAcrossPort((int)((double)cx + vx), (int)((double)cy + vy), this.getWidth(), this.getHeight(), this.angle_, p1, p2);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            DefaultObliqueController.lineAcrossPort((int)((double)cx - vx), (int)((double)cy - vy), this.getWidth(), this.getHeight(), this.angle_, p1, p2);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
        if (!this.interactive_) {
            g2d.translate(cx, cy);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(CENTER_OUTLINE_STROKE);
            g2d.draw(CENTER_HANDLE_SHAPE);
            g2d.rotate(this.angle_);
            g2d.setColor(Color.WHITE);
            g2d.fill(CENTER_HANDLE_SHAPE);
            g2d.rotate(-this.angle_);
            g2d.translate(-cx, -cy);
            double rotationHandleOffset = (double)Math.min(this.getWidth(), this.getHeight()) * 0.8 / 2.0;
            double rotationHandleX = rotationHandleOffset * 0.8 * Math.cos(this.angle_);
            double rotationHandleY = rotationHandleOffset * 0.8 * Math.sin(this.angle_);
            g2d.translate((double)cx + rotationHandleX, (double)cy + rotationHandleY);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(CENTER_OUTLINE_STROKE);
            g2d.draw(ROTATION_HANDLE_SHAPE);
            g2d.setColor(Color.GREEN);
            g2d.fill(ROTATION_HANDLE_SHAPE);
            g2d.translate(-2.0 * rotationHandleX, -2.0 * rotationHandleY);
            g2d.setColor(Color.BLACK);
            g2d.setStroke(CENTER_OUTLINE_STROKE);
            g2d.draw(ROTATION_HANDLE_SHAPE);
            g2d.setColor(Color.GREEN);
            g2d.fill(ROTATION_HANDLE_SHAPE);
            g2d.translate(rotationHandleX - (double)cx, rotationHandleY - (double)cy);
        } else {
            g2d.setColor(AXIS_COLOR);
            g2d.setStroke(DIRECTION_STROKE);
            DefaultObliqueController.lineAcrossPort(cx, cy, this.getWidth(), this.getHeight(), this.angle_ + 1.5707963267948966, p1, p2);
            g2d.drawLine(p1.x, p1.y, p2.x, p2.y);
            g2d.translate(cx, cy);
            g2d.rotate(this.angle_ + 1.5707963267948966);
            double arrowLocation = (double)Math.min(this.getWidth(), this.getHeight()) * 0.8 / 2.0;
            g2d.translate(arrowLocation + 1.0, 0.0);
            g2d.rotate(-1.5707963267948966);
            g2d.setColor(Color.BLACK);
            g2d.setColor(Color.WHITE);
            g2d.rotate(1.5707963267948966);
            g2d.translate(-arrowLocation * 2.0 + 18.0, 0.0);
            g2d.rotate(-1.5707963267948966);
            g2d.setColor(Color.BLACK);
            g2d.setColor(Color.WHITE);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.interactive_) {
            return true;
        }
        int cx = this.centerx_;
        int cy = this.centery_;
        return this.containsCenterHandle(x, y, cx, cy) || this.containsRotationHandle(x, y, cx, cy) || this.containsThicknessLine(x, y, cx, cy);
    }

    private boolean containsCenterHandle(int x, int y, int centerx, int centery) {
        int dx = x - centerx;
        int dy = y - centery;
        return Math.abs(dx * dx + dy * dy) < 64;
    }

    private boolean containsRotationHandle(int x, int y, int centerx, int centery) {
        double rotationHandleLen = (double)Math.min(this.getWidth(), this.getHeight()) * 0.8 / 2.0;
        double hx = rotationHandleLen * 0.8 * Math.cos(this.angle_);
        double hy = rotationHandleLen * 0.8 * Math.sin(this.angle_);
        Point2D.Double pt1 = new Point2D.Double((double)centerx + hx, (double)centery + hy);
        Point2D.Double pt2 = new Point2D.Double((double)centerx - hx, (double)centery - hy);
        return pt1.distance(x, y) < 8.0 || pt2.distance(x, y) < 8.0;
    }

    private boolean containsThicknessLine(int x, int y, int centerx, int centery) {
        if (this.controller_ == null) {
            return false;
        }
        CPoint pt = this.cursor_.getPoint(null);
        double halfT = this.obliqueViewerList_.isEmpty() ? 0.0 : Math.abs(((T3DCapable)this.obliqueViewerList_.get(0)).getViewClip(null)[0]);
        JnVector3d up = new JnVector3d(this.controller_.getUp(null));
        pt.scaleAdd(halfT, up);
        this.geomVc_.getTransform((byte)2, (byte)1).transform(pt);
        halfT = (double)this.centery_ - pt.y;
        int dx = x - centerx;
        int dy = y - centery;
        double vx = -Math.sin(this.angle_);
        double vy = Math.cos(this.angle_);
        double distance = Math.abs(vx * (double)dx + vy * (double)dy);
        return Math.abs(distance - halfT) < 3.0;
    }

    public DefaultObliqueController(T3DCapable controller, XpVisualComponent refvc, Cursor3DModel cursor) {
        this(controller, 0.0, refvc, cursor);
    }

    public DefaultObliqueController(T3DCapable controller, double angle, XpVisualComponent geomVc, Cursor3DModel cursor) {
        this.geomVc_ = geomVc;
        this.controller_ = controller;
        this.angle_ = angle;
        this.setCursor(CustomCursor.ROTATION_2D_CURSOR);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.cursor_ = cursor;
        this.controller_.addPropertyChangeListener(this.getControllerChangeListener());
        if (this.cursor_ != null) {
            this.cursor_.addChangeListener(new CursorChangeListener());
            this.computeCenter();
        }
    }

    protected PropertyChangeListener getControllerChangeListener() {
        if (this.controllerChangeListener_ == null) {
            this.controllerChangeListener_ = new ControllerChangeListener();
        }
        return this.controllerChangeListener_;
    }

    static void pvec(String name, double[] vec) {
        System.err.print(name + "=[");
        for (int i = 0; i < vec.length; ++i) {
            System.err.print(vec[i] + ",");
        }
        System.err.println("]");
    }

    private static void rotationToCamera(JnMatrix3d rot, double[] eye, double[] look, double[] up) {
        up[0] = rot.m01;
        up[1] = rot.m11;
        up[2] = -rot.m21;
        eye[0] = look[0] + rot.m02;
        eye[1] = look[1] + rot.m12;
        eye[2] = look[2] - rot.m22;
    }

    private void computeCenter() {
        if (this.cursor_ != null) {
            CPoint pt = this.cursor_.getPoint(null);
            this.geomVc_.getTransform((byte)2, (byte)1).transform(pt);
            this.centerx_ = (int)pt.x;
            this.centery_ = (int)pt.y;
        } else {
            this.centerx_ = this.getWidth() / 2;
            this.centery_ = this.getHeight() / 2;
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.interactive_ = true;
        int cx = this.centerx_;
        int cy = this.centery_;
        this.prev = event.getPoint();
        if (this.mouseMode_ == 1) {
            int dx = event.getX() - cx;
            int dy = event.getY() - cy;
            double vx = -Math.sin(this.angle_);
            double vy = Math.cos(this.angle_);
            this.sign_ = vx * (double)dx + vy * (double)dy;
        }
        for (T3DCapable t3DCapable : this.obliqueViewerList_) {
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.interactive_ = false;
        for (T3DCapable t3DCapable : this.obliqueViewerList_) {
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point newPt = event.getPoint();
        if (this.mouseMode_ == 0) {
            int cx = this.centerx_;
            int cy = this.centery_;
            int anglex = newPt.x - cx;
            int angley = newPt.y - cy;
            this.angle_ = Math.atan2(angley, anglex);
            if (this.controller_ != null) {
                this.tmpRotation2.rotZ(this.angle_);
                this.tmpRotation1 = DefaultObliqueController.getLPSxform(this.controller_);
                this.tmpRotation2.mul(this.tmpRotation1);
                this.findRotationRx(this.tmpRotation2, this.obliqueRotation_);
                double[] eye = new double[3];
                double[] look = this.controller_.getLookPoint(null);
                if (this.cursor_ != null) {
                    look = this.cursor_.getPoint(null).generateArray();
                }
                double[] up = new double[3];
                DefaultObliqueController.rotationToCamera(this.obliqueRotation_, eye, look, up);
                for (T3DCapable element : this.obliqueViewerList_) {
                    element.setCamera(eye, look, up);
                }
            }
            this.repaint();
        } else if (this.mouseMode_ == 1 && this.controller_ != null) {
            int cx = this.centerx_;
            int cy = this.centery_;
            int dx = event.getX() - cx;
            int dy = event.getY() - cy;
            double vx = -Math.sin(this.angle_);
            double vy = Math.cos(this.angle_);
            double mysign = vx * (double)dx + vy * (double)dy;
            if (this.sign_ == 0.0) {
                this.sign_ = mysign;
            }
            if (mysign * this.sign_ >= 0.0) {
                CPoint pt = this.cursor_.getPoint(null);
                double screenThickness = Math.abs(mysign);
                CPoint spt = new CPoint((double)this.centerx_, (double)this.centery_ - screenThickness, 0.0, 1);
                this.geomVc_.getTransform((byte)1, (byte)2).transform(spt);
                double realThickness = spt.sub(pt).length();
                for (T3DCapable element : this.obliqueViewerList_) {
                    element.setViewClip(new double[]{-realThickness, realThickness});
                }
            } else {
                for (T3DCapable element : this.obliqueViewerList_) {
                    element.setViewClip(new double[]{0.0, 0.0});
                }
            }
            this.repaint();
        } else {
            this.centerx_ = event.getX();
            this.centery_ = event.getY();
            CPoint pt = new CPoint(this.centerx_, this.centery_, 0, 1);
            if (this.controller_ instanceof T3DDepthCapable) {
                double[] ras = ((T3DDepthCapable)((Object)this.controller_)).getRASCoords(this.centerx_, this.centery_, new double[3]);
                pt.setPoint(ras[0], ras[1], ras[2], (byte)2);
            } else {
                this.geomVc_.getTransform((byte)1, (byte)2).transform(pt);
            }
            this.cursor_.setPoint(new CPoint(pt.x, pt.y, pt.z, 2));
            this.repaint();
        }
    }

    private JnMatrix3d findRotationRx(JnMatrix3d rotation, JnMatrix3d rx) {
        double dotSagittal;
        if (rx == null) {
            rx = new JnMatrix3d();
        }
        JnVector3d myZ = new JnVector3d(-rotation.m01, -rotation.m11, -rotation.m21);
        JnVector3d axialMajor = new JnVector3d();
        JnMatrix3d xform = AXIAL_TRANSFORM;
        axialMajor.set(xform.m02, xform.m12, xform.m22);
        JnVector3d coronalMajor = new JnVector3d();
        xform = CORONAL_TRANSFORM;
        coronalMajor.set(xform.m02, xform.m12, xform.m22);
        JnVector3d sagittalMajor = new JnVector3d();
        xform = SAGITTAL_TRANSFORM;
        sagittalMajor.set(xform.m02, xform.m12, xform.m22);
        double dotAxial = myZ.dot(axialMajor);
        double dotCoronal = myZ.dot(coronalMajor);
        double closest = dotSagittal = myZ.dot(sagittalMajor);
        if (Math.abs(dotCoronal) > Math.abs(closest)) {
            xform = CORONAL_TRANSFORM;
            closest = dotCoronal;
        }
        if (Math.abs(dotAxial) > Math.abs(closest)) {
            xform = AXIAL_TRANSFORM;
            closest = dotAxial;
        }
        if (closest < 0.0) {
            rx.m02 = -myZ.x;
            rx.m12 = -myZ.y;
            rx.m22 = -myZ.z;
            this.angle_ += Math.PI;
        } else {
            rx.m02 = myZ.x;
            rx.m12 = myZ.y;
            rx.m22 = myZ.z;
        }
        JnVector3d xx = new JnVector3d(xform.m00, xform.m10, xform.m20);
        JnVector3d yy = new JnVector3d(xform.m01, xform.m11, xform.m21);
        JnVector3d myX = new JnVector3d(rotation.m00, rotation.m10, rotation.m20);
        JnVector3d myY = new JnVector3d(rotation.m02, rotation.m12, rotation.m22);
        double dotX = xx.dot(myX);
        double dotY = xx.dot(myY);
        if (Math.abs(dotX) >= Math.abs(dotY)) {
            if (dotX > 0.0) {
                rx.m00 = myX.x;
                rx.m10 = myX.y;
                rx.m20 = myX.z;
            } else {
                rx.m00 = -myX.x;
                rx.m10 = -myX.y;
                rx.m20 = -myX.z;
            }
            dotY = myY.dot(yy);
            if (dotY > 0.0) {
                rx.m01 = myY.x;
                rx.m11 = myY.y;
                rx.m21 = myY.z;
            } else {
                rx.m01 = -myY.x;
                rx.m11 = -myY.y;
                rx.m21 = -myY.z;
            }
        } else {
            dotX = myY.dot(xx);
            if (dotX > 0.0) {
                rx.m00 = myY.x;
                rx.m10 = myY.y;
                rx.m20 = myY.z;
            } else {
                rx.m00 = -myY.x;
                rx.m10 = -myY.y;
                rx.m20 = -myY.z;
            }
            dotY = myX.dot(yy);
            if (dotY > 0.0) {
                rx.m01 = myX.x;
                rx.m11 = myX.y;
                rx.m21 = myX.z;
            } else {
                rx.m01 = -myX.x;
                rx.m11 = -myX.y;
                rx.m21 = -myX.z;
            }
        }
        return rx;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (!this.interactive_) {
            int y;
            int cx = this.centerx_;
            int cy = this.centery_;
            int x = event.getX();
            if (this.containsRotationHandle(x, y = event.getY(), cx, cy)) {
                if (this.mouseMode_ != 0) {
                    this.setCursor(CustomCursor.ROTATION_2D_CURSOR);
                    this.mouseMode_ = 0;
                }
                return;
            }
            if (this.containsCenterHandle(x, y, cx, cy)) {
                if (this.mouseMode_ != 2) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.mouseMode_ = 2;
                }
                return;
            }
            if (this.containsThicknessLine(x, y, cx, cy)) {
                double cosA = Math.cos(this.angle_);
                double sinA = Math.sin(this.angle_);
                double nsCross = Math.abs(cosA * N_S_V.getX() + sinA * N_S_V.getY());
                double ewCross = Math.abs(cosA * E_W_V.getX() + sinA * E_W_V.getY());
                double neSwCross = Math.abs(cosA * NE_SW_V.getX() + sinA * NE_SW_V.getY());
                double nwSeCross = Math.abs(cosA * NW_SE_V.getX() + sinA * NW_SE_V.getY());
                int cursorM = 11;
                double major = nsCross;
                if (ewCross > major) {
                    major = ewCross;
                    cursorM = 8;
                }
                if (neSwCross > major) {
                    major = neSwCross;
                    cursorM = 6;
                }
                if (nwSeCross > major) {
                    cursorM = 7;
                }
                if (this.mouseMode_ != 1 || this.thicknessDirectionCursor != cursorM) {
                    this.setCursor(Cursor.getPredefinedCursor(cursorM));
                    this.mouseMode_ = 1;
                    this.thicknessDirectionCursor = cursorM;
                }
                return;
            }
        }
    }

    @Override
    public void addViewer(T3DCapable viewer) {
        this.obliqueViewerList_.add(viewer);
    }

    public void remove(T3DCapable viewer) {
        this.obliqueViewerList_.remove(viewer);
    }

    public void removeAllViewers() {
        this.obliqueViewerList_.clear();
    }

    public JnMatrix3d getRotation() {
        return this.obliqueRotation_;
    }

    public double getThickness() {
        return 0.0;
    }

    public boolean isObliqueInteractive() {
        return this.interactive_;
    }

    public void snapViewer() {
        this.angle_ = 0.0;
        if (this.controller_ != null) {
            this.tmpRotation1 = DefaultObliqueController.getLPSxform(this.controller_);
            this.findRotationRx(this.tmpRotation1, this.obliqueRotation_);
            double[] eye = new double[3];
            double[] look = this.controller_.getLookPoint(null);
            if (this.cursor_ != null) {
                look = this.cursor_.getPoint(null).generateArray();
            }
            double[] up = new double[3];
            DefaultObliqueController.rotationToCamera(this.obliqueRotation_, eye, look, up);
            for (T3DCapable element : this.obliqueViewerList_) {
                element.setCamera(eye, look, up);
            }
        }
        this.repaint();
    }

    public T3DCapable[] getObliqueViewers() {
        if (this.obliqueViewerList_.size() > 0) {
            T3DCapable[] viewers = new T3DCapable[this.obliqueViewerList_.size()];
            Object[] objectArray = this.obliqueViewerList_.toArray();
            for (int i = 0; i < viewers.length; ++i) {
                viewers[i] = (T3DCapable)objectArray[i];
            }
            return viewers;
        }
        return null;
    }

    public void setRxColor(Color color) {
        this.rxColor_ = color;
        this.repaint();
    }

    public Color getRxColor() {
        return this.rxColor_;
    }

    private static void lineAcrossPort(int cx, int cy, int width, int height, double angle, Point p1, Point p2) {
        int x;
        if (Math.cos(angle) == 0.0) {
            p1.x = cx;
            p1.y = 0;
            p2.x = cx;
            p2.y = height - 1;
            return;
        }
        if (Math.sin(angle) == 0.0) {
            p1.x = 0;
            p1.y = cy;
            p2.x = width - 1;
            p2.y = cy;
            return;
        }
        int pointsAdded = 0;
        Point p = p1;
        int y = (int)((double)cy - (double)cx * Math.tan(angle));
        if (y >= 0 && y < height) {
            p.x = 0;
            p.y = y;
            p = p2;
            ++pointsAdded;
        }
        if ((y = (int)((double)cy + (double)(width - cx) * Math.tan(angle))) >= 0 && y < height) {
            p.x = width - 1;
            p.y = y;
            if (++pointsAdded == 2) {
                return;
            }
            p = p2;
        }
        if ((x = (int)((double)cx - (double)cy / Math.tan(angle))) >= 0 && x < width) {
            p.x = x;
            p.y = 0;
            if (++pointsAdded == 2) {
                return;
            }
            p = p2;
        }
        if ((x = (int)((double)cx + (double)(height - cy) / Math.tan(angle))) >= 0 && x < width) {
            p.x = x;
            p.y = height - 1;
        }
    }

    @Override
    public void setController(T3DCapable controller) {
        this.removeAllViewers();
        this.controller_ = controller;
    }

    public void setReferenceVc(XpVisualComponent vc) {
        this.geomVc_ = vc;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        DMSession dms = new DMSession("file", "/thesource/images/ThinClient/direct3d", null);
        DMVolume xjv = DMVolume.buildVolume("DMObjectVolume", new Object[]{dms.getRelated("series")[0]});
        T3DViewport port1 = new T3DViewport();
        port1.setVolume(xjv);
        JPanel main = new JPanel(new BorderLayout());
        f.setContentPane(main);
        port1.setPreferredSize(new Dimension(512, 512));
        main.add(port1);
        JPanel leftPanel = new JPanel(new BorderLayout());
        T3DViewport port2 = new T3DViewport();
        port2.setVolumeModel(port1.getVolumeModel());
        port2.setPreferredSize(new Dimension(256, 256));
        T3DViewport port3 = new T3DViewport();
        port3.setVolumeModel(port1.getVolumeModel());
        port3.setPreferredSize(new Dimension(256, 256));
        leftPanel.add((Component)port2, "North");
        leftPanel.add((Component)port3, "South");
        main.add((Component)leftPanel, "Before");
        OrientationCubeVc cube = new OrientationCubeVc(port1.getT3DComponent());
        port1.getT3DComponent().add(cube);
        OrientationCubeVc cube2 = new OrientationCubeVc(port2.getT3DComponent());
        cube2.setTrackballEnabled(true);
        port2.getT3DComponent().add(cube2);
        OrientationCubeVc cube3 = new OrientationCubeVc(port3.getT3DComponent());
        port3.getT3DComponent().add(cube3);
        DefaultObliqueController oblique = new DefaultObliqueController(port2.getT3DComponent(), port2.getT3DComponent(), new DefaultCursor3DModel(port2.getT3DComponent()));
        oblique.addViewer(port1.getT3DComponent());
        oblique.addViewer(port3.getT3DComponent());
        port2.getT3DComponent().add(oblique);
        oblique.snapViewer();
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    private class CursorChangeListener
    implements XjChangeListener {
        private CursorChangeListener() {
        }

        @Override
        public void stateChanged(EventObject e) {
            if (!DefaultObliqueController.this.interactive_) {
                DefaultObliqueController.this.repaint();
            }
        }
    }

    private class ControllerChangeListener
    implements PropertyChangeListener {
        private ControllerChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (!"camera".equals(e.getPropertyName())) {
                return;
            }
            if (!DefaultObliqueController.this.obliqueViewerList_.isEmpty() && DefaultObliqueController.this.controller_ != null) {
                DefaultObliqueController.this.tmpRotation2.rotZ(DefaultObliqueController.this.angle_);
                DefaultObliqueController.this.tmpRotation1 = DefaultObliqueController.getLPSxform(DefaultObliqueController.this.controller_);
                DefaultObliqueController.this.tmpRotation2.mul(DefaultObliqueController.this.tmpRotation1);
                DefaultObliqueController.this.findRotationRx(DefaultObliqueController.this.tmpRotation2, DefaultObliqueController.this.obliqueRotation_);
                double[] eye = new double[3];
                double[] look = DefaultObliqueController.this.cursor_.getPoint(null).generateArray();
                double[] up = new double[3];
                DefaultObliqueController.rotationToCamera(DefaultObliqueController.this.obliqueRotation_, eye, look, up);
                double[] view = new double[]{look[0] - eye[0], look[1] - eye[1], look[2] - eye[2]};
                for (T3DCapable element : DefaultObliqueController.this.obliqueViewerList_) {
                    double[] eEye = element.getEyePoint(new double[3]);
                    double[] eLook = element.getLookPoint(new double[3]);
                    double[] eUp = element.getUp(new double[3]);
                    double[] eView = new double[]{eLook[0] - eEye[0], eLook[1] - eEye[1], eLook[2] - eEye[2]};
                    if (this.isIdentical(eUp, up) && this.isIdentical(eView, view)) continue;
                    element.setCamera(eye, look, up);
                }
            }
        }

        private boolean isIdentical(double[] v1, double[] v2) {
            JnVector3d vv1 = new JnVector3d(v1);
            JnVector3d vv2 = new JnVector3d(v2);
            vv1.normalize();
            vv2.normalize();
            return vv1.sub(vv2).lengthSquared() < 0.001;
        }
    }
}

