/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.geom.ParametricCurve3D;
import com.ge.med.jnu.surface.JnSurface;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.j3d.Commons3D;
import com.ge.med.terra.jami.j3d.J3DBaseRenderEngine;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DBaseRenderEngine;
import com.ge.med.terra.jami.j3d.VoxelCombiner;
import com.ge.med.terra.jami.j3d.mpr.CurvedReformat;
import com.ge.med.terra.jami.j3d.mpr.majoraxisThickmpr;
import com.ge.med.terra.jami.j3d.mpr.thickmprMultiVolume;
import com.ge.med.terra.jami.j3d.surface.SurfaceRenderer;
import com.ge.med.terra.jami.j3d.surface.SurfaceUtils;
import com.ge.med.terra.jami.j3d.vr.RayTracer;
import com.ge.med.terra.jami.j3d.vr.VrCamera;
import com.ge.med.terra.jami.j3d.vr.VrColor;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrContext;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.jami.j3d.vr.vr;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class J3DRenderEngine
extends J3DBaseRenderEngine {
    private VrCamera vrcam = null;
    private boolean voiDirty = true;
    private vr vr_engine = new vr();
    private RayTracer mipRayTracer = new vr.RayLuminanceMIP();
    private RayTracer minipRayTracer = new vr.RayLuminanceMINIP();
    private RayTracer colorRayTracer = new vr.RaySplitColorLut_NonPower2_i();
    private RayTracer byte_colorRayTracer = new vr.ByteRaySplitColorLut_NonPower2_i();
    private RayTracer byte_mipRayTracer = new vr.ByteRayLuminanceMIP();
    private RayTracer byte_minipRayTracer = new vr.ByteRayLuminanceMINIP();
    private CurvedReformat[] cr = new CurvedReformat[8];
    private majoraxisThickmpr[] mipmpr = new majoraxisThickmpr[8];
    private thickmprMultiVolume[] mv_mipmpr = new thickmprMultiVolume[8];
    private VoxelCombiner vox_combiner = null;
    private Object voxCombinerData = null;
    private SurfaceRenderer surfaceRenderer = new SurfaceRenderer();
    private int mcX = 2;
    private int mcY = 2;
    private int mcZ = 1;
    private int mcThresh = 100;
    private float[] surfZbuffer;
    private int[] seg_cmap = new int[4096];
    private static String[] renderStyles = new String[]{"VOLUME", "REFORMAT", "FUSED_REFORMAT", "REFORMAT.TC", "REFORMAT.NN", "MIP", "MINIP", "AVERAGE", "FULLBODY_MIP", "FULLBODY_MINIP", "MAJOR_AXIS_MIP", "MAJOR_AXIS_MINIP", "MAJOR_AXIS_AVERAGE", "CURVED_REFORMAT", "LUMEN_REFORMAT", "MULTIVOLUME_REFORMAT", "MULTIVOLUME_MIP", "MULTIVOLUME_MINIP", "MULTIVOLUME_AVG", "SURFACE", "NO_RENDER"};
    private int jitter_idx = 0;
    private static double[] jitter = new double[128];
    private boolean segVisible = false;
    Map attribMap = new HashMap();
    boolean dirtySurface = true;

    public J3DRenderEngine() {
        this.init();
    }

    public J3DRenderEngine(ParallelTaskManager ptm) {
        super(ptm);
        this.init();
    }

    private void init() {
        this.seg_cmap[0] = 0;
        this.seg_cmap[1] = -2147418368;
        this.seg_cmap[2] = -2130771968;
        this.seg_cmap[3] = -2147483393;
        this.seg_cmap[4] = -2130706688;
        this.setRenderStyle("REFORMAT");
        this.setSegmentationColors(0, -2147418368);
    }

    protected majoraxisThickmpr[] getThickMPRAlgorithms() {
        return this.mipmpr;
    }

    protected thickmprMultiVolume[] getMultiVolumeThickMPRAlgorithms() {
        return this.mv_mipmpr;
    }

    protected majoraxisThickmpr getThickMPRAlgorithm(int layerNo) {
        if (this.mipmpr[layerNo] == null) {
            this.mipmpr[layerNo] = new majoraxisThickmpr();
        }
        return this.mipmpr[layerNo];
    }

    protected thickmprMultiVolume getMultiVolumeThickMPRAlgorithm(int layerNo) {
        if (this.mv_mipmpr[layerNo] == null) {
            this.mv_mipmpr[layerNo] = new thickmprMultiVolume();
        }
        return this.mv_mipmpr[layerNo];
    }

    protected CurvedReformat getCurvedReformat(int layerNo) {
        if (this.cr[layerNo] == null) {
            this.cr[layerNo] = new CurvedReformat();
        }
        return this.cr[layerNo];
    }

    @Override
    public void setVolume(XjVolumeInfo volume, int vol_idx) {
        J3DVolumeModel vol_model = null;
        if (volume != null) {
            vol_model = new J3DVolumeModel(volume);
        }
        this.setVolumeModel(vol_model, vol_idx);
        if (vol_model != null) {
            if (vol_model.vr_context != null) {
                vol_model.vr_context.addTaskMonitor(this);
            }
            if (vol_model.getJVolume() != null) {
                vol_model.getJVolume().addTaskMonitor(this);
            }
            this.syncVolumeModel(vol_idx);
        }
    }

    private void syncVolumeModel(int vol_idx) {
        int rstyle = this.getRenderStyleCode();
        switch (rstyle) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.volumeModelInit(vol_idx);
                break;
            }
        }
    }

    private void initAllVolumeModels() {
        for (int i = 0; i < this.getNumVolumes(); ++i) {
            this.volumeModelInit(i);
        }
    }

    private void volumeModelInit(int vol_idx) {
        J3DVolumeModel vol_model;
        T3DBaseRenderEngine.VolumeContext vc = this.getVolumeContext(vol_idx);
        if (vc != null && (vol_model = (J3DVolumeModel)vc.vol_model) != null && !vol_model.isInitialized()) {
            XpLog.config(">>>> Initializing volume model...");
            VrPreset vrpreset = (VrPreset)vc.getData("PRESET_PROPERTY");
            if (vrpreset != null && vrpreset.modality.equals(this.getModality(vol_idx))) {
                vol_model.init(vrpreset);
            } else if (vol_model.vr_context.presetCurves == null) {
                vol_model.init();
            }
        }
    }

    @Override
    public String[] getSupportedRenderStyles() {
        return renderStyles;
    }

    @Override
    public void cleanVolumeModel(int vol_idx) {
        super.cleanVolumeModel(vol_idx);
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel(vol_idx);
        if (vol_model != null) {
            JVolume.LinearVolume jlv = vol_model.getJVolume();
            if (vol_model.vr_context != null) {
                vol_model.vr_context.removeTaskMonitor(this);
                jlv.removeTaskMonitor(this);
                jlv.removePropertyChangeListener(this);
                if (vol_idx == 0 && vol_model.vr_context == this.vrcam.vr_ctxt) {
                    this.vrcam.vr_ctxt = null;
                }
                this.vrcam.removeVolume(vol_idx);
                if (vol_idx == 0) {
                    this.colorRayTracer.setVrSession(null);
                    this.mipRayTracer.setVrSession(null);
                    this.minipRayTracer.setVrSession(null);
                    this.byte_mipRayTracer.setVrSession(null);
                    this.byte_colorRayTracer.setVrSession(null);
                    this.byte_minipRayTracer.setVrSession(null);
                }
            }
        }
    }

    @Override
    protected void newVolumeModel(int vol_idx) {
        super.newVolumeModel(vol_idx);
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel(vol_idx);
        if (vol_model != null) {
            if (vol_idx == 0) {
                if (this.vrcam != null) {
                    this.vrcam.initVrCamera(vol_model.vr_context, null);
                } else {
                    this.vrcam = new VrCamera(vol_model.vr_context, null);
                }
            } else {
                JVolume.LinearVolume jlv = vol_model.getJVolume();
                this.vrcam.addVolume(jlv);
            }
            this.vrcam.setPerspective(this.isPerspective());
            vol_model.addChangeListener(this);
        }
    }

    @Override
    public void setRenderStyle(String style) {
        if (style.equals("FULLBODY_MIP")) {
            this.initAllVolumeModels();
            RayTracer fbmip = this.mipRayTracer;
            if (this.vrcam != null) {
                this.vrcam.setUseVoi(false);
                VrContext vctxt = this.vrcam.vr_ctxt;
                if (vctxt != null) {
                    fbmip = vctxt.vol instanceof JVolume.LinearShort ? this.mipRayTracer : this.byte_mipRayTracer;
                }
            }
            this.vr_engine.setRayTracer(fbmip);
            this.vr_engine.setVxColorEnhance(false);
        } else if (style.equals("FULLBODY_MINIP")) {
            this.initAllVolumeModels();
            RayTracer fbminip = this.minipRayTracer;
            if (this.vrcam != null) {
                this.vrcam.setUseVoi(false);
                VrContext vctxt = this.vrcam.vr_ctxt;
                if (vctxt != null) {
                    fbminip = vctxt.vol instanceof JVolume.LinearShort ? this.minipRayTracer : this.byte_minipRayTracer;
                }
            }
            this.vr_engine.setRayTracer(fbminip);
            this.vr_engine.setVxColorEnhance(false);
        } else if (style.equals("VOLUME")) {
            this.initAllVolumeModels();
            RayTracer rt = this.colorRayTracer;
            if (this.vrcam != null) {
                this.vrcam.setUseVoi(true);
                VrContext vctxt = this.vrcam.vr_ctxt;
                if (vctxt != null) {
                    if (vctxt.vol instanceof JVolume.LinearShort) {
                        rt = this.colorRayTracer;
                    } else if (vctxt.vol instanceof JVolume.LinearByte) {
                        rt = this.byte_colorRayTracer;
                    }
                }
            }
            this.vr_engine.setRayTracer(rt);
            this.vr_engine.setVxColorEnhance(true);
        } else if ("SURFACE".equals(style)) {
            this.syncSurface();
        }
        super.setRenderStyle(style);
        this.notifyChange();
    }

    protected boolean isMajorAxisThickStyle() {
        int code = this.getRenderStyleCode();
        return code == 13 || code == 11 || code == 12;
    }

    private void newView() {
        int width = this.getBufferWidth();
        int height = this.getBufferHeight();
        int nvols = this.getNumVolumes();
        short[] zbuffer = this.getZBuffer();
        if (this.vox_combiner != null && this.voxCombinerData != null) {
            this.vox_combiner.setData(this.voxCombinerData);
        }
        for (int i = 0; i < nvols; ++i) {
            J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel(i);
            JVolume.LinearVolume jlv = vol_model.getJVolume();
            int dx = jlv.dx;
            int dy = jlv.dy;
            int dz = jlv.dz;
            double[] vox_lookpt = this.getVoxLookPoint(i);
            double[] vox_xdir = this.getVoxXDir(i);
            double[] vox_ydir = this.getVoxYDir(i);
            double[] vox_zdir = this.getVoxZDir(i);
            double nsteps = this.getNumSteps(i);
            int interpolation = 1;
            int rstyle = this.getRenderStyleCode();
            switch (rstyle) {
                case 1: {
                    interpolation = 0;
                    break;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: {
                    interpolation = 2;
                }
            }
            short nocontentPixel = Commons3D.noContentPixel(this.getModality(i));
            majoraxisThickmpr matm = this.getThickMPRAlgorithm(i);
            matm.setView(vox_lookpt, vox_xdir, vox_ydir, vox_zdir, nsteps, width, height, dx, dy, dz, interpolation, nocontentPixel);
            matm.setDepthBuffer(zbuffer);
            thickmprMultiVolume mv_tm = this.getMultiVolumeThickMPRAlgorithm(i);
            mv_tm.setCombiner(this.vox_combiner);
            mv_tm.setView(vox_lookpt, vox_xdir, vox_ydir, vox_zdir, nsteps, width, height, dx, dy, dz, interpolation, nocontentPixel);
            mv_tm.setDepthBuffer(zbuffer);
        }
    }

    @Override
    public String getModality(int vol_idx) {
        J3DVolumeModel vm = (J3DVolumeModel)this.getVolumeModel(vol_idx);
        if (vm != null) {
            return vm.getJVolume().modality;
        }
        return "XX";
    }

    @Override
    public void initRender() {
        super.initRender();
        this.clearBuffers();
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        if (vol_model != null) {
            int rstyle = this.getRenderStyleCode();
            short nocontentPixel = Commons3D.noContentPixel(this.getModality(0));
            switch (rstyle) {
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    int width = this.getBufferWidth();
                    int height = this.getBufferHeight();
                    double aratio = this.getAspectRatio();
                    double viewWidth = this.getViewHeight() * aratio;
                    double[] eyePoint = this.getEyePoint(null);
                    double[] lookPoint = this.getLookPoint(null);
                    int[] rgbbuff = this.getRGBBuffer();
                    if (rgbbuff != null && this.vrcam.output != rgbbuff) {
                        short[] lumbuff = this.getLuminanceBuffer();
                        short[] zbuffer = this.getZBuffer();
                        this.vrcam.setDisplaySession(rgbbuff, lumbuff, zbuffer, width, height);
                    }
                    if (this.voiDirty) {
                        this.vrcam.updateVolumeBounds();
                    }
                    this.voiDirty = false;
                    this.vrcam.setVRView(this.getRASCameraMatrix(), eyePoint, lookPoint, viewWidth, this.getViewHeight());
                    this.vrcam.user_data = vol_model.user_data;
                    this.vrcam.setAirValue(nocontentPixel);
                    this.vrcam.setBackground(this.getRGBBackground());
                    RayTracer rt = this.vr_engine.getRayTracer();
                    rt.setVrSession(this.vrcam);
                    break;
                }
                case 14: 
                case 15: {
                    double[] lp = this.getLookPoint(null);
                    double[] ep = this.getEyePoint(null);
                    int buffWidth = this.getBufferWidth();
                    int buffHeight = this.getBufferHeight();
                    int numVols = this.getNumVolumes();
                    for (int i = 0; i < numVols; ++i) {
                        this.getCurvedReformat(i).initCurveReformat((J3DVolumeModel)this.getVolumeModel(i), lp, ep, buffWidth, buffHeight, nocontentPixel);
                    }
                    break;
                }
                default: {
                    this.newView();
                }
            }
        }
    }

    @Override
    public void setPerspective(boolean b) {
        if (this.vrcam != null) {
            this.vrcam.setPerspective(b);
        }
        super.setPerspective(b);
    }

    @Override
    public Object createThreadData() {
        return new J3DThreadData();
    }

    @Override
    public boolean isRenderChange() {
        return false;
    }

    @Override
    public int renderPixel(int thread_id, int renderOutputLayer, int x, int y, Object thread_data) {
        byte[] bingrid;
        int pixval = this.getBackgroundColor();
        J3DThreadData td = (J3DThreadData)thread_data;
        int rstyle = this.getRenderStyleCode();
        int w = this.getBufferWidth();
        int h = this.getBufferHeight();
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        JVolume.LinearVolume jlv = vol_model.getJVolume();
        short[] short_vol = null;
        Object voldata = jlv.getVolumeData();
        int PAD = jlv.PAD;
        byte[] byArray = bingrid = this.isSegmentationVisible() ? vol_model.vr_context.getSegBingrid() : null;
        if (voldata instanceof short[]) {
            short_vol = ((JVolume.LinearShort)jlv).volume;
        }
        switch (rstyle) {
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 11: {
                if (short_vol == null) break;
                pixval = this.getThickMPRAlgorithm(0).castray_thickmip_tl(x, y, short_vol, bingrid, PAD, w, h);
                break;
            }
            case 3: 
            case 12: {
                if (short_vol == null) break;
                pixval = this.getThickMPRAlgorithm(0).castray_thickminip_tl(x, y, short_vol, PAD, w, h);
                break;
            }
            case 4: 
            case 13: {
                if (short_vol == null) break;
                pixval = this.getThickMPRAlgorithm(0).castray_thickavg_tl(x, y, short_vol, PAD, w, h);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                pixval = this.vr_engine.cast_ray(x, y, jitter[this.jitter_idx], this.vrcam, td.color);
                this.jitter_idx = (this.jitter_idx + 1) % jitter.length;
            }
        }
        return pixval;
    }

    @Override
    public void renderPixels(int thread_id, int renderOutputLayer, int x0, int y0, int width, int height, int stepx, int stepy, Object thread_data) {
        byte[] bingrid;
        J3DThreadData td = (J3DThreadData)thread_data;
        int rstyle = this.getRenderStyleCode();
        int w = this.getBufferWidth();
        int h = this.getBufferHeight();
        int xend = Math.min(x0 + width, w);
        int yend = Math.min(y0 + height, h);
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel(renderOutputLayer);
        if (vol_model == null) {
            return;
        }
        JVolume.LinearVolume jlv = vol_model.getJVolume();
        short[] short_vol = null;
        byte[] byte_vol = null;
        short[] outoverlay = this.getOverlay();
        int[] cmap = null;
        Object voldata = jlv.getVolumeData();
        int PAD = jlv.PAD;
        byte[] byArray = bingrid = this.isSegmentationVisible() ? vol_model.vr_context.getSegBingrid() : null;
        if (voldata instanceof short[]) {
            short_vol = ((JVolume.LinearShort)jlv).volume;
        } else if (voldata instanceof byte[]) {
            JVolume.LinearByte jlb = (JVolume.LinearByte)jlv;
            byte_vol = jlb.volume;
            cmap = jlb.cmap;
        }
        int i = 0;
        short[] lum_outbuffer = this.getLuminanceBuffer();
        int[] rgb_outbuffer = this.getRGBBuffer();
        this.clearPixels(x0, y0, width, height, stepx, stepy);
        switch (rstyle) {
            case 0: {
                i = renderOutputLayer;
                if (short_vol != null) {
                    this.getThickMPRAlgorithm(i).mpr_tl(x0, y0, xend, yend, stepx, stepy, short_vol, bingrid, PAD, lum_outbuffer, outoverlay, w, h);
                    break;
                }
                if (byte_vol == null) break;
                this.getThickMPRAlgorithm(i).mpr_tl(x0, y0, xend, yend, stepx, stepy, byte_vol, bingrid, PAD, lum_outbuffer, outoverlay, w, h);
                break;
            }
            case 1: {
                i = renderOutputLayer;
                if (short_vol == null) break;
                this.getThickMPRAlgorithm(i).mpr_nn(x0, y0, xend, yend, stepx, stepy, short_vol, bingrid, PAD, lum_outbuffer, outoverlay, w, h);
                break;
            }
            case 9: {
                i = renderOutputLayer;
                if (short_vol == null) break;
                this.getThickMPRAlgorithm(i).mpr_tc(x0, y0, xend, yend, stepx, stepy, short_vol, PAD, lum_outbuffer, w, h);
                break;
            }
            case 10: {
                i = renderOutputLayer;
                if (short_vol != null) {
                    Object segdata = vol_model.getData("LABEL_VOLUME");
                    if (segdata instanceof short[]) {
                        short[] label_vol = (short[])segdata;
                        this.getThickMPRAlgorithm(i).mpr_fused_tl(x0, y0, xend, yend, stepx, stepy, short_vol, label_vol, PAD, lum_outbuffer, outoverlay, w, h);
                        break;
                    }
                    byte[] label_vol = (byte[])segdata;
                    this.getThickMPRAlgorithm(i).mpr_fused_tl(x0, y0, xend, yend, stepx, stepy, short_vol, label_vol, PAD, lum_outbuffer, outoverlay, w, h);
                    break;
                }
                if (byte_vol == null) break;
                this.getThickMPRAlgorithm(i).mpr_tl(x0, y0, xend, yend, stepx, stepy, byte_vol, bingrid, PAD, lum_outbuffer, outoverlay, w, h);
                break;
            }
            case 2: 
            case 11: {
                if (short_vol == null) break;
                this.getThickMPRAlgorithm(0).ma_mip(thread_id, x0, y0, width, height, stepx, stepy, short_vol, PAD, lum_outbuffer, w, h);
                break;
            }
            case 3: 
            case 12: {
                if (short_vol == null) break;
                this.getThickMPRAlgorithm(0).ma_minip(thread_id, x0, y0, width, height, stepx, stepy, short_vol, PAD, lum_outbuffer, w, h);
                break;
            }
            case 4: 
            case 13: {
                if (short_vol == null) break;
                this.getThickMPRAlgorithm(0).ma_avg(thread_id, x0, y0, width, height, stepx, stepy, short_vol, PAD, lum_outbuffer, w, h);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.vr_engine.render_vr(x0, y0, x0 + width, y0 + height, stepx, stepy, this.vrcam, td.color);
                break;
            }
            case 14: {
                if (short_vol == null) break;
                this.getCurvedReformat(i).curveReformat(y0, stepy, width, height, short_vol, PAD, lum_outbuffer, jlv.dx, jlv.dy, jlv.dz);
                break;
            }
            case 15: {
                if (short_vol == null) break;
                this.getCurvedReformat(i).lumenReformat(y0, stepy, width, height, short_vol, PAD, lum_outbuffer, jlv.dx, jlv.dy, jlv.dz);
                break;
            }
            case 16: {
                i = renderOutputLayer;
                if (short_vol == null || this.vox_combiner == null) break;
                short[][] vols = (short[][])vol_model.getVolumeData();
                this.getMultiVolumeThickMPRAlgorithm(i).mprMultiVolume_tl(thread_id, x0, y0, width, height, stepx, stepy, vols, PAD, lum_outbuffer, w, h);
                break;
            }
            case 17: {
                if (short_vol == null || this.vox_combiner == null) break;
                short[][] vols = (short[][])vol_model.getVolumeData();
                this.getMultiVolumeThickMPRAlgorithm(0).thick_mipMultiVolume(thread_id, x0, y0, width, height, stepx, stepy, vols, PAD, lum_outbuffer, outoverlay, w, h);
                break;
            }
            case 18: {
                if (short_vol == null || this.vox_combiner == null) break;
                short[][] vols = (short[][])vol_model.getVolumeData();
                this.getMultiVolumeThickMPRAlgorithm(0).thick_minipMultiVolume(thread_id, x0, y0, width, height, stepx, stepy, vols, PAD, lum_outbuffer, outoverlay, w, h);
                break;
            }
            case 19: {
                if (short_vol == null || this.vox_combiner == null) break;
                short[][] vols = (short[][])vol_model.getVolumeData();
                this.getMultiVolumeThickMPRAlgorithm(0).thick_avgMultiVolume(thread_id, x0, y0, width, height, stepx, stepy, vols, PAD, lum_outbuffer, outoverlay, w, h);
                break;
            }
            case 25: {
                short[] zbuffer = this.getZBuffer();
                if (zbuffer == null) break;
                for (int y = y0; y < height; y += stepy) {
                    int yoffset = y * w;
                    for (int x = x0; x < width; x += stepx) {
                        zbuffer[yoffset + x] = 8192;
                    }
                }
                break;
            }
            case 26: {
                this.surfaceRenderer.render(rgb_outbuffer, this.surfZbuffer, w, h, x0, y0, width, height, this.getTransform(1001, 1002, null), this.getTransform(1002, 1000, null), thread_id);
            }
        }
    }

    @Override
    public void setProperty(String propName, Object value) {
        super.setProperty(propName, value);
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        if (propName.equals("PRESET_PROPERTY")) {
            T3DBaseRenderEngine.VolumeContext vc;
            VrPreset preset = (VrPreset)value;
            if (vol_model != null) {
                vol_model.setPreset(preset);
            }
            if ((vc = this.getVolumeContext(0)) != null) {
                vc.setData("PRESET_PROPERTY", preset);
            }
            this.notifyChange();
        } else if (propName.equals("SEGMENTATION_MASK")) {
            byte[] mask = (byte[])value;
            if (vol_model != null) {
                vol_model.vr_context.bingridAnd(mask);
            }
            this.notifyChange();
        } else if (propName.equals("COLORLUT_PROPERTY")) {
            VrColorLut clut = (VrColorLut)value;
            if (vol_model != null) {
                vol_model.vr_context.setColorLut(clut);
            }
            this.notifyChange();
        }
    }

    @Override
    public void getDepthBuffer(float[] depthbuffer, int x, int y, int width, int height) {
        short[] zbuffer = this.getZBuffer();
        int rstyle = this.getRenderStyleCode();
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        JnMatrix4d vox2ras = vol_model.getVoxel2RASTransform();
        switch (rstyle) {
            case 5: 
            case 8: 
            case 25: {
                int bwidth = this.getBufferWidth();
                double[] ul = this.vrcam.ul;
                double[] xstep = this.vrcam.xstep;
                double[] ystep = this.vrcam.ystep;
                double[] zstep = this.vrcam.zstep;
                double[] pt = new double[3];
                JnMatrix4d display2ras = new JnMatrix4d(new double[]{xstep[0], ystep[0], zstep[0], ul[0], xstep[1], ystep[1], zstep[1], ul[1], xstep[2], ystep[2], zstep[2], ul[2], 0.0, 0.0, 0.0, 1.0});
                display2ras.mul(vox2ras, display2ras);
                int iy = 0;
                int yy = y;
                while (yy < y + height) {
                    int iyoffset = iy * 3 * width;
                    int ix = 0;
                    int xx = x;
                    while (xx < x + width) {
                        short step = zbuffer[yy * bwidth + xx];
                        if (step != 8192) {
                            pt[0] = xx;
                            pt[1] = yy;
                            pt[2] = step;
                            display2ras.transform(pt);
                            depthbuffer[iyoffset + 3 * ix] = (float)pt[0];
                            depthbuffer[iyoffset + 3 * ix + 1] = (float)pt[1];
                            depthbuffer[iyoffset + 3 * ix + 2] = (float)pt[2];
                        } else {
                            depthbuffer[iyoffset + 3 * ix] = -9999999.0f;
                            depthbuffer[iyoffset + 3 * ix + 1] = -9999999.0f;
                            depthbuffer[iyoffset + 3 * ix + 2] = -9999999.0f;
                        }
                        ++xx;
                        ++ix;
                    }
                    ++yy;
                    ++iy;
                }
                break;
            }
            case 14: 
            case 15: {
                double[] rcoords = new double[3];
                int iy = 0;
                int yy = y;
                while (yy < y + height) {
                    int iyoffset = iy * 3 * width;
                    int ix = 0;
                    int xx = x;
                    while (xx < x + width) {
                        this.getCurvedReformat(0).getVolumeCoords(xx, yy, rcoords);
                        vox2ras.transform(rcoords);
                        depthbuffer[iyoffset + 3 * ix] = (float)rcoords[0];
                        depthbuffer[iyoffset + 3 * ix + 1] = (float)rcoords[1];
                        depthbuffer[iyoffset + 3 * ix + 2] = (float)rcoords[2];
                        ++xx;
                        ++ix;
                    }
                    ++yy;
                    ++iy;
                }
                break;
            }
            case 26: {
                float[] surfaceZbuffer = this.surfZbuffer;
                int bwidth = this.getBufferWidth();
                double[] display2ras = this.getTransform(1002, 1001, null);
                float[] pt = new float[3];
                int iy = 0;
                int yy = y;
                while (yy < y + height) {
                    int iyoffset = iy * 3 * width;
                    int ix = 0;
                    int xx = x;
                    while (xx < x + width) {
                        float z = surfaceZbuffer[yy * bwidth + xx];
                        if (z != Float.MAX_VALUE) {
                            pt[0] = xx;
                            pt[1] = yy;
                            pt[2] = z;
                            J3DRenderEngine.transform4_3(display2ras, pt);
                            depthbuffer[iyoffset + 3 * ix] = pt[0];
                            depthbuffer[iyoffset + 3 * ix + 1] = pt[1];
                            depthbuffer[iyoffset + 3 * ix + 2] = pt[2];
                        } else {
                            depthbuffer[iyoffset + 3 * ix] = -9999999.0f;
                            depthbuffer[iyoffset + 3 * ix + 1] = -9999999.0f;
                            depthbuffer[iyoffset + 3 * ix + 2] = -9999999.0f;
                        }
                        ++xx;
                        ++ix;
                    }
                    ++yy;
                    ++iy;
                }
                break;
            }
            default: {
                double[] rcoords = new double[3];
                int iy = 0;
                int yy = y;
                while (yy < y + height) {
                    int iyoffset = iy * 3 * width;
                    int ix = 0;
                    int xx = x;
                    while (xx < x + width) {
                        this.getThickMPRAlgorithm(0).getVolumeCoords(xx, yy, rcoords);
                        vox2ras.transform(rcoords);
                        depthbuffer[iyoffset + 3 * ix] = (float)rcoords[0];
                        depthbuffer[iyoffset + 3 * ix + 1] = (float)rcoords[1];
                        depthbuffer[iyoffset + 3 * ix + 2] = (float)rcoords[2];
                        ++xx;
                        ++ix;
                    }
                    ++yy;
                    ++iy;
                }
                break block0;
            }
        }
    }

    @Override
    public int getDepthStep(int x, int y) {
        int rstyle = this.getRenderStyleCode();
        int step = -9999999;
        XjVolumeModel vm = this.getVolumeModel();
        if (vm != null) {
            switch (rstyle) {
                case 5: 
                case 8: {
                    if (this.vrcam == null) break;
                    J3DThreadData tmpVrColor = new J3DThreadData();
                    int vrstep = this.vr_engine.cast_ray_depth(x, y, 0.0, this.vrcam, tmpVrColor.color);
                    if (vrstep == 8192) break;
                    step = vrstep;
                    break;
                }
                case 14: 
                case 15: {
                    step = 0;
                    break;
                }
                default: {
                    step = this.getThickMPRAlgorithm(0).getDepthStep(x, y);
                    if (step == 8192) {
                        J3DVolumeModel jvm = (J3DVolumeModel)vm;
                        int w = this.getBufferWidth();
                        int h = this.getBufferHeight();
                        short[] vol = (short[])jvm.j_vol.getVolumeData();
                        int vol_offset = jvm.j_vol.PAD;
                        short[] depthval = new short[1];
                        short[] imgval = new short[1];
                        switch (rstyle) {
                            case 2: 
                            case 11: {
                                this.getThickMPRAlgorithm(0).thickminip_pixel_tl(x, y, vol, vol_offset, imgval, depthval, w, h);
                                step = depthval[0];
                                break;
                            }
                            case 3: 
                            case 12: {
                                this.getThickMPRAlgorithm(0).thickminip_pixel_tl(x, y, vol, vol_offset, imgval, depthval, w, h);
                                step = depthval[0];
                            }
                        }
                    }
                    if (step != 8192) break;
                    step = -9999999;
                }
            }
        }
        return step;
    }

    @Override
    public double[] getVolumeCoords(int x, int y, double[] vCoords) {
        double[] volCoords = vCoords;
        if (volCoords == null) {
            volCoords = new double[3];
        }
        int rstyle = this.getRenderStyleCode();
        switch (rstyle) {
            case 5: 
            case 8: {
                int step = this.getDepthStep(x, y);
                if (step == -9999999) {
                    return null;
                }
                double[] ul = this.vrcam.ul;
                double[] xstep = this.vrcam.xstep;
                double[] ystep = this.vrcam.ystep;
                double sx = ul[0] + (double)x * xstep[0] + (double)y * ystep[0];
                double sy = ul[1] + (double)x * xstep[1] + (double)y * ystep[1];
                double sz = ul[2] + (double)x * xstep[2] + (double)y * ystep[2];
                volCoords[0] = sx + (double)step * this.vrcam.zstep[0];
                volCoords[1] = sy + (double)step * this.vrcam.zstep[1];
                volCoords[2] = sz + (double)step * this.vrcam.zstep[2];
                break;
            }
            case 14: 
            case 15: {
                volCoords = this.getCurvedReformat(0).getVolumeCoords(x, y, vCoords);
                break;
            }
            default: {
                volCoords = this.getThickMPRAlgorithm(0).getVolumeCoords(x, y, volCoords);
            }
        }
        return volCoords;
    }

    @Override
    public void setOutput(int[] rgbBuff, short[] luminanceBuff, int width, int height) {
        super.setOutput(rgbBuff, luminanceBuff, width, height);
        int zlen = width * height;
        if (this.surfZbuffer == null || this.surfZbuffer.length != zlen) {
            this.surfZbuffer = new float[zlen];
        }
    }

    @Override
    public double[] getRASCoords(int x, int y, double[] rasCoords) {
        if (rasCoords == null) {
            rasCoords = new double[3];
        }
        if (this.getRenderStyleCode() == 26) {
            float[] surfaceZbuffer = this.surfZbuffer;
            double[] display2ras = this.getTransform(1002, 1001, null);
            float[] pt = new float[3];
            float z = surfaceZbuffer[x + y * this.getBufferWidth()];
            if (z != Float.MAX_VALUE) {
                pt[0] = x;
                pt[1] = y;
                pt[2] = z;
                J3DRenderEngine.transform4_3(display2ras, pt);
                rasCoords[0] = pt[0];
                rasCoords[1] = pt[1];
                rasCoords[2] = pt[2];
                return rasCoords;
            }
            return null;
        }
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        double[] vc = this.getVolumeCoords(x, y, rasCoords);
        if (vc == null) {
            return null;
        }
        vol_model.voxelToRas(rasCoords, rasCoords);
        return rasCoords;
    }

    @Override
    public double getValue(int x, int y) {
        int rstyle = this.getRenderStyleCode();
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        double[] tmpGetValue = new double[3];
        double[] vc = this.getVolumeCoords(x, y, tmpGetValue);
        if (vc == null) {
            return -9999999.0;
        }
        double value = 0.0;
        switch (rstyle) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                value = vol_model.getVolumeValue(tmpGetValue[0], tmpGetValue[1], tmpGetValue[2]);
                break;
            }
            default: {
                int w = this.getBufferWidth();
                int h = this.getBufferHeight();
                if (x < 0 || x >= w || y < 0 || y >= h) break;
                short[] lum_data = this.getLuminanceBuffer();
                value = lum_data[y * w + x];
            }
        }
        return value;
    }

    public VrCamera getVrCamera() {
        return this.vrcam;
    }

    @Override
    public double getRescaleSlope(int renderOutputLayer) {
        int renderStyleCode = this.getRenderStyleCode();
        switch (renderStyleCode) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return this.vox_combiner != null ? this.vox_combiner.getRescaleSlope() : 1.0;
            }
        }
        return super.getRescaleSlope(renderOutputLayer);
    }

    @Override
    public double getRescaleIntercept(int renderOutputLayer) {
        int renderStyleCode = this.getRenderStyleCode();
        switch (renderStyleCode) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return this.vox_combiner != null ? this.vox_combiner.getRescaleIntercept() : 0.0;
            }
        }
        return super.getRescaleIntercept(renderOutputLayer);
    }

    @Override
    public VoxelCombiner getVoxelCombiner() {
        return this.vox_combiner;
    }

    @Override
    public void setVoxelCombiner(VoxelCombiner combiner) {
        this.vox_combiner = combiner;
        if (this.vox_combiner != null) {
            this.vox_combiner.setNumberOfThreads(ParallelTaskManager.NCPUS);
        }
        this.voxCombinerData = null;
    }

    @Override
    public void setVoxelCombinerData(Object data) {
        this.voxCombinerData = data;
    }

    @Override
    public Object getVoxelCombinerData() {
        return this.voxCombinerData;
    }

    @Override
    public void setCurve(ParametricCurve3D curve) {
        int numVols = this.getNumVolumes();
        for (int i = 0; i < numVols; ++i) {
            this.getCurvedReformat(i).setCurve(curve);
        }
    }

    @Override
    public ParametricCurve3D getCurve() {
        return this.getCurvedReformat(0).getCurve();
    }

    @Override
    public void setPreset(VrPreset preset) {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        vol_model.setPreset(preset);
        this.notifyChange();
    }

    @Override
    public VrPreset getPreset() {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        return vol_model.vr_context.preset;
    }

    @Override
    public void setRayTracer(RayTracer rt) {
        this.colorRayTracer = rt;
        this.vr_engine.setRayTracer(rt);
        this.notifyChange();
    }

    @Override
    public RayTracer getRayTracer() {
        return this.vr_engine.getRayTracer();
    }

    @Override
    public void setColorLut(VrColorLut colorLut) {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        vol_model.vr_context.setColorLut(colorLut);
        this.notifyChange();
    }

    @Override
    public boolean applySegmentation(byte[] bgrid) {
        return this.intersect(bgrid);
    }

    @Override
    public void clearSegmentation() {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        vol_model.resetBingrid();
        this.notifyChange();
    }

    @Override
    public void setSegmentationVisible(boolean segVisible) {
        this.segVisible = segVisible;
        this.sync_mipmpr_seg();
        this.notifyChange();
    }

    @Override
    public boolean isSegmentationVisible() {
        return this.segVisible;
    }

    private void sync_mipmpr_seg() {
        int inIndex = -1;
        int outIndex = -1;
        if (this.isSegmentationVisible()) {
            int inColor = this.seg_cmap[0];
            int outColor = this.seg_cmap[1];
            inIndex = (inColor & 0xFF000000) == 0 ? -1 : 0;
            outIndex = (outColor & 0xFF000000) == 0 ? -1 : 1;
        }
        this.getThickMPRAlgorithm(0).setSegmentationIndex(inIndex, outIndex);
    }

    @Override
    public void setSegmentationColorMap(int[] cmap) {
        if (cmap != null) {
            if (cmap.length > this.seg_cmap.length) {
                this.seg_cmap = new int[cmap.length];
            }
            Arrays.fill(this.seg_cmap, 0);
            System.arraycopy(cmap, 0, this.seg_cmap, 0, cmap.length);
            this.sync_mipmpr_seg();
            this.notifyChange();
        }
    }

    @Override
    public int[] getSegmentationColorMap() {
        return this.seg_cmap;
    }

    @Override
    public boolean applySegmentation(short[] labels, int offset) {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        this.volumeModelInit(0);
        vol_model.setData("LABEL_VOLUME", labels);
        return true;
    }

    public void setSegmentationColors(int inColor, int outColor) {
        int inIndex = (inColor & 0xFF000000) == 0 ? -1 : 1;
        int outIndex = (outColor & 0xFF000000) == 0 ? -1 : 0;
        this.getThickMPRAlgorithm(0).setSegmentationIndex(inIndex, outIndex);
        this.notifyChange();
    }

    @Override
    public boolean intersect(byte[] bgrid) {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        JVolume.LinearVolume jlv = vol_model.getJVolume();
        int dx = jlv.dx;
        int dy = jlv.dy;
        int dz = jlv.dz;
        int len = dx * dy * dz >> 3;
        if (bgrid.length == len) {
            this.volumeModelInit(0);
            vol_model.bingridAnd(bgrid);
            this.voiDirty = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean union(byte[] bgrid) {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        JVolume.LinearVolume jlv = vol_model.getJVolume();
        int dx = jlv.dx;
        int dy = jlv.dy;
        int dz = jlv.dz;
        int len = dx * dy * dz >> 3;
        if (bgrid.length == len) {
            this.volumeModelInit(0);
            vol_model.bingridOr(bgrid);
            this.voiDirty = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean negation() {
        J3DVolumeModel vol_model = (J3DVolumeModel)this.getVolumeModel();
        this.volumeModelInit(0);
        vol_model.bingridNot();
        this.voiDirty = true;
        return true;
    }

    public void setRayJitter(boolean dojitter) {
        this.vr_engine.setRayJitter(dojitter);
    }

    public boolean isRayJitter() {
        return this.vr_engine.isRayJitter();
    }

    @Override
    public void setSurfaceRenderAttribute(String key, Object value) {
        this.attribMap.put(key, value);
        if ("shading_mode".equals(key)) {
            this.surfaceRenderer.setShadingMode((String)value);
        }
    }

    @Override
    public Object getSurfaceRenderAttribute(String key) {
        return this.attribMap.get(key);
    }

    @Override
    public JnSurface getSurface() {
        XjVolumeModel volmodel = this.getVolumeModel();
        if (volmodel != null) {
            return (JnSurface)volmodel.getClientProperty("surface");
        }
        return null;
    }

    @Override
    public void setSurfaceGenerationParams(int downX, int downY, int downZ, int thresh) {
        if (this.mcX != downX || this.mcY != downY || this.mcZ != downZ || this.mcThresh != thresh) {
            this.mcX = downX;
            this.mcY = downY;
            this.mcZ = downZ;
            this.mcThresh = thresh;
            this.dirtySurface = true;
        }
        if (this.getRenderStyle().equals("SURFACE")) {
            this.syncSurface();
        }
    }

    private void syncSurface() {
        J3DVolumeModel vm = (J3DVolumeModel)this.getVolumeModel();
        if (vm != null && this.dirtySurface) {
            double intercept = vm.j_vol.rescaleIntercept;
            double slope = vm.j_vol.rescaleSlope;
            int rawValue = (int)(((double)this.mcThresh - intercept) / slope);
            JnSurface surface = SurfaceUtils.generateSurface(vm, true, this.mcX, this.mcY, this.mcZ, rawValue);
            vm.putClientProperty("surface", surface);
            this.dirtySurface = false;
            this.surfaceRenderer.setVolumeModel(vm);
        }
    }

    static {
        for (int i = 0; i < jitter.length; ++i) {
            J3DRenderEngine.jitter[i] = Math.random();
        }
    }

    private static class J3DThreadData {
        public VrColor color = new VrColor();

        private J3DThreadData() {
        }
    }
}

