/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DDepthCapable;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.Polygon3D;
import com.ge.med.terra.jami.XpVisualComponent;
import com.ge.med.terra.jami.j3d.CaretDriver;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;

public class Polygon3DVc
extends XpVisualComponent
implements MouseInputListener,
ChangeListener {
    private final Polygon3D myPolygon;
    private final T3DCapable myEngine;
    private final Properties myProperties;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_DRAW = 1;
    private static final int ACTION_DRAG_GRID = 2;
    private int myAction = 0;
    public static final int DRAW_CONTINOUS = 0;
    public static final int DRAW_CLICK_GRIDS = 1;
    private int myDrawMode = 0;
    private boolean myCaretMarkerVisible = true;
    private boolean myCaretLineVisible = true;
    private CaretDriver myCaretDriver = new CaretDriver();
    private int myLastButtonPressed = 0;
    private CPoint myGrabbedGrid = null;
    private Point myCaretPoint = null;

    public Polygon3DVc(Polygon3D polygon, T3DCapable engine) {
        this(polygon, engine, null);
    }

    public Polygon3DVc(Polygon3D polygon, T3DCapable engine, Properties properties) {
        this.myPolygon = polygon;
        this.myEngine = engine;
        this.myProperties = properties != null ? properties : new Properties();
        this.myPolygon.addChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Polygon3D getPolygon3D() {
        return this.myPolygon;
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public void doDraw() {
        this.myAction = 1;
    }

    public void setDrawMode(int drawMode) {
        this.myDrawMode = drawMode;
    }

    public void setCaretMarkerVisibility(boolean caretMarkerVisibility) {
        this.myCaretMarkerVisible = caretMarkerVisibility;
    }

    public void setCaretLineVisibility(boolean caretLineVisibility) {
        this.myCaretLineVisible = caretLineVisibility;
    }

    public void setCaretDriver(CaretDriver caretDriver) {
        this.myCaretDriver = caretDriver;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.myAction == 1 && this.myDrawMode == 1) {
            switch (event.getButton()) {
                case 1: {
                    Point caretPoint = this.myCaretDriver.getCaretPoint(event.getPoint(), this.myPolygon.getPoints());
                    int w = event.getComponent().getWidth();
                    int h = event.getComponent().getHeight();
                    this.myPolygon.addPoint(this.computeRASPoint(caretPoint.x, caretPoint.y, w, h));
                    break;
                }
                case 3: {
                    this.myCaretPoint = null;
                    this.myAction = 0;
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.myLastButtonPressed = event.getButton();
        if (this.myAction == 0) {
            this.myGrabbedGrid = this.grabGrid(event.getX(), event.getY());
            if (this.myGrabbedGrid != null) {
                this.myAction = 2;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.myLastButtonPressed == 1 && this.myAction == 1 && this.myDrawMode == 0) {
            this.myAction = 0;
        } else if (this.myAction == 2) {
            this.myGrabbedGrid = null;
            this.myAction = 0;
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.myLastButtonPressed == 1 && this.myAction == 1 && this.myDrawMode == 0) {
            Point caretPoint = this.myCaretDriver.getCaretPoint(event.getPoint(), this.myPolygon.getPoints());
            int w = event.getComponent().getWidth();
            int h = event.getComponent().getHeight();
            this.myPolygon.addPoint(this.computeRASPoint(caretPoint.x, caretPoint.y, w, h));
        } else if (this.myAction == 2) {
            Point caretPoint = this.myCaretDriver.getCaretPoint(event.getPoint(), this.myPolygon.getPoints());
            int w = event.getComponent().getWidth();
            int h = event.getComponent().getHeight();
            this.myGrabbedGrid.setPoint(this.computeRASPoint(caretPoint.x, caretPoint.y, w, h));
            this.myPolygon.notifyChangeListeners();
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.myAction == 1 && this.myDrawMode == 1 && (this.myCaretMarkerVisible || this.myCaretLineVisible)) {
            this.myCaretPoint = this.myCaretDriver.getCaretPoint(event.getPoint(), this.myPolygon.getPoints());
            this.repaint();
        }
    }

    private CPoint computeRASPoint(int scx, int scy, int w, int h) {
        CPoint retValue = null;
        T3DDepthCapable depthCap = (T3DDepthCapable)((Object)this.myEngine.getCapable("com.ge.med.idc.T3DDepthCapable"));
        if (depthCap != null) {
            double[] rasCoords = depthCap.getRASCoords(scx, scy, null);
            if (rasCoords != null) {
                retValue = new CPoint(rasCoords[0], rasCoords[1], rasCoords[2], 2);
            }
        } else {
            double[] newCursorRAS = GeomUtils.DisplayToRAS(new int[]{scx, scy, 0}, this.myEngine.getEyePoint(null), this.myEngine.getLookPoint(null), this.myEngine.getUp(null), this.myEngine.getViewHeight(), w, h, null);
            retValue = new CPoint(newCursorRAS, 2);
        }
        return retValue;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.repaint();
    }

    @Override
    public boolean contains(int x, int y) {
        boolean retValue = false;
        retValue = this.myAction == 1 ? true : this.grabGrid(x, y) != null;
        return retValue;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int[] xPoints = new int[this.myPolygon.length()];
        int[] yPoints = new int[this.myPolygon.length()];
        g.setColor(this.myProperties.myGridColor);
        for (int i = 0; i < this.myPolygon.length(); ++i) {
            CPoint rasPoint = this.myPolygon.getPointAt(i);
            Point screenPoint = this.computeScreenPoint(rasPoint);
            xPoints[i] = screenPoint.x;
            yPoints[i] = screenPoint.y;
            if (!this.myProperties.myGridVisible) continue;
            g.drawRect(screenPoint.x - ((Properties)this.myProperties).myGridShape.getBounds().width / 2, screenPoint.y - ((Properties)this.myProperties).myGridShape.getBounds().height / 2, ((Properties)this.myProperties).myGridShape.getBounds().width, ((Properties)this.myProperties).myGridShape.getBounds().height);
        }
        switch (this.myProperties.myShape) {
            case 0: {
                g.setColor(this.myProperties.myLineColor);
                g.drawPolyline(xPoints, yPoints, this.myPolygon.length());
                if (this.myCaretPoint == null) break;
                g.setColor(Color.WHITE);
                if (this.myCaretLineVisible && this.myPolygon.length() > 0) {
                    g.drawLine(xPoints[this.myPolygon.length() - 1], yPoints[this.myPolygon.length() - 1], this.myCaretPoint.x, this.myCaretPoint.y);
                }
                if (!this.myCaretMarkerVisible) break;
                g.drawLine(this.myCaretPoint.x - 5, this.myCaretPoint.y, this.myCaretPoint.x + 5, this.myCaretPoint.y);
                g.drawLine(this.myCaretPoint.x, this.myCaretPoint.y - 5, this.myCaretPoint.x, this.myCaretPoint.y + 5);
                break;
            }
            case 2: {
                if (this.myPolygon.length() >= 3) {
                    ((Graphics2D)g).setPaint(this.myProperties.myPaint);
                    g.fillPolygon(xPoints, yPoints, this.myPolygon.length());
                }
            }
            case 1: {
                g.setColor(this.myProperties.myLineColor);
                g.drawPolygon(xPoints, yPoints, this.myPolygon.length());
                if (this.myCaretPoint == null) break;
                g.setColor(Color.WHITE);
                if (this.myCaretLineVisible && this.myPolygon.length() > 0) {
                    g.drawLine(xPoints[0], yPoints[0], this.myCaretPoint.x, this.myCaretPoint.y);
                    if (this.myPolygon.length() > 1) {
                        g.drawLine(xPoints[this.myPolygon.length() - 1], yPoints[this.myPolygon.length() - 1], this.myCaretPoint.x, this.myCaretPoint.y);
                    }
                }
                if (!this.myCaretMarkerVisible) break;
                g.drawLine(this.myCaretPoint.x - 5, this.myCaretPoint.y, this.myCaretPoint.x + 5, this.myCaretPoint.y);
                g.drawLine(this.myCaretPoint.x, this.myCaretPoint.y - 5, this.myCaretPoint.x, this.myCaretPoint.y + 5);
            }
        }
    }

    private CPoint grabGrid(int x, int y) {
        CPoint retValue = null;
        if (this.myProperties.myGridVisible) {
            for (int i = 0; i < this.myPolygon.length(); ++i) {
                CPoint rasPoint = this.myPolygon.getPointAt(i);
                Point screenPoint = this.computeScreenPoint(rasPoint);
                int gridWidth = ((Properties)this.myProperties).myGridShape.getBounds().width;
                int gridHeight = ((Properties)this.myProperties).myGridShape.getBounds().height;
                if (x < screenPoint.x - gridWidth / 2 || x > screenPoint.x + gridWidth / 2 || y < screenPoint.y - gridHeight / 2 || y > screenPoint.y + gridHeight / 2) continue;
                retValue = rasPoint;
            }
        }
        return retValue;
    }

    Point computeScreenPoint(CPoint rasPoint) {
        int width = ((JComponent)((Object)this.myEngine)).getWidth();
        int height = ((JComponent)((Object)this.myEngine)).getHeight();
        double[] point = GeomUtils.RAStoDisplay(rasPoint.generateArray(), this.myEngine.getEyePoint(null), this.myEngine.getLookPoint(null), this.myEngine.getUp(null), this.myEngine.getViewHeight(), width, height, null);
        return new Point((int)point[0], (int)point[1]);
    }

    public static class Properties {
        public static final int SHAPE_OPEN = 0;
        public static final int SHAPE_CLOSED_OUTLINED = 1;
        public static final int SHAPE_CLOSED_FILLED = 2;
        private int myShape = 0;
        private Color myLineColor = Color.RED;
        private boolean myGridVisible = true;
        private Color myGridColor = Color.CYAN;
        private Shape myGridShape = new Rectangle(10, 10);
        private Paint myPaint = Color.RED.darker();

        public void setShape(int shape) {
            this.myShape = shape;
        }

        public void setLineColor(Color lineColor) {
            this.myLineColor = lineColor;
        }

        public void setGridVisibility(boolean gridVisibility) {
            this.myGridVisible = gridVisibility;
        }

        public void setGridColor(Color gridColor) {
            this.myGridColor = gridColor;
        }

        public void setGridShape(Shape gridShape) {
            this.myGridShape = gridShape;
        }

        public void setPaint(Paint paint) {
            this.myPaint = paint;
        }
    }
}

