/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.jnu.JnVector3d;

public class RayBox {
    private static final byte RIGHT = 0;
    private static final byte LEFT = 1;
    private static final byte MIDDLE = 2;
    private static final int NUMDIM = 3;
    private byte[] quadrant = new byte[3];
    private double[] maxT = new double[3];
    private double[] candidatePlane = new double[3];
    private double[] minB = new double[3];
    private double[] maxB = new double[3];
    private double[] origin = new double[3];
    private double[] dir = new double[3];
    private double[] coord = new double[3];

    private String string(double[] d) {
        return "[" + d[0] + "," + d[1] + "," + d[2] + "]";
    }

    private void scale(double[] v, double s) {
        v[0] = v[0] * s;
        v[1] = v[1] * s;
        v[2] = v[2] * s;
    }

    private void inverse(double[] arg, double[] res) {
        res[0] = 1.0 / arg[0];
        res[1] = 1.0 / arg[1];
        res[2] = 1.0 / arg[2];
    }

    private void set(double[] arg, double[] res) {
        res[0] = arg[0];
        res[1] = arg[1];
        res[2] = arg[2];
    }

    public final boolean hitScanLine(JnVector3d minBPt, JnVector3d maxBPt, JnVector3d p0, JnVector3d step, int w, int[] t) {
        minBPt.fillArray(this.minB);
        maxBPt.fillArray(this.maxB);
        p0.fillArray(this.origin);
        step.fillArray(this.dir);
        int hit1 = this.hitRay(this.origin, this.dir);
        if (hit1 != -1) {
            t[0] = hit1;
            this.origin[0] = this.origin[0] + this.dir[0] * (double)w;
            this.origin[1] = this.origin[1] + this.dir[1] * (double)w;
            this.origin[2] = this.origin[2] + this.dir[2] * (double)w;
            this.scale(this.dir, -1.0);
            int hit2 = this.hitRay(this.origin, this.dir);
            t[1] = w - 1 - hit2;
            return true;
        }
        t[0] = 1;
        t[1] = 0;
        return false;
    }

    private int hitRay(double[] origin, double[] dir) {
        int i;
        int i2;
        boolean inside = true;
        for (i2 = 0; i2 < 3; ++i2) {
            if (origin[i2] < this.minB[i2]) {
                this.quadrant[i2] = 1;
                this.candidatePlane[i2] = this.minB[i2];
                inside = false;
                continue;
            }
            if (origin[i2] > this.maxB[i2]) {
                this.quadrant[i2] = 0;
                this.candidatePlane[i2] = this.maxB[i2];
                inside = false;
                continue;
            }
            this.quadrant[i2] = 2;
        }
        if (inside) {
            return 0;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            this.maxT[i2] = this.quadrant[i2] != 2 && dir[i2] != 0.0 ? (this.candidatePlane[i2] - origin[i2]) / dir[i2] : -1.0;
        }
        int whichPlane = 0;
        for (i = 1; i < 3; ++i) {
            if (!(this.maxT[whichPlane] < this.maxT[i])) continue;
            whichPlane = i;
        }
        if (this.maxT[whichPlane] < 0.0) {
            return -1;
        }
        for (i = 0; i < 3; ++i) {
            if (whichPlane != i) {
                this.coord[i] = origin[i] + this.maxT[whichPlane] * dir[i];
                if (!(this.quadrant[i] == 0 && this.coord[i] > this.maxB[i]) && (this.quadrant[i] != 1 || !(this.coord[i] < this.minB[i]))) continue;
                return -1;
            }
            this.coord[i] = this.candidatePlane[i];
        }
        return (int)(this.maxT[whichPlane] + 1.0);
    }

    public final boolean hitBoundingBox(JnVector3d minBPt, JnVector3d maxBPt, JnVector3d originPt, JnVector3d dirV, JnVector3d coordP) {
        int i;
        int i2;
        boolean inside = true;
        minBPt.fillArray(this.minB);
        maxBPt.fillArray(this.maxB);
        originPt.fillArray(this.origin);
        dirV.fillArray(this.dir);
        for (i2 = 0; i2 < 3; ++i2) {
            if (this.origin[i2] < this.minB[i2]) {
                this.quadrant[i2] = 1;
                this.candidatePlane[i2] = this.minB[i2];
                inside = false;
                continue;
            }
            if (this.origin[i2] > this.maxB[i2]) {
                this.quadrant[i2] = 0;
                this.candidatePlane[i2] = this.maxB[i2];
                inside = false;
                continue;
            }
            this.quadrant[i2] = 2;
        }
        if (inside) {
            coordP.set(this.origin);
            return true;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            this.maxT[i2] = this.quadrant[i2] != 2 && this.dir[i2] != 0.0 ? (this.candidatePlane[i2] - this.origin[i2]) / this.dir[i2] : -1.0;
        }
        int whichPlane = 0;
        for (i = 1; i < 3; ++i) {
            if (!(this.maxT[whichPlane] < this.maxT[i])) continue;
            whichPlane = i;
        }
        if (this.maxT[whichPlane] < 0.0) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (whichPlane != i) {
                this.coord[i] = this.origin[i] + this.maxT[whichPlane] * this.dir[i];
                if (!(this.quadrant[i] == 0 && this.coord[i] > this.maxB[i]) && (this.quadrant[i] != 1 || !(this.coord[i] < this.minB[i]))) continue;
                return false;
            }
            this.coord[i] = this.candidatePlane[i];
        }
        coordP.set(this.coord);
        return true;
    }

    public static void main(String[] args) {
        int nimgs;
        RayBox rb = new RayBox();
        int TIMES = nimgs = 10000;
        JnVector3d minB = new JnVector3d(0.0, 0.0, 0.0);
        JnVector3d maxB = new JnVector3d(4.0, 4.0, 4.0);
        JnVector3d o = new JnVector3d(-2.0, 2.0, 2.0);
        JnVector3d d = new JnVector3d(1.0, 0.0, 0.0);
        JnVector3d ipt = new JnVector3d();
        JnVector3d c = new JnVector3d(2.0, 2.0, 2.0);
        int[] t = new int[2];
        JnVector3d tmp1 = new JnVector3d();
        JnVector3d tmp2 = new JnVector3d();
        JnVector3d tmp3 = new JnVector3d();
        double theta = 0.0;
        double dtheta = Math.PI * 2 / (double)TIMES;
        long total = 0L;
        boolean intersect = true;
        for (int i = 0; i < TIMES; ++i) {
            o.set(10.0 * Math.sin(theta), 0.0, 10.0 * Math.cos(theta));
            d.sub(c, o);
            d.normalize();
            d.scale(0.3);
            long t0 = System.currentTimeMillis();
            boolean hit = rb.hitScanLine(minB, maxB, o, d, 60, t);
            long t1 = System.currentTimeMillis();
            total += t1 - t0;
            theta += dtheta;
            intersect = intersect && hit;
        }
        double avgTime = (double)total / (double)nimgs;
        System.out.println("AT=" + avgTime + "  [" + intersect + "] [" + total + "]");
    }
}

