/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d;

import com.ge.med.idc.T3DCapable;
import com.ge.med.idc.T3DRenderStyleCapable;
import com.ge.med.idc.XjVolume;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.j3d.CenterFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class T3DControlPanel
extends JPanel
implements PropertyChangeListener {
    private XjVolume volume;
    private T3DCapable t3d;
    JLabel origInfo = new JLabel();
    JLabel xvInfo = new JLabel();
    JLabel yvInfo = new JLabel();
    JLabel zvInfo = new JLabel();
    JLabel dimInfo = new JLabel();
    JTextField eyex = new JTextField();
    JTextField eyey = new JTextField();
    JTextField eyez = new JTextField();
    JTextField lookx = new JTextField();
    JTextField looky = new JTextField();
    JTextField lookz = new JTextField();
    JTextField upx = new JTextField();
    JTextField upy = new JTextField();
    JTextField upz = new JTextField();
    JTextField vcFront = new JTextField();
    JTextField vcBack = new JTextField();
    JTextField vh = new JTextField();
    JTextField asp = new JTextField();
    private JButton applyEyeButton = new JButton("Apply");
    private JButton applyLookButton = new JButton("Apply");
    private JButton applyUpButton = new JButton("Apply");
    private JButton applyCameraButton = new JButton("Apply");
    private JButton applyViewClipButton = new JButton("Apply");
    private JButton applyViewHeightButton = new JButton("Apply");
    private JButton applyAspectRatioButton = new JButton("Apply");
    private JRadioButton slice;
    private JRadioButton pixel;
    private JButton prevButton;
    private JButton nextButton;
    private JSlider thicknessSlider;
    private JSlider zoomSlider;
    private JComboBox renderStyleCombo = new JComboBox();
    static DecimalFormat format = new DecimalFormat("##0.00");

    public void setVolume(XjVolume volume) {
        this.volume = volume;
        this.updateVolumeInfo();
    }

    private void updateVolumeInfo() {
        if (this.volume != null) {
            double[] orig = this.volume.getRASOfOrigin(null);
            this.origInfo.setText("[" + orig[0] + ", " + orig[1] + "," + orig[2] + "]");
            double[] xv = this.volume.getXDirectionRAS(null);
            this.xvInfo.setText("[" + xv[0] + ", " + xv[1] + "," + xv[2] + "]");
            double[] yv = this.volume.getYDirectionRAS(null);
            this.yvInfo.setText("[" + yv[0] + ", " + yv[1] + "," + yv[2] + "]");
            double[] zv = this.volume.getZDirectionRAS(null);
            this.zvInfo.setText("[" + zv[0] + ", " + zv[1] + "," + zv[2] + "]");
            int[] dims = this.volume.getVolumeDimensions(null);
            this.dimInfo.setText("[" + dims[0] + ", " + dims[1] + "," + dims[2] + "]");
        }
    }

    public XjVolume getVolume() {
        return this.volume;
    }

    public void setT3D(T3DCapable t3d) {
        if (this.t3d != null) {
            this.t3d.removePropertyChangeListener(this);
        }
        this.t3d = t3d;
        if (this.t3d instanceof T3DRenderStyleCapable) {
            T3DRenderStyleCapable rsc = (T3DRenderStyleCapable)((Object)this.t3d);
            String[] styles = rsc.getSupportedRenderStyles();
            DefaultComboBoxModel cm = (DefaultComboBoxModel)this.renderStyleCombo.getModel();
            cm.removeAllElements();
            for (int i = 0; i < styles.length; ++i) {
                cm.addElement(styles[i]);
            }
            System.err.println("rstyle = " + rsc.getRenderStyle());
            cm.setSelectedItem(rsc.getRenderStyle());
            cm.setSelectedItem("REFORMAT");
        }
        if (this.t3d != null) {
            this.updateT3DInfo();
            this.t3d.addPropertyChangeListener(this);
        }
    }

    private void updateT3DInfo() {
        double[] eye = this.t3d.getEyePoint(null);
        this.eyex.setText(format.format(eye[0]));
        this.eyey.setText(format.format(eye[1]));
        this.eyez.setText(format.format(eye[2]));
        double[] look = this.t3d.getLookPoint(null);
        this.lookx.setText(format.format(look[0]));
        this.looky.setText(format.format(look[1]));
        this.lookz.setText(format.format(look[2]));
        double[] up = this.t3d.getUp(null);
        this.upx.setText(format.format(up[0]));
        this.upy.setText(format.format(up[1]));
        this.upz.setText(format.format(up[2]));
        this.asp.setText(format.format(this.t3d.getAspectRatio()));
        this.vh.setText(format.format(this.t3d.getViewHeight()));
        double[] vc = this.t3d.getViewClip(null);
        this.vcFront.setText(format.format(vc[0]));
        this.vcBack.setText(format.format(vc[0]));
    }

    public T3DCapable getT3D() {
        return this.t3d;
    }

    public T3DControlPanel() {
        this.buildUI();
        this.buildActions();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        JPanel viewPane = new JPanel(new BorderLayout());
        JPanel volInfoPanel = new JPanel(new BorderLayout());
        JPanel volinfoLabelPane = new JPanel(new GridLayout(0, 1));
        volinfoLabelPane.add(new JLabel("Origin"));
        volinfoLabelPane.add(new JLabel("x dir"));
        volinfoLabelPane.add(new JLabel("y dir"));
        volinfoLabelPane.add(new JLabel("z dir"));
        volinfoLabelPane.add(new JLabel("dimensions"));
        JPanel volinfoPanel = new JPanel(new GridLayout(0, 1));
        volinfoPanel.add(this.origInfo);
        volinfoPanel.add(this.xvInfo);
        volinfoPanel.add(this.yvInfo);
        volinfoPanel.add(this.zvInfo);
        volinfoPanel.add(this.dimInfo);
        volInfoPanel.add((Component)volinfoLabelPane, "Before");
        volInfoPanel.add(volinfoPanel);
        viewPane.add((Component)volInfoPanel, "First");
        JPanel quickie = new JPanel(new BorderLayout());
        JPanel quickieLabels = new JPanel(new GridLayout(0, 1));
        quickieLabels.add(new JLabel("Paging"));
        quickieLabels.add(new JLabel("Thickness"));
        quickieLabels.add(new JLabel("Zoom"));
        quickieLabels.add(new JLabel("RenderStyle"));
        quickie.add((Component)quickieLabels, "Before");
        JPanel quickieControls = new JPanel(new GridLayout(0, 1));
        JPanel pagingPanel = new JPanel(new CenterFlowLayout());
        this.slice = new JRadioButton("Slice", true);
        this.pixel = new JRadioButton("Pixel", false);
        ButtonGroup pageSizeBg = new ButtonGroup();
        pageSizeBg.add(this.slice);
        pageSizeBg.add(this.pixel);
        this.prevButton = new JButton("<");
        this.nextButton = new JButton(">");
        pagingPanel.add(this.prevButton);
        pagingPanel.add(this.nextButton);
        pagingPanel.add(this.slice);
        pagingPanel.add(this.pixel);
        quickieControls.add(pagingPanel);
        this.thicknessSlider = new JSlider();
        this.zoomSlider = new JSlider();
        quickieControls.add(this.thicknessSlider);
        quickieControls.add(this.zoomSlider);
        JPanel renderStylePane = new JPanel(new CenterFlowLayout());
        renderStylePane.add(this.renderStyleCombo);
        quickieControls.add(renderStylePane);
        quickie.add(quickieControls);
        viewPane.add(quickie);
        JPanel editorPanel = new JPanel(new BorderLayout());
        JPanel editorLabelPanel = new JPanel(new GridLayout(0, 1));
        editorLabelPanel.add(new JLabel("Eye"));
        editorLabelPanel.add(new JLabel("Look"));
        editorLabelPanel.add(new JLabel("Up"));
        editorLabelPanel.add(new JLabel("Camera"));
        editorLabelPanel.add(new JLabel("View Clip"));
        editorLabelPanel.add(new JLabel("View Height"));
        editorLabelPanel.add(new JLabel("Asp. Ratio"));
        JPanel fieldPanel = new JPanel(new GridLayout(0, 1));
        JPanel eyePanel = new JPanel(new GridLayout(1, 0));
        eyePanel.add(this.eyex);
        eyePanel.add(this.eyey);
        eyePanel.add(this.eyez);
        fieldPanel.add(eyePanel);
        JPanel lookPanel = new JPanel(new GridLayout(1, 0));
        lookPanel.add(this.lookx);
        lookPanel.add(this.looky);
        lookPanel.add(this.lookz);
        fieldPanel.add(lookPanel);
        JPanel upPanel = new JPanel(new GridLayout(1, 0));
        upPanel.add(this.upx);
        upPanel.add(this.upy);
        upPanel.add(this.upz);
        fieldPanel.add(upPanel);
        fieldPanel.add(new JLabel("(trio of eye, look and up)"));
        JPanel vcPanel = new JPanel(new GridLayout(1, 0));
        vcPanel.add(this.vcFront);
        vcPanel.add(this.vcBack);
        fieldPanel.add(vcPanel);
        fieldPanel.add(this.vh);
        fieldPanel.add(this.asp);
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1));
        buttonPanel.add(this.applyEyeButton);
        buttonPanel.add(this.applyLookButton);
        buttonPanel.add(this.applyUpButton);
        buttonPanel.add(this.applyCameraButton);
        buttonPanel.add(this.applyViewClipButton);
        buttonPanel.add(this.applyViewHeightButton);
        buttonPanel.add(this.applyAspectRatioButton);
        editorPanel.add((Component)editorLabelPanel, "Before");
        editorPanel.add(fieldPanel);
        editorPanel.add((Component)buttonPanel, "After");
        viewPane.add((Component)editorPanel, "Last");
        this.add(viewPane);
    }

    private void buildActions() {
        this.applyAspectRatioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.t3d == null) {
                    return;
                }
                T3DControlPanel.this.t3d.setAspectRatio(Double.parseDouble(T3DControlPanel.this.asp.getText()));
            }
        });
        this.applyCameraButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.t3d == null) {
                    return;
                }
                double[] eye = new double[]{Double.parseDouble(T3DControlPanel.this.eyex.getText()), Double.parseDouble(T3DControlPanel.this.eyey.getText()), Double.parseDouble(T3DControlPanel.this.eyez.getText())};
                double[] look = new double[]{Double.parseDouble(T3DControlPanel.this.lookx.getText()), Double.parseDouble(T3DControlPanel.this.looky.getText()), Double.parseDouble(T3DControlPanel.this.lookz.getText())};
                double[] up = new double[]{Double.parseDouble(T3DControlPanel.this.upx.getText()), Double.parseDouble(T3DControlPanel.this.upy.getText()), Double.parseDouble(T3DControlPanel.this.upz.getText())};
                double normi = 1.0 / Math.sqrt(up[0] * up[0] + up[1] * up[1] + up[2] * up[2]);
                up[0] = up[0] * normi;
                up[1] = up[1] * normi;
                up[2] = up[2] * normi;
                T3DControlPanel.this.t3d.setCamera(eye, look, up);
            }
        });
        this.applyEyeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.t3d == null) {
                    return;
                }
                double[] eye = new double[]{Double.parseDouble(T3DControlPanel.this.eyex.getText()), Double.parseDouble(T3DControlPanel.this.eyey.getText()), Double.parseDouble(T3DControlPanel.this.eyez.getText())};
                T3DControlPanel.this.t3d.setEyePoint(eye);
            }
        });
        this.applyLookButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.t3d == null) {
                    return;
                }
                double[] look = new double[]{Double.parseDouble(T3DControlPanel.this.lookx.getText()), Double.parseDouble(T3DControlPanel.this.looky.getText()), Double.parseDouble(T3DControlPanel.this.lookz.getText())};
                T3DControlPanel.this.t3d.setLookPoint(look);
            }
        });
        this.applyUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.t3d == null) {
                    return;
                }
                double[] up = new double[]{Double.parseDouble(T3DControlPanel.this.upx.getText()), Double.parseDouble(T3DControlPanel.this.upy.getText()), Double.parseDouble(T3DControlPanel.this.upz.getText())};
                double normi = 1.0 / Math.sqrt(up[0] * up[0] + up[1] * up[1] + up[2] * up[2]);
                up[0] = up[0] * normi;
                up[1] = up[1] * normi;
                up[2] = up[2] * normi;
                T3DControlPanel.this.t3d.setUp(up);
            }
        });
        this.applyViewHeightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.t3d == null) {
                    return;
                }
                System.out.println("VH = " + T3DControlPanel.this.vh.getText());
                T3DControlPanel.this.t3d.setViewHeight(Double.parseDouble(T3DControlPanel.this.vh.getText()));
            }
        });
        this.applyViewClipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.t3d == null) {
                    return;
                }
                T3DControlPanel.this.t3d.setViewClip(new double[]{Double.parseDouble(T3DControlPanel.this.vcFront.getText()), Double.parseDouble(T3DControlPanel.this.vcBack.getText())});
            }
        });
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.volume == null || T3DControlPanel.this.t3d == null) {
                    return;
                }
                double step = T3DControlPanel.this.pixel.isSelected() ? new JnVector3d(T3DControlPanel.this.volume.getXDirectionRAS(null)).magnitude() : new JnVector3d(T3DControlPanel.this.volume.getZDirectionRAS(null)).magnitude();
                step = -step;
                T3DControlPanel.this.page(step);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.volume == null || T3DControlPanel.this.t3d == null) {
                    return;
                }
                double step = T3DControlPanel.this.pixel.isSelected() ? new JnVector3d(T3DControlPanel.this.volume.getXDirectionRAS(null)).magnitude() : new JnVector3d(T3DControlPanel.this.volume.getZDirectionRAS(null)).magnitude();
                T3DControlPanel.this.page(step);
            }
        });
        this.renderStyleCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (T3DControlPanel.this.t3d instanceof T3DRenderStyleCapable) {
                    T3DRenderStyleCapable trsc = (T3DRenderStyleCapable)((Object)T3DControlPanel.this.t3d);
                    trsc.setRenderStyle(T3DControlPanel.this.renderStyleCombo.getSelectedItem().toString());
                }
            }
        });
    }

    private void page(double step) {
        JnVector3d eye = new JnVector3d(this.t3d.getEyePoint(null));
        JnVector3d look = new JnVector3d(this.t3d.getLookPoint(null));
        JnVector3d view = new JnVector3d(look.x, look.y, look.z);
        view.sub(eye);
        view.normalize();
        eye.scaleAdd(step, view);
        look.scaleAdd(step, view);
        this.t3d.setCamera(eye.generateArray(), look.generateArray(), this.t3d.getUp(null));
    }

    public static void main(String[] args) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("eyePoint".equals(evt.getPropertyName())) {
            double[] eye = this.t3d.getEyePoint(null);
            this.eyex.setText(format.format(eye[0]));
            this.eyey.setText(format.format(eye[1]));
            this.eyez.setText(format.format(eye[2]));
        } else if ("lookPoint".equals(evt.getPropertyName())) {
            double[] look = this.t3d.getLookPoint(null);
            this.lookx.setText(format.format(look[0]));
            this.looky.setText(format.format(look[1]));
            this.lookz.setText(format.format(look[2]));
        } else if ("up".equals(evt.getPropertyName())) {
            double[] up = this.t3d.getUp(null);
            this.upx.setText(format.format(up[0]));
            this.upy.setText(format.format(up[1]));
            this.upz.setText(format.format(up[2]));
        } else if ("aspectRatio".equals(evt.getPropertyName())) {
            this.asp.setText(format.format(this.t3d.getAspectRatio()));
        } else if ("viewHeight".equals(evt.getPropertyName())) {
            this.vh.setText(format.format(this.t3d.getViewHeight()));
        } else if ("viewClip".equals(evt.getPropertyName())) {
            double[] vc = this.t3d.getViewClip(null);
            this.vcFront.setText(format.format(vc[0]));
            this.vcBack.setText(format.format(vc[1]));
        } else if ("renderStyle".equals(evt.getPropertyName())) {
            this.renderStyleCombo.setSelectedItem(evt.getNewValue());
        }
    }
}

