/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.ParametricCurve3D;
import com.ge.med.jnu.geom.RayBox;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import java.util.Arrays;

public class CurvedReformat {
    private static final int SHIFT = 15;
    private static final int SCALE = 32768;
    private static final int FRAC_MASK = Short.MAX_VALUE;
    private ParametricCurve3D curve = null;
    private ParametricCurve3D curveCopy = null;
    private double tInc = 0.0;
    private double[] scanIncXvect = null;
    private J3DVolumeModel vol_model = null;
    private double[][] startRowPts = null;
    private double[][] endRowPts = null;
    private int outWidth = 0;
    private JnVector3d lookNormal = new JnVector3d();
    private double xInc = 0.0;
    private double[] centerVox = new double[3];
    private int nocontentPixel = 0;

    private static void mprstrip_tl(double[] lookpt, double[] xstep, int y, short[] vol, int vol_offset, short[] img, int w, int h, int dx, int dy, int dz, int nocontentPix) {
        double startX = lookpt[0] - (double)w * 0.5 * xstep[0];
        double startY = lookpt[1] - (double)w * 0.5 * xstep[1];
        double startZ = lookpt[2] - (double)w * 0.5 * xstep[2];
        int ixstep_x = (int)(xstep[0] * 32768.0);
        int ixstep_y = (int)(xstep[1] * 32768.0);
        int ixstep_z = (int)(xstep[2] * 32768.0);
        int xskip_x = ixstep_x;
        int xskip_y = ixstep_y;
        int xskip_z = ixstep_z;
        int psize = dx * dy;
        int ix = 0;
        int iy = 0;
        int iz = 0;
        int rix = (int)(startX * 32768.0);
        int riy = (int)(startY * 32768.0);
        int riz = (int)(startZ * 32768.0);
        int xy_scooch = 2;
        RayBox rb = new RayBox();
        JnVector3d minb = new JnVector3d(1.0, 1.0, 0.0);
        JnVector3d maxb = new JnVector3d(dx - 2, dy - 2, dz - 1);
        JnVector3d delta_x = new JnVector3d(xstep);
        JnVector3d rowPt = new JnVector3d(startX, startY, startZ);
        int[] tidx = new int[2];
        int yoffset = y * w;
        Arrays.fill(img, yoffset, yoffset + w - 1, (short)nocontentPix);
        try {
            boolean hit = rb.hitScanLine(minb, maxb, rowPt, delta_x, w, tidx);
            int xstart = Math.max(tidx[0], 0);
            int xend = Math.min(w, tidx[1]);
            int six = rix + ixstep_x * xstart;
            int siy = riy + ixstep_y * xstart;
            int siz = riz + ixstep_z * xstart;
            if (hit) {
                for (int j = xstart; j < xend; ++j) {
                    int frac0_x = six & Short.MAX_VALUE;
                    int frac0_y = siy & Short.MAX_VALUE;
                    int frac0_z = siz & Short.MAX_VALUE;
                    ix = six >> 15;
                    iy = siy >> 15;
                    iz = siz >> 15;
                    int poffset0 = vol_offset + iz * psize;
                    int roffset0 = iy * dx;
                    int vidx = poffset0 + roffset0 + ix;
                    int vidx_n = vidx + psize;
                    short voxel0 = vol[vidx];
                    short voxel1 = vol[vidx + 1];
                    short voxel2 = vol[vidx + dx];
                    short voxel3 = vol[vidx + dx + 1];
                    short voxel4 = vol[vidx_n];
                    short voxel5 = vol[vidx_n + 1];
                    short voxel6 = vol[vidx_n + dx];
                    short voxel7 = vol[vidx_n + dx + 1];
                    int voxel_z0_x1 = voxel0 + ((voxel1 - voxel0) * frac0_x >> 15);
                    int voxel_z0_x2 = voxel2 + ((voxel3 - voxel2) * frac0_x >> 15);
                    int voxel_z0 = voxel_z0_x1 + ((voxel_z0_x2 - voxel_z0_x1) * frac0_y >> 15);
                    int voxel_z1_x1 = voxel4 + ((voxel5 - voxel4) * frac0_x >> 15);
                    int voxel_z1_x2 = voxel6 + ((voxel7 - voxel6) * frac0_x >> 15);
                    int voxel_z1 = voxel_z1_x1 + ((voxel_z1_x2 - voxel_z1_x1) * frac0_y >> 15);
                    int voxel = voxel_z0 + ((voxel_z1 - voxel_z0) * frac0_z >> 15);
                    img[yoffset + j] = (short)voxel;
                    six += xskip_x;
                    siy += xskip_y;
                    siz += xskip_z;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            System.err.println("static_mprstrip[trilinear]: Bad array idx: [" + ix + "," + iy + "," + iz + "]");
        }
    }

    public void initCurveReformat(J3DVolumeModel vol, double[] lookpt, double[] eyept, int buffWidth, int buffHeight, int nocontentPix) {
        if (this.curve == null || this.curve.length() <= 0.0) {
            this.curveCopy = null;
            return;
        }
        this.outWidth = buffWidth;
        this.curveCopy = (ParametricCurve3D)this.curve.clone();
        this.nocontentPixel = nocontentPix;
        this.vol_model = vol;
        double fov = (double)buffWidth * (1.0 / (double)buffHeight) * this.curve.length();
        double[] lp = lookpt;
        double[] ep = eyept;
        this.lookNormal.set(lp);
        this.lookNormal.sub(ep);
        this.lookNormal.normalize();
        this.tInc = 1.0 / (double)buffHeight;
        this.xInc = fov / (double)buffWidth;
        if (this.startRowPts == null || this.startRowPts.length != buffHeight) {
            this.startRowPts = new double[buffHeight][3];
            this.endRowPts = new double[buffHeight][3];
        }
        double[] scanInc = this.lookNormal.generateArray();
        scanInc[0] = scanInc[0] * this.xInc;
        scanInc[1] = scanInc[1] * this.xInc;
        scanInc[2] = scanInc[2] * this.xInc;
        double[] scanXpointVox = new double[3];
        double[] centerRAS = new double[3];
        vol.rasToVoxels(centerRAS, this.centerVox);
        vol.rasToVoxels(scanInc, scanXpointVox);
        JnVector3d scanXvoxVect = new JnVector3d(scanXpointVox);
        scanXvoxVect.sub(this.centerVox);
        this.scanIncXvect = scanXvoxVect.generateArray();
    }

    public void lumenReformat(int y0, int stepy, int width, int height, short[] vol, int PAD, short[] lumbuffer, int dx, int dy, int dz) {
        if (this.curveCopy == null || this.curveCopy.length() <= 0.0) {
            return;
        }
        double[] pointRAS = new double[3];
        double[] pointVOX = new double[3];
        double[] velocity = new double[3];
        double[] projectionRAS = new double[3];
        double[] projectionVOX = new double[3];
        double[] scanIncVOX = new double[3];
        JnVector3d velocityVect = new JnVector3d();
        JnVector3d NcrossL = new JnVector3d();
        JnVector3d projectionVect = new JnVector3d();
        JnVector3d scanVect = new JnVector3d();
        for (int y = y0; y < height; y += stepy) {
            double t = (double)y * this.tInc;
            this.curveCopy.positionAt(t, pointRAS);
            this.vol_model.rasToVoxels(pointRAS, pointVOX);
            this.curveCopy.velocityAt(t, velocity);
            velocityVect = new JnVector3d(velocity);
            NcrossL = JnVector3d.cross(velocityVect, this.lookNormal);
            projectionVect = JnVector3d.cross(NcrossL, velocityVect);
            projectionVect.normalize();
            projectionRAS = projectionVect.generateArray();
            projectionRAS[0] = projectionRAS[0] * this.xInc;
            projectionRAS[1] = projectionRAS[1] * this.xInc;
            projectionRAS[2] = projectionRAS[2] * this.xInc;
            this.vol_model.rasToVoxels(projectionRAS, projectionVOX);
            scanVect = new JnVector3d(projectionVOX);
            scanVect.sub(this.centerVox);
            scanIncVOX = scanVect.generateArray();
            this.calcStartEndPoints(y, pointVOX, scanIncVOX, width);
            CurvedReformat.mprstrip_tl(pointVOX, scanIncVOX, y, vol, PAD, lumbuffer, width, height, dx, dy, dz, this.nocontentPixel);
        }
    }

    public void curveReformat(int y0, int stepy, int width, int height, short[] vol, int PAD, short[] lumbuffer, int dx, int dy, int dz) {
        if (this.curveCopy == null || this.curveCopy.length() <= 0.0) {
            return;
        }
        double[] pointRAS = new double[3];
        double[] pointVOX = new double[3];
        for (int y = y0; y < height; y += stepy) {
            double t = (double)y * this.tInc;
            this.curveCopy.positionAt(t, pointRAS);
            this.vol_model.rasToVoxels(pointRAS, pointVOX);
            this.calcStartEndPoints(y, pointVOX, this.scanIncXvect, width);
            CurvedReformat.mprstrip_tl(pointVOX, this.scanIncXvect, y, vol, PAD, lumbuffer, width, height, dx, dy, dz, this.nocontentPixel);
        }
    }

    private void calcStartEndPoints(int rowNum, double[] lookpt, double[] xstep, int w) {
        this.startRowPts[rowNum][0] = lookpt[0] - (double)w * 0.5 * xstep[0];
        this.startRowPts[rowNum][1] = lookpt[1] - (double)w * 0.5 * xstep[1];
        this.startRowPts[rowNum][2] = lookpt[2] - (double)w * 0.5 * xstep[2];
        this.endRowPts[rowNum][0] = lookpt[0] + (double)w * 0.5 * xstep[0];
        this.endRowPts[rowNum][1] = lookpt[1] + (double)w * 0.5 * xstep[1];
        this.endRowPts[rowNum][2] = lookpt[2] + (double)w * 0.5 * xstep[2];
    }

    public boolean getRowEndPoints(int rowNum, double[] p0, double[] p1) {
        if (this.startRowPts != null && rowNum >= 0 && rowNum < this.startRowPts.length) {
            p0[0] = this.startRowPts[rowNum][0];
            p0[1] = this.startRowPts[rowNum][1];
            p0[2] = this.startRowPts[rowNum][2];
            p1[0] = this.endRowPts[rowNum][0];
            p1[1] = this.endRowPts[rowNum][1];
            p1[2] = this.endRowPts[rowNum][2];
            return true;
        }
        return false;
    }

    public double[] getVolumeCoords(int x, int y, double[] vCoords) {
        if (vCoords == null) {
            vCoords = new double[3];
        }
        if (this.startRowPts != null && y >= 0 && y < this.startRowPts.length) {
            double[] xstep = new double[3];
            int w = this.outWidth - 1;
            xstep[0] = (this.endRowPts[y][0] - this.startRowPts[y][0]) / (double)w;
            xstep[1] = (this.endRowPts[y][1] - this.startRowPts[y][1]) / (double)w;
            xstep[2] = (this.endRowPts[y][2] - this.startRowPts[y][2]) / (double)w;
            JnVector3d.scaleAdd(this.startRowPts[y], xstep, x, vCoords);
        }
        return vCoords;
    }

    public void setCurve(ParametricCurve3D curve) {
        this.curve = curve;
    }

    public ParametricCurve3D getCurve() {
        return this.curve;
    }
}

