/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.idc.T3DRenderEngine;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeModel;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.CPoint;
import com.ge.med.terra.jami.CTransform;
import com.ge.med.terra.jami.DemoUtils;
import com.ge.med.terra.jami.XpMultiImageViewport;
import com.ge.med.terra.jami.XpUserAnnotationModel;
import com.ge.med.terra.jami.capable.SegmentationCapable;
import com.ge.med.terra.jami.capable.VrCapable;
import com.ge.med.terra.jami.j3d.CubeTrackball;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DComponent;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.mpr.MprApp_clearButton_actionAdapter;
import com.ge.med.terra.jami.j3d.mpr.MprApp_loadButton_actionAdapter;
import com.ge.med.terra.jami.j3d.mpr.MprApp_rectButton_actionAdapter;
import com.ge.med.terra.jami.j3d.mpr.MprApp_renderComboBox_actionAdapter;
import com.ge.med.terra.jami.j3d.mpr.MprApp_segButton_actionAdapter;
import com.ge.med.terra.jami.j3d.mpr.MprApp_thicknessSlider_changeAdapter;
import com.ge.med.terra.jami.j3d.mpr.MprApp_uannoButton_actionAdapter;
import com.ge.med.terra.jami.roi.XpRectangularRoi;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;

public class MprApp
extends JPanel {
    private static final int DIM = 600;
    private static final int SLIDER_RESOLUTION = 200;
    private T3DViewport vp = new T3DViewport(MprApp.createT3DRenderEngine());
    private XjVolume xjvol = null;
    private CubeTrackball cube = new CubeTrackball();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel uiPanel = new JPanel();
    JButton segButton = new JButton();
    JButton rectButton = new JButton();
    JButton uannoButton = new JButton();
    JButton resetsegButton = new JButton("Reset Segmentation");
    JButton t3dButton = new JButton("T3D ViewInfo");
    JToggleButton valueButton = new JToggleButton("Inspect values");
    JPanel stuffPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JSlider thicknessSlider = new JSlider(0, 0, 200, 0);
    JPanel sliderPanel = new JPanel();
    JLabel sliderLabel = new JLabel();
    BorderLayout borderLayout3 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();
    private boolean inspectValues = false;
    private boolean segvisible = false;
    private boolean init = true;
    JButton clearButton = new JButton();
    JButton loadButton = new JButton();
    JPanel renderPanel = new JPanel();
    JComboBox renderComboBox = new JComboBox();
    JLabel renderLabel = new JLabel();

    private static T3DRenderEngine createT3DRenderEngine() {
        String clname = System.getProperty("j3d.t3dcomponent", "com.ge.med.terra.jami.j3d.J3DRenderEngine");
        T3DRenderEngine t3dcomp = null;
        try {
            Class<?> cl = Class.forName(clname);
            Constructor<?> cons = cl.getConstructor(null);
            t3dcomp = (T3DRenderEngine)cons.newInstance(null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return t3dcomp;
    }

    public MprApp() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MprApp(String[] params) {
        this();
        this.vp.setPreferredSize(new Dimension(600, 600));
        this.add((Component)this.vp, "Center");
        String[] rstyles = this.vp.getSupportedRenderStyles();
        this.renderComboBox.setModel(new DefaultComboBoxModel<String>(rstyles));
        int reformat_idx = 0;
        for (int i = 0; i < rstyles.length; ++i) {
            if (!rstyles[i].equals("REFORMAT")) continue;
            reformat_idx = i;
            break;
        }
        this.renderComboBox.setSelectedIndex(reformat_idx);
        this.t3dButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                T3DComponent jc = MprApp.this.vp.getT3DComponent();
                System.err.println("Size: " + jc.getSize());
                JnVector3d.vprint("Eye  ", jc.getEyePoint(null));
                JnVector3d.vprint("Look ", jc.getLookPoint(null));
                JnVector3d.vprint("Up   ", jc.getUp(null));
                System.err.println("--------------------------------------------");
            }
        });
        this.valueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MprApp.this.inspectValues = !MprApp.this.inspectValues;
            }
        });
        this.load(params);
        J3DVolumeModel vm = (J3DVolumeModel)this.vp.getVolumeModel();
        vm.init();
        this.render2D(this.vp.getVolumeModel(), this);
        this.vp.setRenderStyle("REFORMAT");
        this.vp.getT3DComponent().addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MprApp.this.inspectValues) {
                    T3DComponent tc = (T3DComponent)e.getSource();
                    int x = e.getX();
                    int y = e.getY();
                    CTransform ct = tc.getTransform((byte)1, (byte)5);
                    CPoint p = new CPoint(x, y, 0, 1);
                    CPoint v = new CPoint(5);
                    ct.transform(p, v);
                    System.err.println(">>>> VOXEL COORDS: " + v);
                }
            }
        });
    }

    private void render2D(XjVolumeModel vm, JPanel p) {
        XpMultiImageViewport vp = new XpMultiImageViewport();
        vp.setRowCol(2, 2);
        vp.setPreferredSize(new Dimension(600, 600));
        if (vm instanceof J3DVolumeModel) {
            vp.setVolumeModel(vm);
        }
        p.add((Component)vp, "East");
    }

    private void load(String[] params) {
        if (params != null) {
            DMSession dms = new DMSession(params);
            DMObject[] dmo = dms.getRelated("series");
            System.out.println("# Series: " + dmo.length);
            int series = 0;
            if (dmo.length >= 3) {
                series = 2;
            }
            this.xjvol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[series]});
            this.vp.setVolume(this.xjvol);
            this.cube.setVisible(true);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("MPR App");
        String[] params = null;
        params = args.length > 0 ? new String[]{"file", args[0]} : new String[]{"file", DemoUtils.demoChooseDirectory("MPRApp")};
        MprApp sid = new MprApp(params);
        frame.setLocation(100, 100);
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(sid);
        frame.pack();
        frame.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.segButton.setText("View Segmentation");
        this.segButton.addActionListener(new MprApp_segButton_actionAdapter(this));
        this.rectButton.setText("Rectangle");
        this.rectButton.addActionListener(new MprApp_rectButton_actionAdapter(this));
        this.uannoButton.setText("User Annot");
        this.uannoButton.addActionListener(new MprApp_uannoButton_actionAdapter(this));
        this.stuffPanel.setLayout(this.borderLayout2);
        this.thicknessSlider.setPaintLabels(true);
        this.thicknessSlider.setPaintTrack(true);
        this.thicknessSlider.setMajorTickSpacing(40);
        this.thicknessSlider.setToolTipText("Slab Thickness");
        this.thicknessSlider.addChangeListener(new MprApp_thicknessSlider_changeAdapter(this));
        this.sliderLabel.setText("Slab Thickness:");
        this.uiPanel.setLayout(this.borderLayout3);
        this.stuffPanel.setBorder(BorderFactory.createEtchedBorder());
        this.uiPanel.setPreferredSize(new Dimension(409, 110));
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(0);
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonPanel.setPreferredSize(new Dimension(513, 61));
        this.sliderPanel.setBorder(BorderFactory.createEtchedBorder());
        this.sliderPanel.setPreferredSize(new Dimension(315, 40));
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new MprApp_clearButton_actionAdapter(this));
        this.loadButton.setText("Load");
        this.loadButton.addActionListener(new MprApp_loadButton_actionAdapter(this));
        this.renderLabel.setText("Render Style:");
        this.renderComboBox.addActionListener(new MprApp_renderComboBox_actionAdapter(this));
        this.renderPanel.setPreferredSize(new Dimension(200, 37));
        this.sliderPanel.add((Component)this.sliderLabel, null);
        this.stuffPanel.add((Component)this.buttonPanel, "Center");
        this.buttonPanel.add(this.loadButton);
        this.buttonPanel.add(this.clearButton);
        this.buttonPanel.add((Component)this.uannoButton, null);
        this.buttonPanel.add((Component)this.t3dButton, null);
        this.buttonPanel.add((Component)this.segButton, null);
        this.buttonPanel.add((Component)this.rectButton, null);
        this.buttonPanel.add((Component)this.valueButton, null);
        this.uiPanel.add((Component)this.stuffPanel, "Center");
        this.add((Component)this.uiPanel, "South");
        this.stuffPanel.add((Component)this.sliderPanel, "South");
        this.sliderPanel.add((Component)this.thicknessSlider, null);
        this.stuffPanel.add((Component)this.renderPanel, "West");
        this.renderPanel.add(this.renderLabel);
        this.renderPanel.add(this.renderComboBox);
        this.buttonPanel.add((Component)this.resetsegButton, null);
        this.resetsegButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VrCapable vrc = (VrCapable)MprApp.this.vp.getCapable("com.ge.med.terra.jami.capable.VrCapable");
                if (vrc != null) {
                    vrc.clearSegmentation();
                    vrc.repaint();
                }
            }
        });
    }

    void rectButton_actionPerformed(ActionEvent e) {
        double hw = (double)this.vp.getFrame().getSlice().width * 0.5;
        double hh = (double)this.vp.getFrame().getSlice().height * 0.5;
        XpRectangularRoi.Rectangle sr = new XpRectangularRoi.Rectangle(new Rectangle2D.Double(hw, hh, 100.0, 100.0));
        this.vp.add(sr);
    }

    void uannoButton_actionPerformed(ActionEvent e) {
        int[] dims = this.vp.getVolume().getVolumeDimensions(null);
        CPoint textAnchor = new CPoint(200, 100, 0, 1);
        CPoint target = new CPoint(dims[0] >> 1, dims[1] >> 1, dims[2] >> 1, 5);
        XpUserAnnotationModel uam = new XpUserAnnotationModel("Demo Text", textAnchor, target);
        this.vp.add(uam);
    }

    void segButton_actionPerformed(ActionEvent e) {
        SegmentationCapable vrc = (SegmentationCapable)((Object)this.vp.getCapable("com.ge.med.terra.jami.capable.SegmentationCapable"));
        if (vrc != null) {
            if (this.init) {
                XjVolume vol = this.xjvol;
                int[] dims = vol.getVolumeDimensions(null);
                int blen = dims[0] * dims[1] * dims[2] >> 3;
                byte[] seg = new byte[blen];
                Arrays.fill(seg, (byte)-1);
                int lim = dims[0] >> 2;
                for (int z = 0; z < dims[2]; ++z) {
                    for (int y = 0; y < dims[1]; ++y) {
                        for (int x = 0; x < dims[0]; ++x) {
                            if (x <= lim || y <= lim || x >= dims[0] - lim || y >= dims[1] - lim) continue;
                            int idx = z * dims[1] * dims[0] + y * dims[0] + x;
                            int mod = idx % 8;
                            byte bval = seg[idx >>= 3];
                            seg[idx] = (byte)(bval & ~(1 << mod));
                        }
                    }
                }
                vrc.applySegmentation(seg);
                this.init = false;
            }
            this.segvisible = !this.segvisible;
            vrc.setSegmentationVisible(this.segvisible);
            if (this.segvisible) {
                this.segButton.setText("Remove Segmentation");
            } else {
                this.segButton.setText("View Segmentation");
            }
        }
    }

    void thicknessSlider_stateChanged(ChangeEvent e) {
        int thick = this.thicknessSlider.getValue();
        double hthick = (double)thick * 0.5;
        this.vp.setViewClip(new double[]{-hthick, hthick});
        this.vp.repaint();
    }

    public void clearButton_actionPerformed(ActionEvent e) {
        this.vp.setVolume(null);
        this.cube.setVisible(false);
        this.vp.repaint();
    }

    public void loadButton_actionPerformed(ActionEvent e) {
        File f = new File("/thesource/images/Direct3d");
        String fpath = f.getAbsolutePath();
        if (!f.exists()) {
            fpath = "./";
        }
        JFileChooser chooser = new JFileChooser(fpath);
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            String dirname = "" + chooser.getSelectedFile();
            System.out.println("You chose to open this dir: " + dirname);
            String[] params = new String[]{"file", dirname};
            this.load(params);
            this.vp.repaint();
        }
    }

    public void renderComboBox_actionPerformed(ActionEvent e) {
        String rstyle = "" + this.renderComboBox.getSelectedItem();
        this.vp.setRenderStyle(rstyle);
        this.vp.repaint();
    }
}

