/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mpr;

import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnMatrix4d;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.Worker;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMVolume;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import javax.swing.JFrame;

public class fastmip {
    private static final int SHIFT = 16;
    private static final int SCALE = 65536;
    private static final int FRAC_MASK = 65535;
    private static final int INTNBITS = 9;
    private static final int DIV_SCALEF = 18;
    private static final double EPSILON = 1.0E-5;
    private JnVector3d zero_vec = new JnVector3d();
    private JnVector3d deltaX = new JnVector3d();
    private JnVector3d deltaY = new JnVector3d();
    private JnVector3d deltaZ = new JnVector3d();
    private JnMatrix4d R = new JnMatrix4d();
    private JnMatrix4d P = new JnMatrix4d();
    private double[] proj_planeULHC = new double[3];
    private JVolume.LinearShort jls = null;
    private int PGSIZE = 0;
    private int dx = 0;
    private int dy = 0;
    private int dz = 0;
    private JnMatrix4d vol2ras = new JnMatrix4d();
    private static final double[] cornerpts = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 1.0};

    public void setGeometry(XjVolumeInfo xjvol, JVolume.LinearShort jls) {
        this.jls = jls;
        double[] xdir = new double[3];
        double[] ydir = new double[3];
        double[] zdir = new double[3];
        double[] ulhc = new double[3];
        double[] spacing = new double[3];
        int[] vol_dims = new int[3];
        double[] vol_center = new double[3];
        this.dx = jls.dx;
        this.dy = jls.dy;
        this.dz = jls.dz;
        this.PGSIZE = jls.dx * jls.dy;
        xjvol.getXDirectionRAS(xdir);
        xjvol.getYDirectionRAS(ydir);
        xjvol.getZDirectionRAS(zdir);
        xjvol.getRASOfOrigin(ulhc);
        xjvol.getVolumeDimensions(vol_dims);
        this.vol2ras.setColumns(xdir, ydir, zdir, ulhc);
        vol_center[0] = ulhc[0] + xdir[0] * (double)vol_dims[0] * 0.5 + ydir[0] * (double)vol_dims[1] * 0.5 + zdir[0] * (double)vol_dims[2] * 0.5;
        vol_center[1] = ulhc[1] + xdir[1] * (double)vol_dims[0] * 0.5 + ydir[1] * (double)vol_dims[1] * 0.5 + zdir[1] * (double)vol_dims[2] * 0.5;
        vol_center[2] = ulhc[2] + xdir[2] * (double)vol_dims[0] * 0.5 + ydir[2] * (double)vol_dims[1] * 0.5 + zdir[2] * (double)vol_dims[2] * 0.5;
        spacing[0] = JnVector3d.length(xdir);
        spacing[1] = JnVector3d.length(ydir);
        spacing[2] = JnVector3d.length(zdir);
    }

    public void setView(double[] lookpt, double[] xdir, double[] ydir, double[] zdir, int w, int h) {
        double hw = (double)w * 0.5;
        double hh = (double)h * 0.5;
        this.proj_planeULHC[0] = lookpt[0] - xdir[0] * hw - ydir[0] * hh;
        this.proj_planeULHC[1] = lookpt[1] - xdir[1] * hw - ydir[1] * hh;
        this.proj_planeULHC[2] = lookpt[2] - xdir[2] * hw - ydir[2] * hh;
        this.R.setColumns(xdir, ydir, zdir, this.proj_planeULHC);
        this.P.invert(this.R);
        this.zero_vec.set(0.0, 0.0, 0.0);
        this.P.transform(this.zero_vec);
        this.deltaX.set(1.0, 0.0, 0.0);
        this.P.transform(this.deltaX);
        this.deltaX.sub(this.zero_vec);
        this.deltaY.set(0.0, 1.0, 0.0);
        this.P.transform(this.deltaY);
        this.deltaY.sub(this.zero_vec);
        this.deltaZ.set(0.0, 0.0, 1.0);
        this.P.transform(this.deltaZ);
        this.deltaZ.sub(this.zero_vec);
    }

    public void render(int x0, int x1, int y0, int y1, int xskip, int yskip, short[] outimg, int w, int h, fastmip_data fd) {
        this.mipproject(x0, x1, y0, y1, xskip, yskip, outimg, w, h, fd);
    }

    private void set(double[] v, double x, double y, double z) {
        v[0] = x;
        v[1] = y;
        v[2] = z;
    }

    private static void invert(AffineTransform at, double[] mem) {
        at.getMatrix(mem);
        double M00 = mem[0];
        double M01 = mem[2];
        double M02 = mem[4];
        double M10 = mem[1];
        double M11 = mem[3];
        double M12 = mem[5];
        double det = M00 * M11 - M01 * M10;
        if (Math.abs(det) <= Double.MIN_VALUE) {
            throw new RuntimeException("Determinant is " + det);
        }
        double m00 = M11 / det;
        double m10 = -M10 / det;
        double m01 = -M01 / det;
        double m11 = M00 / det;
        double m02 = (M01 * M12 - M11 * M02) / det;
        double m12 = (M10 * M02 - M00 * M12) / det;
        at.setTransform(m00, m10, m01, m11, m02, m12);
    }

    private static void minmax(double[] ul, double[] dirx, double[] diry, int DX, int DY, int w, int h, double[] minmaxX, double[] minmaxY) {
        double minx = ul[0];
        double maxx = ul[0];
        double miny = ul[1];
        double maxy = ul[1];
        double mx = ul[0] + (double)DX * dirx[0];
        double my = ul[1] + (double)DX * dirx[1];
        minx = mx < minx ? mx : minx;
        maxx = mx > maxx ? mx : maxx;
        miny = my < miny ? my : miny;
        maxy = my > maxy ? my : maxy;
        mx = ul[0] + (double)DX * dirx[0] + (double)DY * diry[0];
        my = ul[1] + (double)DX * dirx[1] + (double)DY * diry[1];
        minx = mx < minx ? mx : minx;
        maxx = mx > maxx ? mx : maxx;
        miny = my < miny ? my : miny;
        maxy = my > maxy ? my : maxy;
        mx = ul[0] + (double)DY * diry[0];
        my = ul[1] + (double)DY * diry[1];
        minx = mx < minx ? mx : minx;
        maxx = mx > maxx ? mx : maxx;
        miny = my < miny ? my : miny;
        double d = maxy = my > maxy ? my : maxy;
        double d2 = minx < 0.0 ? 0.0 : (minx = minx > (double)(w - 1) ? (double)(w - 1) : minx);
        double d3 = maxx < 0.0 ? 0.0 : (maxx = maxx > (double)(w - 1) ? (double)(w - 1) : maxx);
        double d4 = miny < 0.0 ? 0.0 : (miny = miny > (double)(h - 1) ? (double)(h - 1) : miny);
        maxy = maxy < 0.0 ? 0.0 : (maxy > (double)(h - 1) ? (double)(h - 1) : maxy);
        minmaxX[0] = minx;
        minmaxX[1] = maxx;
        minmaxY[0] = miny;
        minmaxY[1] = maxy;
    }

    public void mipproject(int x0, int x1, int y0, int y1, int xskip, int yskip, short[] outimg, int w, int h, fastmip_data fd) {
        AffineTransform tx = fd.tx;
        double[] pts = fd.pts;
        double[] ul = fd.ul;
        double[] ur = fd.ur;
        double[] bl = fd.bl;
        double[] ul_next = fd.ul_next;
        double[] dirx = fd.dirx;
        double[] diry = fd.diry;
        double[] dirz = fd.dirz;
        double[] minmaxX = fd.minmaxX;
        double[] minmaxY = fd.minmaxY;
        short[] voldata = this.jls.volume;
        int sliceOffset = this.jls.PAD;
        int TRIM = 2;
        int DX = this.dx - 4;
        int DY = this.dy - 4;
        int DZ = this.dz - 2;
        this.set(ul, 0.0, 0.0, 0.0);
        this.set(ur, 1.0, 0.0, 0.0);
        this.set(bl, 0.0, 1.0, 0.0);
        this.set(ul_next, 0.0, 0.0, 1.0);
        this.P.transform(ul);
        this.P.transform(ur);
        this.P.transform(bl);
        this.P.transform(ul_next);
        dirx[0] = ur[0] - ul[0];
        dirx[1] = ur[1] - ul[1];
        diry[0] = bl[0] - ul[0];
        diry[1] = bl[1] - ul[1];
        dirz[0] = ul_next[0] - ul[0];
        dirz[1] = ul_next[1] - ul[1];
        fastmip.minmax(ul, dirx, diry, DX, DY, w, h, minmaxX, minmaxY);
        double lendirx = minmaxX[1] - minmaxX[0];
        double lendiry = minmaxY[1] - minmaxY[0];
        if (lendirx > 2.0 && lendiry > 2.0) {
            int z = 0;
            while (z < this.dz) {
                this.set(ul, 2.0, 2.0, z);
                this.P.transform(ul);
                fastmip.minmax(ul, dirx, diry, DX, DY, w, h, minmaxX, minmaxY);
                double miny = minmaxY[0];
                double maxy = minmaxY[1];
                int iminy = (int)Math.max(miny, (double)y0);
                int imaxy = (int)Math.min(maxy, (double)y1);
                tx.setTransform(dirx[0], dirx[1], diry[0], diry[1], ul[0], ul[1]);
                fastmip.invert(tx, fd.mem);
                tx.transform(cornerpts, 0, pts, 0, 3);
                double oX = pts[0];
                double oY = pts[1];
                double dX_x = pts[2] - oX;
                double dX_y = pts[3] - oY;
                double dY_x = pts[4] - oX;
                double dY_y = pts[5] - oY;
                double row_x = oX + (double)iminy * dY_x;
                double row_y = oY + (double)iminy * dY_y;
                int irow_x = (int)(row_x * 65536.0);
                int irow_y = (int)(row_y * 65536.0);
                int idX_x = (int)(dX_x * 65536.0);
                int idX_y = (int)(dX_y * 65536.0);
                int idY_x = (int)(dY_x * 65536.0);
                int idY_y = (int)(dY_y * 65536.0);
                for (int y = iminy; y <= imaxy; y += yskip) {
                    double temp;
                    double t0;
                    double t1;
                    int rowoffset = y * w;
                    double xx0 = x0;
                    double xx1 = x1;
                    if (Math.abs(dX_x) > 1.0E-5) {
                        t1 = ((double)(this.dx - 2) - row_x) / dX_x;
                        t0 = (1.0 - row_x) / dX_x;
                        if (t1 < t0) {
                            temp = t1;
                            t1 = t0;
                            t0 = temp;
                        }
                        xx0 = Math.max(t0, xx0);
                        xx1 = Math.min(t1, xx1);
                    }
                    if (Math.abs(dX_y) > 1.0E-5) {
                        t1 = ((double)(this.dy - 2) - row_y) / dX_y;
                        t0 = (1.0 - row_y) / dX_y;
                        if (t1 < t0) {
                            temp = t1;
                            t1 = t0;
                            t0 = temp;
                        }
                        xx0 = Math.max(t0, xx0);
                        xx1 = Math.min(t1, xx1);
                    }
                    int ix0 = (int)(xx0 + 1.0);
                    int ix1 = (int)(xx1 - 1.0);
                    int pt_x = irow_x + ix0 * idX_x;
                    int pt_y = irow_y + ix0 * idX_y;
                    for (int x = ix0; x <= ix1; x += xskip) {
                        int xx = pt_x >> 16;
                        int yy = pt_y >> 16;
                        int fx = (pt_x & 0xFFFF) >> 7;
                        int fy = (pt_y & 0xFFFF) >> 7;
                        int vidx0 = sliceOffset + yy * this.dx + xx;
                        int vidx1 = vidx0 + this.dx;
                        try {
                            short v00 = voldata[vidx0];
                            short v01 = voldata[vidx0 + 1];
                            short v10 = voldata[vidx1];
                            short v11 = voldata[vidx1 + 1];
                            int v1 = (v00 << 9) + fx * (v01 - v00);
                            int v2 = (v10 << 9) + fx * (v11 - v10);
                            short v = (short)((v1 << 9) + fy * (v2 - v1) >> 18);
                            if (v > outimg[rowoffset + x]) {
                                outimg[rowoffset + x] = v;
                            }
                        }
                        catch (Exception e) {
                            System.err.println(">>> array idx: xx=" + xx + "  yy=" + yy);
                        }
                        pt_x += xskip * idX_x;
                        pt_y += xskip * idX_y;
                    }
                    irow_x += yskip * idY_x;
                    irow_y += yskip * idY_y;
                    row_x += (double)yskip * dY_x;
                    row_y += (double)yskip * dY_y;
                }
                ++z;
                sliceOffset += this.PGSIZE;
            }
        } else {
            System.err.println("---- SLICE ALIGNED VIEW: lendirx=" + lendirx + "  lendiry=" + lendiry);
            int y = 0;
            while (y < this.dy) {
                this.set(ul, 2.0, y, 2.0);
                this.P.transform(ul);
                fastmip.minmax(ul, dirx, dirz, DX, DZ, w, h, minmaxX, minmaxY);
                double miny = minmaxY[0];
                double maxy = minmaxY[1];
                int iminy = (int)Math.max(miny, (double)y0);
                int imaxy = (int)Math.min(maxy, (double)y1);
                tx.setTransform(dirx[0], dirx[1], dirz[0], dirz[1], ul[0], ul[1]);
                fastmip.invert(tx, fd.mem);
                tx.transform(cornerpts, 0, pts, 0, 3);
                double oX = pts[0];
                double oY = pts[1];
                double dX_x = pts[2] - oX;
                double dX_y = pts[3] - oY;
                double dY_x = pts[4] - oX;
                double dY_y = pts[5] - oY;
                double row_x = oX + (double)iminy * dY_x;
                double row_y = oY + (double)iminy * dY_y;
                int irow_x = (int)(row_x * 65536.0);
                int irow_y = (int)(row_y * 65536.0);
                int idX_x = (int)(dX_x * 65536.0);
                int idX_y = (int)(dX_y * 65536.0);
                int idY_x = (int)(dY_x * 65536.0);
                int idY_y = (int)(dY_y * 65536.0);
                for (int display_y = iminy; display_y <= imaxy; display_y += yskip) {
                    int rowoffset = display_y * w;
                    double xx0 = x0;
                    double xx1 = x1;
                    if (Math.abs(dX_x) > 1.0E-5) {
                        double t1 = ((double)(this.dx - 2) - row_x) / dX_x;
                        double t0 = (1.0 - row_x) / dX_x;
                        if (t1 < t0) {
                            double temp = t1;
                            t1 = t0;
                            t0 = temp;
                        }
                        xx0 = Math.max(t0, xx0);
                        xx1 = Math.min(t1, xx1);
                    }
                    if (Math.abs(dX_y) > 1.0E-5) {
                        double t1 = ((double)(this.dz - 2) - row_y) / dX_y;
                        double t0 = (1.0 - row_y) / dX_y;
                        if (t1 < t0) {
                            double temp = t1;
                            t1 = t0;
                            t0 = temp;
                        }
                        xx0 = Math.max(t0, xx0);
                        xx1 = Math.min(t1, xx1);
                    }
                    int ix0 = (int)(xx0 + 1.0);
                    int ix1 = (int)(xx1 - 1.0);
                    int pt_x = irow_x + ix0 * idX_x;
                    int pt_z = irow_y + ix0 * idX_y;
                    for (int x = ix0; x <= ix1; x += xskip) {
                        int xx = pt_x >> 16;
                        int zz = pt_z >> 16;
                        int fx = (pt_x & 0xFFFF) >> 7;
                        int fz = (pt_z & 0xFFFF) >> 7;
                        int vidx0 = this.jls.PAD + zz * this.PGSIZE + y * this.dx + xx;
                        int vidx1 = vidx0 + this.PGSIZE;
                        try {
                            short v00 = voldata[vidx0];
                            short v01 = voldata[vidx0 + 1];
                            short v10 = voldata[vidx1];
                            short v11 = voldata[vidx1 + 1];
                            int v1 = (v00 << 9) + fx * (v01 - v00);
                            int v2 = (v10 << 9) + fx * (v11 - v10);
                            short v = (short)((v1 << 9) + fz * (v2 - v1) >> 18);
                            if (v > outimg[rowoffset + x]) {
                                outimg[rowoffset + x] = v;
                            }
                        }
                        catch (Exception e) {
                            System.err.println(">>> array idx: xx=" + xx + "  zz=" + zz);
                        }
                        pt_x += xskip * idX_x;
                        pt_z += xskip * idX_y;
                    }
                    irow_x += yskip * idY_x;
                    irow_y += yskip * idY_y;
                    row_x += (double)yskip * dY_x;
                    row_y += (double)yskip * dY_y;
                }
                ++y;
                sliceOffset += this.PGSIZE;
            }
        }
    }

    public static void main(String[] args) {
        int DIM = 1024;
        ParallelTaskManager ptm = new ParallelTaskManager();
        Worker[] workers = new Worker[ParallelTaskManager.NCPUS];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new FastMipWorker(ptm, i);
        }
        ptm.setWorkers(workers);
        DMSession dms = new DMSession(new String[]{"file", args[0]});
        DMObject[] dmo = dms.getRelated("series");
        System.out.println("# Series: " + dmo.length);
        DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo[0]});
        JVolume.LinearShort jv = new JVolume.LinearShort(vol);
        int dx = jv.dx;
        int dy = jv.dy;
        int dz = jv.dz;
        int[] wwwl = new int[65536];
        int ww = 1200;
        int min = 800 - (ww >> 1);
        int max = 800 + (ww >> 1);
        for (int i = 0; i < wwwl.length; ++i) {
            short v = (short)i;
            int val = 0;
            if (v >= max) {
                val = 255;
            } else if (v > min) {
                val = (int)((double)(v - min) / (double)ww * 255.0);
            }
            wwwl[i] = 0xFF000000 | val << 16 | val << 8 | val;
        }
        BufferedImage rimg = new BufferedImage(1024, 1024, 2);
        int[] output = ((DataBufferInt)rimg.getRaster().getDataBuffer()).getData();
        short[] lumout = new short[0x100000];
        double[] lookpt = new double[]{(float)dx * 0.5f, (float)dy * 0.5f, (float)dz * 0.5f};
        double vox_fov = 512.0;
        double[] xdir = new double[]{vox_fov / 1024.0, 0.0, 0.0};
        double[] ydir = new double[]{0.0, vox_fov / 1024.0, 0.0};
        double[] zdir = new double[]{0.0, 0.0, 0.9f};
        ydir[2] = ydir[2] / jv.ratio;
        fastmip fm = new fastmip();
        fm.setGeometry(vol, jv);
        fm.setView(lookpt, xdir, ydir, zdir, 1024, 1024);
        FastMipData fmd = new FastMipData();
        fmd.fm = fm;
        fmd.lumout = lumout;
        fmd.width = 1024;
        fmd.height = 1024;
        long t0 = System.currentTimeMillis();
        ptm.launch(fmd);
        long t1 = System.currentTimeMillis();
        long t = t1 - t0;
        System.err.println(">>>> mipproject: [" + t + "]");
        for (int i = 0; i < output.length; ++i) {
            int idx = lumout[i] & 0xFFFF;
            output[i] = wwwl[idx];
        }
        JFrame jf = XpImageUtils.displayImage(rimg, "fastmip");
        jf.setDefaultCloseOperation(3);
    }

    public static class FastMipWorker
    extends Worker {
        private fastmip_data fd = new fastmip_data();

        public FastMipWorker(ParallelTaskManager ptm, int workerId) {
            super(ptm, workerId);
            this.fd.id = workerId;
        }

        @Override
        public void work(int workerId, int workers, Object data) {
            FastMipData fmd = (FastMipData)data;
            int rows = fmd.height / workers;
            int y0 = workerId * rows;
            int y1 = y0 + rows - 1;
            fmd.fm.render(0, fmd.width - 1, y0, y1, 1, 2, fmd.lumout, fmd.width, fmd.height, this.fd);
        }
    }

    public static class FastMipData {
        public fastmip fm = null;
        public short[] lumout = null;
        public int width = 0;
        public int height = 0;
    }

    public static class fastmip_data {
        public int id = 0;
        public AffineTransform tx = new AffineTransform();
        public Point2D src = new Point2D.Double();
        public Point2D res = new Point2D.Double();
        public double[] ul = new double[3];
        public double[] ur = new double[3];
        public double[] bl = new double[3];
        public double[] ul_next = new double[3];
        public double[] pts = new double[6];
        public double[] dirx = new double[2];
        public double[] diry = new double[2];
        public double[] dirz = new double[2];
        public double[] minmaxX = new double[2];
        public double[] minmaxY = new double[2];
        public double[] mem = new double[6];
    }
}

