/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

public class MPFillerStrategy {
    public static void fill1x2(int k, int nworkers, int[] scrbuff, int w, int h) {
        int IROW = 2;
        for (int y = 0; y < h - 2; y += 2) {
            int yoffset = y * w;
            for (int x = k; x < w; x += nworkers) {
                int i = x + yoffset;
                int v00 = scrbuff[i] >> 1 & 0x7F7F7F;
                int v20 = scrbuff[i + 2 * w] >> 1 & 0x7F7F7F;
                scrbuff[i + w] = v00 + v20;
            }
        }
    }

    public static void fill1x2s(int k, int nworkers, short[] scrbuff, int w, int h) {
        int IROW = 2;
        for (int y = 0; y < h - 2; y += 2) {
            int yoffset = y * w;
            for (int x = k; x < w; x += nworkers) {
                int i = x + yoffset;
                short v00 = scrbuff[i];
                short v20 = scrbuff[i + 2 * w];
                scrbuff[i + w] = (short)(v00 + v20 >> 1);
            }
        }
    }

    public static void fill2x2(int k, int nworkers, int[] scrbuff, int w, int h) {
        int lastX = w - 2;
        for (int y = 0; y < h - 2; y += 2) {
            for (int x = k * 2; x < w - 2; x += 2 * nworkers) {
                int v21;
                int v01;
                int i = x + y * w;
                int v00 = scrbuff[i] >> 1 & 0x7F7F7F;
                int v02 = scrbuff[i + 2] >> 1 & 0x7F7F7F;
                scrbuff[i + 1] = v01 = v00 + v02;
                int v20 = scrbuff[i + 2 * w] >> 1 & 0x7F7F7F;
                scrbuff[i + w] = v00 + v20;
                int v22 = scrbuff[i + 2 * w + 2] >> 1 & 0x7F7F7F;
                scrbuff[i + w * 2 + 1] = v21 = v20 + v22;
                scrbuff[i + w + 2] = v02 + v22;
                v01 = v01 >> 1 & 0x7F7F7F;
                v21 = v21 >> 1 & 0x7F7F7F;
                scrbuff[i + w + 1] = v01 + v21;
                lastX = x;
            }
        }
        int x = lastX + 2 * nworkers;
        boolean pixelEdge = false;
        if (x < w) {
            for (int y = 0; y < h - 2; y += 2) {
                int i = x + y * w;
                int v00 = scrbuff[i] >> 1 & 0x7F7F7F;
                boolean v02 = false;
                int v01 = v00 + 0;
                int v20 = scrbuff[i + 2 * w] >> 1 & 0x7F7F7F;
                scrbuff[i + w] = v00 + v20;
                boolean v22 = false;
                int v21 = v20 + 0;
                if (x < w - 1) {
                    scrbuff[i + 1] = v01;
                    scrbuff[i + w * 2 + 1] = v21;
                    v01 = v01 >> 1 & 0x7F7F7F;
                    v21 = v21 >> 1 & 0x7F7F7F;
                    scrbuff[i + w + 1] = v01 + v21;
                }
                if (x >= w - 2) continue;
                scrbuff[i + w + 2] = 0;
            }
        }
    }

    public static void fill2x2s(int k, int nworkers, short[] scrbuff, int w, int h) {
        int lastX = w - 2;
        for (int y = 0; y < h - 2; y += 2) {
            for (int x = k * 2; x < w - 2; x += 2 * nworkers) {
                int i = x + y * w;
                short v00 = scrbuff[i];
                short v02 = scrbuff[i + 2];
                int v01 = v00 + v02 >> 1;
                scrbuff[i + 1] = (short)v01;
                short v20 = scrbuff[i + 2 * w];
                scrbuff[i + w] = (short)(v00 + v20 >> 1);
                short v22 = scrbuff[i + 2 * w + 2];
                int v21 = v20 + v22 >> 1;
                scrbuff[i + w * 2 + 1] = (short)v21;
                scrbuff[i + w + 2] = (short)(v02 + v22 >> 1);
                scrbuff[i + w + 1] = (short)(v01 + v21 >> 1);
                lastX = x;
            }
        }
        int x = lastX + 2 * nworkers;
        boolean pixelEdge = false;
        if (x < w) {
            for (int y = 0; y < h - 2; y += 2) {
                int i = x + y * w;
                short v00 = scrbuff[i];
                boolean v02 = false;
                int v01 = v00 + 0 >> 1;
                short v20 = scrbuff[i + 2 * w];
                scrbuff[i + w] = (short)(v00 + v20 >> 1);
                boolean v22 = false;
                int v21 = v20 + 0 >> 1;
                if (x < w - 1) {
                    scrbuff[i + 1] = (short)v01;
                    scrbuff[i + w * 2 + 1] = (short)v21;
                    scrbuff[i + w + 1] = (short)(v01 + v21 >> 1);
                }
                if (x >= w - 2) continue;
                scrbuff[i + w + 2] = 0;
            }
        }
    }

    public static void fill4x2(int k, int nworkers, int[] buff, int w, int h) {
        int BASERESX = 4;
        int BASERESY = 2;
        int width = w;
        int height = h;
        int xstep = 4 * nworkers;
        for (int y = 0; y < height - 2; y += 2) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            for (int x = k * 4; x < width - 4; x += xstep) {
                int p0 = buff[y0offset + x] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x + 4] >> 1 & 0x7F7F7F;
                int n = p0 + p1;
                buff[y0offset + x + 2] = n;
                int p01 = n;
                p01 = p01 >> 1 & 0x7F7F7F;
                int p2 = buff[y2offset + x] >> 1 & 0x7F7F7F;
                int p3 = buff[y2offset + x + 4] >> 1 & 0x7F7F7F;
                int n2 = p0 + p2;
                buff[y1offset + x] = n2;
                int p02 = n2;
                int p23 = p2 + p3 >> 1 & 0x7F7F7F;
                int p13 = p1 + p3 >> 1 & 0x7F7F7F;
                p02 = p02 >> 1 & 0x7F7F7F;
                buff[y0offset + x + 1] = p0 + p01;
                buff[y0offset + x + 3] = p1 + p01;
                int n3 = p01 + p23;
                buff[y1offset + x + 2] = n3;
                int c = n3;
                c = c >> 1 & 0x7F7F7F;
                buff[y1offset + x + 1] = p02 + c;
                buff[y1offset + x + 3] = p13 + c;
            }
        }
    }

    public static void fill4x2s(int k, int nworkers, short[] buff, int w, int h) {
        int BASERESX = 4;
        int BASERESY = 2;
        int width = w;
        int height = h;
        int xstep = 4 * nworkers;
        for (int y = 0; y < height - 2; y += 2) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            for (int x = k * 4; x < width - 4; x += xstep) {
                short p0 = buff[y0offset + x];
                short p1 = buff[y0offset + x + 4];
                short s = (short)(p0 + p1 >> 1);
                buff[y0offset + x + 2] = s;
                short p01 = s;
                short p2 = buff[y2offset + x];
                short p3 = buff[y2offset + x + 4];
                short s2 = (short)(p0 + p2 >> 1);
                buff[y1offset + x] = s2;
                short p02 = s2;
                int p23 = p2 + p3 >> 1;
                int p13 = p1 + p3 >> 1;
                buff[y0offset + x + 1] = (short)(p0 + p01 >> 1);
                buff[y0offset + x + 3] = (short)(p1 + p01 >> 1);
                short s3 = (short)(p01 + p23 >> 1);
                buff[y1offset + x + 2] = s3;
                short c = s3;
                buff[y1offset + x + 1] = (short)(p02 + c >> 1);
                buff[y1offset + x + 3] = (short)(p13 + c >> 1);
            }
        }
    }

    public static void fill4x4_0(int k, int nworkers, int[] buff, int w, int h) {
        int BASERES = 4;
        int width = w;
        int height = h;
        int xstep = 4 * nworkers;
        for (int y = 0; y < height - 4; y += 4) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            int y3offset = y2offset + w;
            int y4offset = y3offset + w;
            for (int x = k * 4; x < width - 4; x += xstep) {
                int p0 = buff[y0offset + x] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x + 4] >> 1 & 0x7F7F7F;
                int n = p0 + p1;
                buff[y0offset + x + 2] = n;
                int p01 = n;
                p01 = p01 >> 1 & 0x7F7F7F;
                int p2 = buff[y4offset + x] >> 1 & 0x7F7F7F;
                int p3 = buff[y4offset + x + 4] >> 1 & 0x7F7F7F;
                int n2 = p0 + p2;
                buff[y2offset + x] = n2;
                int p02 = n2;
                int p23 = p2 + p3 >> 1 & 0x7F7F7F;
                int p13 = p1 + p3 >> 1 & 0x7F7F7F;
                p02 = p02 >> 1 & 0x7F7F7F;
                int n3 = p0 + p01;
                buff[y0offset + x + 1] = n3;
                int a = n3;
                int n4 = p1 + p01;
                buff[y0offset + x + 3] = n4;
                int b = n4;
                int n5 = p23 + p01;
                buff[y2offset + x + 2] = n5;
                int pmid = n5;
                pmid = pmid >> 1 & 0x7F7F7F;
                int n6 = p02 + pmid;
                buff[y2offset + x + 1] = n6;
                int c = n6;
                int n7 = p13 + pmid;
                buff[y2offset + x + 3] = n7;
                int d = n7;
                a = a >> 1 & 0x7F7F7F;
                b = b >> 1 & 0x7F7F7F;
                c = c >> 1 & 0x7F7F7F;
                d = d >> 1 & 0x7F7F7F;
                int pa = p2 + p23 >> 1 & 0x7F7F7F;
                int pb = p3 + p23 >> 1 & 0x7F7F7F;
                buff[y1offset + x] = p0 + p02;
                buff[y1offset + x + 1] = a + c;
                buff[y1offset + x + 2] = p01 + pmid;
                buff[y1offset + x + 3] = b + d;
                buff[y3offset + x] = p2 + p02;
                buff[y3offset + x + 1] = pa + c;
                buff[y3offset + x + 2] = p23 + pmid;
                buff[y3offset + x + 3] = pb + d;
            }
        }
    }

    public static void fill4x4_0s(int k, int nworkers, short[] buff, int w, int h) {
        int BASERES = 4;
        int width = w;
        int height = h;
        int xstep = 4 * nworkers;
        for (int y = 0; y < height - 4; y += 4) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            int y3offset = y2offset + w;
            int y4offset = y3offset + w;
            for (int x = k * 4; x < width - 4; x += xstep) {
                short p0 = buff[y0offset + x];
                short p1 = buff[y0offset + x + 4];
                short s = (short)(p0 + p1 >> 1);
                buff[y0offset + x + 2] = s;
                short p01 = s;
                short p2 = buff[y4offset + x];
                short p3 = buff[y4offset + x + 4];
                short s2 = (short)(p0 + p2 >> 1);
                buff[y2offset + x] = s2;
                short p02 = s2;
                int p23 = p2 + p3 >> 1;
                int p13 = p1 + p3 >> 1;
                short s3 = (short)(p0 + p01 >> 1);
                buff[y0offset + x + 1] = s3;
                short a = s3;
                short s4 = (short)(p1 + p01 >> 1);
                buff[y0offset + x + 3] = s4;
                short b = s4;
                short s5 = (short)(p23 + p01 >> 1);
                buff[y2offset + x + 2] = s5;
                short pmid = s5;
                short s6 = (short)(p02 + pmid >> 1);
                buff[y2offset + x + 1] = s6;
                short c = s6;
                short s7 = (short)(p13 + pmid >> 1);
                buff[y2offset + x + 3] = s7;
                short d = s7;
                int pa = p2 + p23 >> 1;
                int pb = p3 + p23 >> 1;
                buff[y1offset + x] = (short)(p0 + p02 >> 1);
                buff[y1offset + x + 1] = (short)(a + c >> 1);
                buff[y1offset + x + 2] = (short)(p01 + pmid >> 1);
                buff[y1offset + x + 3] = (short)(b + d >> 1);
                buff[y3offset + x] = (short)(p2 + p02 >> 1);
                buff[y3offset + x + 1] = (short)(pa + c >> 1);
                buff[y3offset + x + 2] = (short)(p23 + pmid >> 1);
                buff[y3offset + x + 3] = (short)(pb + d >> 1);
            }
        }
    }

    public static void fill4x4_1(int k, int nworkers, int[] buff, int w, int h) {
        int BASERES = 4;
        int width = w;
        int height = h;
        int xstep = 4 * nworkers;
        for (int y = 0; y < height - 4; y += 4) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            int y3offset = y2offset + w;
            int y4offset = y3offset + w;
            for (int x = k * 4; x < width - 4; x += xstep) {
                int p0 = buff[y0offset + x] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x + 4] >> 1 & 0x7F7F7F;
                int p02 = buff[y2offset + x] >> 1 & 0x7F7F7F;
                int p13 = buff[y2offset + x + 4] >> 1 & 0x7F7F7F;
                int p2 = buff[y4offset + x] >> 1 & 0x7F7F7F;
                int p3 = buff[y4offset + x + 4] >> 1 & 0x7F7F7F;
                int n = p0 + p1;
                buff[y0offset + x + 2] = n;
                int p01 = n;
                int p23 = p2 + p3 >> 1 & 0x7F7F7F;
                p01 = p01 >> 1 & 0x7F7F7F;
                int n2 = p02 + p13;
                buff[y2offset + x + 2] = n2;
                int pmid = n2;
                pmid = pmid >> 1 & 0x7F7F7F;
                int n3 = p0 + p01;
                buff[y0offset + x + 1] = n3;
                int a = n3;
                int n4 = p1 + p01;
                buff[y0offset + x + 3] = n4;
                int b = n4;
                int n5 = p02 + pmid;
                buff[y2offset + x + 1] = n5;
                int c = n5;
                int n6 = p13 + pmid;
                buff[y2offset + x + 3] = n6;
                int d = n6;
                a = a >> 1 & 0x7F7F7F;
                b = b >> 1 & 0x7F7F7F;
                c = c >> 1 & 0x7F7F7F;
                d = d >> 1 & 0x7F7F7F;
                buff[y1offset + x] = p0 + p02;
                buff[y1offset + x + 1] = a + c;
                buff[y1offset + x + 2] = p01 + pmid;
                buff[y1offset + x + 3] = b + d;
                buff[y3offset + x] = p2 + p02;
                buff[y3offset + x + 1] = p2 + c;
                buff[y3offset + x + 2] = p23 + pmid;
                buff[y3offset + x + 3] = p3 + d;
            }
        }
    }

    public static void fill4x4_2(int k, int nworkers, int[] buff, int w, int h) {
        int BASERES = 4;
        int width = w;
        int height = h;
        int xstep = 4 * nworkers;
        for (int y = 0; y < height - 4; y += 4) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            int y3offset = y2offset + w;
            int y4offset = y3offset + w;
            for (int x = k * 4; x < width - 4; x += xstep) {
                int p0 = buff[y0offset + x] >> 1 & 0x7F7F7F;
                int p01 = buff[y0offset + x + 2] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x + 4] >> 1 & 0x7F7F7F;
                int p02 = buff[y2offset + x] >> 1 & 0x7F7F7F;
                int p13 = buff[y2offset + x + 4] >> 1 & 0x7F7F7F;
                int p2 = buff[y4offset + x] >> 1 & 0x7F7F7F;
                int p23 = buff[y4offset + x + 2] >> 1 & 0x7F7F7F;
                int p3 = buff[y4offset + x + 4] >> 1 & 0x7F7F7F;
                int k0 = p01 + p23 >> 1 & 0x7F7F7F;
                int k1 = p02 + p13 >> 1 & 0x7F7F7F;
                int n = k0 + k1;
                buff[y2offset + x + 2] = n;
                int pmid = n;
                pmid = pmid >> 1 & 0x7F7F7F;
                int n2 = p0 + p01;
                buff[y0offset + x + 1] = n2;
                int a = n2;
                int n3 = p1 + p01;
                buff[y0offset + x + 3] = n3;
                int b = n3;
                int n4 = p02 + pmid;
                buff[y2offset + x + 1] = n4;
                int c = n4;
                int n5 = p13 + pmid;
                buff[y2offset + x + 3] = n5;
                int d = n5;
                a = a >> 1 & 0x7F7F7F;
                b = b >> 1 & 0x7F7F7F;
                c = c >> 1 & 0x7F7F7F;
                d = d >> 1 & 0x7F7F7F;
                buff[y1offset + x] = p0 + p02;
                buff[y1offset + x + 1] = a + c;
                buff[y1offset + x + 2] = p01 + pmid;
                buff[y1offset + x + 3] = b + d;
                buff[y3offset + x] = p2 + p02;
                buff[y3offset + x + 1] = p2 + c;
                buff[y3offset + x + 2] = p23 + pmid;
                buff[y3offset + x + 3] = p3 + d;
            }
        }
    }

    public static void fill4x4_2s(int k, int nworkers, short[] buff, int w, int h) {
        int BASERES = 4;
        int width = w;
        int height = h;
        int xstep = 4 * nworkers;
        for (int y = 0; y < height - 4; y += 4) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            int y3offset = y2offset + w;
            int y4offset = y3offset + w;
            for (int x = k * 4; x < width - 4; x += xstep) {
                short p0 = buff[y0offset + x];
                short p01 = buff[y0offset + x + 2];
                short p1 = buff[y0offset + x + 4];
                short p02 = buff[y2offset + x];
                short p13 = buff[y2offset + x + 4];
                short p2 = buff[y4offset + x];
                short p23 = buff[y4offset + x + 2];
                short p3 = buff[y4offset + x + 4];
                int k0 = p01 + p23 >> 1;
                int k1 = p02 + p13 >> 1;
                short s = (short)(k0 + k1 >> 1);
                buff[y2offset + x + 2] = s;
                short pmid = s;
                short s2 = (short)(p0 + p01 >> 1);
                buff[y0offset + x + 1] = s2;
                short a = s2;
                short s3 = (short)(p1 + p01 >> 1);
                buff[y0offset + x + 3] = s3;
                short b = s3;
                short s4 = (short)(p02 + pmid >> 1);
                buff[y2offset + x + 1] = s4;
                short c = s4;
                short s5 = (short)(p13 + pmid >> 1);
                buff[y2offset + x + 3] = s5;
                short d = s5;
                buff[y1offset + x] = (short)(p0 + p02 >> 1);
                buff[y1offset + x + 1] = (short)(a + c >> 1);
                buff[y1offset + x + 2] = (short)(p01 + pmid >> 1);
                buff[y1offset + x + 3] = (short)(b + d >> 1);
                buff[y3offset + x] = (short)(p2 + p02 >> 1);
                buff[y3offset + x + 1] = (short)(p2 + c >> 1);
                buff[y3offset + x + 2] = (short)(p23 + pmid >> 1);
                buff[y3offset + x + 3] = (short)(p3 + d >> 1);
            }
        }
    }

    public static void fill8x4_0(int k, int nworkers, int[] buff, int w, int h) {
        int BASERESX = 8;
        int BASERESY = 4;
        int width = w;
        int height = h;
        int xstep = 8 * nworkers;
        for (int y = 0; y < height - 4; y += 4) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            int y3offset = y2offset + w;
            int y4offset = y3offset + w;
            for (int x = k * 8; x < width - 8; x += xstep) {
                int p0 = buff[y0offset + x] >> 1 & 0x7F7F7F;
                int p1 = buff[y0offset + x + 8] >> 1 & 0x7F7F7F;
                int n = p0 + p1;
                buff[y0offset + x + 4] = n;
                int p01 = n;
                p01 = p01 >> 1 & 0x7F7F7F;
                int p2 = buff[y4offset + x] >> 1 & 0x7F7F7F;
                int p3 = buff[y4offset + x + 8] >> 1 & 0x7F7F7F;
                int n2 = p0 + p2;
                buff[y2offset + x] = n2;
                int p02 = n2;
                int p23 = p2 + p3 >> 1 & 0x7F7F7F;
                int p13 = p1 + p3 >> 1 & 0x7F7F7F;
                p02 = p02 >> 1 & 0x7F7F7F;
                int n3 = p0 + p01;
                buff[y0offset + x + 2] = n3;
                int a = n3;
                int n4 = p1 + p01;
                buff[y0offset + x + 6] = n4;
                int b = n4;
                a = a >> 1 & 0x7F7F7F;
                b = b >> 1 & 0x7F7F7F;
                int n5 = p0 + a;
                buff[y0offset + x + 1] = n5;
                int y0_1 = n5;
                int n6 = p01 + a;
                buff[y0offset + x + 3] = n6;
                int y0_3 = n6;
                int n7 = p01 + b;
                buff[y0offset + x + 5] = n7;
                int y0_5 = n7;
                int n8 = b + p1;
                buff[y0offset + x + 7] = n8;
                int y0_7 = n8;
                y0_1 = y0_1 >> 1 & 0x7F7F7F;
                y0_3 = y0_3 >> 1 & 0x7F7F7F;
                y0_5 = y0_5 >> 1 & 0x7F7F7F;
                y0_7 = y0_7 >> 1 & 0x7F7F7F;
                int n9 = p23 + p01;
                buff[y2offset + x + 4] = n9;
                int pmid = n9;
                pmid = pmid >> 1 & 0x7F7F7F;
                int n10 = p02 + pmid;
                buff[y2offset + x + 2] = n10;
                int c = n10;
                int n11 = p13 + pmid;
                buff[y2offset + x + 6] = n11;
                int d = n11;
                c = c >> 1 & 0x7F7F7F;
                d = d >> 1 & 0x7F7F7F;
                int n12 = p02 + c;
                buff[y2offset + x + 1] = n12;
                int y2_1 = n12;
                int n13 = c + pmid;
                buff[y2offset + x + 3] = n13;
                int y2_3 = n13;
                int n14 = d + pmid;
                buff[y2offset + x + 5] = n14;
                int y2_5 = n14;
                int n15 = d + p13;
                buff[y2offset + x + 7] = n15;
                int y2_7 = n15;
                y2_1 = y2_1 >> 1 & 0x7F7F7F;
                y2_3 = y2_3 >> 1 & 0x7F7F7F;
                y2_5 = y2_5 >> 1 & 0x7F7F7F;
                y2_7 = y2_7 >> 1 & 0x7F7F7F;
                int pa = p2 + p23 >> 1 & 0x7F7F7F;
                int pb = p3 + p23 >> 1 & 0x7F7F7F;
                buff[y1offset + x] = p0 + p02;
                buff[y1offset + x + 1] = y0_1 + y2_1;
                buff[y1offset + x + 2] = a + c;
                buff[y1offset + x + 3] = y0_3 + y2_3;
                buff[y1offset + x + 4] = p01 + pmid;
                buff[y1offset + x + 5] = y0_5 + y2_5;
                buff[y1offset + x + 6] = b + d;
                buff[y1offset + x + 7] = y0_7 + y2_7;
                int n16 = p2 + p02;
                buff[y3offset + x] = n16;
                int y3_0 = n16;
                int n17 = pa + c;
                buff[y3offset + x + 2] = n17;
                int y3_2 = n17;
                int n18 = p23 + pmid;
                buff[y3offset + x + 4] = n18;
                int y3_4 = n18;
                int n19 = pb + d;
                buff[y3offset + x + 6] = n19;
                int y3_6 = n19;
                y3_0 = y3_0 >> 1 & 0x7F7F7F;
                y3_2 = y3_2 >> 1 & 0x7F7F7F;
                y3_4 = y3_4 >> 1 & 0x7F7F7F;
                y3_6 = y3_6 >> 1 & 0x7F7F7F;
                buff[y3offset + x + 1] = y3_0 + y3_2;
                buff[y3offset + x + 3] = y3_4 + y3_2;
                buff[y3offset + x + 5] = y3_4 + y3_6;
                buff[y3offset + x + 7] = y2_7 + y3_6;
            }
        }
    }

    public static void fill8x4_0s(int k, int nworkers, short[] buff, int w, int h) {
        int BASERESX = 8;
        int BASERESY = 4;
        int width = w;
        int height = h;
        int xstep = 8 * nworkers;
        for (int y = 0; y < height - 4; y += 4) {
            int y0offset = y * w;
            int y1offset = y0offset + w;
            int y2offset = y1offset + w;
            int y3offset = y2offset + w;
            int y4offset = y3offset + w;
            for (int x = k * 8; x < width - 8; x += xstep) {
                short p0 = buff[y0offset + x];
                short p1 = buff[y0offset + x + 8];
                short s = (short)(p0 + p1 >> 1);
                buff[y0offset + x + 4] = s;
                short p01 = s;
                short p2 = buff[y4offset + x];
                short p3 = buff[y4offset + x + 8];
                short s2 = (short)(p0 + p2 >> 1);
                buff[y2offset + x] = s2;
                short p02 = s2;
                int p23 = p2 + p3 >> 1;
                int p13 = p1 + p3 >> 1;
                short s3 = (short)(p0 + p01 >> 1);
                buff[y0offset + x + 2] = s3;
                short a = s3;
                short s4 = (short)(p1 + p01 >> 1);
                buff[y0offset + x + 6] = s4;
                short b = s4;
                short s5 = (short)(p0 + a >> 1);
                buff[y0offset + x + 1] = s5;
                short y0_1 = s5;
                short s6 = (short)(p01 + a >> 1);
                buff[y0offset + x + 3] = s6;
                short y0_3 = s6;
                short s7 = (short)(p01 + b >> 1);
                buff[y0offset + x + 5] = s7;
                short y0_5 = s7;
                short s8 = (short)(b + p1 >> 1);
                buff[y0offset + x + 7] = s8;
                short y0_7 = s8;
                short s9 = (short)(p23 + p01 >> 1);
                buff[y2offset + x + 4] = s9;
                short pmid = s9;
                short s10 = (short)(p02 + pmid >> 1);
                buff[y2offset + x + 2] = s10;
                short c = s10;
                short s11 = (short)(p13 + pmid >> 1);
                buff[y2offset + x + 6] = s11;
                short d = s11;
                short s12 = (short)(p02 + c >> 1);
                buff[y2offset + x + 1] = s12;
                short y2_1 = s12;
                short s13 = (short)(c + pmid >> 1);
                buff[y2offset + x + 3] = s13;
                short y2_3 = s13;
                short s14 = (short)(d + pmid >> 1);
                buff[y2offset + x + 5] = s14;
                short y2_5 = s14;
                short s15 = (short)(d + p13 >> 1);
                buff[y2offset + x + 7] = s15;
                short y2_7 = s15;
                int pa = p2 + p23 >> 1;
                int pb = p3 + p23 >> 1;
                buff[y1offset + x] = (short)(p0 + p02 >> 1);
                buff[y1offset + x + 1] = (short)(y0_1 + y2_1 >> 1);
                buff[y1offset + x + 2] = (short)(a + c >> 1);
                buff[y1offset + x + 3] = (short)(y0_3 + y2_3 >> 1);
                buff[y1offset + x + 4] = (short)(p01 + pmid >> 1);
                buff[y1offset + x + 5] = (short)(y0_5 + y2_5 >> 1);
                buff[y1offset + x + 6] = (short)(b + d >> 1);
                buff[y1offset + x + 7] = (short)(y0_7 + y2_7 >> 1);
                short s16 = (short)(p2 + p02 >> 1);
                buff[y3offset + x] = s16;
                short y3_0 = s16;
                short s17 = (short)(pa + c >> 1);
                buff[y3offset + x + 2] = s17;
                short y3_2 = s17;
                short s18 = (short)(p23 + pmid >> 1);
                buff[y3offset + x + 4] = s18;
                short y3_4 = s18;
                short s19 = (short)(pb + d >> 1);
                buff[y3offset + x + 6] = s19;
                short y3_6 = s19;
                buff[y3offset + x + 1] = (short)(y3_0 + y3_2 >> 1);
                buff[y3offset + x + 3] = (short)(y3_4 + y3_2 >> 1);
                buff[y3offset + x + 5] = (short)(y3_4 + y3_6 >> 1);
                buff[y3offset + x + 7] = (short)(y2_7 + y3_6 >> 1);
            }
        }
    }
}

