/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.terra.jami.j3d.mprender.BaseIRE;
import com.ge.med.terra.jami.j3d.mprender.ThreadPool;
import java.awt.Rectangle;

public class SamplingMtIRE
extends BaseIRE {
    public static final int QUALITY = 40;
    private final int baseRes = 16;
    private final int baseSteps = 3;
    private ThreadPool tp = new ThreadPool(this.NOT - 1);
    private int[] hist = new int[24576];
    private Rectangle r = new Rectangle(0, 0, 0, 0);
    private int scrh;
    private int scrw;
    private final int highbyte = -16777216;
    private int[] levels = new int[16];
    private Rectangle origRectangle = new Rectangle();
    private Runnable[] linerunners4 = null;
    private Runnable[] linerunners8 = null;
    private Runnable[] mresrunners2_8 = null;

    public void SamplingMtIRE() {
        this.blue = true;
    }

    private final int diff(int a, int b) {
        int pne1 = a & 0xFF;
        int pne2 = a >> 8 & 0xFF;
        int pne3 = a >> 16 & 0xFF;
        int pse1 = b & 0xFF;
        int pse2 = b >> 8 & 0xFF;
        int pse3 = b >> 16 & 0xFF;
        int d1 = pne1 - pse1;
        int d2 = pne2 - pse2;
        int d3 = pne3 - pse3;
        return d1 * d1 + d2 * d2 + d3 * d3 >> 5;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.tp.destroy();
        this.tp = null;
    }

    public void setPriority(int p) {
        Thread.currentThread().setPriority(p);
        this.tp.setPriority(p);
    }

    @Override
    public void multiPassRender() {
        this.setPriority(5);
        int renderMode = this.getRenderMode();
        switch (renderMode) {
            case 0: {
                this.defaultMultiPassRender();
                break;
            }
            case 1: {
                this.lineMultiPassRender();
                break;
            }
            case 2: {
                this.mresMultiPassRender();
            }
        }
    }

    public static void markTime(String str) {
    }

    private void defaultMultiPassRender() {
        int i;
        int k;
        this.r.x = 0;
        this.r.y = 0;
        this.r.width = this.scr.getWidth();
        this.r.height = this.scr.getHeight();
        this.scrw = this.scr.getWidth();
        this.scrh = this.scr.getHeight();
        long start = System.currentTimeMillis();
        this.done = false;
        SamplingMtIRE.markTime("start");
        int i2 = 1;
        while (i2 < this.NOT) {
            k = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    for (int i = k; i < SamplingMtIRE.this.scrbuff.length; i += SamplingMtIRE.this.NOT) {
                        SamplingMtIRE.this.scrbuff[i] = SamplingMtIRE.this.bgColor;
                    }
                }
            });
        }
        for (i2 = 0; i2 < this.scrbuff.length; i2 += this.NOT) {
            this.scrbuff[i2] = this.bgColor;
        }
        this.tp.waitfordone();
        SamplingMtIRE.markTime("start");
        i2 = 1;
        while (i2 < this.NOT) {
            k = i2++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    Rectangle r2 = new Rectangle(SamplingMtIRE.this.r);
                    r2.x += k * 16;
                    r2.width -= k * 16;
                    SamplingMtIRE.this.ren.castRays(r2, 16 * SamplingMtIRE.this.NOT, 16, 0, 1, SamplingMtIRE.this.thread_data[k]);
                    SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, r2, 16 * SamplingMtIRE.this.NOT, 16);
                }
            });
        }
        this.ren.castRays(this.r, 16 * this.NOT, 16, 0, 1, this.thread_data[0]);
        this.highbit(this.scrbuff, this.scrw, this.r, 16 * this.NOT, 16);
        this.tp.waitfordone();
        SamplingMtIRE.markTime("pass 1");
        long phase1 = System.currentTimeMillis();
        final int speed = (int)(phase1 - start);
        if (phase1 - start < 0L) {
            for (i = 0; i < 4; ++i) {
                this.mtBulkRay(i / 2, i % 2, 0, 1);
                if (i == 0) {
                    this.mtFill2x2();
                }
                if (!this.noChange) {
                    this.ren.updateWorld();
                    return;
                }
                this.tp.waitfordone();
                phase1 = System.currentTimeMillis();
                if (phase1 - start > 30L || i == 3) {
                    Thread.yield();
                    this.copyToBackBuff();
                    this.scrcomp.repaint();
                    if (phase1 - start > 100L) break;
                    if (i == 3) {
                        return;
                    }
                }
                if (this.noChange) continue;
                this.ren.updateWorld();
                return;
            }
        }
        i = 1;
        while (i < this.NOT) {
            final int k2 = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    SamplingMtIRE.this.lightBasedPass(k2, speed, 0, 1);
                }
            });
        }
        this.lightBasedPass(0, speed, 0, 1);
        this.tp.waitfordone();
        SamplingMtIRE.markTime("done light base ");
        for (i = 0; i < this.hist.length; ++i) {
            this.hist[i] = 0;
        }
        for (int y = 16; y < this.scrh; y += 32) {
            for (int x = 16; x < this.scrw; x += 32) {
                int i3 = x + y * this.scrw;
                int n = this.diff(this.scrbuff[i3], this.scrbuff[i3 - 16]);
                this.hist[n] = this.hist[n] + 1;
                int n2 = this.diff(this.scrbuff[i3], this.scrbuff[i3 - 16 * this.scrw]);
                this.hist[n2] = this.hist[n2] + 1;
            }
        }
        int max = 0;
        int sum = 1;
        int thresh = 100;
        for (int i4 = 0; i4 < this.hist.length; ++i4) {
            sum += this.hist[i4];
            if (this.hist[i4] <= 0) continue;
            max = i4;
        }
        int v = 0;
        int i5 = this.hist.length - 1;
        while (i5 > 0) {
            this.levels[(v += this.hist[i5]) * this.levels.length / sum] = i5--;
        }
        start = 0L;
        for (int pas = 0; pas < this.levels.length && thresh != 0; ++pas) {
            final int fthresh = thresh = this.levels[pas];
            int i6 = 1;
            while (i6 < this.NOT) {
                final int k3 = i6++;
                this.tp.add(new Runnable(){

                    @Override
                    public void run() {
                        SamplingMtIRE.this.edgeBasedPass(fthresh, k3, 0, 1);
                    }
                });
            }
            this.edgeBasedPass(thresh, 0, 0, 1);
            this.tp.waitfordone();
            SamplingMtIRE.markTime("done edge " + pas);
            long nextPaint = System.currentTimeMillis();
            if (nextPaint - start > 100L) {
                this.mtFill2x2();
                Thread.yield();
                this.copyToBackBuff();
                this.scrcomp.repaint();
                start = nextPaint;
            }
            if (this.noChange) continue;
            this.ren.updateWorld();
            return;
        }
        this.setPriority(1);
        this.mtRay(1, 1, 0, 1);
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
        this.mtRay(1, 0, 0, 1);
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.copyToBackBuff();
        Thread.yield();
        this.scrcomp.repaint();
        this.mtRay(0, 1, 0, 1);
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.copyToBackBuff();
        this.scrcomp.repaint();
        i5 = 1;
        while (i5 < this.NOT) {
            final int k4 = i5++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    SamplingMtIRE.this.finalfill(k4, 0, 1);
                }
            });
        }
        this.finalfill(0, 0, 1);
        this.tp.waitfordone();
        Thread.yield();
        this.copyToBackBuff();
        this.done = true;
        this.scrcomp.repaint();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
    }

    private void finalfill(int t, int zoff, int zstep) {
        for (int i = t; i < this.scrbuff.length; i += this.NOT) {
            if (this.scrbuff[i] < 0) continue;
            this.scrbuff[i] = this.ren.castRay(i % this.scrw, i / this.scrw, zoff, zstep, this.thread_data[t]);
        }
    }

    private void mtFill2x2() {
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    SamplingMtIRE.this.fill2x2(k);
                }
            });
        }
        this.fill2x2(0);
        this.tp.waitfordone();
    }

    private void mtRay(final int dx, final int dy, final int zoff, final int zstep) {
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    Rectangle tr = new Rectangle(dx, dy, SamplingMtIRE.this.scrw - dx, SamplingMtIRE.this.scrh - dy);
                    tr.x += k * 2;
                    tr.width -= k * 2;
                    int height = SamplingMtIRE.this.scrh;
                    int ystep = height / 32;
                    if (ystep == 0) {
                        ystep = 1;
                    }
                    for (int y = tr.y; y < height; y += ystep) {
                        if (!SamplingMtIRE.this.noChange) {
                            return;
                        }
                        tr.y = y;
                        tr.height = y + ystep > height ? height - y : ystep;
                        SamplingMtIRE.this.ren.castRays(tr, 2 * SamplingMtIRE.this.NOT, 2, zoff, zstep, SamplingMtIRE.this.thread_data[k]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, tr, 2 * SamplingMtIRE.this.NOT, 2);
                    }
                }
            });
        }
        Rectangle tr = new Rectangle(dx, dy, this.scrw - dx, this.scrh - dy);
        int height = this.scrh;
        int ystep = height / 32;
        if (ystep == 0) {
            ystep = 1;
        }
        for (int y = tr.y; y < height && this.noChange; y += ystep) {
            tr.y = y;
            tr.height = y + ystep > height ? height - y : ystep;
            this.ren.castRays(tr, 2 * this.NOT, 2, zoff, zstep, this.thread_data[0]);
            this.highbit(this.scrbuff, this.scrw, tr, 2 * this.NOT, 2);
        }
        if (this.tp != null) {
            this.tp.waitfordone();
        }
    }

    private void mtBulkRay(final int dx, final int dy, final int zoff, final int zstep) {
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    Rectangle tr = new Rectangle(dx, dy, SamplingMtIRE.this.scrw - dx, SamplingMtIRE.this.scrh - dy);
                    tr.x += k * 2;
                    tr.width -= k * 2;
                    SamplingMtIRE.this.ren.castRays(tr, 2 * SamplingMtIRE.this.NOT, 2, zoff, zstep, SamplingMtIRE.this.thread_data[k]);
                    SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, tr, 2 * SamplingMtIRE.this.NOT, 2);
                }
            });
        }
        Rectangle tr = new Rectangle(dx, dy, this.scrw - dx, this.scrh - dy);
        this.ren.castRays(tr, 2 * this.NOT, 2, zoff, zstep, this.thread_data[0]);
        this.highbit(this.scrbuff, this.scrw, tr, 2 * this.NOT, 2);
        if (this.tp != null) {
            this.tp.waitfordone();
        }
    }

    private void fullRay(final int zoff, final int zstep) {
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    Rectangle tr = new Rectangle(0, 0, SamplingMtIRE.this.scrw, SamplingMtIRE.this.scrh);
                    tr.x += k;
                    tr.width -= k;
                    int height = SamplingMtIRE.this.scrh;
                    int ystep = height / 32;
                    if (ystep == 0) {
                        ystep = 1;
                    }
                    for (int y = tr.y; y < height; y += ystep) {
                        tr.y = y;
                        tr.height = y + ystep > height ? height - y : ystep;
                        SamplingMtIRE.this.ren.castRays(tr, SamplingMtIRE.this.NOT, 1, zoff, zstep, SamplingMtIRE.this.thread_data[k]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, tr, SamplingMtIRE.this.NOT, 1);
                    }
                }
            });
        }
        Rectangle tr = new Rectangle(0, 0, this.scrw, this.scrh);
        this.ren.castRays(tr, this.NOT, 1, zoff, zstep, this.thread_data[0]);
        this.highbit(this.scrbuff, this.scrw, tr, this.NOT, 1);
        if (this.tp != null) {
            this.tp.waitfordone();
        }
    }

    private void fill2x2(int t) {
        for (int y = 0; y < this.r.height - 2; y += 2) {
            for (int x = t * 2; x < this.r.width - 2; x += 2 * this.NOT) {
                int v21;
                int v01;
                int i = x + y * this.scrw;
                int v00 = this.scrbuff[i] >> 1 & 0x7F7F7F;
                int v02 = this.scrbuff[i + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i + 1] = v01 = v00 + v02;
                int v20 = this.scrbuff[i + 2 * this.scrw] >> 1 & 0x7F7F7F;
                this.scrbuff[i + this.scrw] = v00 + v20;
                int v22 = this.scrbuff[i + 2 * this.scrw + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i + this.scrw * 2 + 1] = v21 = v20 + v22;
                this.scrbuff[i + this.scrw + 2] = v02 + v22;
                v01 = v01 >> 1 & 0x7F7F7F;
                v21 = v21 >> 1 & 0x7F7F7F;
                this.scrbuff[i + this.scrw + 1] = v01 + v21;
            }
        }
    }

    private void edgeBasedPass(int thresh, int t, int zoff, int zstep) {
        int xstart = t * (this.scrw / this.NOT & 0xFFFFFFF0);
        int xend = (1 + t) * (this.scrw / this.NOT & 0xFFFFFFF0) + 1;
        int toggle = 0;
        if (t == this.NOT - 1) {
            xend = this.scrw;
        }
        for (int res = 0; res < 3; ++res) {
            int b;
            int a;
            int diff;
            int d3;
            int d2;
            int d1;
            int pb3;
            int pb2;
            int pb1;
            int pb;
            int test;
            int step = 16 >> res;
            int hstep = step / 2;
            int pa = this.scrbuff[0];
            int pa1 = pa & 0xFF;
            int pa2 = pa >> 8 & 0xFF;
            int pa3 = pa >> 16 & 0xFF;
            for (int x = xstart; x < xend; x += step) {
                test = x + hstep;
                pb = this.scrbuff[test + hstep];
                pb1 = pb & 0xFF;
                pb2 = pb >> 8 & 0xFF;
                pb3 = pb >> 16 & 0xFF;
                if (this.scrbuff[test] >= 0) {
                    d1 = pa1 - pb1;
                    d2 = pa2 - pb2;
                    d3 = pa3 - pb3;
                    diff = d1 * d1 + d2 * d2 + d3 * d3 >> 5;
                    if (thresh < diff) {
                        this.scrbuff[test] = this.ren.castRay(test % this.scrw, test / this.scrw, zoff, zstep, this.thread_data[t]) | 0xFF000000;
                    } else {
                        a = pa >> 1 & 0x7F7F7F;
                        b = pb >> 1 & 0x7F7F7F;
                        this.scrbuff[test] = a + b;
                    }
                }
                pa = pb;
                pa1 = pb1;
                pa2 = pb2;
                pa3 = pb3;
            }
            pa = this.scrbuff[0];
            pa1 = pa & 0xFF;
            pa2 = pa >> 8 & 0xFF;
            pa3 = pa >> 16 & 0xFF;
            for (int y = this.r.y; y < this.r.height - step; y += step) {
                test = xstart + y * this.scrw + hstep * this.scrw;
                if (this.scrbuff[test] < 0) continue;
                pb = this.scrbuff[test + hstep * this.scrw];
                pb1 = pb & 0xFF;
                d1 = pa1 - pb1;
                pb2 = pb >> 8 & 0xFF;
                d2 = pa2 - pb2;
                pb3 = pb >> 16 & 0xFF;
                d3 = pa3 - pb3;
                diff = d1 * d1 + d2 * d2 + d3 * d3 >> 5;
                if (thresh < diff) {
                    this.scrbuff[test] = this.ren.castRay(test % this.scrw, test / this.scrw, zoff, zstep, this.thread_data[t]) | 0xFF000000;
                } else {
                    a = pa >> 1 & 0x7F7F7F;
                    b = pb >> 1 & 0x7F7F7F;
                    this.scrbuff[test] = a + b;
                }
                pa = pb;
                pa1 = pb1;
                pa2 = pb2;
                pa3 = pb3;
            }
            for (int y = this.r.y + hstep; y < this.r.height - step; y += step) {
                for (int x = xstart + hstep; x < xend; x += step) {
                    int b2;
                    int a2;
                    int diff2;
                    int pa4;
                    int off;
                    int i = y * this.scrw + x;
                    int test2 = i + hstep;
                    if (this.scrbuff[test2] >= 0) {
                        off = hstep * this.scrw;
                        pa4 = this.scrbuff[test2 - off];
                        pb = this.scrbuff[test2 + off];
                        diff2 = this.diff(pa4, pb);
                        if (thresh < diff2) {
                            this.scrbuff[test2] = this.ren.castRay(test2 % this.scrw, test2 / this.scrw, zoff, zstep, this.thread_data[t]) | 0xFF000000;
                        } else {
                            a2 = pa4 >> 1 & 0x7F7F7F;
                            b2 = pb >> 1 & 0x7F7F7F;
                            this.scrbuff[test2] = a2 + b2;
                        }
                    }
                    if (this.scrbuff[test2 = i + hstep * this.scrw] >= 0) {
                        int pa5 = this.scrbuff[test2 - hstep];
                        int pb4 = this.scrbuff[test2 + hstep];
                        int diff3 = this.diff(pa5, pb4);
                        if (thresh < diff3) {
                            this.scrbuff[test2] = this.ren.castRay(test2 % this.scrw, test2 / this.scrw, zoff, zstep, this.thread_data[t]) | 0xFF000000;
                        } else {
                            int a3 = pa5 >> 1 & 0x7F7F7F;
                            int b3 = pb4 >> 1 & 0x7F7F7F;
                            this.scrbuff[test2] = a3 + b3;
                        }
                    }
                    if (this.scrbuff[test2 = i] < 0) continue;
                    off = hstep;
                    if ((toggle = toggle + 1 & 1) == 0) {
                        off *= this.scrw;
                    }
                    if (thresh < (diff2 = this.diff(pa4 = this.scrbuff[test2 - off], pb = this.scrbuff[test2 + off]))) {
                        this.scrbuff[test2] = this.ren.castRay(test2 % this.scrw, test2 / this.scrw, zoff, zstep, this.thread_data[t]) | 0xFF000000;
                        continue;
                    }
                    a2 = pa4 >> 1 & 0x7F7F7F;
                    b2 = pb >> 1 & 0x7F7F7F;
                    this.scrbuff[test2] = a2 + b2;
                }
            }
        }
    }

    private void lightBasedPass(int thread, int speed, int zoff, int zstep) {
        if (speed > 40) {
            return;
        }
        int halfPass = 16 / (speed < 20 ? 4 : 2);
        int mask = -16;
        int xskip = halfPass * this.NOT;
        int xstart = thread * halfPass;
        for (int y = 0; y < this.scrh; y += halfPass) {
            int yp = y + 8 & mask;
            yp = yp < this.scrh ? (yp *= this.scrw) : (this.scrh - 1 & mask) * this.scrw;
            for (int x = xstart; x < this.scrw; x += xskip) {
                if (x % 16 == 0 && y % 16 == 0) continue;
                int p = x + 8 & mask;
                p = p < this.scrw ? (p += yp) : this.scrw - 1 & mask + yp;
                int k = this.scrbuff[p] & 0xFFFFFF;
                k = (k & 0xFF) + (k >> 8 & 0xFF) + (k >> 16 & 0xFF);
                if (k < 40) continue;
                int i = y * this.scrw + x;
                this.scrbuff[i] = this.ren.castRay(x, y, zoff, zstep, this.thread_data[thread]) | 0xFF000000;
            }
        }
    }

    protected void display() {
        Thread.yield();
        this.copyToBackBuff();
        this.scrcomp.repaint();
    }

    private void lineMultiPassRender() {
        int k;
        this.r.x = 0;
        this.r.y = 0;
        this.r.width = this.scr.getWidth();
        this.r.height = this.scr.getHeight();
        this.scrw = this.scr.getWidth();
        this.scrh = this.scr.getHeight();
        this.origRectangle.setBounds(this.r);
        long start = System.currentTimeMillis();
        this.done = false;
        SamplingMtIRE.markTime("LINERENDER_START");
        int i = 1;
        while (i < this.NOT) {
            k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    for (int i = k; i < SamplingMtIRE.this.scrbuff.length; i += SamplingMtIRE.this.NOT) {
                        SamplingMtIRE.this.scrbuff[i] = SamplingMtIRE.this.bgColor;
                    }
                }
            });
        }
        for (i = 0; i < this.scrbuff.length; i += this.NOT) {
            this.scrbuff[i] = this.bgColor;
        }
        this.tp.waitfordone();
        SamplingMtIRE.markTime("LINERENDER_PASS1");
        if (this.linerunners8 == null) {
            this.linerunners8 = new Runnable[this.NOT];
            for (i = 0; i < this.NOT; ++i) {
                k = i;
                this.linerunners8[i] = new Runnable(){

                    @Override
                    public void run() {
                        int LINESKIP_PASS = 8;
                        Rectangle r2 = new Rectangle(SamplingMtIRE.this.r);
                        r2.y += k * 8;
                        r2.height -= k * 8;
                        SamplingMtIRE.this.ren.castRays(r2, 1, 8 * SamplingMtIRE.this.NOT, 0, 1, SamplingMtIRE.this.thread_data[k]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, r2, 1, 8 * SamplingMtIRE.this.NOT);
                    }
                };
            }
        }
        for (i = 1; i < this.NOT; ++i) {
            this.tp.add(this.linerunners8[i]);
        }
        this.linerunners8[0].run();
        this.tp.waitfordone();
        this.mtFillLines8();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.r.y = this.origRectangle.y + 4;
        this.r.height = this.origRectangle.height - 8;
        SamplingMtIRE.markTime("LINERENDER_PASS2");
        for (i = 1; i < this.NOT; ++i) {
            this.tp.add(this.linerunners8[i]);
        }
        this.linerunners8[0].run();
        this.tp.waitfordone();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.mtFillLines4();
        this.display();
        this.r.y = this.origRectangle.y + 2;
        this.r.height = this.origRectangle.height - 4;
        SamplingMtIRE.markTime("LINERENDER_PASS3");
        for (i = 1; i < this.NOT; ++i) {
            this.tp.add(this.linerunners8[i]);
        }
        this.linerunners8[0].run();
        this.tp.waitfordone();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.mtFillLines2();
        this.display();
        this.r.y = this.origRectangle.y + 6;
        this.r.height = this.origRectangle.height - 12;
        SamplingMtIRE.markTime("LINERENDER_PASS4");
        for (i = 1; i < this.NOT; ++i) {
            this.tp.add(this.linerunners8[i]);
        }
        this.linerunners8[0].run();
        this.tp.waitfordone();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.mtFillLines2();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        this.r.y = this.origRectangle.y + 1;
        this.r.height = this.origRectangle.height - 1;
        if (this.linerunners4 == null) {
            this.linerunners4 = new Runnable[this.NOT];
            for (i = 0; i < this.NOT; ++i) {
                k = i;
                this.linerunners4[i] = new Runnable(){

                    @Override
                    public void run() {
                        int LINESKIP_PASS = 4;
                        Rectangle r2 = new Rectangle(SamplingMtIRE.this.r);
                        r2.y += k * 4;
                        r2.height -= k * 4;
                        SamplingMtIRE.this.ren.castRays(r2, 1, 4 * SamplingMtIRE.this.NOT, 0, 1, SamplingMtIRE.this.thread_data[k]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, r2, 1, 4 * SamplingMtIRE.this.NOT);
                    }
                };
            }
        }
        for (i = 1; i < this.NOT; ++i) {
            this.tp.add(this.linerunners4[i]);
        }
        this.linerunners4[0].run();
        this.tp.waitfordone();
        this.display();
        this.done = true;
    }

    private void mtFillLines8() {
        this.ren.prePaint();
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k * 8;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k * 8);
                    SamplingMtIRE.this.fillLines8(ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fillLines8(this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void mtFillLines4() {
        this.ren.prePaint();
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k * 4;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k * 4);
                    SamplingMtIRE.this.fillLines4(ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fillLines4(this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void mtFillLines2() {
        this.ren.prePaint();
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k * 2;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k * 2);
                    SamplingMtIRE.this.fillLines2(ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fillLines2(this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void fillLines2(int ystart, int yend, int nproc) {
        int linestep = 2 * nproc;
        int line2 = this.scrw << 1;
        for (int y = ystart; y < yend - linestep; y += linestep) {
            int yoffset = y * this.scrw;
            for (int x = 0; x < this.r.width; ++x) {
                int i = x + yoffset;
                int v00 = this.scrbuff[i] >> 1 & 0x7F7F7F;
                int v20 = this.scrbuff[i + line2] >> 1 & 0x7F7F7F;
                this.scrbuff[i + this.scrw] = v00 + v20;
            }
        }
    }

    private void fillLines4(int ystart, int yend, int nproc) {
        int linestep = 4 * nproc;
        int line1 = this.scrw;
        int line2 = this.scrw * 2;
        int line3 = this.scrw * 3;
        int line4 = this.scrw * 4;
        int v20 = 0;
        for (int y = ystart; y < yend - linestep; y += linestep) {
            int yoffset = y * this.scrw;
            for (int x = 0; x < this.r.width; ++x) {
                int i = x + yoffset;
                int v00 = this.scrbuff[i] >> 1 & 0x7F7F7F;
                int v40 = this.scrbuff[i + line4] >> 1 & 0x7F7F7F;
                this.scrbuff[i + line2] = v20 = v00 + v40;
                v20 = v20 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line1] = v00 + v20;
                this.scrbuff[i + line3] = v20 + v40;
            }
        }
    }

    private void fillLines8(int ystart, int yend, int nproc) {
        int linestep = 8 * nproc;
        int line1 = this.scrw;
        int line2 = 2 * this.scrw;
        int line3 = 3 * this.scrw;
        int line4 = 4 * this.scrw;
        int line5 = 5 * this.scrw;
        int line6 = 6 * this.scrw;
        int line7 = 7 * this.scrw;
        int line8 = 8 * this.scrw;
        int v60 = 0;
        for (int y = ystart; y < yend - linestep; y += linestep) {
            int yoffset = y * this.scrw;
            for (int x = 0; x < this.r.width; ++x) {
                int v20;
                int v40;
                int i = x + yoffset;
                int v00 = this.scrbuff[i] >> 1 & 0x7F7F7F;
                int v80 = this.scrbuff[i + line8] >> 1 & 0x7F7F7F;
                this.scrbuff[i + line4] = v40 = v00 + v80;
                v40 = v40 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line2] = v20 = v00 + v40;
                this.scrbuff[i + line6] = v60 = v80 + v40;
                v20 = v20 >> 1 & 0x7F7F7F;
                v60 = v60 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line1] = v00 + v20;
                this.scrbuff[i + line3] = v20 + v40;
                this.scrbuff[i + line5] = v40 + v60;
                this.scrbuff[i + line7] = v80 + v60;
            }
        }
    }

    private void mresMultiPassRender() {
        int k;
        this.r.x = 0;
        this.r.y = 0;
        this.r.width = this.scr.getWidth();
        this.r.height = this.scr.getHeight();
        this.scrw = this.scr.getWidth();
        this.scrh = this.scr.getHeight();
        this.origRectangle.setBounds(this.r);
        long start = System.currentTimeMillis();
        this.done = false;
        SamplingMtIRE.markTime("MULTIRES_START");
        int i = 1;
        while (i < this.NOT) {
            k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    for (int i = k; i < SamplingMtIRE.this.scrbuff.length; i += SamplingMtIRE.this.NOT) {
                        SamplingMtIRE.this.scrbuff[i] = 0;
                    }
                }
            });
        }
        for (i = 0; i < this.scrbuff.length; i += this.NOT) {
            this.scrbuff[i] = 0;
        }
        this.tp.waitfordone();
        SamplingMtIRE.markTime("MULTIRES_PASS1");
        if (this.mresrunners2_8 == null) {
            this.mresrunners2_8 = new Runnable[this.NOT];
            for (i = 0; i < this.NOT; ++i) {
                k = i;
                this.mresrunners2_8[i] = new Runnable(){

                    @Override
                    public void run() {
                        int COLSKIP_PASS = 2;
                        int LINESKIP_PASS = 8;
                        Rectangle r2 = new Rectangle(SamplingMtIRE.this.r);
                        r2.x += k * 2;
                        r2.width -= k * 2;
                        r2.y += k * 8;
                        r2.height -= k * 8;
                        SamplingMtIRE.this.ren.castRays(r2, 2 * SamplingMtIRE.this.NOT, 8 * SamplingMtIRE.this.NOT, 0, 1, SamplingMtIRE.this.thread_data[k]);
                        SamplingMtIRE.this.highbit(SamplingMtIRE.this.scrbuff, SamplingMtIRE.this.scrw, r2, 2 * SamplingMtIRE.this.NOT, 8 * SamplingMtIRE.this.NOT);
                    }
                };
            }
        }
        for (i = 1; i < this.NOT; ++i) {
            this.tp.add(this.mresrunners2_8[i]);
        }
        this.mresrunners2_8[0].run();
        this.tp.waitfordone();
        this.mtFill2_8();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        if (!this.castRunners("MULTIRES_PASS2", this.mresrunners2_8, 4)) {
            return;
        }
        this.mtFill2_4();
        this.display();
        if (!this.castRunners("MULTIRES_PASS3", this.mresrunners2_8, 2)) {
            return;
        }
        this.mtFill2_2();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        if (!this.castRunners("MULTIRES_PASS4", this.mresrunners2_8, 6)) {
            return;
        }
        this.mtFill2_2();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return;
        }
        if (!this.castRunners("MULTIRES_PASS5", this.mresrunners2_8, 1)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS6", this.mresrunners2_8, 3)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS7", this.mresrunners2_8, 5)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS8", this.mresrunners2_8, 7)) {
            return;
        }
        this.origRectangle.x = 1;
        if (!this.castRunners("MULTIRES_PASS9", this.mresrunners2_8, 0)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS10", this.mresrunners2_8, 4)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS11", this.mresrunners2_8, 1)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS12", this.mresrunners2_8, 5)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS13", this.mresrunners2_8, 2)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS14", this.mresrunners2_8, 6)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS15", this.mresrunners2_8, 3)) {
            return;
        }
        if (!this.castRunners("MULTIRES_PASS16", this.mresrunners2_8, 7)) {
            return;
        }
        this.done = true;
    }

    private boolean castRunners(String passName, Runnable[] runners, int offset) {
        this.r.x = this.origRectangle.x;
        this.r.y = this.origRectangle.y + offset;
        this.r.width = this.origRectangle.width;
        this.r.height = this.origRectangle.height - (offset << 1);
        SamplingMtIRE.markTime(passName);
        for (int i = 1; i < this.NOT; ++i) {
            this.tp.add(runners[i]);
        }
        runners[0].run();
        this.tp.waitfordone();
        this.display();
        if (!this.noChange) {
            this.ren.updateWorld();
            return false;
        }
        return true;
    }

    private void mtFill2_8() {
        this.ren.prePaint();
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int xstart = ((SamplingMtIRE)SamplingMtIRE.this).r.x + k * 2;
                    int xend = xstart + (((SamplingMtIRE)SamplingMtIRE.this).r.width - k * 2);
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k * 8;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k * 8);
                    SamplingMtIRE.this.fill2_8(xstart, xend, ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fill2_8(this.r.x, this.r.x + this.r.width, this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void mtFill2_4() {
        this.ren.prePaint();
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int xstart = ((SamplingMtIRE)SamplingMtIRE.this).r.x + k * 2;
                    int xend = xstart + (((SamplingMtIRE)SamplingMtIRE.this).r.width - k * 2);
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k * 4;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k * 4);
                    SamplingMtIRE.this.fill2_4(xstart, xend, ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fill2_4(this.r.x, this.r.x + this.r.width, this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void mtFill2_2() {
        this.ren.prePaint();
        int i = 1;
        while (i < this.NOT) {
            final int k = i++;
            this.tp.add(new Runnable(){

                @Override
                public void run() {
                    int xstart = ((SamplingMtIRE)SamplingMtIRE.this).r.x + k * 2;
                    int xend = xstart + (((SamplingMtIRE)SamplingMtIRE.this).r.width - k * 2);
                    int ystart = ((SamplingMtIRE)SamplingMtIRE.this).r.y + k * 2;
                    int yend = ystart + (((SamplingMtIRE)SamplingMtIRE.this).r.height - k * 2);
                    SamplingMtIRE.this.fill2_2(xstart, xend, ystart, yend, SamplingMtIRE.this.NOT);
                }
            });
        }
        this.fill2_2(this.r.x, this.r.x + this.r.width, this.r.y, this.r.y + this.r.height, this.NOT);
        this.tp.waitfordone();
    }

    private void fill2_8(int xstart, int xend, int ystart, int yend, int nproc) {
        int linestep = 8 * nproc;
        int colstep = 2 * nproc;
        int line1 = this.scrw;
        int line2 = 2 * this.scrw;
        int line3 = 3 * this.scrw;
        int line4 = 4 * this.scrw;
        int line5 = 5 * this.scrw;
        int line6 = 6 * this.scrw;
        int line7 = 7 * this.scrw;
        int line8 = 8 * this.scrw;
        int v60 = 0;
        int v81 = 0;
        int v61 = 0;
        for (int y = ystart; y < yend - linestep; y += linestep) {
            int yoffset = y * this.scrw;
            for (int x = xstart; x < xend - colstep; x += colstep) {
                int v21;
                int v41;
                int v20;
                int v40;
                int v01;
                int i = x + yoffset;
                int v00 = this.scrbuff[i] >> 1 & 0x7F7F7F;
                int v02 = this.scrbuff[i + 2] >> 1 & 0x7F7F7F;
                int v80 = this.scrbuff[i + line8] >> 1 & 0x7F7F7F;
                int v82 = this.scrbuff[i + line8 + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i + 1] = v01 = v00 + v02;
                this.scrbuff[i + line8 + 1] = v81 = v80 + v82;
                this.scrbuff[i + line4] = v40 = v00 + v80;
                v40 = v40 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line2] = v20 = v00 + v40;
                this.scrbuff[i + line6] = v60 = v80 + v40;
                v20 = v20 >> 1 & 0x7F7F7F;
                v60 = v60 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line1] = v00 + v20;
                this.scrbuff[i + line3] = v20 + v40;
                this.scrbuff[i + line5] = v40 + v60;
                this.scrbuff[i + line7] = v80 + v60;
                v01 = v01 >> 1 & 0x7F7F7F;
                v81 = v81 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line4 + 1] = v41 = v01 + v81;
                v41 = v41 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line2 + 1] = v21 = v01 + v41;
                this.scrbuff[i + line6 + 1] = v61 = v41 + v81;
                v21 = v21 >> 1 & 0x7F7F7F;
                v61 = v61 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line1 + 1] = v01 + v21;
                this.scrbuff[i + line3 + 1] = v21 + v41;
                this.scrbuff[i + line5 + 1] = v41 + v61;
                this.scrbuff[i + line7 + 1] = v61 + v81;
            }
        }
    }

    private void fill2_4(int xstart, int xend, int ystart, int yend, int nproc) {
        int linestep = 4 * nproc;
        int colstep = 2 * nproc;
        int line1 = this.scrw;
        int line2 = 2 * this.scrw;
        int line3 = 3 * this.scrw;
        int line4 = 4 * this.scrw;
        int v20 = 0;
        int v41 = 0;
        int v21 = 0;
        for (int y = ystart; y < yend - linestep; y += linestep) {
            int yoffset = y * this.scrw;
            for (int x = xstart; x < xend - colstep; x += colstep) {
                int v01;
                int i = x + yoffset;
                int v00 = this.scrbuff[i] >> 1 & 0x7F7F7F;
                int v02 = this.scrbuff[i + 2] >> 1 & 0x7F7F7F;
                int v40 = this.scrbuff[i + line4] >> 1 & 0x7F7F7F;
                int v42 = this.scrbuff[i + line4 + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i + 1] = v01 = v00 + v02;
                this.scrbuff[i + line4 + 1] = v41 = v40 + v42;
                this.scrbuff[i + line2] = v20 = v00 + v40;
                v20 = v20 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line1] = v00 + v20;
                this.scrbuff[i + line3] = v20 + v40;
                v01 = v01 >> 1 & 0x7F7F7F;
                v41 = v41 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line2 + 1] = v21 = v01 + v41;
                v21 = v21 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line1 + 1] = v01 + v21;
                this.scrbuff[i + line3 + 1] = v21 + v41;
            }
        }
    }

    private void fill2_2(int xstart, int xend, int ystart, int yend, int nproc) {
        int linestep = 2 * nproc;
        int colstep = 2 * nproc;
        int line1 = this.scrw;
        int line2 = 2 * this.scrw;
        int v01 = 0;
        int v21 = 0;
        for (int y = ystart; y < yend - linestep; y += linestep) {
            int yoffset = y * this.scrw;
            for (int x = xstart; x < xend - colstep; x += colstep) {
                int i = x + yoffset;
                int v00 = this.scrbuff[i] >> 1 & 0x7F7F7F;
                int v02 = this.scrbuff[i + 2] >> 1 & 0x7F7F7F;
                int v20 = this.scrbuff[i + line2] >> 1 & 0x7F7F7F;
                int v22 = this.scrbuff[i + line2 + 2] >> 1 & 0x7F7F7F;
                this.scrbuff[i + 1] = v01 = v00 + v02;
                this.scrbuff[i + line2 + 1] = v21 = v20 + v22;
                this.scrbuff[i + line1] = v00 + v20;
                v01 = v01 >> 1 & 0x7F7F7F;
                v21 = v21 >> 1 & 0x7F7F7F;
                this.scrbuff[i + line1 + 1] = v01 + v21;
            }
        }
    }
}

