/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.mprender;

import com.ge.med.idc.IterativeRenderer;
import com.ge.med.jnu.geom.JnPoint;
import com.ge.med.terra.jami.ParallelTaskManager;
import com.ge.med.terra.jami.j3d.mprender.BaseMultipassAlgorithm;
import com.ge.med.terra.jami.j3d.mprender.MPFillerStrategy;

public class TwopassLineAlgorithm
extends BaseMultipassAlgorithm {
    private static final int BASERES = 2;
    private BaseMultipassAlgorithm.Runner[] r;
    private BaseMultipassAlgorithm.Runner[] fillrgb;
    private BaseMultipassAlgorithm.Runner[] filllum;

    public TwopassLineAlgorithm(ParallelTaskManager ptm) {
        super(ptm, true);
        this.r = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.fillrgb = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.filllum = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.init();
    }

    public TwopassLineAlgorithm() {
        super(true);
        this.r = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.fillrgb = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.filllum = new BaseMultipassAlgorithm.Runner[this.NOT];
        this.init();
    }

    private void init() {
        int i;
        for (i = 0; i < this.NOT; ++i) {
            this.r[i] = new BaseMultipassAlgorithm.Runner(){

                @Override
                public void work(int k, int workers, int passno, IterativeRenderer ren, Object global_data, Object thread_data) {
                    BaseMultipassAlgorithm.RenderData rd = (BaseMultipassAlgorithm.RenderData)global_data;
                    int renderOutputLayer = rd.outLayer;
                    int w = ren.getBufferWidth();
                    int h = ren.getBufferHeight();
                    int xoff = rd.p.x;
                    int yoff = rd.p.y;
                    int y = k * 2 + yoff;
                    int x = xoff;
                    int width = w;
                    int height = h - yoff;
                    ren.renderPixels(k, renderOutputLayer, x, y, width, height, 1, 2 * TwopassLineAlgorithm.this.NOT, thread_data);
                    TwopassLineAlgorithm.this.markbits(x, y, width, height, 1 * TwopassLineAlgorithm.this.NOT, 2);
                }
            };
        }
        for (i = 0; i < this.NOT; ++i) {
            this.fillrgb[i] = new BaseMultipassAlgorithm.Runner(){

                @Override
                public void work(int k, int workers, int passno, IterativeRenderer ren, Object global_data, Object thread_data) {
                    int[] buff = (int[])global_data;
                    short[] zbuffer = ren.getZBuffer();
                    int w = ren.getBufferWidth();
                    int h = ren.getBufferHeight();
                    switch (passno) {
                        case 0: {
                            MPFillerStrategy.fill1x2(k, workers, buff, w, h);
                            if (zbuffer == null) break;
                            MPFillerStrategy.fill1x2s(k, workers, zbuffer, w, h);
                        }
                    }
                }
            };
        }
        for (i = 0; i < this.NOT; ++i) {
            this.filllum[i] = new BaseMultipassAlgorithm.Runner(){

                @Override
                public void work(int k, int workers, int passno, IterativeRenderer ren, Object global_data, Object thread_data) {
                    short[] buff = (short[])global_data;
                    short[] zbuffer = ren.getZBuffer();
                    int w = ren.getBufferWidth();
                    int h = ren.getBufferHeight();
                    switch (passno) {
                        case 0: {
                            MPFillerStrategy.fill1x2s(k, workers, buff, w, h);
                            if (zbuffer == null) break;
                            MPFillerStrategy.fill1x2s(k, workers, zbuffer, w, h);
                        }
                    }
                }
            };
        }
    }

    @Override
    public int renderMPass(int x, int y, int w, int h, int renderOutputLayer, int passno) {
        int xoff = 0;
        int yoff = -1;
        switch (passno) {
            case 0: {
                yoff = 0;
                break;
            }
            case 1: {
                yoff = 1;
            }
        }
        BaseMultipassAlgorithm.RenderData rd = new BaseMultipassAlgorithm.RenderData();
        rd.p = new JnPoint(xoff, yoff);
        rd.outLayer = renderOutputLayer;
        this.launch(this.r, rd);
        return 1 - passno;
    }

    @Override
    public void fillMPass(int x, int y, int w, int h, int renderOutputLayer, int passno) {
        IterativeRenderer ren = this.getT3DIRenderer();
        Object buff = ren.getPixelBuffer();
        BaseMultipassAlgorithm.Runner[] r = this.filllum;
        if (buff instanceof int[]) {
            r = this.fillrgb;
        }
        this.launch(r, buff);
    }
}

