/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.registration;

import com.ge.med.idc.LinearTransformable;
import com.ge.med.idc.T3DCapable;
import com.ge.med.jnu.JnVector3d;
import com.ge.med.jnu.geom.GeomUtils;
import com.ge.med.terra.jami.XpMouseController;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class PanTransformMouseController
extends MouseInputAdapter
implements XpMouseController {
    protected int prevY;
    protected int prevX;
    protected T3DCapable t3d;
    protected double[] transform = new double[16];
    protected JnVector3d translatev = new JnVector3d();
    protected LinearTransformable transformObject = null;

    public void setLinearTransformable(LinearTransformable transformObject) {
        this.transformObject = transformObject;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.t3d == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        double[] prevPtRAS = GeomUtils.DisplayToRAS(new int[]{this.prevX, this.prevY, 0}, this.t3d.getEyePoint(null), this.t3d.getLookPoint(null), this.t3d.getUp(null), this.t3d.getViewHeight(), e.getComponent().getWidth(), e.getComponent().getHeight(), new double[3]);
        double[] currPtRAS = GeomUtils.DisplayToRAS(new int[]{x, y, 0}, this.t3d.getEyePoint(null), this.t3d.getLookPoint(null), this.t3d.getUp(null), this.t3d.getViewHeight(), e.getComponent().getWidth(), e.getComponent().getHeight(), new double[3]);
        this.translatev.set(currPtRAS);
        this.translatev.sub(prevPtRAS);
        this.transformObject.getLinearTransform(this.transform);
        this.transform[3] = this.transform[3] + this.translatev.x;
        this.transform[7] = this.transform[7] + this.translatev.y;
        this.transform[11] = this.transform[11] + this.translatev.z;
        this.transformObject.setLinearTransform(this.transform);
        this.t3d.repaint();
        this.prevX = x;
        this.prevY = y;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void setTarget(JComponent jc) {
        if (jc instanceof T3DCapable) {
            this.t3d = (T3DCapable)((Object)jc);
        }
    }
}

