/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.jami.j3d.registration;

import com.ge.med.idc.LinearTransformable;
import com.ge.med.idc.XjMemVolume;
import com.ge.med.idc.XjTagValue;
import com.ge.med.idc.XjVolume;
import com.ge.med.idc.XjVolumeInfo;
import com.ge.med.jnu.JnMatrix4d;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class TransformableVolume
implements XjVolumeInfo,
LinearTransformable {
    protected XjVolumeInfo refVolume;
    protected JnMatrix4d transform = null;
    protected double[] origin = new double[3];
    protected double[] origin2 = new double[3];
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static TransformableVolume createTransformableVolume(XjVolumeInfo volInfo) {
        if (volInfo instanceof XjVolume) {
            return new FileVolume((XjVolume)volInfo);
        }
        if (volInfo instanceof XjMemVolume) {
            return new MemVolume((XjMemVolume)volInfo);
        }
        String msg = "Volume type not valid.  Supported types are XjVolume and XjMemVolume";
        throw new IllegalArgumentException(msg);
    }

    @Override
    public int getBitsPerVoxel() {
        return this.refVolume.getBitsPerVoxel();
    }

    @Override
    public int getPixelType() {
        return this.refVolume.getPixelType();
    }

    @Override
    public String getRelatedComposite() {
        return this.refVolume.getRelatedComposite();
    }

    @Override
    public Object getVSliceValue(int sliceNo, int group, int element) {
        return this.refVolume.getVSliceValue(sliceNo, group, element);
    }

    @Override
    public Object getValue(int group, int element) {
        return this.refVolume.getValue(group, element);
    }

    @Override
    public int getValues(XjTagValue[] tv) {
        return this.refVolume.getValues(tv);
    }

    @Override
    public double[] getRASOfOrigin(double[] ras_ulc) {
        ras_ulc = this.refVolume.getRASOfOrigin(ras_ulc);
        this.transform.transform(ras_ulc);
        return ras_ulc;
    }

    @Override
    public int[] getVolumeDimensions(int[] dims) {
        return this.refVolume.getVolumeDimensions(dims);
    }

    @Override
    public double[] getXDirectionRAS(double[] ras_dx) {
        ras_dx = this.refVolume.getXDirectionRAS(ras_dx);
        this.refVolume.getRASOfOrigin(this.origin);
        ras_dx[0] = ras_dx[0] + this.origin[0];
        ras_dx[1] = ras_dx[1] + this.origin[1];
        ras_dx[2] = ras_dx[2] + this.origin[2];
        this.transform.transform(ras_dx);
        this.getRASOfOrigin(this.origin2);
        ras_dx[0] = ras_dx[0] - this.origin2[0];
        ras_dx[1] = ras_dx[1] - this.origin2[1];
        ras_dx[2] = ras_dx[2] - this.origin2[2];
        return ras_dx;
    }

    @Override
    public double[] getYDirectionRAS(double[] ras_dy) {
        ras_dy = this.refVolume.getYDirectionRAS(ras_dy);
        this.refVolume.getRASOfOrigin(this.origin);
        ras_dy[0] = ras_dy[0] + this.origin[0];
        ras_dy[1] = ras_dy[1] + this.origin[1];
        ras_dy[2] = ras_dy[2] + this.origin[2];
        this.transform.transform(ras_dy);
        this.getRASOfOrigin(this.origin2);
        ras_dy[0] = ras_dy[0] - this.origin2[0];
        ras_dy[1] = ras_dy[1] - this.origin2[1];
        ras_dy[2] = ras_dy[2] - this.origin2[2];
        return ras_dy;
    }

    @Override
    public double[] getZDirectionRAS(double[] ras_dz) {
        ras_dz = this.refVolume.getZDirectionRAS(ras_dz);
        this.refVolume.getRASOfOrigin(this.origin);
        ras_dz[0] = ras_dz[0] + this.origin[0];
        ras_dz[1] = ras_dz[1] + this.origin[1];
        ras_dz[2] = ras_dz[2] + this.origin[2];
        this.transform.transform(ras_dz);
        this.getRASOfOrigin(this.origin2);
        ras_dz[0] = ras_dz[0] - this.origin2[0];
        ras_dz[1] = ras_dz[1] - this.origin2[1];
        ras_dz[2] = ras_dz[2] - this.origin2[2];
        return ras_dz;
    }

    @Override
    public double[] getLinearTransform(double[] returnTransform) {
        if (returnTransform == null) {
            returnTransform = new double[16];
        }
        this.transform.get(returnTransform);
        return returnTransform;
    }

    @Override
    public void setLinearTransform(double[] transformArray) {
        if (transformArray == null) {
            transformArray = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        }
        if (!this.transform.equals(transformArray)) {
            this.transform.set(transformArray);
            this.pcs.firePropertyChange("LINEAR_TRANSFORM_PROPERTY", null, transformArray);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(prop, l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(String s, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(s, l);
    }

    public static class MemVolume
    extends TransformableVolume
    implements XjMemVolume {
        public MemVolume(XjMemVolume referenceVolume) {
            this.refVolume = referenceVolume;
            this.transform = new JnMatrix4d();
            this.transform.setIdentity();
        }

        @Override
        public Object getSliceData(int sliceNo) {
            return ((XjMemVolume)this.refVolume).getSliceData(sliceNo);
        }

        @Override
        public int getSliceOffset(int sliceNo) {
            return ((XjMemVolume)this.refVolume).getSliceOffset(sliceNo);
        }

        @Override
        public boolean isContiguous() {
            return ((XjMemVolume)this.refVolume).isContiguous();
        }
    }

    public static class FileVolume
    extends TransformableVolume
    implements XjVolume {
        public FileVolume(XjVolume referenceVolume) {
            this.refVolume = referenceVolume;
            this.transform = new JnMatrix4d();
            this.transform.setIdentity();
        }

        @Override
        public long getVSliceOffset(int sliceNo) {
            return ((XjVolume)this.refVolume).getVSliceOffset(sliceNo);
        }

        @Override
        public String getVSlicePath(int sliceNo) {
            return ((XjVolume)this.refVolume).getVSlicePath(sliceNo);
        }

        @Override
        public boolean isVolumeLittleEndian() {
            return ((XjVolume)this.refVolume).isVolumeLittleEndian();
        }
    }
}

